/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.sam;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.components.SamConversionResolver;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassConstructorDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.java.sam.SamAdapterClassConstructorDescriptor;
import org.jetbrains.kotlin.load.java.sam.SamAdapterDescriptor;
import org.jetbrains.kotlin.load.java.sam.SamAdapterFunctionDescriptor;
import org.jetbrains.kotlin.load.java.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.load.java.sam.SamConstructorDescriptorImpl;
import org.jetbrains.kotlin.load.java.sam.SamTypeAliasConstructorDescriptorImpl;
import org.jetbrains.kotlin.load.java.sam.SingleAbstractMethodUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JavaResolverUtils;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;

public class SingleAbstractMethodUtils {
    private SingleAbstractMethodUtils() {
    }

    @NotNull
    public static List<CallableMemberDescriptor> getAbstractMembers(@NotNull ClassDescriptor classDescriptor2) {
        ArrayList<CallableMemberDescriptor> abstractMembers = new ArrayList<CallableMemberDescriptor>();
        for (DeclarationDescriptor member : DescriptorUtils.getAllDescriptors(classDescriptor2.getUnsubstitutedMemberScope())) {
            if (!(member instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)member).getModality() != Modality.ABSTRACT) continue;
            abstractMembers.add((CallableMemberDescriptor)member);
        }
        return abstractMembers;
    }

    @Nullable
    public static SimpleType getFunctionTypeForSamInterface(@NotNull JavaClassDescriptor clazz, @Nullable SamConversionResolver samResolver) {
        if (samResolver == null) {
            return clazz.getDefaultFunctionTypeForSamInterface();
        }
        return samResolver.resolveFunctionTypeIfSamInterface(clazz);
    }

    @Nullable
    public static KotlinType getFunctionTypeForSamType(@NotNull KotlinType samType, @Nullable SamConversionResolver samResolver) {
        UnwrappedType unwrappedType = samType.unwrap();
        if (unwrappedType instanceof FlexibleType) {
            SimpleType lower2 = SingleAbstractMethodUtils.getFunctionTypeForSamType(((FlexibleType)unwrappedType).getLowerBound(), samResolver);
            SimpleType upper = SingleAbstractMethodUtils.getFunctionTypeForSamType(((FlexibleType)unwrappedType).getUpperBound(), samResolver);
            assert (lower2 == null == (upper == null)) : "Illegal flexible type: " + unwrappedType;
            if (upper == null) {
                return null;
            }
            return KotlinTypeFactory.flexibleType(lower2, upper);
        }
        return SingleAbstractMethodUtils.getFunctionTypeForSamType((SimpleType)unwrappedType, samResolver);
    }

    @Nullable
    private static SimpleType getFunctionTypeForSamType(@NotNull SimpleType samType, @Nullable SamConversionResolver samResolver) {
        SimpleType functionTypeDefault;
        ClassifierDescriptor classifier2 = samType.getConstructor().getDeclarationDescriptor();
        if (classifier2 instanceof JavaClassDescriptor && (functionTypeDefault = SingleAbstractMethodUtils.getFunctionTypeForSamInterface((JavaClassDescriptor)classifier2, samResolver)) != null) {
            SimpleType noProjectionsSamType = SingleAbstractMethodUtilsKt.nonProjectionParametrization(samType);
            if (noProjectionsSamType == null) {
                return null;
            }
            KotlinType type2 = TypeSubstitutor.create(noProjectionsSamType).substitute(functionTypeDefault, Variance.IN_VARIANCE);
            assert (type2 != null) : "Substitution based on type with no projections '" + noProjectionsSamType + "' should not end with conflict";
            SimpleType simpleType2 = TypeSubstitutionKt.asSimpleType(type2);
            return simpleType2.makeNullableAsSpecified(samType.isMarkedNullable());
        }
        return null;
    }

    @NotNull
    public static SimpleType getFunctionTypeForAbstractMethod(@NotNull FunctionDescriptor function2, boolean shouldConvertFirstParameterToDescriptor) {
        KotlinType returnType2 = function2.getReturnType();
        assert (returnType2 != null) : "function is not initialized: " + function2;
        List<ValueParameterDescriptor> valueParameters2 = function2.getValueParameters();
        ArrayList<KotlinType> parameterTypes = new ArrayList<KotlinType>(valueParameters2.size());
        ArrayList<Name> parameterNames = new ArrayList<Name>(valueParameters2.size());
        int startIndex = 0;
        KotlinType receiverType = null;
        if (shouldConvertFirstParameterToDescriptor && !function2.getValueParameters().isEmpty()) {
            receiverType = valueParameters2.get(0).getType();
            startIndex = 1;
        }
        for (int i = startIndex; i < valueParameters2.size(); ++i) {
            ValueParameterDescriptor parameter = valueParameters2.get(i);
            parameterTypes.add(parameter.getType());
            parameterNames.add(function2.hasSynthesizedParameterNames() ? SpecialNames.NO_NAME_PROVIDED : parameter.getName());
        }
        return FunctionTypesKt.createFunctionType(DescriptorUtilsKt.getBuiltIns(function2), Annotations.Companion.getEMPTY(), receiverType, parameterTypes, parameterNames, returnType2);
    }

    @Nullable
    public static FunctionDescriptor getSingleAbstractMethodOrNull(@NotNull JavaClassDescriptor klass2) {
        CallableMemberDescriptor member;
        if (DescriptorUtilsKt.getFqNameSafe(klass2).asString().equals("android.databinding.DataBindingComponent")) {
            return null;
        }
        if (klass2.isDefinitelyNotSamInterface()) {
            return null;
        }
        List<CallableMemberDescriptor> abstractMembers = SingleAbstractMethodUtils.getAbstractMembers(klass2);
        if (abstractMembers.size() == 1 && (member = abstractMembers.get(0)) instanceof SimpleFunctionDescriptor) {
            return member.getTypeParameters().isEmpty() ? (FunctionDescriptor)member : null;
        }
        return null;
    }

    @NotNull
    public static SamConstructorDescriptor createSamConstructorFunction(@NotNull DeclarationDescriptor owner, @NotNull JavaClassDescriptor samInterface, @NotNull SamConversionResolver samResolver) {
        assert (SingleAbstractMethodUtils.getSingleAbstractMethodOrNull(samInterface) != null) : samInterface;
        SamConstructorDescriptorImpl result2 = new SamConstructorDescriptorImpl(owner, samInterface);
        List<TypeParameterDescriptor> samTypeParameters = samInterface.getTypeConstructor().getParameters();
        SimpleType unsubstitutedSamType = samInterface.getDefaultType();
        SingleAbstractMethodUtils.initializeSamConstructorDescriptor(samInterface, result2, samTypeParameters, unsubstitutedSamType, samResolver);
        return result2;
    }

    private static void initializeSamConstructorDescriptor(@NotNull JavaClassDescriptor samInterface, @NotNull SimpleFunctionDescriptorImpl samConstructor, @NotNull List<TypeParameterDescriptor> samTypeParameters, @NotNull KotlinType unsubstitutedSamType, @NotNull SamConversionResolver samResolver) {
        TypeParameters typeParameters2 = SingleAbstractMethodUtils.recreateAndInitializeTypeParameters(samTypeParameters, samConstructor);
        KotlinType parameterTypeUnsubstituted = SingleAbstractMethodUtils.getFunctionTypeForSamType(unsubstitutedSamType, samResolver);
        assert (parameterTypeUnsubstituted != null) : "couldn't get function type for SAM type " + unsubstitutedSamType;
        KotlinType parameterType = typeParameters2.substitutor.substitute(parameterTypeUnsubstituted, Variance.IN_VARIANCE);
        assert (parameterType != null) : "couldn't substitute type: " + parameterTypeUnsubstituted + ", substitutor = " + typeParameters2.substitutor;
        ValueParameterDescriptorImpl parameter = new ValueParameterDescriptorImpl(samConstructor, null, 0, Annotations.Companion.getEMPTY(), Name.identifier("function"), parameterType, false, false, false, null, SourceElement.NO_SOURCE);
        KotlinType returnType2 = typeParameters2.substitutor.substitute(unsubstitutedSamType, Variance.OUT_VARIANCE);
        assert (returnType2 != null) : "couldn't substitute type: " + unsubstitutedSamType + ", substitutor = " + typeParameters2.substitutor;
        samConstructor.initialize((ReceiverParameterDescriptor)null, (ReceiverParameterDescriptor)null, typeParameters2.descriptors, Collections.singletonList(parameter), returnType2, Modality.FINAL, samInterface.getVisibility());
    }

    public static SamConstructorDescriptor createTypeAliasSamConstructorFunction(@NotNull TypeAliasDescriptor typeAliasDescriptor, @NotNull SamConstructorDescriptor underlyingSamConstructor, @NotNull SamConversionResolver samResolver) {
        SamTypeAliasConstructorDescriptorImpl result2 = new SamTypeAliasConstructorDescriptorImpl(typeAliasDescriptor, underlyingSamConstructor);
        JavaClassDescriptor samInterface = (JavaClassDescriptor)underlyingSamConstructor.getBaseDescriptorForSynthetic();
        List<TypeParameterDescriptor> samTypeParameters = typeAliasDescriptor.getTypeConstructor().getParameters();
        SimpleType unsubstitutedSamType = typeAliasDescriptor.getExpandedType();
        SingleAbstractMethodUtils.initializeSamConstructorDescriptor(samInterface, result2, samTypeParameters, unsubstitutedSamType, samResolver);
        return result2;
    }

    public static boolean isSamType(@NotNull KotlinType type2) {
        return SingleAbstractMethodUtils.getFunctionTypeForSamType(type2, null) != null;
    }

    public static boolean isSamAdapterNecessary(@NotNull FunctionDescriptor fun) {
        for (ValueParameterDescriptor param : fun.getValueParameters()) {
            if (!SingleAbstractMethodUtils.isSamType(param.getType())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static SamAdapterDescriptor<JavaMethodDescriptor> createSamAdapterFunction(final @NotNull JavaMethodDescriptor original, @NotNull SamConversionResolver samResolver) {
        final SamAdapterFunctionDescriptor result2 = new SamAdapterFunctionDescriptor(original);
        return SingleAbstractMethodUtils.initSamAdapter(original, result2, new FunctionInitializer(){

            @Override
            public void initialize(@NotNull List<TypeParameterDescriptor> typeParameters2, @NotNull List<ValueParameterDescriptor> valueParameters2, @NotNull KotlinType returnType2) {
                result2.initialize((ReceiverParameterDescriptor)null, original.getDispatchReceiverParameter(), typeParameters2, (List)valueParameters2, returnType2, Modality.FINAL, original.getVisibility());
            }
        }, samResolver);
    }

    @NotNull
    public static SamAdapterDescriptor<JavaClassConstructorDescriptor> createSamAdapterConstructor(final @NotNull JavaClassConstructorDescriptor original, @NotNull SamConversionResolver samResolver) {
        final SamAdapterClassConstructorDescriptor result2 = new SamAdapterClassConstructorDescriptor(original);
        return SingleAbstractMethodUtils.initSamAdapter(original, result2, new FunctionInitializer(){

            @Override
            public void initialize(@NotNull List<TypeParameterDescriptor> typeParameters2, @NotNull List<ValueParameterDescriptor> valueParameters2, @NotNull KotlinType returnType2) {
                result2.initialize(valueParameters2, original.getVisibility());
                result2.setReturnType(returnType2);
            }
        }, samResolver);
    }

    @NotNull
    private static <F extends FunctionDescriptor> SamAdapterDescriptor<F> initSamAdapter(@NotNull F original, @NotNull SamAdapterDescriptor<F> adapter, @NotNull FunctionInitializer initializer2, @NotNull SamConversionResolver samResolver) {
        TypeParameters typeParameters2 = SingleAbstractMethodUtils.recreateAndInitializeTypeParameters(original.getTypeParameters(), adapter);
        KotlinType returnTypeUnsubstituted = original.getReturnType();
        assert (returnTypeUnsubstituted != null) : "Creating SAM adapter for not initialized original: " + original;
        TypeSubstitutor substitutor2 = typeParameters2.substitutor;
        KotlinType returnType2 = substitutor2.substitute(returnTypeUnsubstituted, Variance.INVARIANT);
        assert (returnType2 != null) : "couldn't substitute type: " + returnTypeUnsubstituted + ", substitutor = " + substitutor2;
        List<ValueParameterDescriptor> valueParameters2 = SingleAbstractMethodUtils.createValueParametersForSamAdapter(original, adapter, substitutor2, samResolver);
        initializer2.initialize(typeParameters2.descriptors, valueParameters2, returnType2);
        return adapter;
    }

    public static List<ValueParameterDescriptor> createValueParametersForSamAdapter(@NotNull FunctionDescriptor original, @NotNull FunctionDescriptor samAdapter, @NotNull TypeSubstitutor substitutor2, @NotNull SamConversionResolver samResolver) {
        List<ValueParameterDescriptor> originalValueParameters = original.getValueParameters();
        ArrayList<ValueParameterDescriptor> valueParameters2 = new ArrayList<ValueParameterDescriptor>(originalValueParameters.size());
        for (ValueParameterDescriptor originalParam : originalValueParameters) {
            KotlinType originalType = originalParam.getType();
            KotlinType functionType = SingleAbstractMethodUtils.getFunctionTypeForSamType(originalType, samResolver);
            KotlinType newTypeUnsubstituted = functionType != null ? functionType : originalType;
            KotlinType newType = substitutor2.substitute(newTypeUnsubstituted, Variance.IN_VARIANCE);
            assert (newType != null) : "couldn't substitute type: " + newTypeUnsubstituted + ", substitutor = " + substitutor2;
            ValueParameterDescriptorImpl newParam = new ValueParameterDescriptorImpl(samAdapter, null, originalParam.getIndex(), originalParam.getAnnotations(), originalParam.getName(), newType, false, false, false, null, SourceElement.NO_SOURCE);
            valueParameters2.add(newParam);
        }
        return valueParameters2;
    }

    @NotNull
    private static TypeParameters recreateAndInitializeTypeParameters(@NotNull List<TypeParameterDescriptor> originalParameters, @Nullable DeclarationDescriptor newOwner) {
        if (newOwner instanceof SamAdapterClassConstructorDescriptor) {
            return new TypeParameters(originalParameters, TypeSubstitutor.EMPTY);
        }
        Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> traitToFunTypeParameters = JavaResolverUtils.recreateTypeParametersAndReturnMapping(originalParameters, newOwner);
        TypeSubstitutor typeParametersSubstitutor = JavaResolverUtils.createSubstitutorForTypeParameters(traitToFunTypeParameters);
        for (Map.Entry<TypeParameterDescriptor, TypeParameterDescriptorImpl> mapEntry : traitToFunTypeParameters.entrySet()) {
            TypeParameterDescriptor traitTypeParameter = mapEntry.getKey();
            TypeParameterDescriptorImpl funTypeParameter = mapEntry.getValue();
            for (KotlinType upperBound : traitTypeParameter.getUpperBounds()) {
                KotlinType upperBoundSubstituted = typeParametersSubstitutor.substitute(upperBound, Variance.INVARIANT);
                assert (upperBoundSubstituted != null) : "couldn't substitute type: " + upperBound + ", substitutor = " + typeParametersSubstitutor;
                funTypeParameter.addUpperBound(upperBoundSubstituted);
            }
            funTypeParameter.setInitialized();
        }
        ArrayList<TypeParameterDescriptorImpl> typeParameters2 = new ArrayList<TypeParameterDescriptorImpl>(traitToFunTypeParameters.values());
        return new TypeParameters(typeParameters2, typeParametersSubstitutor);
    }

    private static abstract class FunctionInitializer {
        private FunctionInitializer() {
        }

        public abstract void initialize(@NotNull List<TypeParameterDescriptor> var1, @NotNull List<ValueParameterDescriptor> var2, @NotNull KotlinType var3);
    }

    private static class TypeParameters {
        public final List<TypeParameterDescriptor> descriptors;
        public final TypeSubstitutor substitutor;

        private TypeParameters(List<TypeParameterDescriptor> descriptors, TypeSubstitutor substitutor2) {
            this.descriptors = descriptors;
            this.substitutor = substitutor2;
        }
    }
}

