/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.highlighter.JavaClassFileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.ScriptDefinitionProvider;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=2, xi=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"findScriptDefinition", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "file", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "psiFile", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "psi"})
public final class KotlinScriptDefinitionProviderKt {
    @Nullable
    public static final KotlinScriptDefinition findScriptDefinition(@NotNull VirtualFile file2, @NotNull Project project) {
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                if (file2.isDirectory()) {
                    return null;
                }
                if (Intrinsics.areEqual((Object)file2.getExtension(), (Object)"kt")) break block6;
                String string = file2.getExtension();
                JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)javaClassFileType, (String)"JavaClassFileType.INSTANCE");
                if (!Intrinsics.areEqual((Object)string, (Object)javaClassFileType.getDefaultExtension())) break block7;
            }
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance(project).findFile(file2);
        if (psiFile != null) {
            if (!(psiFile instanceof KtFile) || !((KtFile)psiFile).isScript()) {
                return null;
            }
            Lazy<KotlinScriptDefinition> lazy = ((KtFile)psiFile).getScript();
            return lazy != null && (lazy = lazy.kotlinScriptDefinition) != null ? (KotlinScriptDefinition)lazy.getValue() : null;
        }
        ScriptDefinitionProvider scriptDefinitionProvider = ScriptDefinitionProvider.Companion.getInstance(project);
        String string = file2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
        return scriptDefinitionProvider.findScriptDefinition(string);
    }

    @Nullable
    public static final KotlinScriptDefinition findScriptDefinition(@NotNull PsiFile psiFile) {
        Lazy<KotlinScriptDefinition> lazy;
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        if (psiFile.isDirectory()) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        return (lazy = (Lazy<KotlinScriptDefinition>)psiFile2) != null && (lazy = lazy.getScript()) != null && (lazy = lazy.kotlinScriptDefinition) != null ? (KotlinScriptDefinition)lazy.getValue() : null;
    }
}

