/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.resolvedCallUtil;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=2, xi=2, d1={"\u0000J\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t*\u0006\u0012\u0002\b\u00030\n\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\t*\u0006\u0012\u0002\b\u00030\n\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\r*\u0006\u0012\u0002\b\u00030\n\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f*\u0006\u0012\u0002\b\u00030\n\u001a\u000e\u0010\u0010\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\n\u001a\u001c\u0010\u0012\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\n2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002\u001a\u0016\u0010\u0014\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0006\u001a\u00020\u0007\u001a&\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u0006\u0012\u0002\b\u00030\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0013\u00a8\u0006\u0018"}, d2={"getArgumentByParameterIndex", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "index", "", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getDispatchReceiverWithSmartCast", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getExplicitReceiverValue", "getImplicitReceiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ImplicitReceiver;", "getImplicitReceivers", "", "hasBothReceivers", "", "hasSafeNullableReceiver", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "hasThisOrNoDispatchReceiver", "makeNullableTypeIfSafeReceiver", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "frontend"})
public final class ResolvedCallUtilKt {
    public static final boolean hasThisOrNoDispatchReceiver(@NotNull ResolvedCall<?> $receiver, @NotNull BindingContext context) {
        KtExpression expression2;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ReceiverValue dispatchReceiverValue = $receiver.getDispatchReceiver();
        Object obj = $receiver.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resultingDescriptor");
        if (obj.getDispatchReceiverParameter() == null || dispatchReceiverValue == null) {
            return true;
        }
        DeclarationDescriptor dispatchReceiverDescriptor = null;
        ReceiverValue receiverValue = dispatchReceiverValue;
        if (receiverValue instanceof ImplicitReceiver) {
            dispatchReceiverDescriptor = ((ImplicitReceiver)dispatchReceiverValue).getDeclarationDescriptor();
        } else if (receiverValue instanceof ClassValueReceiver) {
            dispatchReceiverDescriptor = ((ClassValueReceiver)dispatchReceiverValue).getClassQualifier().getDescriptor();
        } else if (receiverValue instanceof ExpressionReceiver && (expression2 = KtPsiUtil.deparenthesize(((ExpressionReceiver)dispatchReceiverValue).getExpression())) instanceof KtThisExpression) {
            dispatchReceiverDescriptor = (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, ((KtThisExpression)expression2).getInstanceReference());
        }
        Object obj2 = $receiver.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj2, (String)"resultingDescriptor");
        return Intrinsics.areEqual((Object)dispatchReceiverDescriptor, (Object)DescriptorUtilsKt.getOwnerForEffectiveDispatchReceiverParameter(obj2));
    }

    @Nullable
    public static final ReceiverValue getExplicitReceiverValue(@NotNull ResolvedCall<?> $receiver) {
        ReceiverValue receiverValue;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        switch (ResolvedCallUtilKt$WhenMappings.$EnumSwitchMapping$0[$receiver.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                receiverValue = $receiver.getDispatchReceiver();
                if (receiverValue != null) break;
                Intrinsics.throwNpe();
                break;
            }
            case 2: 
            case 3: {
                receiverValue = $receiver.getExtensionReceiver();
                if (receiverValue != null) break;
                Intrinsics.throwNpe();
                break;
            }
            default: {
                receiverValue = null;
            }
        }
        return receiverValue;
    }

    @Nullable
    public static final ImplicitReceiver getImplicitReceiverValue(@NotNull ResolvedCall<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Object object = CollectionsKt.firstOrNull((Iterable)ResolvedCallUtilKt.getImplicitReceivers($receiver));
        if (!(object instanceof ImplicitReceiver)) {
            object = null;
        }
        return (ImplicitReceiver)object;
    }

    @NotNull
    public static final Collection<ReceiverValue> getImplicitReceivers(@NotNull ResolvedCall<?> $receiver) {
        List list2;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        switch (ResolvedCallUtilKt$WhenMappings.$EnumSwitchMapping$1[$receiver.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                list2 = CollectionsKt.listOfNotNull((Object[])new ReceiverValue[]{$receiver.getExtensionReceiver(), $receiver.getDispatchReceiver()});
                break;
            }
            case 2: {
                list2 = CollectionsKt.listOfNotNull((Object)$receiver.getExtensionReceiver());
                break;
            }
            case 3: {
                list2 = CollectionsKt.listOfNotNull((Object)$receiver.getDispatchReceiver());
                break;
            }
            case 4: {
                list2 = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list2;
    }

    private static final boolean hasSafeNullableReceiver(@NotNull ResolvedCall<?> $receiver, CallResolutionContext<?> context) {
        ReceiverValue receiverValue;
        ReceiverValue it;
        Call call2 = $receiver.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"call");
        if (!CallUtilKt.isSafeCall(call2)) {
            return false;
        }
        Object object = ResolvedCallUtilKt.getExplicitReceiverValue($receiver);
        if (object == null || (object = context.dataFlowValueFactory.createDataFlowValue(it = (receiverValue = object), (ResolutionContext)context)) == null) {
            return false;
        }
        Object receiverValue2 = object;
        return context.dataFlowInfo.getStableNullability((DataFlowValue)receiverValue2).canBeNull();
    }

    @Nullable
    public static final KotlinType makeNullableTypeIfSafeReceiver(@NotNull ResolvedCall<?> $receiver, @Nullable KotlinType type2, @NotNull CallResolutionContext<?> context) {
        KotlinType kotlinType;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        KotlinType kotlinType2 = type2;
        if (kotlinType2 != null) {
            KotlinType kotlinType3;
            KotlinType it = kotlinType3 = kotlinType2;
            kotlinType = TypeUtils.makeNullableIfNeeded(type2, ResolvedCallUtilKt.hasSafeNullableReceiver($receiver, context));
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    public static final boolean hasBothReceivers(@NotNull ResolvedCall<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return $receiver.getDispatchReceiver() != null && $receiver.getExtensionReceiver() != null;
    }

    @Nullable
    public static final ReceiverValue getDispatchReceiverWithSmartCast(@NotNull ResolvedCall<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return SmartCastUtilKt.getReceiverValueWithSmartCast($receiver.getDispatchReceiver(), $receiver.getSmartCastDispatchReceiverType());
    }

    @NotNull
    public static final List<ValueArgument> getArgumentByParameterIndex(@NotNull KtCallElement $receiver, int index2, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($receiver, context);
        if (resolvedCall2 == null) {
            return CollectionsKt.emptyList();
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        List<ValueParameterDescriptor> list2 = resolvedCall3.getResultingDescriptor().getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resolvedCall.resultingDescriptor.valueParameters");
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.getOrNull(list2, (int)index2);
        if (valueParameterDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        ValueParameterDescriptor parameterToProcess = valueParameterDescriptor;
        Object object = resolvedCall3.getValueArguments().get(parameterToProcess);
        if (object == null || (object = object.getArguments()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }
}

