/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.resolve.calls.inference.NewConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.components.KotlinConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;
import org.jetbrains.kotlin.resolve.calls.inference.model.ExpectedTypeConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.model.AllCandidatesResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.CallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.CompletedCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.ErrorCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallKind;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.KotlinResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.ManyCandidatesCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.NoneCandidatesCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.PartialCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionAtomsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.SimpleCandidateFactory;
import org.jetbrains.kotlin.resolve.calls.model.SingleCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.tower.Candidate;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J:\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0002J.\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u001f\u001a\u00020\b*\u00020\u000b2\u0006\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020!J\u001c\u0010\"\u001a\u00020\r*\u00020\u000b2\u0006\u0010#\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010$\u001a\u00020\u001e*\u00020\u000bH\u0002J\u001e\u0010%\u001a\u00020\u0018*\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0013\u001a\u00020\b*\u00020\u000b2\u0006\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/KotlinCallCompleter;", "", "postponedArgumentsAnalyzer", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;", "kotlinConstraintSystemCompleter", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;", "(Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;)V", "createAllCandidatesResult", "Lorg/jetbrains/kotlin/resolve/calls/model/CallResolutionResult;", "candidates", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinResolutionCandidate;", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "prepareCandidateForCompletion", "factory", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleCandidateFactory;", "runCompletion", "", "resolvedCallAtom", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;", "completionMode", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter$ConstraintSystemCompletionMode;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/NewConstraintSystem;", "collectAllCandidatesMode", "", "asCallResolutionResult", "type", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder$SimpleHolder;", "computeReturnTypeWithSmartCastInfo", "returnType", "isErrorCandidate", "prepareForCompletion", "completionType", "diagnosticHolder", "resolution"})
public final class KotlinCallCompleter {
    private final PostponedArgumentsAnalyzer postponedArgumentsAnalyzer;
    private final KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter;

    @NotNull
    public final CallResolutionResult runCompletion(@NotNull SimpleCandidateFactory factory2, @NotNull Collection<KotlinResolutionCandidate> candidates2, @Nullable UnwrappedType expectedType, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        Intrinsics.checkParameterIsNotNull((Object)factory2, (String)"factory");
        Intrinsics.checkParameterIsNotNull(candidates2, (String)"candidates");
        Intrinsics.checkParameterIsNotNull((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        KotlinDiagnosticsHolder.SimpleHolder diagnosticHolder = new KotlinDiagnosticsHolder.SimpleHolder();
        if (candidates2.isEmpty()) {
            diagnosticHolder.addDiagnostic(new NoneCandidatesCallDiagnostic(factory2.getKotlinCall()));
        }
        if (candidates2.size() > 1) {
            diagnosticHolder.addDiagnostic(new ManyCandidatesCallDiagnostic(factory2.getKotlinCall(), candidates2));
        }
        KotlinResolutionCandidate candidate2 = this.prepareCandidateForCompletion(factory2, candidates2, resolutionCallbacks);
        KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode completionType = this.prepareForCompletion(candidate2, expectedType, resolutionCallbacks);
        return resolutionCallbacks.getInferenceSession().shouldRunCompletion(candidate2) ? this.runCompletion(candidate2, completionType, diagnosticHolder, resolutionCallbacks) : this.asCallResolutionResult(candidate2, KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.PARTIAL, diagnosticHolder);
    }

    @NotNull
    public final CallResolutionResult createAllCandidatesResult(@NotNull Collection<KotlinResolutionCandidate> candidates2, @Nullable UnwrappedType expectedType, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        Intrinsics.checkParameterIsNotNull(candidates2, (String)"candidates");
        Intrinsics.checkParameterIsNotNull((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        KotlinDiagnosticsHolder.SimpleHolder diagnosticsHolder = new KotlinDiagnosticsHolder.SimpleHolder();
        for (KotlinResolutionCandidate candidate2 : candidates2) {
            this.prepareForCompletion(candidate2, expectedType, resolutionCallbacks);
            this.runCompletion(candidate2.getResolvedCall(), KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL, diagnosticsHolder, candidate2.getSystem(), resolutionCallbacks, true);
        }
        return new AllCandidatesResolutionResult(candidates2);
    }

    private final CallResolutionResult runCompletion(@NotNull KotlinResolutionCandidate $receiver, KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode completionType, KotlinDiagnosticsHolder.SimpleHolder diagnosticHolder, KotlinResolutionCallbacks resolutionCallbacks) {
        if (this.isErrorCandidate($receiver)) {
            KotlinCallCompleter.runCompletion$default(this, $receiver.getResolvedCall(), KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL, diagnosticHolder, $receiver.getSystem(), resolutionCallbacks, false, 32, null);
            return this.asCallResolutionResult($receiver, completionType, diagnosticHolder);
        }
        KotlinCallCompleter.runCompletion$default(this, $receiver.getResolvedCall(), completionType, diagnosticHolder, $receiver.getSystem(), resolutionCallbacks, false, 32, null);
        return this.asCallResolutionResult($receiver, completionType, diagnosticHolder);
    }

    /*
     * WARNING - void declaration
     */
    private final void runCompletion(ResolvedCallAtom resolvedCallAtom, KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode completionMode, KotlinDiagnosticsHolder diagnosticsHolder, NewConstraintSystem constraintSystem, KotlinResolutionCallbacks resolutionCallbacks, boolean collectAllCandidatesMode) {
        void $receiver$iv;
        UnwrappedType unwrappedType = ResolutionAtomsKt.getFreshReturnType(resolvedCallAtom);
        if (unwrappedType == null) {
            SimpleType simpleType2 = constraintSystem.getBuiltIns().getUnitType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"constraintSystem.builtIns.unitType");
            unwrappedType = simpleType2;
        }
        UnwrappedType returnType2 = unwrappedType;
        this.kotlinConstraintSystemCompleter.runCompletion(constraintSystem.asConstraintSystemCompleterContext(), completionMode, CollectionsKt.listOf((Object)resolvedCallAtom), returnType2, (Function1<? super PostponedResolvedAtom, Unit>)((Function1)new Function1<PostponedResolvedAtom, Unit>(this, collectAllCandidatesMode, constraintSystem, resolutionCallbacks, diagnosticsHolder){
            final /* synthetic */ KotlinCallCompleter this$0;
            final /* synthetic */ boolean $collectAllCandidatesMode;
            final /* synthetic */ NewConstraintSystem $constraintSystem;
            final /* synthetic */ KotlinResolutionCallbacks $resolutionCallbacks;
            final /* synthetic */ KotlinDiagnosticsHolder $diagnosticsHolder;

            public final void invoke(@NotNull PostponedResolvedAtom it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (this.$collectAllCandidatesMode) {
                    it.setEmptyAnalyzedResults();
                } else {
                    KotlinCallCompleter.access$getPostponedArgumentsAnalyzer$p(this.this$0).analyze(this.$constraintSystem.asPostponedArgumentsAnalyzerContext(), this.$resolutionCallbacks, it, this.$diagnosticsHolder);
                }
            }
            {
                this.this$0 = kotlinCallCompleter;
                this.$collectAllCandidatesMode = bl;
                this.$constraintSystem = newConstraintSystem;
                this.$resolutionCallbacks = kotlinResolutionCallbacks;
                this.$diagnosticsHolder = kotlinDiagnosticsHolder;
                super(1);
            }
        }));
        Iterable iterable = constraintSystem.getDiagnostics();
        KotlinDiagnosticsHolder kotlinDiagnosticsHolder = diagnosticsHolder;
        for (Object element$iv : $receiver$iv) {
            KotlinCallDiagnostic p1 = (KotlinCallDiagnostic)element$iv;
            kotlinDiagnosticsHolder.addDiagnostic(p1);
        }
    }

    static /* bridge */ /* synthetic */ void runCompletion$default(KotlinCallCompleter kotlinCallCompleter, ResolvedCallAtom resolvedCallAtom, KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode constraintSystemCompletionMode, KotlinDiagnosticsHolder kotlinDiagnosticsHolder, NewConstraintSystem newConstraintSystem, KotlinResolutionCallbacks kotlinResolutionCallbacks, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        kotlinCallCompleter.runCompletion(resolvedCallAtom, constraintSystemCompletionMode, kotlinDiagnosticsHolder, newConstraintSystem, kotlinResolutionCallbacks, bl);
    }

    private final KotlinResolutionCandidate prepareCandidateForCompletion(SimpleCandidateFactory factory2, Collection<KotlinResolutionCandidate> candidates2, KotlinResolutionCallbacks resolutionCallbacks) {
        KotlinResolutionCandidate kotlinResolutionCandidate;
        KotlinResolutionCandidate candidate2 = (KotlinResolutionCandidate)CollectionsKt.singleOrNull((Iterable)candidates2);
        Object object = candidate2;
        if (object != null && (object = ((KotlinResolutionCandidate)object).getResolvedCall()) != null) {
            Object object2;
            Object it = object2 = object;
            resolutionCallbacks.bindStubResolvedCallForCandidate((ResolvedCallAtom)it);
        }
        if ((kotlinResolutionCandidate = candidate2) == null) {
            kotlinResolutionCandidate = (KotlinResolutionCandidate)TowerUtilsKt.forceResolution((Candidate)factory2.createErrorCandidate());
        }
        return kotlinResolutionCandidate;
    }

    private final KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode prepareForCompletion(@NotNull KotlinResolutionCandidate $receiver, UnwrappedType expectedType, KotlinResolutionCallbacks resolutionCallbacks) {
        UnwrappedType substitutedType;
        if (expectedType != null && TypeUtils.noExpectedType(expectedType)) {
            return KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL;
        }
        KotlinType kotlinType = $receiver.getResolvedCall().getCandidateDescriptor().getReturnType();
        if (kotlinType == null || (kotlinType = kotlinType.unwrap()) == null) {
            return KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.PARTIAL;
        }
        KotlinType returnType2 = kotlinType;
        if (expectedType != null) {
            UnwrappedType returnTypeWithSmartCastInfo = this.computeReturnTypeWithSmartCastInfo($receiver, (UnwrappedType)returnType2, resolutionCallbacks);
            substitutedType = $receiver.getResolvedCall().getSubstitutor().substituteKeepAnnotations(returnTypeWithSmartCastInfo);
            if (!resolutionCallbacks.isCompileTimeConstant($receiver.getResolvedCall(), expectedType)) {
                $receiver.getCsBuilder$resolution().addSubtypeConstraint(substitutedType, expectedType, new ExpectedTypeConstraintPosition($receiver.getResolvedCall().getAtom()));
            }
        } else {
            substitutedType = $receiver.getResolvedCall().getSubstitutor().substituteKeepAnnotations((UnwrappedType)returnType2);
        }
        return expectedType != null || $receiver.getCsBuilder$resolution().isProperType(substitutedType) ? KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL : KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.PARTIAL;
    }

    private final UnwrappedType computeReturnTypeWithSmartCastInfo(@NotNull KotlinResolutionCandidate $receiver, UnwrappedType returnType2, KotlinResolutionCallbacks resolutionCallbacks) {
        if ($receiver.getResolvedCall().getAtom().getCallKind() != KotlinCallKind.VARIABLE) {
            return returnType2;
        }
        Object object = resolutionCallbacks.createReceiverWithSmartCastInfo($receiver.getResolvedCall());
        if (object == null || (object = ArgumentsUtilsKt.getStableType((ReceiverValueWithSmartCastInfo)object)) == null) {
            object = returnType2;
        }
        return object;
    }

    @NotNull
    public final CallResolutionResult asCallResolutionResult(@NotNull KotlinResolutionCandidate $receiver, @NotNull KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode type2, @NotNull KotlinDiagnosticsHolder.SimpleHolder diagnosticsHolder) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type2), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticsHolder, (String)"diagnosticsHolder");
        ConstraintStorage systemStorage = $receiver.getSystem().asReadOnlyStorage();
        List allDiagnostics = CollectionsKt.plus((Collection)diagnosticsHolder.getDiagnostics(), (Iterable)$receiver.getDiagnosticsFromResolutionParts());
        if (this.isErrorCandidate($receiver)) {
            return new ErrorCallResolutionResult($receiver.getResolvedCall(), allDiagnostics, systemStorage);
        }
        return type2 == KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL ? (SingleCallResolutionResult)new CompletedCallResolutionResult($receiver.getResolvedCall(), allDiagnostics, systemStorage) : (SingleCallResolutionResult)new PartialCallResolutionResult($receiver.getResolvedCall(), allDiagnostics, systemStorage);
    }

    private final boolean isErrorCandidate(@NotNull KotlinResolutionCandidate $receiver) {
        return ErrorUtils.isError($receiver.getResolvedCall().getCandidateDescriptor()) || ConstraintStorage.Empty.INSTANCE.getHasContradiction();
    }

    public KotlinCallCompleter(@NotNull PostponedArgumentsAnalyzer postponedArgumentsAnalyzer, @NotNull KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter) {
        Intrinsics.checkParameterIsNotNull((Object)postponedArgumentsAnalyzer, (String)"postponedArgumentsAnalyzer");
        Intrinsics.checkParameterIsNotNull((Object)kotlinConstraintSystemCompleter, (String)"kotlinConstraintSystemCompleter");
        this.postponedArgumentsAnalyzer = postponedArgumentsAnalyzer;
        this.kotlinConstraintSystemCompleter = kotlinConstraintSystemCompleter;
    }

    @NotNull
    public static final /* synthetic */ PostponedArgumentsAnalyzer access$getPostponedArgumentsAnalyzer$p(KotlinCallCompleter $this) {
        return $this.postponedArgumentsAnalyzer;
    }
}

