/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.FunctionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/LocalFunctionGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "generateFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "ktFun", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "generateFunctionDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "generateLambda", "ktLambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "ir.psi2ir"})
public final class LocalFunctionGenerator
extends StatementGeneratorExtension {
    @NotNull
    public final IrStatement generateLambda(@NotNull KtLambdaExpression ktLambda) {
        Intrinsics.checkParameterIsNotNull((Object)ktLambda, (String)"ktLambda");
        KtFunctionLiteral ktFunctionLiteral = ktLambda.getFunctionLiteral();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFunctionLiteral, (String)"ktLambda.functionLiteral");
        KtFunctionLiteral ktFun = ktFunctionLiteral;
        IrType lambdaExpressionType = this.toIrType(GeneratorKt.getInferredTypeWithImplicitCastsOrFail(this, ktLambda));
        IrSimpleFunction irLambdaFunction = new FunctionGenerator(this.getContext()).generateLambdaFunctionDeclaration(ktFun);
        IrBlockImpl irBlock2 = new IrBlockImpl(ktLambda.getStartOffset(), PsiUtilsKt.getEndOffset(ktLambda), lambdaExpressionType, IrStatementOrigin.LAMBDA.INSTANCE);
        irBlock2.getStatements().add(irLambdaFunction);
        irBlock2.getStatements().add(new IrFunctionReferenceImpl(ktLambda.getStartOffset(), PsiUtilsKt.getEndOffset(ktLambda), lambdaExpressionType, irLambdaFunction.getSymbol(), (FunctionDescriptor)((IrSimpleFunctionSymbol)irLambdaFunction.getSymbol()).getDescriptor(), 0, IrStatementOrigin.LAMBDA.INSTANCE));
        return irBlock2;
    }

    @NotNull
    public final IrStatement generateFunction(@NotNull KtNamedFunction ktFun) {
        IrStatement irStatement;
        Intrinsics.checkParameterIsNotNull((Object)ktFun, (String)"ktFun");
        if (ktFun.getName() != null) {
            irStatement = this.generateFunctionDeclaration(ktFun);
        } else {
            IrType funExpressionType = this.toIrType(GeneratorKt.getInferredTypeWithImplicitCastsOrFail(this, ktFun));
            IrBlockImpl irBlock2 = new IrBlockImpl(PsiUtilsKt.getStartOffset(ktFun), PsiUtilsKt.getEndOffset(ktFun), funExpressionType, IrStatementOrigin.ANONYMOUS_FUNCTION.INSTANCE);
            IrFunction irFun = this.generateFunctionDeclaration(ktFun);
            irBlock2.getStatements().add(irFun);
            irBlock2.getStatements().add(new IrFunctionReferenceImpl(PsiUtilsKt.getStartOffset(ktFun), PsiUtilsKt.getEndOffset(ktFun), funExpressionType, irFun.getSymbol(), irFun.getSymbol().getDescriptor(), 0, IrStatementOrigin.ANONYMOUS_FUNCTION.INSTANCE));
            irStatement = irBlock2;
        }
        return irStatement;
    }

    private final IrFunction generateFunctionDeclaration(KtNamedFunction ktFun) {
        return new FunctionGenerator(this.getContext()).generateFunctionDeclaration(ktFun);
    }

    public LocalFunctionGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)statementGenerator, (String)"statementGenerator");
        super(statementGenerator);
    }
}

