/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.BridgesKt;
import org.jetbrains.kotlin.backend.common.bridges.FunctionHandle;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.BridgesConstruction;
import org.jetbrains.kotlin.ir.backend.js.lower.FunctionAndSignature;
import org.jetbrains.kotlin.ir.backend.js.lower.IrBasedFunctionHandle;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BridgesConstruction;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "createBridge", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "bridge", "delegateTo", "generateBridges", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lower", "irCastIfNeeded", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "argument", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "backend.js"})
public final class BridgesConstruction
implements ClassLoweringPass {
    @NotNull
    private final JsIrBackendContext context;

    @Override
    public void lower(@NotNull IrClass irClass) {
        Object it;
        IrDeclarationWithVisibility it2;
        Object element$iv$iv;
        Object $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        Iterable $receiver$iv = irClass.getDeclarations();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            it2 = (IrSimpleFunction)element$iv$iv;
            if (!(!JsAstUtilsKt.isStatic((IrFunction)it2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (IrSimpleFunction)element$iv;
            this.generateBridges((IrSimpleFunction)it, irClass);
        }
        $receiver$iv = irClass.getDeclarations();
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        it = $receiver$iv$iv.iterator();
        while (it.hasNext()) {
            element$iv$iv = it.next();
            if (!(element$iv$iv instanceof IrProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        it = $receiver$iv$iv.iterator();
        while (it.hasNext()) {
            element$iv$iv = it.next();
            it2 = (IrProperty)element$iv$iv;
            Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object[])new IrSimpleFunction[]{it2.getGetter(), it2.getSetter()});
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (IrSimpleFunction)element$iv;
            this.generateBridges((IrSimpleFunction)it, irClass);
        }
    }

    private final void generateBridges(IrSimpleFunction function2, IrClass irClass) {
        if (DescriptorUtils.isMethodOfAny(function2.getDescriptor())) {
            return;
        }
        Set bridgesToGenerate2 = BridgesKt.generateBridges((FunctionHandle)new IrBasedFunctionHandle(function2), generateBridges.bridgesToGenerate.1.INSTANCE);
        for (Bridge bridge : bridgesToGenerate2) {
            FunctionAndSignature from = (FunctionAndSignature)bridge.component1();
            FunctionAndSignature to = (FunctionAndSignature)bridge.component2();
            if (Intrinsics.areEqual((Object)to.getFunction().getVisibility(), (Object)Visibilities.INVISIBLE_FAKE) || !IrUtilsKt.isInterface(IrUtilsKt.getParentAsClass(from.getFunction())) && IrUtilsKt.isReal(from.getFunction()) && from.getFunction().getModality() != Modality.ABSTRACT && !IrUtilsKt.isReal(to.getFunction())) continue;
            irClass.getDeclarations().add(this.createBridge(function2, from.getFunction(), to.getFunction()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrFunction createBridge(IrSimpleFunction function2, IrSimpleFunction bridge, IrSimpleFunction delegateTo) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $receiver$iv$iv2;
        IrBlockBodyBuilder it;
        Collection<ValueParameterDescriptor> collection;
        void $receiver$iv$iv3;
        void $receiver$iv2;
        ClassDescriptor containingClass = IrUtilsKt.getParentAsClass(function2).getDescriptor();
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = SimpleFunctionDescriptorImpl.create(containingClass, Annotations.Companion.getEMPTY(), bridge.getName(), CallableMemberDescriptor.Kind.SYNTHESIZED, function2.getDescriptor().getSource());
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptorImpl, (String)"SimpleFunctionDescriptor\u2026scriptor.source\n        )");
        SimpleFunctionDescriptorImpl bridgeDescriptorForIrFunction = simpleFunctionDescriptorImpl;
        ReceiverParameterDescriptor receiverParameterDescriptor = bridge.getDescriptor().getExtensionReceiverParameter();
        KotlinType kotlinType = receiverParameterDescriptor != null ? receiverParameterDescriptor.getReturnType() : null;
        ReceiverParameterDescriptor receiverParameterDescriptor2 = containingClass.getThisAsReceiverParameter();
        List<TypeParameterDescriptor> list2 = bridge.getDescriptor().getTypeParameters();
        List<ValueParameterDescriptor> list3 = bridge.getDescriptor().getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"bridge.descriptor.valueParameters");
        Iterable iterable = list3;
        List<TypeParameterDescriptor> list4 = list2;
        ReceiverParameterDescriptor receiverParameterDescriptor3 = receiverParameterDescriptor2;
        KotlinType kotlinType2 = kotlinType;
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl2 = bridgeDescriptorForIrFunction;
        IrBlockBody irBlockBody2 = $receiver$iv2;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv3) {
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            CallableDescriptor callableDescriptor = bridgeDescriptorForIrFunction;
            void v7 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"it");
            Name name = v7.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"it.name");
            ValueParameterDescriptor valueParameterDescriptor2 = it.copy(callableDescriptor, name, it.getIndex());
            collection.add(valueParameterDescriptor2);
        }
        collection = (List)destination$iv$iv;
        simpleFunctionDescriptorImpl2.initialize(kotlinType2, receiverParameterDescriptor3, list4, (List)collection, bridge.getDescriptor().getReturnType(), bridge.getDescriptor().getModality(), function2.getVisibility());
        bridgeDescriptorForIrFunction.setSuspend(bridge.getDescriptor().isSuspend());
        IrFunctionImpl irFunction = new IrFunctionImpl(-1, -1, IrDeclarationOrigin.DEFINED.INSTANCE, bridgeDescriptorForIrFunction);
        IrUtilsKt.createParameterDeclarations(irFunction);
        irFunction.setReturnType(bridge.getReturnType());
        IrGeneratorWithScope $receiver$iv3 = LowerUtilsKt.createIrBuilder$default(this.context, irFunction.getSymbol(), 0, 0, 6, null);
        destination$iv$iv = $receiver$iv3;
        int n = ((IrElement)irFunction).getStartOffset();
        int endOffset$iv$iv = ((IrElement)irFunction).getEndOffset();
        it = new IrBlockBodyBuilder($receiver$iv$iv2.getContext(), $receiver$iv$iv2.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        void $receiver = this_$iv$iv$iv;
        IrCall call2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$receiver, delegateTo.getSymbol());
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$receiver;
        IrValueParameter irValueParameter = irFunction.getDispatchReceiverParameter();
        if (irValueParameter == null) {
            Intrinsics.throwNpe();
        }
        call2.setDispatchReceiver(ExpressionHelpersKt.irGet(irBuilderWithScope, irValueParameter));
        IrValueParameter irValueParameter2 = irFunction.getExtensionReceiverParameter();
        if (irValueParameter2 != null) {
            IrValueParameter $i$f$map;
            IrValueParameter it2 = $i$f$map = irValueParameter2;
            IrExpression irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$receiver, it2);
            IrValueParameter irValueParameter3 = delegateTo.getExtensionReceiverParameter();
            if (irValueParameter3 == null) {
                Intrinsics.throwNpe();
            }
            call2.setExtensionReceiver(this.irCastIfNeeded((IrBlockBodyBuilder)$receiver, irExpression, irValueParameter3.getType()));
        }
        int toTake = irFunction.getValueParameters().size() - (call2.getDescriptor().isSuspend() ^ irFunction.getDescriptor().isSuspend() ? 1 : 0);
        Iterable $i$a$1$let = $receiver$iv = (Iterable)irFunction.getValueParameters().subList(0, toTake);
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void valueParameter;
            void i;
            int n2 = index$iv$iv++;
            Collection collection2 = destination$iv$iv2;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n3 = n2;
            IrValueParameter irValueParameter4 = (IrValueParameter)item$iv$iv;
            int n4 = n3;
            Collection collection3 = collection2;
            call2.putValueArgument((int)i, this.irCastIfNeeded((IrBlockBodyBuilder)$receiver, ExpressionHelpersKt.irGet((IrBuilderWithScope)$receiver, (IrValueDeclaration)valueParameter), delegateTo.getValueParameters().get((int)i).getType()));
            Unit unit = Unit.INSTANCE;
            collection3.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv2;
        $receiver.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$receiver, call2));
        IrBlockBody $receiver2 = irBlockBody2 = this_$iv$iv$iv.doBuild();
        irFunction.setBody($receiver2);
        return irFunction;
    }

    private final IrExpression irCastIfNeeded(@NotNull IrBlockBodyBuilder $receiver, IrExpression argument, IrType type2) {
        return Intrinsics.areEqual((Object)IrTypesKt.getClassifierOrNull(argument.getType()), (Object)IrTypesKt.getClassifierOrNull(type2)) || IrTypePredicatesKt.isUnit(type2) ? argument : (IrExpression)ExpressionHelpersKt.irAs($receiver, argument, type2);
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public BridgesConstruction(@NotNull JsIrBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

