/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.AccessorForCompanionObjectInstanceFieldDescriptor;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.CallableReferenceUtilKt;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.SyntheticClassDescriptorForLambda;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.intrinsics.HashCode;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.com.google.common.collect.Sets;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.metadata.jvm.serialization.JvmStringTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class AsmUtil {
    private static final Set<Type> STRING_BUILDER_OBJECT_APPEND_ARG_TYPES = Sets.newHashSet(AsmTypes.getType(String.class), AsmTypes.getType(StringBuffer.class), AsmTypes.getType(CharSequence.class));
    public static final int NO_FLAG_PACKAGE_PRIVATE = 0;
    @NotNull
    private static final Map<Visibility, Integer> visibilityToAccessFlag = ImmutableMap.builder().put(Visibilities.PRIVATE, 2).put(Visibilities.PRIVATE_TO_THIS, 2).put(Visibilities.PROTECTED, 4).put(JavaVisibilities.PROTECTED_STATIC_VISIBILITY, 4).put(JavaVisibilities.PROTECTED_AND_PACKAGE, 4).put(Visibilities.PUBLIC, 1).put(Visibilities.INTERNAL, 1).put(Visibilities.LOCAL, 0).put(JavaVisibilities.PACKAGE_VISIBILITY, 0).build();
    public static final String BOUND_REFERENCE_RECEIVER = "receiver";
    public static final String RECEIVER_NAME = "$receiver";
    public static final String CAPTURED_RECEIVER_FIELD = "receiver$0";
    public static final String CAPTURED_THIS_FIELD = "this$0";
    private static final ImmutableMap<Integer, JvmPrimitiveType> primitiveTypeByAsmSort;
    private static final ImmutableMap<Type, Type> primitiveTypeByBoxedType;

    private AsmUtil() {
    }

    @NotNull
    public static Type boxType(@NotNull Type type2) {
        Type boxedType = AsmUtil.boxPrimitiveType(type2);
        return boxedType != null ? boxedType : type2;
    }

    @NotNull
    public static Type boxType(@NotNull Type type2, @NotNull KotlinType kotlinType, @NotNull GenerationState state2) {
        if (InlineClassesUtilsKt.isInlineClassType(kotlinType)) {
            return state2.getTypeMapper().mapTypeAsDeclaration(kotlinType);
        }
        Type boxedPrimitiveType = AsmUtil.boxPrimitiveType(type2);
        return boxedPrimitiveType != null ? boxedPrimitiveType : type2;
    }

    @Nullable
    private static Type boxPrimitiveType(@NotNull Type type2) {
        JvmPrimitiveType jvmPrimitiveType = primitiveTypeByAsmSort.get(type2.getSort());
        return jvmPrimitiveType != null ? AsmUtil.asmTypeByFqNameWithoutInnerClasses(jvmPrimitiveType.getWrapperFqName()) : null;
    }

    @NotNull
    public static Type unboxType(@NotNull Type boxedType) {
        Type primitiveType = AsmUtil.unboxPrimitiveTypeOrNull(boxedType);
        if (primitiveType == null) {
            throw new UnsupportedOperationException("Unboxing: " + boxedType);
        }
        return primitiveType;
    }

    @Nullable
    public static Type unboxPrimitiveTypeOrNull(@NotNull Type boxedType) {
        return primitiveTypeByBoxedType.get(boxedType);
    }

    public static boolean isBoxedPrimitiveType(@NotNull Type boxedType) {
        return primitiveTypeByBoxedType.get(boxedType) != null;
    }

    @NotNull
    public static Type unboxUnlessPrimitive(@NotNull Type boxedOrPrimitiveType) {
        if (AsmUtil.isPrimitive(boxedOrPrimitiveType)) {
            return boxedOrPrimitiveType;
        }
        return AsmUtil.unboxType(boxedOrPrimitiveType);
    }

    public static boolean isBoxedTypeOf(@NotNull Type boxedType, @NotNull Type unboxedType) {
        return AsmUtil.unboxPrimitiveTypeOrNull(boxedType) == unboxedType;
    }

    public static boolean isIntPrimitive(Type type2) {
        return type2 == Type.INT_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.BYTE_TYPE || type2 == Type.CHAR_TYPE;
    }

    public static boolean isIntOrLongPrimitive(Type type2) {
        return AsmUtil.isIntPrimitive(type2) || type2 == Type.LONG_TYPE;
    }

    public static boolean isPrimitive(Type type2) {
        return type2.getSort() != 10 && type2.getSort() != 9;
    }

    public static boolean isPrimitiveNumberClassDescriptor(DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return false;
        }
        return KotlinBuiltIns.isPrimitiveClass((ClassDescriptor)descriptor2) && !KotlinBuiltIns.isBoolean((ClassDescriptor)descriptor2);
    }

    @NotNull
    public static Type correctElementType(@NotNull Type type2) {
        String internalName = type2.getInternalName();
        assert (internalName.charAt(0) == '[');
        return Type.getType(internalName.substring(1));
    }

    @NotNull
    public static Type getArrayType(@NotNull Type componentType) {
        return Type.getType("[" + componentType.getDescriptor());
    }

    @Nullable
    public static PrimitiveType asmPrimitiveTypeToLangPrimitiveType(Type type2) {
        JvmPrimitiveType jvmPrimitiveType = primitiveTypeByAsmSort.get(type2.getSort());
        return jvmPrimitiveType != null ? jvmPrimitiveType.getPrimitiveType() : null;
    }

    @NotNull
    public static Method method(@NotNull String name, @NotNull Type returnType2, Type ... parameterTypes) {
        return new Method(name, Type.getMethodDescriptor(returnType2, parameterTypes));
    }

    public static boolean isAbstractMethod(FunctionDescriptor functionDescriptor, OwnerKind kind) {
        return (functionDescriptor.getModality() == Modality.ABSTRACT || JvmCodegenUtil.isJvmInterface(functionDescriptor.getContainingDeclaration()) && !AnnotationUtilKt.hasJvmDefaultAnnotation(functionDescriptor)) && !AsmUtil.isStaticMethod(kind, functionDescriptor);
    }

    public static boolean isStaticMethod(OwnerKind kind, CallableMemberDescriptor functionDescriptor) {
        return AsmUtil.isStaticKind(kind) || KotlinTypeMapper.isStaticAccessor(functionDescriptor) || CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(functionDescriptor);
    }

    public static boolean isStaticKind(OwnerKind kind) {
        return kind == OwnerKind.PACKAGE || kind == OwnerKind.DEFAULT_IMPLS || kind == OwnerKind.ERASED_INLINE_CLASS;
    }

    public static int getMethodAsmFlags(FunctionDescriptor functionDescriptor, OwnerKind kind, GenerationState state2) {
        DeclarationDescriptor containingDeclaration;
        int flags = AsmUtil.getCommonCallableFlags(functionDescriptor, state2);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.METHOD_FLAGS) {
            if (!flagAnnotation.hasAnnotation(functionDescriptor.getOriginal())) continue;
            flags |= flagAnnotation.getJvmFlag();
        }
        if (functionDescriptor.getOriginal().isExternal()) {
            flags |= 0x100;
        }
        if (CodegenUtilKt.isJvmStaticInCompanionObject(functionDescriptor)) {
            flags &= 0xFFFFFEFF;
        }
        if (!(functionDescriptor.getModality() != Modality.FINAL || functionDescriptor instanceof ConstructorDescriptor || (containingDeclaration = functionDescriptor.getContainingDeclaration()) instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.INTERFACE)) {
            flags |= 0x10;
        }
        if (AsmUtil.isStaticMethod(kind, functionDescriptor)) {
            flags |= 8;
        }
        if (AsmUtil.isAbstractMethod(functionDescriptor, kind)) {
            flags |= 0x400;
        }
        if (KotlinTypeMapper.isAccessor(functionDescriptor) || AnnotationUtilKt.hasJvmSyntheticAnnotation(functionDescriptor)) {
            flags |= 0x1000;
        }
        return flags;
    }

    public static int getCommonCallableFlags(FunctionDescriptor functionDescriptor, @NotNull GenerationState state2) {
        int flags = AsmUtil.getVisibilityAccessFlag(functionDescriptor);
        flags |= AsmUtil.getVarargsFlag(functionDescriptor);
        flags |= AsmUtil.getDeprecatedAccessFlag(functionDescriptor);
        if (state2.getDeprecationProvider().isDeprecatedHidden(functionDescriptor) || functionDescriptor.isSuspend() && functionDescriptor.getVisibility().equals(Visibilities.PRIVATE)) {
            flags |= 0x1000;
        }
        return flags;
    }

    public static int getVisibilityAccessFlag(@NotNull MemberDescriptor descriptor2) {
        Integer specialCase = AsmUtil.specialCaseVisibility(descriptor2);
        if (specialCase != null) {
            return specialCase;
        }
        Visibility visibility = descriptor2.getVisibility();
        Integer defaultMapping = AsmUtil.getVisibilityAccessFlag(visibility);
        if (defaultMapping == null) {
            throw new IllegalStateException(visibility + " is not a valid visibility in backend for " + DescriptorRenderer.DEBUG_TEXT.render(descriptor2));
        }
        return defaultMapping;
    }

    @Nullable
    public static Integer getVisibilityAccessFlag(Visibility visibility) {
        return visibilityToAccessFlag.get(visibility);
    }

    public static int getVisibilityAccessFlagForClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 instanceof SyntheticClassDescriptorForLambda) {
            return AsmUtil.getVisibilityAccessFlagForAnonymous(descriptor2);
        }
        if (ExpectedActualDeclarationChecker.isOptionalAnnotationClass(descriptor2)) {
            return 0;
        }
        if (descriptor2.getVisibility() == Visibilities.PUBLIC || descriptor2.getVisibility() == Visibilities.PROTECTED || descriptor2.getVisibility() == Visibilities.LOCAL || descriptor2.getVisibility() == Visibilities.INTERNAL) {
            return 1;
        }
        return 0;
    }

    private static int getVisibilityAccessFlagForAnonymous(@NotNull ClassDescriptor descriptor2) {
        return InlineUtil.isInlineOrContainingInline(descriptor2.getContainingDeclaration()) ? 1 : 0;
    }

    public static int calculateInnerClassAccessFlags(@NotNull ClassDescriptor innerClass) {
        int visibility = innerClass instanceof SyntheticClassDescriptorForLambda ? AsmUtil.getVisibilityAccessFlagForAnonymous(innerClass) : (innerClass.getVisibility() == Visibilities.LOCAL ? 1 : AsmUtil.getVisibilityAccessFlag(innerClass));
        return visibility | AsmUtil.innerAccessFlagsForModalityAndKind(innerClass) | (innerClass.isInner() ? 0 : 8);
    }

    private static int innerAccessFlagsForModalityAndKind(@NotNull ClassDescriptor innerClass) {
        switch (innerClass.getKind()) {
            case INTERFACE: {
                return 1536;
            }
            case ENUM_CLASS: {
                return 16400;
            }
            case ANNOTATION_CLASS: {
                return 9728;
            }
        }
        Modality modality = innerClass.getModality();
        if (modality == Modality.FINAL) {
            return 16;
        }
        if (modality == Modality.ABSTRACT || modality == Modality.SEALED) {
            return 1024;
        }
        return 0;
    }

    public static int getDeprecatedAccessFlag(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return KotlinBuiltIns.isDeprecated(descriptor2) ? 131072 : AsmUtil.getDeprecatedAccessFlag(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty());
        }
        if (KotlinBuiltIns.isDeprecated(descriptor2)) {
            return 131072;
        }
        return 0;
    }

    private static int getVarargsFlag(FunctionDescriptor functionDescriptor) {
        if (!functionDescriptor.getValueParameters().isEmpty() && functionDescriptor.getValueParameters().get(functionDescriptor.getValueParameters().size() - 1).getVarargElementType() != null) {
            return 128;
        }
        return 0;
    }

    @Nullable
    private static Integer specialCaseVisibility(@NotNull MemberDescriptor memberDescriptor) {
        PropertyDescriptor property;
        DeclarationDescriptor containingDeclaration = memberDescriptor.getContainingDeclaration();
        Visibility memberVisibility = memberDescriptor.getVisibility();
        if (org.jetbrains.kotlin.descriptors.annotations.AnnotationUtilKt.isEffectivelyInlineOnly(memberDescriptor)) {
            return 2;
        }
        if (memberVisibility == Visibilities.LOCAL && memberDescriptor instanceof CallableMemberDescriptor) {
            return 1;
        }
        if (DescriptorUtils.isEnumEntry(memberDescriptor)) {
            return 0;
        }
        if (CodegenUtilKt.isToArrayFromCollection(memberDescriptor)) {
            return 1;
        }
        if (memberDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isAnonymousObject(memberDescriptor.getContainingDeclaration())) {
            return AsmUtil.getVisibilityAccessFlagForAnonymous((ClassDescriptor)memberDescriptor.getContainingDeclaration());
        }
        if (memberDescriptor instanceof SyntheticJavaPropertyDescriptor) {
            return AsmUtil.getVisibilityAccessFlag(((SyntheticJavaPropertyDescriptor)memberDescriptor).getGetMethod());
        }
        if (memberDescriptor instanceof PropertyAccessorDescriptor && (property = ((PropertyAccessorDescriptor)memberDescriptor).getCorrespondingProperty()) instanceof SyntheticJavaPropertyDescriptor) {
            FunctionDescriptor method;
            FunctionDescriptor functionDescriptor = method = memberDescriptor == property.getGetter() ? ((SyntheticJavaPropertyDescriptor)property).getGetMethod() : ((SyntheticJavaPropertyDescriptor)property).getSetMethod();
            assert (method != null) : "No get/set method in SyntheticJavaPropertyDescriptor: " + property;
            return AsmUtil.getVisibilityAccessFlag(method);
        }
        if (memberDescriptor instanceof CallableDescriptor && memberVisibility == Visibilities.PROTECTED) {
            for (CallableDescriptor overridden : DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)((Object)memberDescriptor))) {
                if (!JvmCodegenUtil.isJvmInterface(overridden.getContainingDeclaration())) continue;
                return 1;
            }
        }
        if (!Visibilities.isPrivate(memberVisibility)) {
            return null;
        }
        if (memberDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)memberDescriptor).isSuspend()) {
            return 0;
        }
        if (memberDescriptor instanceof AccessorForCompanionObjectInstanceFieldDescriptor) {
            return 0;
        }
        if (memberDescriptor instanceof ConstructorDescriptor) {
            if (DescriptorUtils.isEnumEntry(containingDeclaration)) {
                return 0;
            }
            if (DescriptorUtils.isEnumClass(containingDeclaration)) {
                return 4;
            }
        }
        return null;
    }

    public static Type stringValueOfType(Type type2) {
        int sort = type2.getSort();
        return sort == 10 || sort == 9 ? AsmTypes.OBJECT_TYPE : (sort == 3 || sort == 4 ? Type.INT_TYPE : type2);
    }

    private static Type stringBuilderAppendType(Type type2) {
        switch (type2.getSort()) {
            case 10: {
                return STRING_BUILDER_OBJECT_APPEND_ARG_TYPES.contains(type2) ? type2 : AsmTypes.OBJECT_TYPE;
            }
            case 9: {
                return AsmTypes.OBJECT_TYPE;
            }
            case 3: 
            case 4: {
                return Type.INT_TYPE;
            }
        }
        return type2;
    }

    public static void genThrow(@NotNull InstructionAdapter v2, @NotNull String exception, @Nullable String message) {
        v2.anew(Type.getObjectType(exception));
        v2.dup();
        if (message != null) {
            v2.aconst(message);
            v2.invokespecial(exception, "<init>", "(Ljava/lang/String;)V", false);
        } else {
            v2.invokespecial(exception, "<init>", "()V", false);
        }
        v2.athrow();
    }

    public static void genClosureFields(@NotNull CalculatedClosure closure, ClassBuilder v2, KotlinTypeMapper typeMapper) {
        KotlinType captureReceiverType;
        ArrayList<Pair<String, Type>> allFields = new ArrayList<Pair<String, Type>>();
        ClassDescriptor captureThis = closure.getCaptureThis();
        if (captureThis != null) {
            allFields.add(Pair.create(CAPTURED_THIS_FIELD, typeMapper.mapType(captureThis)));
        }
        if ((captureReceiverType = closure.getCaptureReceiverType()) != null && !CallableReferenceUtilKt.isForCallableReference(closure)) {
            allFields.add(Pair.create(CAPTURED_RECEIVER_FIELD, typeMapper.mapType(captureReceiverType)));
        }
        allFields.addAll(closure.getRecordedFields());
        AsmUtil.genClosureFields(allFields, v2);
    }

    public static void genClosureFields(List<Pair<String, Type>> allFields, ClassBuilder builder) {
        int access = 4112;
        for (Pair<String, Type> field : allFields) {
            builder.newField(JvmDeclarationOrigin.NO_ORIGIN, access, (String)field.first, ((Type)field.second).getDescriptor(), null, null);
        }
    }

    public static int genAssignInstanceFieldFromParam(FieldInfo info, int index2, InstructionAdapter iv) {
        return AsmUtil.genAssignInstanceFieldFromParam(info, index2, iv, 0, false);
    }

    public static int genAssignInstanceFieldFromParam(FieldInfo info, int index2, InstructionAdapter iv, int ownerIndex, boolean cast) {
        assert (!info.isStatic());
        Type fieldType = info.getFieldType();
        iv.load(ownerIndex, info.getOwnerType());
        if (cast) {
            iv.load(index2, AsmTypes.OBJECT_TYPE);
            StackValue.coerce(AsmTypes.OBJECT_TYPE, fieldType, iv);
        } else {
            iv.load(index2, fieldType);
        }
        iv.visitFieldInsn(181, info.getOwnerInternalName(), info.getFieldName(), fieldType.getDescriptor());
        return index2 += fieldType.getSize();
    }

    public static void genStringBuilderConstructor(InstructionAdapter v2) {
        v2.visitTypeInsn(187, "java/lang/StringBuilder");
        v2.dup();
        v2.invokespecial("java/lang/StringBuilder", "<init>", "()V", false);
    }

    public static void genInvokeAppendMethod(@NotNull InstructionAdapter v2, @NotNull Type type2, @Nullable KotlinType kotlinType) {
        Type appendParameterType;
        if (kotlinType != null && InlineClassesUtilsKt.isInlineClassType(kotlinType)) {
            appendParameterType = AsmTypes.OBJECT_TYPE;
            SimpleType nullableAnyType = kotlinType.getConstructor().getBuiltIns().getNullableAnyType();
            StackValue.coerce(type2, kotlinType, appendParameterType, nullableAnyType, v2);
        } else {
            appendParameterType = AsmUtil.stringBuilderAppendType(type2);
        }
        v2.invokevirtual("java/lang/StringBuilder", "append", "(" + appendParameterType.getDescriptor() + ")Ljava/lang/StringBuilder;", false);
    }

    public static StackValue genToString(@NotNull StackValue receiver, @NotNull Type receiverType, @Nullable KotlinType receiverKotlinType) {
        return StackValue.operation(AsmTypes.JAVA_STRING_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v2 -> {
            SimpleType kotlinType;
            Type type2;
            if (receiverKotlinType != null && InlineClassesUtilsKt.isInlineClassType(receiverKotlinType)) {
                type2 = AsmTypes.OBJECT_TYPE;
                kotlinType = receiverKotlinType.getConstructor().getBuiltIns().getNullableAnyType();
            } else {
                type2 = AsmUtil.stringValueOfType(receiverType);
                kotlinType = null;
            }
            receiver.put(type2, kotlinType, (InstructionAdapter)v2);
            v2.invokestatic("java/lang/String", "valueOf", "(" + type2.getDescriptor() + ")Ljava/lang/String;", false);
            return null;
        }));
    }

    static void genHashCode(MethodVisitor mv, InstructionAdapter iv, Type type2, JvmTarget jvmTarget) {
        if (type2.getSort() == 9) {
            Type elementType = AsmUtil.correctElementType(type2);
            if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                iv.invokestatic("java/util/Arrays", "hashCode", "([Ljava/lang/Object;)I", false);
            } else {
                iv.invokestatic("java/util/Arrays", "hashCode", "(" + type2.getDescriptor() + ")I", false);
            }
        } else if (type2.getSort() == 10) {
            iv.invokevirtual("java/lang/Object", "hashCode", "()I", false);
        } else if (type2.getSort() == 1) {
            Label end = new Label();
            iv.dup();
            iv.ifeq(end);
            iv.pop();
            iv.iconst(1);
            iv.mark(end);
        } else if (JvmTarget.JVM_1_6 == jvmTarget) {
            if (type2.getSort() == 7) {
                AsmUtil.genLongHashCode(mv, iv);
            } else if (type2.getSort() == 8) {
                iv.invokestatic("java/lang/Double", "doubleToLongBits", "(D)J", false);
                AsmUtil.genLongHashCode(mv, iv);
            } else if (type2.getSort() == 6) {
                iv.invokestatic("java/lang/Float", "floatToIntBits", "(F)I", false);
            }
        } else {
            HashCode.Companion.invokeHashCode(iv, type2);
        }
    }

    private static void genLongHashCode(MethodVisitor mv, InstructionAdapter iv) {
        iv.dup2();
        iv.iconst(32);
        iv.ushr(Type.LONG_TYPE);
        iv.xor(Type.LONG_TYPE);
        mv.visitInsn(136);
    }

    public static void genInvertBoolean(InstructionAdapter v2) {
        v2.iconst(1);
        v2.xor(Type.INT_TYPE);
    }

    @NotNull
    public static StackValue genEqualsForExpressionsOnStack(@NotNull IElementType opToken, @NotNull StackValue left, @NotNull StackValue right) {
        Type leftType = left.type;
        Type rightType = right.type;
        if (AsmUtil.isPrimitive(leftType) && leftType == rightType) {
            return StackValue.cmp(opToken, leftType, left, right);
        }
        return StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v2 -> {
            left.put(leftType, (InstructionAdapter)v2);
            right.put(rightType, (InstructionAdapter)v2);
            AsmUtil.genAreEqualCall(v2);
            if (opToken == KtTokens.EXCLEQ || opToken == KtTokens.EXCLEQEQEQ) {
                AsmUtil.genInvertBoolean(v2);
            }
            return Unit.INSTANCE;
        }));
    }

    public static void genAreEqualCall(InstructionAdapter v2) {
        v2.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
    }

    public static void genIEEE754EqualForNullableTypesCall(InstructionAdapter v2, Type left, Type right) {
        v2.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", "(" + left.getDescriptor() + right.getDescriptor() + ")Z", false);
    }

    public static void numConst(int value, Type type2, InstructionAdapter v2) {
        if (type2 == Type.FLOAT_TYPE) {
            v2.fconst(value);
        } else if (type2 == Type.DOUBLE_TYPE) {
            v2.dconst(value);
        } else if (type2 == Type.LONG_TYPE) {
            v2.lconst(value);
        } else if (type2 == Type.CHAR_TYPE || type2 == Type.BYTE_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.INT_TYPE) {
            v2.iconst(value);
        } else {
            throw new IllegalArgumentException("Primitive numeric type expected, got: " + type2);
        }
    }

    public static void genIncrement(Type baseType, int myDelta, InstructionAdapter v2) {
        Type operationType = AsmUtil.numberFunctionOperandType(baseType);
        AsmUtil.numConst(myDelta, operationType, v2);
        v2.add(operationType);
        StackValue.coerce(operationType, baseType, v2);
    }

    public static void swap(InstructionAdapter v2, Type stackTop, Type afterTop) {
        if (stackTop.getSize() == 1) {
            if (afterTop.getSize() == 1) {
                v2.swap();
            } else {
                v2.dupX2();
                v2.pop();
            }
        } else {
            if (afterTop.getSize() == 1) {
                v2.dup2X1();
            } else {
                v2.dup2X2();
            }
            v2.pop2();
        }
    }

    public static void genNotNullAssertionsForParameters(@NotNull InstructionAdapter v2, @NotNull GenerationState state2, @NotNull FunctionDescriptor descriptor2, @NotNull FrameMap frameMap) {
        if (state2.isParamAssertionsDisabled()) {
            return;
        }
        if (descriptor2.isSuspend()) {
            return;
        }
        if (AsmUtil.getVisibilityAccessFlag(descriptor2) == 2) {
            ReceiverParameterDescriptor receiverParameter;
            if (state2.isReceiverAssertionsDisabled()) {
                return;
            }
            if (descriptor2.isOperator() && (receiverParameter = descriptor2.getExtensionReceiverParameter()) != null) {
                AsmUtil.genParamAssertion(v2, state2.getTypeMapper(), frameMap, receiverParameter, RECEIVER_NAME);
            }
            return;
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            AsmUtil.genParamAssertion(v2, state2.getTypeMapper(), frameMap, receiverParameter, RECEIVER_NAME);
        }
        for (ValueParameterDescriptor parameter : descriptor2.getValueParameters()) {
            AsmUtil.genParamAssertion(v2, state2.getTypeMapper(), frameMap, parameter, parameter.getName().asString());
        }
    }

    private static void genParamAssertion(@NotNull InstructionAdapter v2, @NotNull KotlinTypeMapper typeMapper, @NotNull FrameMap frameMap, @NotNull ParameterDescriptor parameter, @NotNull String name) {
        KotlinType type2 = parameter.getType();
        if (TypeUtils.isNullableType(type2) || InlineClassesUtilsKt.isNullableUnderlyingType(type2)) {
            return;
        }
        Type asmType = typeMapper.mapType(type2);
        if (asmType.getSort() == 10 || asmType.getSort() == 9) {
            StackValue value;
            if (JvmCodegenUtil.isDeclarationOfBigArityFunctionInvoke(parameter.getContainingDeclaration())) {
                int index2 = AsmUtil.getIndexOfParameterInVarargInvokeArray(parameter);
                value = StackValue.arrayElement(AsmTypes.OBJECT_TYPE, null, StackValue.local(1, AsmUtil.getArrayType(AsmTypes.OBJECT_TYPE)), StackValue.constant(index2));
            } else {
                int index3 = frameMap.getIndex(parameter);
                value = StackValue.local(index3, asmType);
            }
            value.put(asmType, v2);
            v2.visitLdcInsn(name);
            v2.invokestatic("kotlin/jvm/internal/Intrinsics", "checkParameterIsNotNull", "(Ljava/lang/Object;Ljava/lang/String;)V", false);
        }
    }

    @NotNull
    public static StackValue genNotNullAssertions(@NotNull GenerationState state2, final @NotNull StackValue stackValue, final @Nullable RuntimeAssertionInfo runtimeAssertionInfo) {
        if (state2.isCallAssertionsDisabled()) {
            return stackValue;
        }
        if (runtimeAssertionInfo == null || !runtimeAssertionInfo.getNeedNotNullAssertion()) {
            return stackValue;
        }
        return new StackValue(stackValue.type){

            @Override
            public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v2) {
                Type innerType = stackValue.type;
                stackValue.put(innerType, v2);
                if (innerType.getSort() == 10 || innerType.getSort() == 9) {
                    v2.dup();
                    v2.visitLdcInsn(runtimeAssertionInfo.getMessage());
                    v2.invokestatic("kotlin/jvm/internal/Intrinsics", "checkExpressionValueIsNotNull", "(Ljava/lang/Object;Ljava/lang/String;)V", false);
                }
                StackValue.coerce(innerType, type2, v2);
            }
        };
    }

    private static int getIndexOfParameterInVarargInvokeArray(@NotNull ParameterDescriptor parameter) {
        if (parameter instanceof ReceiverParameterDescriptor) {
            return 0;
        }
        DeclarationDescriptor container2 = parameter.getContainingDeclaration();
        assert (parameter instanceof ValueParameterDescriptor) : "Non-extension-receiver parameter must be a value parameter: " + parameter;
        int extensionShift = ((CallableDescriptor)container2).getExtensionReceiverParameter() == null ? 0 : 1;
        return extensionShift + ((ValueParameterDescriptor)parameter).getIndex();
    }

    public static void generateVarargInvokeArityAssert(InstructionAdapter v2, int functionArity) {
        Label start = new Label();
        v2.load(1, AsmUtil.getArrayType(AsmTypes.OBJECT_TYPE));
        v2.arraylength();
        v2.iconst(functionArity);
        v2.ificmpeq(start);
        v2.visitLdcInsn("Vararg argument must contain " + functionArity + " elements.");
        v2.invokestatic("kotlin/jvm/internal/Intrinsics", "throwIllegalArgument", "(Ljava/lang/String;)V", false);
        v2.visitLabel(start);
    }

    public static void pushDefaultValueOnStack(@NotNull Type type2, @NotNull InstructionAdapter v2) {
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            v2.aconst(null);
        } else {
            AsmUtil.pushDefaultPrimitiveValueOnStack(type2, v2);
        }
    }

    public static void pushDefaultPrimitiveValueOnStack(@NotNull Type type2, @NotNull InstructionAdapter v2) {
        if (type2.getSort() == 6) {
            v2.fconst(0.0f);
        } else if (type2.getSort() == 8) {
            v2.dconst(0.0);
        } else if (type2.getSort() == 7) {
            v2.lconst(0L);
        } else {
            v2.iconst(0);
        }
    }

    public static boolean isInstancePropertyWithStaticBackingField(@NotNull PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && DescriptorUtils.isObject(propertyDescriptor.getContainingDeclaration());
    }

    public static int getVisibilityForBackingField(@NotNull PropertyDescriptor propertyDescriptor, boolean isDelegate) {
        boolean isExtensionProperty;
        boolean bl = isExtensionProperty = propertyDescriptor.getExtensionReceiverParameter() != null;
        if (isDelegate || isExtensionProperty) {
            return 2;
        }
        return propertyDescriptor.isLateInit() || JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(propertyDescriptor) ? AsmUtil.getVisibilityAccessFlag(AsmUtil.descriptorForVisibility(propertyDescriptor)) : 2;
    }

    private static MemberDescriptor descriptorForVisibility(@NotNull PropertyDescriptor propertyDescriptor) {
        if (!propertyDescriptor.isVar()) {
            return propertyDescriptor;
        }
        return propertyDescriptor.getSetter() != null ? propertyDescriptor.getSetter() : propertyDescriptor;
    }

    public static boolean isPropertyWithBackingFieldCopyInOuterClass(@NotNull PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor propertyContainer = propertyDescriptor.getContainingDeclaration();
        return propertyDescriptor.isConst() && DescriptorUtils.isCompanionObject(propertyContainer) && JvmCodegenUtil.isJvmInterface(propertyContainer.getContainingDeclaration()) && AsmUtil.getVisibilityForBackingField(propertyDescriptor, false) == 1;
    }

    public static Type comparisonOperandType(Type left, Type right) {
        if (left == Type.DOUBLE_TYPE || right == Type.DOUBLE_TYPE) {
            return Type.DOUBLE_TYPE;
        }
        if (left == Type.FLOAT_TYPE || right == Type.FLOAT_TYPE) {
            return Type.FLOAT_TYPE;
        }
        if (left == Type.LONG_TYPE || right == Type.LONG_TYPE) {
            return Type.LONG_TYPE;
        }
        if (left == Type.CHAR_TYPE || right == Type.CHAR_TYPE) {
            return Type.CHAR_TYPE;
        }
        return Type.INT_TYPE;
    }

    @NotNull
    public static Type numberFunctionOperandType(@NotNull Type expectedType) {
        if (expectedType == Type.SHORT_TYPE || expectedType == Type.BYTE_TYPE || expectedType == Type.CHAR_TYPE) {
            return Type.INT_TYPE;
        }
        return expectedType;
    }

    public static void pop(@NotNull MethodVisitor v2, @NotNull Type type2) {
        if (type2.getSize() == 2) {
            v2.visitInsn(88);
        } else {
            v2.visitInsn(87);
        }
    }

    public static void pop2(@NotNull MethodVisitor v2, @NotNull Type type2) {
        if (type2.getSize() == 2) {
            v2.visitInsn(88);
            v2.visitInsn(88);
        } else {
            v2.visitInsn(88);
        }
    }

    public static void dup(@NotNull InstructionAdapter v2, @NotNull Type type2) {
        AsmUtil.dup(v2, type2.getSize());
    }

    private static void dup(@NotNull InstructionAdapter v2, int size) {
        if (size == 2) {
            v2.dup2();
        } else if (size == 1) {
            v2.dup();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void dupx(@NotNull InstructionAdapter v2, @NotNull Type type2) {
        AsmUtil.dupx(v2, type2.getSize());
    }

    private static void dupx(@NotNull InstructionAdapter v2, int size) {
        if (size == 2) {
            v2.dup2X2();
        } else if (size == 1) {
            v2.dupX1();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void dup(@NotNull InstructionAdapter v2, @NotNull Type topOfStack, @NotNull Type afterTop) {
        if (topOfStack.getSize() == 0 && afterTop.getSize() == 0) {
            return;
        }
        if (topOfStack.getSize() == 0) {
            AsmUtil.dup(v2, afterTop);
        } else if (afterTop.getSize() == 0) {
            AsmUtil.dup(v2, topOfStack);
        } else if (afterTop.getSize() == 1) {
            if (topOfStack.getSize() == 1) {
                AsmUtil.dup(v2, 2);
            } else {
                v2.dup2X1();
                v2.pop2();
                v2.dupX2();
                v2.dupX2();
                v2.pop();
                v2.dup2X1();
            }
        } else {
            throw new UnsupportedOperationException("Don't know how generate dup3/dup4 for: " + topOfStack + " and " + afterTop);
        }
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull DescriptorSerializer serializer, @NotNull MessageLite message) {
        AsmUtil.writeAnnotationData(av, message, (JvmStringTable)((Object)serializer.getStringTable()));
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull MessageLite message, @NotNull JvmStringTable stringTable) {
        AsmUtil.writeAnnotationData(av, JvmProtoBufUtil.writeData(message, stringTable), ArrayUtil.toStringArray(stringTable.getStrings()));
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull String[] data, @NotNull String[] strings) {
        AnnotationVisitor dataVisitor = av.visitArray("d1");
        for (String string : data) {
            dataVisitor.visit(null, string);
        }
        dataVisitor.visitEnd();
        AnnotationVisitor stringsVisitor = av.visitArray("d2");
        for (String string : strings) {
            stringsVisitor.visit(null, string);
        }
        stringsVisitor.visitEnd();
    }

    @NotNull
    public static Type asmTypeByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        return Type.getObjectType(AsmUtil.internalNameByFqNameWithoutInnerClasses(fqName2));
    }

    @NotNull
    public static Type asmTypeByClassId(@NotNull ClassId classId) {
        return Type.getObjectType(classId.asString().replace('.', '$'));
    }

    @NotNull
    public static String internalNameByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        return JvmClassName.byFqNameWithoutInnerClasses(fqName2).getInternalName();
    }

    public static void putJavaLangClassInstance(@NotNull InstructionAdapter v2, @NotNull Type type2) {
        if (AsmUtil.isPrimitive(type2)) {
            v2.getstatic(AsmUtil.boxType(type2).getInternalName(), "TYPE", "Ljava/lang/Class;");
        } else {
            v2.aconst(type2);
        }
    }

    public static void wrapJavaClassIntoKClass(@NotNull InstructionAdapter v2) {
        v2.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinClass", Type.getMethodDescriptor(AsmTypes.K_CLASS_TYPE, AsmTypes.getType(Class.class)), false);
    }

    public static void wrapJavaClassesIntoKClasses(@NotNull InstructionAdapter v2) {
        v2.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinClasses", Type.getMethodDescriptor(AsmTypes.K_CLASS_ARRAY_TYPE, AsmTypes.getType(Class[].class)), false);
    }

    public static int getReceiverIndex(@NotNull CodegenContext context, @NotNull CallableMemberDescriptor descriptor2) {
        OwnerKind kind = context.getContextKind();
        return kind != OwnerKind.DEFAULT_IMPLS && AsmUtil.isStaticMethod(kind, descriptor2) ? 0 : 1;
    }

    static {
        ImmutableMap.Builder<Integer, JvmPrimitiveType> typeBySortBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<Type, Type> typeByWrapperBuilder = ImmutableMap.builder();
        for (JvmPrimitiveType primitiveType : JvmPrimitiveType.values()) {
            Type asmType = Type.getType(primitiveType.getDesc());
            typeBySortBuilder.put(asmType.getSort(), primitiveType);
            typeByWrapperBuilder.put(AsmUtil.asmTypeByFqNameWithoutInnerClasses(primitiveType.getWrapperFqName()), asmType);
        }
        primitiveTypeByAsmSort = typeBySortBuilder.build();
        primitiveTypeByBoxedType = typeByWrapperBuilder.build();
    }
}

