/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.script;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.dependencies.ScriptReport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.script.CliScriptReportSink$WhenMappings;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.script.ScriptReportSink;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/cli/common/script/CliScriptReportSink;", "Lorg/jetbrains/kotlin/script/ScriptReportSink;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "attachReports", "", "scriptFile", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "reports", "", "Lkotlin/script/experimental/dependencies/ScriptReport;", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocation;", "position", "Lkotlin/script/experimental/dependencies/ScriptReport$Position;", "convertSeverity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "Lkotlin/script/experimental/dependencies/ScriptReport$Severity;", "cli"})
public final class CliScriptReportSink
implements ScriptReportSink {
    private final MessageCollector messageCollector;

    @Override
    public void attachReports(@NotNull VirtualFile scriptFile, @NotNull List<ScriptReport> reports) {
        Intrinsics.checkParameterIsNotNull((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkParameterIsNotNull(reports, (String)"reports");
        Iterable $receiver$iv = reports;
        for (Object element$iv : $receiver$iv) {
            ScriptReport it = (ScriptReport)element$iv;
            this.messageCollector.report(this.convertSeverity(it.getSeverity()), it.getMessage(), this.location(scriptFile, it.getPosition()));
        }
    }

    private final CompilerMessageLocation location(VirtualFile scriptFile, ScriptReport.Position position) {
        if (position == null) {
            return CompilerMessageLocation.Companion.create(scriptFile.getPath());
        }
        return CompilerMessageLocation.Companion.create(scriptFile.getPath(), position.getStartLine(), position.getStartColumn(), null);
    }

    private final CompilerMessageSeverity convertSeverity(@NotNull ScriptReport.Severity $receiver) {
        CompilerMessageSeverity compilerMessageSeverity;
        switch (CliScriptReportSink$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                break;
            }
            case 2: {
                compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                break;
            }
            case 3: {
                compilerMessageSeverity = CompilerMessageSeverity.WARNING;
                break;
            }
            case 4: {
                compilerMessageSeverity = CompilerMessageSeverity.INFO;
                break;
            }
            case 5: {
                compilerMessageSeverity = CompilerMessageSeverity.LOGGING;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return compilerMessageSeverity;
    }

    public CliScriptReportSink(@NotNull MessageCollector messageCollector2) {
        Intrinsics.checkParameterIsNotNull((Object)messageCollector2, (String)"messageCollector");
        this.messageCollector = messageCollector2;
    }
}

