/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.platform;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetAnnotationUseSiteTarget;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.TypeUtils;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={")\u0006)Yb)\u001b7f\u00072\f7o]!o]>$\u0018\r^5p]N\u001c\u0005.Z2lKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\be\u0016\u001cx\u000e\u001c<f\u0015\rQg/\u001c\u0006\ta2\fGOZ8s[*Y\u0012\t\u001a3ji&|g.\u00197B]:|G/\u0019;j_:\u001c\u0005.Z2lKJT\u0011#\u0011'X\u0003f\u001bv,\u0011)Q\u0019&\u001b\u0015I\u0011'F\u0015\u001dA\u0015m\u001d5TKRTAA[1wC*!Q\u000f^5m\u0015\u00191\u0015OT1nK*!a.Y7f\u00151\u0019\u0007.Z2l\u000b:$(/[3t\u0015\u001d)g\u000e\u001e:jKNTA\u0001T5ti*\u0011\"*\u001a;B]:|G/\u0019;j_:,e\u000e\u001e:z\u0015\r\u00018/\u001b\u0006\u000eC\u000e$X/\u00197UCJ<W\r^:\u000b\u0019-{G\u000f\\5o)\u0006\u0014x-\u001a;\u000b\u0017\u0011,7o\u0019:jaR|'o\u001d\u0006\fC:tw\u000e^1uS>t7OC\u0003ue\u0006\u001cWM\u0003\u0007CS:$\u0017N\\4Ue\u0006\u001cWM\u0003\u0003V]&$(5\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0005\u0011\u0011\u0001bA\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001r\u0001\u0007\u0001\u000b\u0005AQ!\u0002\u0002\u0005\t!-Qa\u0001C\u0005\u0011\u0013a\u0001!\u0002\u0002\u0005\u0003!5Qa\u0001C\u0006\u0011\u0019a\u0001!\u0002\u0002\u0005\n!%Q!\u0001E\u0002\u000b\r!q\u0001\u0003\u0005\r\u0001\u0015\u0011A!\u0001\u0005\n\u000b\r!\u0001\u0002#\u0005\r\u0001\u0015\u0011A!\u0001E\u000b\u000b\t!\u0011\u0002C\u0006\u0006\u0007\u0011M\u0001B\u0003\u0007\u0001\u000b\r!\u0019\u0001\u0003\u0007\r\u0001\u0015\u0019Aa\u0002E\r\u0019\u0001)!\u0001\"\u0003\t\u0011\u0015\u0011A1\u0001\u0005\r\t\r\fAbA\r\u0004\u000b\u0005A9\u0001g\u0002.#\u0011\tG\u0001\u0007\u0003\"\u0011\u0015\t\u0001\"B\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0004\u0019\ra)Qk\u0001\u0003\u0006\u0007\u0011!\u0011\"\u0001E\u0007[Q\"1\u0002G\u0004\u001e\u001a\u0011\u0001\u0001rB\u0007\t\u000b\u0005Ay!\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0003M\t1\u001f\u00016\u0001AO\r\t\u0001A\u0019\"\u0004\u0005\u0006\u0003!=\u0011\u0002B\u0005\u0004\u000b\u0005A!\u0002\u0007\u0006\u0019\u0010A\u001b\t!h\u0004\u0005\u0001!]QbA\u0003\u0002\u0011+A*\u0002U\u0002\u0002C\r)\u0011\u0001C\u0006\u0019\u0017E\u001b\u0011\u0002B\u0004\n\u0003\u0011\u0001Q\"\u0001E\f\u001b\u0005A9\"D\u0001\t\u0019U\u0002\u0001"})
public final class FileClassAnnotationsChecker
implements AdditionalAnnotationChecker {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final HashSet<FqName> ALWAYS_APPLICABLE;
    public static final FileClassAnnotationsChecker INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(FileClassAnnotationsChecker.class);
        new FileClassAnnotationsChecker();
    }

    @Override
    public void checkEntries(@NotNull List<? extends JetAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace) {
        boolean bl;
        ClassDescriptor classDescriptor;
        ArrayList<Pair> fileAnnotationsToCheck;
        block6: {
            Intrinsics.checkParameterIsNotNull(entries, "entries");
            Intrinsics.checkParameterIsNotNull(actualTargets, "actualTargets");
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            fileAnnotationsToCheck = CollectionsKt.arrayListOf(new Pair[0]);
            for (JetAnnotationEntry pair : entries) {
                AnnotationDescriptor descriptor2;
                JetAnnotationUseSiteTarget jetAnnotationUseSiteTarget = pair.getUseSiteTarget();
                if (Intrinsics.areEqual((Object)(jetAnnotationUseSiteTarget != null ? jetAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null), (Object)AnnotationUseSiteTarget.FILE) ^ true) continue;
                if ((AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, pair) == null) {
                    continue;
                }
                if (TypeUtils.getClassDescriptor(descriptor2.getType()) == null) {
                    continue;
                }
                ClassDescriptor classDescriptor2 = classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "classDescriptor");
                Set<KotlinTarget> applicableTargets = AnnotationChecker.Companion.applicableTargetSet(classDescriptor2);
                if (applicableTargets == null || !applicableTargets.contains((Object)KotlinTarget.FILE)) continue;
                fileAnnotationsToCheck.add(new Pair<JetAnnotationEntry, ClassDescriptor>(pair, classDescriptor));
            }
            Iterable iterable = fileAnnotationsToCheck;
            for (JetAnnotationEntry element : iterable) {
                Pair it2 = (Pair)((Object)element);
                if (!Intrinsics.areEqual(DescriptorUtilsKt.getClassId((ClassDescriptor)it2.getSecond()).asSingleFqName(), JvmFileClassUtil.INSTANCE$.getJVM_MULTIFILE_CLASS())) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (!bl) {
            return;
        }
        for (Pair pair : fileAnnotationsToCheck) {
            JetAnnotationEntry entry = (JetAnnotationEntry)pair.component1();
            classDescriptor = (ClassDescriptor)pair.component2();
            FqName classFqName = DescriptorUtilsKt.getClassId(classDescriptor).asSingleFqName();
            if (ALWAYS_APPLICABLE.contains(classFqName) || !(Intrinsics.areEqual((Object)DescriptorUtilsKt.getAnnotationRetention(classDescriptor), (Object)KotlinRetention.SOURCE) ^ true)) continue;
            trace.report(ErrorsJvm.ANNOTATION_IS_NOT_APPLICABLE_TO_MULTIFILE_CLASSES.on((JetAnnotationEntry)((PsiElement)entry), classFqName));
        }
    }

    FileClassAnnotationsChecker() {
        INSTANCE$ = this;
        ALWAYS_APPLICABLE = SetsKt.hashSetOf(JvmFileClassUtil.INSTANCE$.getJVM_NAME(), JvmFileClassUtil.INSTANCE$.getJVM_MULTIFILE_CLASS());
    }
}

