/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsObjectScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScopesKt;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.util.Maps;

public abstract class JsScope {
    @NotNull
    private final String description;
    private Map<String, JsName> names;
    private final JsScope parent;
    protected int tempIndex;
    private final String scopeId;
    private static final Pattern FRESH_NAME_SUFFIX = Pattern.compile("[\\$_]\\d+$");

    public JsScope(JsScope parent, @NotNull String description, @Nullable String scopeId) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope", "<init>"));
        }
        this.names = Collections.emptyMap();
        this.tempIndex = 0;
        this.scopeId = scopeId;
        this.description = description;
        this.parent = parent;
    }

    protected JsScope(@NotNull String description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope", "<init>"));
        }
        this.names = Collections.emptyMap();
        this.tempIndex = 0;
        this.description = description;
        this.parent = null;
        this.scopeId = null;
    }

    @NotNull
    public JsScope innerObjectScope(@NotNull String scopeName) {
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope", "innerObjectScope"));
        }
        JsObjectScope jsObjectScope = JsScopesKt.JsObjectScope(this, scopeName);
        if (jsObjectScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope", "innerObjectScope"));
        }
        return jsObjectScope;
    }

    @NotNull
    public JsName declareName(@NotNull String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope", "declareName"));
        }
        JsName name = this.findOwnName(identifier);
        JsName jsName = name != null ? name : this.doCreateName(identifier);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope", "declareName"));
        }
        return jsName;
    }

    @NotNull
    public JsName declareFreshName(@NotNull String suggestedName) {
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope", "declareFreshName"));
        }
        assert (!suggestedName.isEmpty());
        String ident = this.getFreshIdent(suggestedName);
        assert (!this.hasOwnName(ident));
        JsName jsName = this.doCreateName(ident);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope", "declareFreshName"));
        }
        return jsName;
    }

    private String getNextTempName() {
        return "tmp$" + (this.scopeId != null ? this.scopeId + "$" : "") + this.tempIndex++;
    }

    @NotNull
    public JsName declareTemporary() {
        JsName jsName = this.declareFreshName(this.getNextTempName());
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope", "declareTemporary"));
        }
        return jsName;
    }

    @Nullable
    public final JsName findName(String ident) {
        JsName name = this.findOwnName(ident);
        if (name == null && this.parent != null) {
            return this.parent.findName(ident);
        }
        return name;
    }

    public boolean hasOwnName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope", "hasOwnName"));
        }
        return this.names.containsKey(name);
    }

    public final JsScope getParent() {
        return this.parent;
    }

    public JsProgram getProgram() {
        assert (this.parent != null) : "Subclasses must override getProgram() if they do not set a parent";
        return this.parent.getProgram();
    }

    public final String toString() {
        if (this.parent != null) {
            return this.description + "->" + this.parent;
        }
        return this.description;
    }

    public void copyOwnNames(JsScope other) {
        this.names = new HashMap<String, JsName>(this.names);
        this.names.putAll(other.names);
    }

    @NotNull
    public String getDescription() {
        String string = this.description;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope", "getDescription"));
        }
        return string;
    }

    @NotNull
    protected JsName doCreateName(@NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope", "doCreateName"));
        }
        JsName name = new JsName(this, ident);
        this.names = Maps.put(this.names, ident, name);
        JsName jsName = name;
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope", "doCreateName"));
        }
        return jsName;
    }

    protected JsName findOwnName(@NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope", "findOwnName"));
        }
        return this.names.get(ident);
    }

    @NotNull
    protected String getFreshIdent(@NotNull String suggestedIdent) {
        if (suggestedIdent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedIdent", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope", "getFreshIdent"));
        }
        char sep = '_';
        String baseName = suggestedIdent;
        int counter = 0;
        Matcher matcher = FRESH_NAME_SUFFIX.matcher(suggestedIdent);
        if (matcher.find()) {
            String group = matcher.group();
            baseName = matcher.replaceAll("");
            sep = group.charAt(0);
            counter = Integer.valueOf(group.substring(1));
        }
        String freshName = suggestedIdent;
        while (this.hasOwnName(freshName)) {
            freshName = baseName + sep + counter++;
        }
        String string = freshName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope", "getFreshIdent"));
        }
        return string;
    }
}

