/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preprocessor;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.StringsKt;
import kotlin.TuplesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.preprocessor.Evaluator;
import org.jetbrains.kotlin.preprocessor.JsPlatformEvaluator;
import org.jetbrains.kotlin.preprocessor.JvmPlatformEvaluator;
import org.jetbrains.kotlin.preprocessor.PreprocessorKt;
import org.jetbrains.kotlin.preprocessor.Profile;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"`\u0006)\t\u0002O]8gS2,WI^1mk\u0006$xN]:\u000b\u00075\u000b\u0007O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0007'R\u0014\u0018N\\4\u000b\u0013\u0019+hn\u0019;j_:\u0004$\"C#wC2,\u0018\r^8s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTA\u0002\u001d:faJ|7-Z:t_JTAA[1wC*!Q\u000f^5m\u0015Q9W\r\u001e)s_\u001aLG.Z#wC2,\u0018\r^8sg*q\u0001K]3qe>\u001cWm]:pe.#(bD2sK\u0006$XMS:Qe>4\u0017\u000e\\3\u000b\u0015Q\f'oZ3u%>|GO\u0003\u0003GS2,'BA5p\u0015\u001d\u0001&o\u001c4jY\u0016T\u0001c\u0019:fCR,'J^7Qe>4\u0017\u000e\\3\u000b\u000fY,'o]5p]*\u0019\u0011J\u001c;\u000b\u001b\r\u0014X-\u0019;f!J|g-\u001b7f\u0015\u0011q\u0017-\\3\u000b\t1\fgn\u001a\u0006\u0016G>tg/\u001a:u\u0019&tWmU3qCJ\fGo\u001c:t\u00155I7\u000fV3yi\u0016\u000bX/\u00197U_*91m\u001c8uK:$(b\u0002\"p_2,\u0017M\u001c\u0006\u000f[\u0006\\WMU3mCRLg/\u001a+p\u0015\u00111'o\\7\u000b\u0005Q|'\u0002D7lI&\u00148o\u0014:GC&d'\u0002B+oSR\u0004\u001aA\u0003\u0002\u0011\u0005)1\u0001\u0002\u0001\t\u00021\u0001Qa\u0001\u0003\u0001\u0011\u0007a\u0001!B\u0002\u0005\u0001!\u0011A\u0002A\u0003\u0002\u0011\r)!\u0001\u0002\u0002\t\b\u0015\u0011AQ\u0001\u0005\u0002\u000b\t!1\u0001\u0003\u0003\u0006\u0007\u0011\u001d\u0001R\u0001\u0007\u0001\u000b\u0005AI!\u0002\u0002\u0005\n!)QA\u0001\u0003\u0006\u0011\u0003)!\u0001\"\u0003\t\u0011\u0015\u0019AA\u0002E\b\u0019\u0001)1\u0001b\u0002\t\u00121\u0001QA\u0001C\u0004\u0011#)!\u0001\u0002\u0004\t\u0010\u0015\u0019A\u0001\u0001\u0005\u000b\u0019\u0001)!\u0001\"\u0003\t\u0018\u0015\u0011A!\u0003E\u0002\u000b\r!\u0001\u0001c\u0007\r\u0001\u0015\u0019A\u0001\u0001\u0005\u0011\u0019\u0001)\t\u0005B2\u00051\u0001\t##B\u0001\t\u0002%!\u0011bA\u0003\u0002\u0011\u0005A\u0012!C\u0005\n\u0011\u0015\t\u00012A\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0003\u0019\ta\r\u0001\u0014A+\u0004\u0011\u0015\u0019A\u0001A\u0005\u0002\u0011\u0017i1\u0001b\u0003\n\u0003!-\u0001l\u0001\u0004\u0006.\u0011\u0019\u0001TBO\b\t\u0001Aq!D\u0002\u0006\u0003!5\u0001T\u0002)\u0004\u0001\u0005\u001aQ!\u0001\u0005\b1\u001d\t6!\u0002C\u0007\u0013\u0005Ay!D\u0001\t\u0011a\u001ba!B\u0011\u0005\u0007aIQt\u0002\u0003\u0001\u0011\u001di1!B\u0001\t\u000ea5\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u00012C\u0007\u0004\u000b\u0005A\t\u0002'\u0005Q\u0007\u0003\t3!B\u0001\t\u000fa9\u0011kA\u0004\u0005\u0013%\t\u0001rB\u0007\u0002\u0011!i\u0011\u0001\"\u0002Y\u0007\u0019)\u0011\u0005B\u0002\u0019\u0016u=A\u0001\u0001\u0005\f\u001b\r)\u0011\u0001C\u0001\u0019\u0003A\u001b\u0001!h\u0004\u0005\u0001!9QbA\u0003\u0002\u0011\u001bAj\u0001UB\u0001C\r)\u0011\u0001C\u0004\u0019\u000fE\u001bq\u0001\"\u0006\n\u0003!=Q\"\u0001E\n\u001b\u0005A\u0001\u0002W\u0002\u0007\u000bI!1!F\u0002\u0006\u0003!\t\u0001$\u0001\r\rC\r)\u0011\u0001C\u0001\u0019\u0003E\u001bQ\u0001\u0002\u0007\n\u0003!MQ\"\u0001E\n1\u000e1Q\u0011\b\u0003\u0004+\r)\u0011\u0001#\u0004\u0019\u000eaeQt\u0002\u0003\u0001\u00115i1!B\u0001\t\u0003a\t\u0001k!\u0001\"\u0007\u0015\t\u0001B\u0003\r\u000b#\u000e9A\u0011D\u0005\u0002\t\u0003i\u0011\u0001\u0003\u0005\u000e\u0003!M\u0001l\u0001\u0004\u0006O\u0011\u0019QcA\u0003\u0002\u0011\u001bAj\u0001\u0007\b\u001e\u0010\u0011\u0001\u0001RD\u0007\u0004\u000b\u0005Ai\u0001'\u0004Q\u0007\u0003iz\u0001\u0002\u0001\t\u001f5\u0019Q!\u0001E\u00071\u001b\u00016!A\u0011\u0004\u000b\u0005Ai\u0001'\u0004R\u0007%!a\"C\u0001\t\u00115\t\u0001\u0002C\u0007\u0002\u0011!i\u0011\u0001\u0003\u0005Y\u0007\u0019)!\u0003B\u0002\u0016\u0007\u0015\t\u0001R\u0002M\u00071?\t3!B\u0001\t\u0016aU\u0011kA\u0003\u0005 %\tA\u0001A\u0007\u0002\u0011!A6A\u0002"})
public final class PreprocessorKt {
    @NotNull
    static final Map<String, ? extends Function0<? extends Evaluator>> profileEvaluators;

    @NotNull
    public static final Profile createJvmProfile(@NotNull File targetRoot, int version) {
        Intrinsics.checkParameterIsNotNull(targetRoot, "targetRoot");
        return new Profile("JVM" + version, new JvmPlatformEvaluator(version), new File(targetRoot, "jvm" + version));
    }

    @NotNull
    public static final Profile createJsProfile(@NotNull File targetRoot) {
        Intrinsics.checkParameterIsNotNull(targetRoot, "targetRoot");
        return new Profile("JS", new JsPlatformEvaluator(0, 1, null), new File(targetRoot, "js"));
    }

    @NotNull
    public static final Map<String, Function0<? extends Evaluator>> getProfileEvaluators() {
        return profileEvaluators;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Profile createProfile(@NotNull String name, @NotNull File targetRoot) {
        void evaluator;
        void profileName;
        Object v0;
        block2: {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(targetRoot, "targetRoot");
            Iterable $receiver = profileEvaluators.entrySet();
            for (Object element : $receiver) {
                Map.Entry it2 = (Map.Entry)element;
                if (!StringsKt.equals((String)MapsKt.getKey(it2), name, true)) continue;
                v0 = element;
                break block2;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        if (entry == null) {
            throw (Throwable)new IllegalArgumentException("Profile with name '" + name + "' is not supported");
        }
        Map.Entry entry2 = entry;
        String string = (String)MapsKt.component1(entry2);
        Function0 function0 = (Function0)MapsKt.component2(entry2);
        entry2 = null;
        return new Profile((String)profileName, (Evaluator)evaluator.invoke(), targetRoot);
    }

    @NotNull
    public static final String convertLineSeparators(String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        String string = StringUtil.convertLineSeparators($receiver);
        Intrinsics.checkExpressionValueIsNotNull(string, "StringUtil.convertLineSeparators(this)");
        return string;
    }

    public static final boolean isTextEqualTo(File $receiver, @NotNull String content) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(content, "content");
        return Intrinsics.areEqual(StringsKt.lines(FilesKt.readText$default($receiver, null, 1)), StringsKt.lines(content));
    }

    @NotNull
    public static final File makeRelativeTo(File $receiver, @NotNull File from, @NotNull File to) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(to, "to");
        return new File(to, FilesKt.relativeTo($receiver, from));
    }

    public static final void mkdirsOrFail(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (!$receiver.mkdirs() && !$receiver.exists()) {
            throw (Throwable)new IOException("Failed to create directory " + $receiver + ".");
        }
    }

    static {
        Iterable $receiver = CollectionsKt.listOf(6, 7, 8);
        float capacity = (float)CollectionsKt.collectionSizeOrDefault($receiver, 10) / 0.75f + 1.0f;
        LinkedHashMap<String, Function0> result2 = new LinkedHashMap<String, Function0>(Math.max((int)capacity, 16));
        for (Object element : $receiver) {
            int version;
            int n = ((Number)element).intValue();
            LinkedHashMap<String, Function0> linkedHashMap = result2;
            String string = "JVM" + version;
            version = ((Number)element).intValue();
            Function0 function0 = new Function0<JvmPlatformEvaluator>(version){
                final /* synthetic */ int $version;

                @NotNull
                public final JvmPlatformEvaluator invoke() {
                    return new JvmPlatformEvaluator(this.$version);
                }
                {
                    this.$version = n;
                    super(0);
                }
            };
            linkedHashMap.put(string, function0);
        }
        profileEvaluators = MapsKt.plus((Map)result2, TuplesKt.to("JS", profileEvaluators.3.INSTANCE$));
    }
}

