/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import com.intellij.util.SmartList;
import java.util.List;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.IntProgression;
import kotlin.RangesKt;
import kotlin.internal.InternalPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.ExpressionDecomposerKt;
import org.jetbrains.kotlin.js.inline.util.JsExpressionVisitor;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsEmpty;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"Z\u0004)1!j\u001d(pI\u0016T1aY8n\u0015\u00199wn\\4mK*!A-\u0019:u\u0015!\u0019w.\u001c9jY\u0016\u0014(b\u00022bG.,g\u000e\u001a\u0006\u0003UNT1!Y:u\u0015\u0015i\u0017\r^2i\u0015%\u0001(/\u001a3jG\u0006$XMC\u0005Gk:\u001cG/[8oc)11n\u001c;mS:TqAQ8pY\u0016\fgNC\u0002TKRTAA[1wC*!Q\u000f^5m\u0015\rQg/\u001c\u0006\nMVt7\r^5p]NTa#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001cw.\u001c9pg\u0016\u00148\n\u001e\u0006\u0005\u0019&\u001cHOC\u0006KgN#\u0018\r^3nK:$(b\u0003;p'R\fG/Z7f]RT!c^5uQB\u000b'/\u001a8ug>3gj\u001c3fg*)an\u001c3fgB\r!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019QA\u0001C\u0003\u0011\u000f)1\u0001B\u0002\t\u00011\u0001Q!\u0001E\u0006\u000b\r!A\u0001C\u0003\r\u0001\u0015\u0019A\u0001\u0002\u0005\u0007\u0019\u0001)1\u0001\u0002\u0003\t\u000e1\u0001Q!\u0001\u0005\b\u000b\t!a\u0001c\u0004\u0006\u0005\u00115\u0001RB\u0003\u0003\t\rA\u0001!\u0002\u0002\u0005\t!AQA\u0001\u0003\t\u0011#)!\u0001\"\u0005\t\u000b\u0015\u0019A\u0001\u0002E\n\u0019\u0001)1\u0001B\u0002\t\u00151\u0001QA\u0001\u0003\u0004\u0011))!\u0001\"\u0004\t\u0014\u0015]C!A\u000b\u0004\u000b\u0005A9\u0001g\u0002\u0019\tu\rB\u0001\u0001E\u0005\u001b5)\u0011\u0001#\u0003\n\t%\u0019Q!\u0001E\u00041\u000fIA!C\u0002\u0006\u0003!)\u0001$\u0002M\u0005!\u000e\u0005\u0011\u0005C\u0003\u0002\u0011\u0017IA!C\u0002\u0006\u0003!\u001d\u0001t\u0001M\u0006#\u000e9A\u0001B\u0005\u0002\u0011\u001di\u0011\u0001c\u0004\u000e\u0003!I\u0001lA\u0005\u0006/\u0011\tQ\u0003C\u0003\u0002\u0011'IA!C\u0002\u0006\u0003!Q\u0001D\u0003M\n1+\t3!B\u0001\t\u0015aQ\u0011kA\u0003\u0005\u0016%\t\u0001RC\u0007\u0002\u0011-A6!CC'\t\u0005)2!B\u0001\t\ba\u001d\u0001dCO\r\t\u0001A9\"\u0004\u0005\u0006\u0003!-\u0011\u0002B\u0005\u0004\u000b\u0005A9\u0001g\u0002\u0019\fA\u001b\t!\t\u0005\u0006\u0003!-\u0011\u0002B\u0005\u0004\u000b\u0005A9\u0001g\u0002\u0019\fE\u001bq\u0001B\u0006\n\u0003!9Q\"\u0001E\b\u001b\u0005Aq\u0001W\u0002\n"})
public final class ExpressionDecomposerKt {
    @NotNull
    public static final Set<JsNode> match(JsNode $receiver, @NotNull Function1<? super JsNode, ? extends Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        JsExpressionVisitor visitor2 = new JsExpressionVisitor(predicate){
            public static final /* synthetic */ KClass $kotlinClass;
            @NotNull
            private final Set<JsNode> matched;
            final /* synthetic */ Function1 $predicate;

            static {
                $kotlinClass = Reflection.createKotlinClass(match.visitor.1.class);
            }

            @NotNull
            public final Set<JsNode> getMatched() {
                return this.matched;
            }

            protected <R extends JsNode> void doTraverse(@NotNull R node, @Nullable JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(node, "node");
                super.doTraverse(node, ctx);
                if (this.matched.contains(node) ^ true && ((Boolean)this.$predicate.invoke(node)).booleanValue()) {
                    this.matched.add(node);
                }
            }
            {
                this.$predicate = $captured_local_variable$0;
                this.matched = CollectionUtilsKt.IdentitySet();
            }
        };
        visitor2.accept($receiver);
        return visitor2.getMatched();
    }

    @NotNull
    public static final Set<JsNode> withParentsOfNodes(JsNode $receiver, @NotNull Set<? extends JsNode> nodes) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(nodes, "nodes");
        JsExpressionVisitor visitor2 = new JsExpressionVisitor(nodes){
            public static final /* synthetic */ KClass $kotlinClass;
            private final SmartList<JsNode> stack;
            @NotNull
            private final Set<JsNode> matched;
            final /* synthetic */ Set $nodes;

            static {
                $kotlinClass = Reflection.createKotlinClass(withParentsOfNodes.visitor.1.class);
            }

            @NotNull
            public final Set<JsNode> getMatched() {
                return this.matched;
            }

            protected <R extends JsNode> void doTraverse(R node, @Nullable JsContext<?> ctx) {
                this.stack.add(node);
                super.doTraverse(node, ctx);
                if (this.$nodes.contains(node)) {
                    this.addAllUntilMatchedOrStatement((List<? extends JsNode>)this.stack);
                }
                this.stack.remove(CollectionsKt.getLastIndex((List)this.stack));
            }

            /*
             * WARNING - void declaration
             */
            public final void addAllUntilMatchedOrStatement(@NotNull List<? extends JsNode> nodesOnStack) {
                Intrinsics.checkParameterIsNotNull(nodesOnStack, "nodesOnStack");
                IntProgression intProgression = RangesKt.downTo(CollectionsKt.getLastIndex(nodesOnStack), 0);
                int n = ((Number)intProgression.getStart()).intValue();
                int n2 = ((Number)intProgression.getEnd()).intValue();
                int n3 = ((Number)intProgression.getIncrement()).intValue();
                int n4 = InternalPackage.getProgressionFinalElement(n, n2, n3);
                int n5 = n;
                int n6 = n2;
                if (n3 > 0 ? n5 <= n6 : n5 >= n6) {
                    void i;
                    JsNode currentNode;
                    while (!this.matched.contains(currentNode = nodesOnStack.get((int)i))) {
                        this.matched.add(currentNode);
                        if (currentNode instanceof JsStatement || i == n4) break;
                        n = i + n3;
                    }
                }
            }
            {
                this.$nodes = $captured_local_variable$0;
                this.stack = new SmartList<E>();
                this.matched = CollectionUtilsKt.IdentitySet();
            }
        };
        visitor2.accept($receiver);
        return visitor2.getMatched();
    }

    @NotNull
    public static final JsStatement toStatement(List<? extends JsStatement> $receiver) {
        JsStatement jsStatement;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        switch ($receiver.size()) {
            case 0: {
                jsStatement = JsEmpty.INSTANCE$;
                break;
            }
            case 1: {
                jsStatement = $receiver.get(0);
                break;
            }
            default: {
                jsStatement = new JsBlock($receiver);
            }
        }
        return jsStatement;
    }
}

