/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\u0000\u0004)aq-\u001a;F]\u0012|eMZ:fi*9Q\r\\3nK:$(B\u0003)tS\u0016cW-\\3oi*\u00191m\\7\u000b\u0011%tG/\u001a7mS*T1\u0001]:j\u0015\rIe\u000e\u001e\u0006\u0007W>$H.\u001b8\u000b+A{7/\u001b;j_:LgnZ*ue\u0006$XmZ=Li*qq-\u001a;Ti\u0006\u0014Ho\u00144gg\u0016$(b\u00045bgNKh\u000e^1y\u000bJ\u0014xN]:\u000b\u0015A\u001c\u0018.\u00127f[\u0016tGOC\u0004C_>dW-\u00198\u000b\u00175\f'o[#mK6,g\u000e\u001e\u0006\u0005\u0019&\u001cHOC\u0005UKb$(+\u00198hK*9q\u000e]3oCBL'\u0002B;uS2TAA[1wC*AQ.\u0019:l\u001d>$WM\u0003\u0003o_\u0012,'bB!T):{G-\u001a\u0006\u0005Y\u0006twMC\u0005nCJ\\'+\u00198hK*)!/\u00198hK*!aM]8n\u0015\t!x\u000e\u001f\u0006\u0003!\rQA\u0001\u0003\u0001\u0011\t)!\u0001\"\u0001\t\u0006\u0015\u0019A!\u0001\u0005\u0002\u0019\u0001)\u0011\u0001c\u0002\u0006\u0007\u0011\u0011\u0001b\u0001\u0007\u0001\u000b\t!\u0011\u0001C\u0001\u0006\u0007\u0011\u0011\u0001B\u0002\u0007\u0001\u000b\r!!\u0001C\u0004\r\u0001\u0015\u0011A\u0011\u0001\u0005\t\u000b\t!I\u0001#\u0005\u0006\u0007\u0011)\u0001r\u0002\u0007\u0001\u000b\u0005A\u0011\"\u0002\u0002\u0005\r!EQA\u0001C\u0007\u0011\u001d)!\u0001\"\u0001\t\u0017\u0015\u0019Aq\u0002E\u000b\u0019\u0001)!\u0001b\u0004\t\u0016\u0015\u0011A!\u0002E\b\u000b[!\u0011\u0001\u0007\u0001\u001e\u0010\u0011\u0001\u0001\u0012A\u0007\u0004\u000b\u0005A\u0019\u0001g\u0001Q\u0007\u0001\t3!B\u0001\t\u0006a\u0015\u0011kA\u0003\u0005\u0001%\tAQA\u0007\u0002\u0011\rA6\u0001BC\u0017\t\u0005AJ!h\u0004\u0005\u0001!\u0005QbA\u0003\u0002\u0011\u0007A\u001a\u0001U\u0002\u0001C\r)\u0011\u0001#\u0002\u0019\u0006E\u001bQ\u0001\"\u0003\n\u0003\u0011\u0015Q\"\u0001\u0005\u00041\u000e!QQ\u0006\u0003\u00041\u0015iz\u0001\u0002\u0001\t\f5\u0019Q!\u0001E\u00021\u0007\u00016\u0001A\u0011\u0004\u000b\u0005A9\u0001g\u0002R\u0007\u0015!Q!C\u0001\u0005\u00025\t\u0001b\u0001-\u0004\t\u0015]Ba\u0001M\u0007;\u001f!\u0001\u0001#\u0001\u000e\u0007\u0015\t\u00012\u0001M\u0002!\u000e\u0001\u0011\u0005C\u0003\u0002\u0011\u0011IA!C\u0002\u0006\u0003!-\u00014\u0002\r\u0005#\u000e)AQB\u0005\u0002\u0011\u001di\u0011\u0001C\u0002Y\u0007\u0011)9\u0004B\u0002\u0019\u0014u=A\u0001\u0001\u0005\u000b\u001b\r)\u0011\u0001\u0003\u0005\u0019\u0011A\u001b\u0001!\t\u0005\u0006\u0003!!\u0011\u0002B\u0005\u0004\u000b\u0005AY\u0001g\u0003\u0019\tE\u001bQ\u0001b\u0005\n\u0003!9Q\"\u0001E\t1\u000e!Qq\u0007\u0003\u00041/iz\u0001\u0002\u0001\t\u00195\u0019Q!\u0001E\u00061\u0017\u00016\u0001A\u0011\t\u000b\u0005AA!\u0003\u0003\n\u0007\u0015\t\u00012\u0002M\u00061\u0011\t6!\u0002C\f\u0013\u0005Aq!D\u0001\t\u0013a\u001bA!\u0002\u0014\u0005\u0007a]Qt\u0002\u0003\u0001\u00113i1!B\u0001\t\u0004a\r\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\"D\u0007\u0004\u000b\u0005A\u0019\u0001g\u0001Q\u0007\u0003\t\u0003\"B\u0001\t\t%!\u0011bA\u0003\u0002\u0011\u0017AZ\u0001\u0007\u0003R\u0007\u001d!9\"C\u0001\t\u000f5\t\u0001bA\u0007\u0002\u0011\rA6\u0001\u0002"})
public final class PositioningStrategyKt {
    @NotNull
    public static final List<TextRange> markElement(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        return CollectionsKt.listOf(new TextRange(PositioningStrategyKt.getStartOffset(element), PositioningStrategyKt.getEndOffset(element)));
    }

    @NotNull
    public static final List<TextRange> markNode(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        PsiElement psiElement = node.getPsi();
        Intrinsics.checkExpressionValueIsNotNull(psiElement, "node.getPsi()");
        return PositioningStrategyKt.markElement(psiElement);
    }

    @NotNull
    public static final List<TextRange> markRange(@NotNull TextRange range) {
        Intrinsics.checkParameterIsNotNull(range, "range");
        return CollectionsKt.listOf(range);
    }

    @NotNull
    public static final List<TextRange> markRange(@NotNull PsiElement from, @NotNull PsiElement to) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(to, "to");
        return PositioningStrategyKt.markRange(new TextRange(PositioningStrategyKt.getStartOffset(from), PositioningStrategyKt.getEndOffset(to)));
    }

    public static final int getStartOffset(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        PsiElement child = element.getFirstChild();
        if (child != null) {
            while (child instanceof PsiComment || child instanceof PsiWhiteSpace) {
                child = child.getNextSibling();
            }
            if (child != null) {
                return PositioningStrategyKt.getStartOffset(child);
            }
        }
        return PsiUtilsKt.getStartOffset(element);
    }

    public static final int getEndOffset(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        PsiElement child = element.getLastChild();
        if (child != null) {
            while (child instanceof PsiComment || child instanceof PsiWhiteSpace) {
                child = child.getPrevSibling();
            }
            if (child != null) {
                return PositioningStrategyKt.getEndOffset(child);
            }
        }
        return PsiUtilsKt.getEndOffset(element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasSyntaxErrors(@NotNull PsiElement psiElement) {
        Intrinsics.checkParameterIsNotNull(psiElement, "psiElement");
        if (psiElement instanceof PsiErrorElement) {
            return true;
        }
        PsiElement[] children = psiElement.getChildren();
        if (!ArraysKt.isNotEmpty((Object[])children)) return false;
        PsiElement psiElement2 = (PsiElement)ArraysKt.last((Object[])children);
        Intrinsics.checkExpressionValueIsNotNull(psiElement2, "children.last()");
        if (!PositioningStrategyKt.hasSyntaxErrors(psiElement2)) return false;
        return true;
    }
}

