/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.binding;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.fileClasses.FileClassesPackage;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetStubbedPsiUtil;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.org.objectweb.asm.Type;

public final class PsiCodegenPredictor {
    private PsiCodegenPredictor() {
    }

    public static boolean checkPredictedNameFromPsi(@NotNull DeclarationDescriptor descriptor2, @Nullable Type nameFromDescriptors, @NotNull JvmFileClassesProvider fileClassesManager) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/binding/PsiCodegenPredictor", "checkPredictedNameFromPsi"));
        }
        if (fileClassesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileClassesManager", "org/jetbrains/kotlin/codegen/binding/PsiCodegenPredictor", "checkPredictedNameFromPsi"));
        }
        PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (element instanceof JetDeclaration) {
            String classNameFromPsi = PsiCodegenPredictor.getPredefinedJvmInternalName((JetDeclaration)element, fileClassesManager);
            assert (classNameFromPsi == null || Type.getObjectType(classNameFromPsi).equals(nameFromDescriptors)) : String.format("Invalid algorithm for getting qualified name from psi! Predicted: %s, actual %s\nElement: %s", classNameFromPsi, nameFromDescriptors, element.getText());
        }
        return true;
    }

    @Nullable
    public static String getPredefinedJvmInternalName(@NotNull JetDeclaration declaration, @NotNull JvmFileClassesProvider fileClassesProvider) {
        String parentInternalName;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/binding/PsiCodegenPredictor", "getPredefinedJvmInternalName"));
        }
        if (fileClassesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileClassesProvider", "org/jetbrains/kotlin/codegen/binding/PsiCodegenPredictor", "getPredefinedJvmInternalName"));
        }
        JetDeclaration parentDeclaration = JetStubbedPsiUtil.getContainingDeclaration(declaration);
        if (parentDeclaration != null) {
            parentInternalName = PsiCodegenPredictor.getPredefinedJvmInternalName(parentDeclaration, fileClassesProvider);
            if (parentInternalName == null) {
                return null;
            }
        } else {
            JetFile containingFile = declaration.getContainingJetFile();
            if (declaration instanceof JetNamedFunction) {
                Name name = ((JetNamedFunction)declaration).getNameAsName();
                return name == null ? null : FileClassesPackage.getFileClassInternalName(fileClassesProvider, containingFile) + "$" + name.asString();
            }
            parentInternalName = AsmUtil.internalNameByFqNameWithoutInnerClasses(containingFile.getPackageFqName());
        }
        if (!PsiTreeUtil.instanceOf(declaration, JetClass.class, JetObjectDeclaration.class, JetNamedFunction.class, JetProperty.class) || PsiCodegenPredictor.isEnumEntryWithoutBody(declaration)) {
            return null;
        }
        Name name = ((JetNamedDeclaration)declaration).getNameAsName();
        if (name == null) {
            return null;
        }
        if (declaration instanceof JetNamedFunction && !(parentDeclaration instanceof JetClass) && !(parentDeclaration instanceof JetObjectDeclaration)) {
            return null;
        }
        if (declaration instanceof JetProperty) {
            return parentInternalName + "$" + name.asString();
        }
        if (parentInternalName.isEmpty()) {
            return name.asString();
        }
        return parentInternalName + (parentDeclaration == null ? "/" : "$") + name.asString();
    }

    private static boolean isEnumEntryWithoutBody(JetDeclaration declaration) {
        if (!(declaration instanceof JetEnumEntry)) {
            return false;
        }
        JetClassBody body = ((JetEnumEntry)declaration).getBody();
        return body == null || body.getDeclarations().size() == 0;
    }
}

