/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationArgumentVisitor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArrayValue
extends ConstantValue<List<? extends ConstantValue<?>>> {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final JetType type;
    private final KotlinBuiltIns builtIns;

    static {
        $kotlinClass = Reflection.createKotlinClass(ArrayValue.class);
    }

    @Override
    public <R, D> R accept(@NotNull AnnotationArgumentVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitArrayValue(this, data2);
    }

    @NotNull
    public final JetType getElementType() {
        JetType jetType = this.builtIns.getArrayElementType(this.getType());
        Intrinsics.checkExpressionValueIsNotNull(jetType, "builtIns.getArrayElementType(type)");
        return jetType;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.constants.ArrayValue");
        }
        return Intrinsics.areEqual((List)this.getValue(), (List)((ArrayValue)object2).getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    @NotNull
    public JetType getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayValue(@NotNull List<? extends ConstantValue<?>> value, @NotNull JetType type2, @NotNull KotlinBuiltIns builtIns) {
        void value2;
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        super(value);
        this.type = type2;
        this.builtIns = builtIns;
        boolean bl = KotlinBuiltIns.isArray(this.getType()) || KotlinBuiltIns.isPrimitiveArray(this.getType());
        if (PreconditionsKt.getASSERTIONS_ENABLED() && value2 == false) {
            String message = "Type should be an array, but was " + this.getType() + ": " + value;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
    }
}

