/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import com.intellij.psi.impl.file.PsiLargeFileImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.com.google.common.util.concurrent.Atomics;

public class SingleRootFileViewProvider
extends UserDataHolderBase
implements FileViewProvider {
    private static final Key<Boolean> OUR_NO_SIZE_LIMIT_KEY = Key.create("no.size.limit");
    private static final Logger LOG = Logger.getInstance("#" + SingleRootFileViewProvider.class.getCanonicalName());
    @NotNull
    private final PsiManager myManager;
    @NotNull
    private final VirtualFile myVirtualFile;
    private final boolean myEventSystemEnabled;
    private final boolean myPhysical;
    private final AtomicReference<PsiFile> myPsiFile;
    private volatile Content myContent;
    private volatile Reference<Document> myDocument;
    @NotNull
    private final Language myBaseLanguage;
    @NotNull
    private final FileType myFileType;

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        this(manager, file, true);
    }

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        this(manager, virtualFile, eventSystemEnabled, virtualFile.getFileType());
    }

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull FileType fileType) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        this(manager, virtualFile, eventSystemEnabled, SingleRootFileViewProvider.calcBaseLanguage(virtualFile, manager.getProject(), fileType), fileType);
    }

    protected SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull Language language) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        this(manager, virtualFile, eventSystemEnabled, language, virtualFile.getFileType());
    }

    protected SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull Language language, @NotNull FileType type2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/SingleRootFileViewProvider", "<init>"));
        }
        this.myPsiFile = Atomics.newReference();
        this.myManager = manager;
        this.myVirtualFile = virtualFile;
        this.myEventSystemEnabled = eventSystemEnabled;
        this.myBaseLanguage = language;
        this.setContent(new VirtualFileContent());
        this.myPhysical = this.isEventSystemEnabled() && !(virtualFile instanceof LightVirtualFile) && !(virtualFile.getFileSystem() instanceof NonPhysicalFileSystem);
        this.myFileType = type2;
    }

    @Override
    @NotNull
    public Language getBaseLanguage() {
        Language language = this.myBaseLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SingleRootFileViewProvider", "getBaseLanguage"));
        }
        return language;
    }

    private static Language calcBaseLanguage(@NotNull VirtualFile file, @NotNull Project project, @NotNull FileType fileType) {
        Language language;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/SingleRootFileViewProvider", "calcBaseLanguage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/SingleRootFileViewProvider", "calcBaseLanguage"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/SingleRootFileViewProvider", "calcBaseLanguage"));
        }
        if (file instanceof LightVirtualFile && (language = ((LightVirtualFile)file).getLanguage()) != null) {
            return language;
        }
        if (fileType.isBinary()) {
            return Language.ANY;
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file)) {
            return PlainTextLanguage.INSTANCE;
        }
        if (fileType instanceof LanguageFileType) {
            return LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)fileType).getLanguage(), file, project);
        }
        return PlainTextLanguage.INSTANCE;
    }

    @Override
    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = Collections.singleton(this.getBaseLanguage());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SingleRootFileViewProvider", "getLanguages"));
        }
        return set;
    }

    @Override
    @Nullable
    public final PsiFile getPsi(@NotNull Language target) {
        VirtualFile virtualFile;
        FileManager fileManager;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/psi/SingleRootFileViewProvider", "getPsi"));
        }
        if (!this.isPhysical() && (fileManager = ((PsiManagerEx)this.myManager).getFileManager()).findCachedViewProvider(virtualFile = this.getVirtualFile()) == null) {
            fileManager.setViewProvider(virtualFile, this);
        }
        return this.getPsiInner(target);
    }

    @Override
    @NotNull
    public List<PsiFile> getAllFiles() {
        List<PsiFile> list = ContainerUtil.createMaybeSingletonList(this.getPsi(this.getBaseLanguage()));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SingleRootFileViewProvider", "getAllFiles"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected PsiFile getPsiInner(@NotNull Language target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/psi/SingleRootFileViewProvider", "getPsiInner"));
        }
        if (target != this.getBaseLanguage()) {
            return null;
        }
        PsiFile psiFile = this.myPsiFile.get();
        if (psiFile == null) {
            boolean set;
            psiFile = this.createFile();
            if (psiFile == null) {
                psiFile = PsiUtilCore.NULL_PSI_FILE;
            }
            if (!(set = this.myPsiFile.compareAndSet(null, psiFile)) && psiFile != PsiUtilCore.NULL_PSI_FILE) {
                PsiFile alreadyCreated = this.myPsiFile.get();
                if (alreadyCreated == psiFile) {
                    LOG.error(this + ".createFile() must create new file instance but got the same: " + psiFile);
                }
                if (psiFile instanceof PsiFileEx) {
                    DebugUtil.startPsiModification("invalidating throw-away copy");
                    try {
                        ((PsiFileEx)psiFile).markInvalidated();
                    }
                    finally {
                        DebugUtil.finishPsiModification();
                    }
                }
                psiFile = alreadyCreated;
            }
        }
        return psiFile == PsiUtilCore.NULL_PSI_FILE ? null : psiFile;
    }

    @Override
    public void beforeContentsSynchronized() {
    }

    @Override
    public void contentsSynchronized() {
        if (this.myContent instanceof PsiFileContent) {
            this.setContent(new VirtualFileContent());
        }
        this.checkLengthConsistency();
    }

    public void beforeDocumentChanged(@Nullable PsiFile psiCause) {
        PsiFile psiFile;
        PsiFile psiFile2 = psiFile = psiCause != null ? psiCause : this.getPsi(this.getBaseLanguage());
        if (psiFile instanceof PsiFileImpl && this.myContent instanceof VirtualFileContent) {
            this.setContent(new PsiFileContent((PsiFileImpl)psiFile, psiCause == null ? this.getModificationStamp() : LocalTimeCounter.currentTime()));
            this.checkLengthConsistency();
        }
    }

    public final void onContentReload() {
        List<PsiFile> files = this.getCachedPsiFiles();
        ArrayList<PsiTreeChangeEventImpl> events = ContainerUtil.newArrayList();
        ArrayList<PsiTreeChangeEventImpl> genericEvents = ContainerUtil.newArrayList();
        for (PsiFile file : files) {
            genericEvents.add(this.createChildrenChangeEvent(file, true));
            events.add(this.createChildrenChangeEvent(file, false));
        }
        this.beforeContentsSynchronized();
        for (PsiTreeChangeEventImpl event : genericEvents) {
            ((PsiManagerImpl)this.getManager()).beforeChildrenChange(event);
        }
        for (PsiTreeChangeEventImpl event : events) {
            ((PsiManagerImpl)this.getManager()).beforeChildrenChange(event);
        }
        for (PsiFile psiFile : files) {
            if (!(psiFile instanceof PsiFileEx)) continue;
            ((PsiFileEx)psiFile).onContentReload();
        }
        for (PsiTreeChangeEventImpl event : events) {
            ((PsiManagerImpl)this.getManager()).childrenChanged(event);
        }
        for (PsiTreeChangeEventImpl event : genericEvents) {
            ((PsiManagerImpl)this.getManager()).childrenChanged(event);
        }
        this.contentsSynchronized();
    }

    private PsiTreeChangeEventImpl createChildrenChangeEvent(PsiFile file, boolean generic) {
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        event.setParent(file);
        event.setFile(file);
        event.setGenericChange(generic);
        if (file instanceof PsiFileImpl && ((PsiFileImpl)file).isContentsLoaded()) {
            event.setOffset(0);
            event.setOldLength(file.getTextLength());
        }
        return event;
    }

    @Override
    public void rootChanged(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/SingleRootFileViewProvider", "rootChanged"));
        }
        if (psiFile instanceof PsiFileImpl && ((PsiFileImpl)psiFile).isContentsLoaded()) {
            this.setContent(new PsiFileContent((PsiFileImpl)psiFile, LocalTimeCounter.currentTime()));
        }
    }

    @Override
    public boolean isEventSystemEnabled() {
        return this.myEventSystemEnabled;
    }

    @Override
    public boolean isPhysical() {
        return this.myPhysical;
    }

    @Override
    public long getModificationStamp() {
        return this.getContent().getModificationStamp();
    }

    @Override
    public boolean supportsIncrementalReparse(@NotNull Language rootLanguage) {
        if (rootLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootLanguage", "com/intellij/psi/SingleRootFileViewProvider", "supportsIncrementalReparse"));
        }
        return true;
    }

    public PsiFile getCachedPsi(@NotNull Language target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/psi/SingleRootFileViewProvider", "getCachedPsi"));
        }
        PsiFile file = this.myPsiFile.get();
        return file == PsiUtilCore.NULL_PSI_FILE ? null : file;
    }

    public List<PsiFile> getCachedPsiFiles() {
        return ContainerUtil.createMaybeSingletonList(this.getCachedPsi(this.myBaseLanguage));
    }

    @NotNull
    public List<FileElement> getKnownTreeRoots() {
        PsiFile psiFile = this.getCachedPsi(this.myBaseLanguage);
        if (!(psiFile instanceof PsiFileImpl)) {
            List<FileElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SingleRootFileViewProvider", "getKnownTreeRoots"));
            }
            return list;
        }
        FileElement element = ((PsiFileImpl)psiFile).getTreeElement();
        List<FileElement> list = ContainerUtil.createMaybeSingletonList(element);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SingleRootFileViewProvider", "getKnownTreeRoots"));
        }
        return list;
    }

    private PsiFile createFile() {
        try {
            VirtualFile vFile = this.getVirtualFile();
            if (vFile.isDirectory()) {
                return null;
            }
            if (this.isIgnored()) {
                return null;
            }
            Project project = this.myManager.getProject();
            if (this.isPhysical() && vFile.isInLocalFileSystem()) {
                FileIndexFacade indexFacade;
                VirtualFile parent = vFile.getParent();
                if (parent == null) {
                    return null;
                }
                PsiDirectory psiDir = this.getManager().findDirectory(parent);
                if (psiDir == null && !(indexFacade = FileIndexFacade.getInstance(project)).isInLibrarySource(vFile) && !indexFacade.isInLibraryClasses(vFile)) {
                    return null;
                }
            }
            return this.createFile(project, vFile, this.myFileType);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return null;
        }
    }

    protected boolean isIgnored() {
        VirtualFile file = this.getVirtualFile();
        return !(file instanceof LightVirtualFile) && FileTypeRegistry.getInstance().isFileIgnored(file);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull FileType fileType) {
        PsiFile psiFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/SingleRootFileViewProvider", "createFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/SingleRootFileViewProvider", "createFile"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/SingleRootFileViewProvider", "createFile"));
        }
        if (fileType.isBinary() || file.is(VFileProperty.SPECIAL)) {
            return new PsiBinaryFileImpl((PsiManagerImpl)this.getManager(), this);
        }
        if (!SingleRootFileViewProvider.isTooLargeForIntelligence(file) && (psiFile = this.createFile(this.getBaseLanguage())) != null) {
            return psiFile;
        }
        if (SingleRootFileViewProvider.isTooLargeForContentLoading(file)) {
            return new PsiLargeFileImpl((PsiManagerImpl)this.getManager(), this);
        }
        return new PsiPlainTextFileImpl(this);
    }

    @Deprecated
    public static boolean isTooLarge(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/SingleRootFileViewProvider", "isTooLarge"));
        }
        return SingleRootFileViewProvider.isTooLargeForIntelligence(vFile);
    }

    public static boolean isTooLargeForIntelligence(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/SingleRootFileViewProvider", "isTooLargeForIntelligence"));
        }
        if (!SingleRootFileViewProvider.checkFileSizeLimit(vFile)) {
            return false;
        }
        return SingleRootFileViewProvider.fileSizeIsGreaterThan(vFile, PersistentFSConstants.getMaxIntellisenseFileSize());
    }

    public static boolean isTooLargeForContentLoading(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/SingleRootFileViewProvider", "isTooLargeForContentLoading"));
        }
        return SingleRootFileViewProvider.fileSizeIsGreaterThan(vFile, PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD);
    }

    private static boolean checkFileSizeLimit(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/SingleRootFileViewProvider", "checkFileSizeLimit"));
        }
        return !Boolean.TRUE.equals(vFile.getUserData(OUR_NO_SIZE_LIMIT_KEY));
    }

    public static void doNotCheckFileSizeLimit(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/SingleRootFileViewProvider", "doNotCheckFileSizeLimit"));
        }
        vFile.putUserData(OUR_NO_SIZE_LIMIT_KEY, Boolean.TRUE);
    }

    public static boolean isTooLargeForIntelligence(@NotNull VirtualFile vFile, long contentSize) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/SingleRootFileViewProvider", "isTooLargeForIntelligence"));
        }
        if (!SingleRootFileViewProvider.checkFileSizeLimit(vFile)) {
            return false;
        }
        return contentSize > (long)PersistentFSConstants.getMaxIntellisenseFileSize();
    }

    public static boolean isTooLargeForContentLoading(@NotNull VirtualFile vFile, long contentSize) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/SingleRootFileViewProvider", "isTooLargeForContentLoading"));
        }
        return contentSize > PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD;
    }

    private static boolean fileSizeIsGreaterThan(@NotNull VirtualFile vFile, long maxBytes) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/SingleRootFileViewProvider", "fileSizeIsGreaterThan"));
        }
        if (vFile instanceof LightVirtualFile) {
            int lengthInChars = ((LightVirtualFile)vFile).getContent().length();
            if ((long)lengthInChars < maxBytes / 2L) {
                return false;
            }
            if ((long)lengthInChars > maxBytes) {
                return true;
            }
        }
        return vFile.getLength() > maxBytes;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/psi/SingleRootFileViewProvider", "createFile"));
        }
        if (lang != this.getBaseLanguage()) {
            return null;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null) {
            return parserDefinition.createFile(this);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiManager getManager() {
        PsiManager psiManager = this.myManager;
        if (psiManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SingleRootFileViewProvider", "getManager"));
        }
        return psiManager;
    }

    @Override
    @NotNull
    public CharSequence getContents() {
        CharSequence charSequence = this.getContent().getText();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SingleRootFileViewProvider", "getContents"));
        }
        return charSequence;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SingleRootFileViewProvider", "getVirtualFile"));
        }
        return virtualFile;
    }

    @Nullable
    private Document getCachedDocument() {
        Document document = SoftReference.dereference(this.myDocument);
        if (document != null) {
            return document;
        }
        return FileDocumentManager.getInstance().getCachedDocument(this.getVirtualFile());
    }

    @Override
    public Document getDocument() {
        Document document = SoftReference.dereference(this.myDocument);
        if (document == null) {
            document = FileDocumentManager.getInstance().getDocument(this.getVirtualFile());
            this.myDocument = document == null ? null : new java.lang.ref.SoftReference<Document>(document);
        }
        return document;
    }

    @Override
    public FileViewProvider clone() {
        VirtualFile origFile = this.getVirtualFile();
        LightVirtualFile copy2 = new LightVirtualFile(origFile.getName(), this.myFileType, this.getContents(), origFile.getCharset(), this.getModificationStamp());
        copy2.setOriginalFile(origFile);
        copy2.putUserData(UndoConstants.DONT_RECORD_UNDO, Boolean.TRUE);
        copy2.setCharset(origFile.getCharset());
        return this.createCopy(copy2);
    }

    @Override
    @NotNull
    public SingleRootFileViewProvider createCopy(@NotNull VirtualFile copy2) {
        if (copy2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "com/intellij/psi/SingleRootFileViewProvider", "createCopy"));
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.getManager(), copy2, false, this.myBaseLanguage);
        if (singleRootFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SingleRootFileViewProvider", "createCopy"));
        }
        return singleRootFileViewProvider;
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        PsiFile psiFile = this.getPsi(this.getBaseLanguage());
        return SingleRootFileViewProvider.findReferenceAt(psiFile, offset);
    }

    @Override
    public PsiElement findElementAt(int offset, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/SingleRootFileViewProvider", "findElementAt"));
        }
        PsiFile psiFile = this.getPsi(language);
        return psiFile != null ? SingleRootFileViewProvider.findElementAt(psiFile, offset) : null;
    }

    @Override
    @Nullable
    public PsiReference findReferenceAt(int offset, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/SingleRootFileViewProvider", "findReferenceAt"));
        }
        PsiFile psiFile = this.getPsi(language);
        return psiFile != null ? SingleRootFileViewProvider.findReferenceAt(psiFile, offset) : null;
    }

    @Nullable
    private static PsiReference findReferenceAt(@Nullable PsiFile psiFile, int offset) {
        if (psiFile == null) {
            return null;
        }
        int offsetInElement = offset;
        for (PsiElement child = psiFile.getFirstChild(); child != null; child = child.getNextSibling()) {
            int length = child.getTextLength();
            if (length <= offsetInElement) {
                offsetInElement -= length;
                continue;
            }
            return child.findReferenceAt(offsetInElement);
        }
        return null;
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return SingleRootFileViewProvider.findElementAt(this.getPsi(this.getBaseLanguage()), offset);
    }

    @Override
    public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/psi/SingleRootFileViewProvider", "findElementAt"));
        }
        if (!ReflectionUtil.isAssignable(lang, this.getBaseLanguage().getClass())) {
            return null;
        }
        return this.findElementAt(offset);
    }

    @Nullable
    public static PsiElement findElementAt(@Nullable PsiElement psiFile, int offset) {
        if (psiFile == null) {
            return null;
        }
        int offsetInElement = offset;
        for (PsiElement child = psiFile.getFirstChild(); child != null; child = child.getNextSibling()) {
            int length = child.getTextLength();
            if (length <= offsetInElement) {
                offsetInElement -= length;
                continue;
            }
            return child.findElementAt(offsetInElement);
        }
        return null;
    }

    public void forceCachedPsi(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/SingleRootFileViewProvider", "forceCachedPsi"));
        }
        PsiFile prev = this.myPsiFile.getAndSet(psiFile);
        if (prev != null && prev != psiFile && prev instanceof PsiFileEx) {
            ((PsiFileEx)prev).markInvalidated();
        }
        ((PsiManagerEx)this.myManager).getFileManager().setViewProvider(this.getVirtualFile(), this);
    }

    @NotNull
    private Content getContent() {
        Content content = this.myContent;
        if (content == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SingleRootFileViewProvider", "getContent"));
        }
        return content;
    }

    private void setContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/psi/SingleRootFileViewProvider", "setContent"));
        }
        this.myContent = content;
    }

    private void checkLengthConsistency() {
        Document document = this.getCachedDocument();
        if (document instanceof DocumentWindow) {
            return;
        }
        if (document != null && ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myManager.getProject())).getSynchronizer().isInSynchronization(document)) {
            return;
        }
        List<FileElement> knownTreeRoots = this.getKnownTreeRoots();
        if (knownTreeRoots.isEmpty()) {
            return;
        }
        int fileLength = this.myContent.getTextLength();
        for (FileElement fileElement : knownTreeRoots) {
            int nodeLength = fileElement.getTextLength();
            if (nodeLength == fileLength) continue;
            LOG.error("Inconsistent " + fileElement.getElementType() + " tree in " + this + "; nodeLength=" + nodeLength + "; fileLength=" + fileLength);
        }
    }

    @NonNls
    public String toString() {
        return this.getClass().getSimpleName() + "{myVirtualFile=" + this.myVirtualFile + ", content=" + this.getContent() + '}';
    }

    public void markInvalidated() {
        PsiFile psiFile = this.getCachedPsi(this.myBaseLanguage);
        if (psiFile instanceof PsiFileEx) {
            ((PsiFileEx)psiFile).markInvalidated();
        }
    }

    private CharSequence getLastCommittedText(Document document) {
        return PsiDocumentManager.getInstance(this.myManager.getProject()).getLastCommittedText(document);
    }

    private long getLastCommittedStamp(Document document) {
        return PsiDocumentManager.getInstance(this.myManager.getProject()).getLastCommittedStamp(document);
    }

    @Override
    @NotNull
    public PsiFile getStubBindingRoot() {
        PsiFile psi = this.getPsi(this.getBaseLanguage());
        assert (psi != null);
        PsiFile psiFile = psi;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SingleRootFileViewProvider", "getStubBindingRoot"));
        }
        return psiFile;
    }

    @Override
    @NotNull
    public final FileType getFileType() {
        FileType fileType = this.myFileType;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SingleRootFileViewProvider", "getFileType"));
        }
        return fileType;
    }

    private class PsiFileContent
    implements Content {
        private final PsiFileImpl myFile;
        private volatile String myContent;
        private final long myModificationStamp;
        private final List<FileElement> myFileElementHardRefs = new SmartList<FileElement>();

        private PsiFileContent(PsiFileImpl file, long modificationStamp) {
            this.myFile = file;
            this.myModificationStamp = modificationStamp;
            for (PsiFile aFile : SingleRootFileViewProvider.this.getAllFiles()) {
                if (!(aFile instanceof PsiFileImpl)) continue;
                this.myFileElementHardRefs.add(((PsiFileImpl)aFile).calcTreeElement());
            }
        }

        @Override
        public CharSequence getText() {
            String content = this.myContent;
            if (content == null) {
                this.myContent = content = ApplicationManager.getApplication().runReadAction(new Computable<String>(){

                    @Override
                    public String compute() {
                        return PsiFileContent.this.myFile.calcTreeElement().getText();
                    }
                });
            }
            return content;
        }

        @Override
        public int getTextLength() {
            String content = this.myContent;
            if (content != null) {
                return content.length();
            }
            return this.myFile.calcTreeElement().getTextLength();
        }

        @Override
        public long getModificationStamp() {
            return this.myModificationStamp;
        }
    }

    private class VirtualFileContent
    implements Content {
        private VirtualFileContent() {
        }

        @Override
        public CharSequence getText() {
            VirtualFile virtualFile = SingleRootFileViewProvider.this.getVirtualFile();
            if (virtualFile instanceof LightVirtualFile) {
                Document doc = SingleRootFileViewProvider.this.getCachedDocument();
                if (doc != null) {
                    return SingleRootFileViewProvider.this.getLastCommittedText(doc);
                }
                return ((LightVirtualFile)virtualFile).getContent();
            }
            Document document = SingleRootFileViewProvider.this.getDocument();
            if (document == null) {
                return LoadTextUtil.loadText(virtualFile);
            }
            return SingleRootFileViewProvider.this.getLastCommittedText(document);
        }

        @Override
        public int getTextLength() {
            return this.getText().length();
        }

        @Override
        public long getModificationStamp() {
            VirtualFile virtualFile = SingleRootFileViewProvider.this.getVirtualFile();
            if (virtualFile instanceof LightVirtualFile) {
                Document doc = SingleRootFileViewProvider.this.getCachedDocument();
                if (doc != null) {
                    return SingleRootFileViewProvider.this.getLastCommittedStamp(doc);
                }
                return virtualFile.getModificationStamp();
            }
            Document document = SingleRootFileViewProvider.this.getDocument();
            if (document == null) {
                return virtualFile.getModificationStamp();
            }
            return SingleRootFileViewProvider.this.getLastCommittedStamp(document);
        }

        @NonNls
        public String toString() {
            return "VirtualFileContent{size=" + SingleRootFileViewProvider.this.getVirtualFile().getLength() + "}";
        }
    }

    private static interface Content {
        public CharSequence getText();

        public int getTextLength();

        public long getModificationStamp();
    }
}

