/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentMostlySingularMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.WeakKeyWeakValueHashMap;
import com.intellij.util.text.CharSequenceReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.gnu.trove.THashSet;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseExternalAnnotationsManager
extends ExternalAnnotationsManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.BaseExternalAnnotationsManager");
    private static final Key<Boolean> EXTERNAL_ANNO_MARKER = Key.create("EXTERNAL_ANNO_MARKER");
    private static final List<PsiFile> NULL_LIST = Collections.emptyList();
    protected final PsiManager myPsiManager;
    private final ConcurrentMap<VirtualFile, List<PsiFile>> myExternalAnnotations;
    private final Map<AnnotationData, AnnotationData> myAnnotationDataCache;
    private final ConcurrentMap<PsiFile, Pair<MostlySingularMultiMap<String, AnnotationData>, Long>> myAnnotationFileToDataAndModStamp;
    private static final List<AnnotationData> NO_DATA = new ArrayList<AnnotationData>(1);
    private final ConcurrentMostlySingularMultiMap<PsiModifierListOwner, AnnotationData> cache;
    private final CharTableImpl charTable;
    private static final JavaParserUtil.ParserWrapper ANNOTATION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseAnnotation(builder);
        }
    };

    public BaseExternalAnnotationsManager(@NotNull PsiManager psiManager) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "<init>"));
        }
        this.myExternalAnnotations = ContainerUtil.createConcurrentSoftValueMap();
        this.myAnnotationDataCache = new WeakKeyWeakValueHashMap<AnnotationData, AnnotationData>();
        this.myAnnotationFileToDataAndModStamp = ContainerUtil.createConcurrentSoftMap();
        this.cache = new ConcurrentMostlySingularMultiMap();
        this.charTable = new CharTableImpl();
        this.myPsiManager = psiManager;
        LowMemoryWatcher.register(new Runnable(){

            @Override
            public void run() {
                BaseExternalAnnotationsManager.this.dropCache();
            }
        }, psiManager.getProject());
    }

    @Nullable
    protected static String getExternalName(@NotNull PsiModifierListOwner listOwner, boolean showParamName) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "getExternalName"));
        }
        return PsiFormatUtil.getExternalName(listOwner, showParamName, Integer.MAX_VALUE);
    }

    @NotNull
    static PsiModifierListOwner preferCompiledElement(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "preferCompiledElement"));
        }
        PsiElement original = element.getOriginalElement();
        PsiModifierListOwner psiModifierListOwner = original instanceof PsiModifierListOwner ? (PsiModifierListOwner)original : element;
        if (psiModifierListOwner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "preferCompiledElement"));
        }
        return psiModifierListOwner;
    }

    protected abstract boolean hasAnyAnnotationsRoots();

    @Override
    public boolean isExternalAnnotation(@NotNull PsiAnnotation annotation2) {
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "isExternalAnnotation"));
        }
        return annotation2.getUserData(EXTERNAL_ANNO_MARKER) != null;
    }

    @Override
    @Nullable
    public PsiAnnotation findExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findExternalAnnotation"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findExternalAnnotation"));
        }
        List<AnnotationData> list = this.collectExternalAnnotations(listOwner);
        AnnotationData data2 = BaseExternalAnnotationsManager.findByFQN(list, annotationFQN);
        return data2 == null ? null : data2.getAnnotation(this);
    }

    @Override
    public boolean isExternalAnnotationWritable(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "isExternalAnnotationWritable"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "isExternalAnnotationWritable"));
        }
        List<AnnotationData> map2 = this.doCollect(listOwner, true);
        return BaseExternalAnnotationsManager.findByFQN(map2, annotationFQN) != null;
    }

    private static AnnotationData findByFQN(@NotNull List<AnnotationData> map2, final @NotNull String annotationFQN) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findByFQN"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findByFQN"));
        }
        return ContainerUtil.find(map2, new Condition<AnnotationData>(){

            @Override
            public boolean value(AnnotationData data2) {
                return data2.myFqName.equals(annotationFQN);
            }
        });
    }

    @Override
    @Nullable
    public PsiAnnotation[] findExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findExternalAnnotations"));
        }
        List<AnnotationData> result2 = this.collectExternalAnnotations(listOwner);
        return result2.isEmpty() ? null : ContainerUtil.map2Array(result2, PsiAnnotation.EMPTY_ARRAY, new Function<AnnotationData, PsiAnnotation>(){

            @Override
            public PsiAnnotation fun(AnnotationData data2) {
                return data2.getAnnotation(BaseExternalAnnotationsManager.this);
            }
        });
    }

    @NotNull
    private List<AnnotationData> collectExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        List<AnnotationData> computed;
        List<AnnotationData> cached;
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "collectExternalAnnotations"));
        }
        if (!this.hasAnyAnnotationsRoots()) {
            List<AnnotationData> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "collectExternalAnnotations"));
            }
            return list;
        }
        do {
            if ((cached = (List<AnnotationData>)this.cache.get(listOwner)) != NO_DATA && cached.isEmpty()) continue;
            List<AnnotationData> list = cached;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "collectExternalAnnotations"));
            }
            return list;
        } while (!this.cache.replace(listOwner, (Collection<AnnotationData>)cached, computed = this.doCollect(listOwner, false)));
        cached = computed;
        List<AnnotationData> list = cached;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "collectExternalAnnotations"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private AnnotationData internAnnotationData(@NotNull AnnotationData data2) {
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "internAnnotationData"));
        }
        Map<AnnotationData, AnnotationData> map2 = this.myAnnotationDataCache;
        // MONITORENTER : map2
        AnnotationData interned = this.myAnnotationDataCache.get(data2);
        if (interned == null) {
            this.myAnnotationDataCache.put(data2, data2);
            interned = data2;
        }
        AnnotationData annotationData = interned;
        // MONITOREXIT : map2
        if (annotationData != null) return annotationData;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "internAnnotationData"));
    }

    @NotNull
    private MostlySingularMultiMap<String, AnnotationData> getDataFromFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "getDataFromFile"));
        }
        Pair cached = (Pair)this.myAnnotationFileToDataAndModStamp.get(file);
        long fileModificationStamp = file.getModificationStamp();
        if (cached != null && (Long)cached.getSecond() == fileModificationStamp) {
            MostlySingularMultiMap mostlySingularMultiMap = (MostlySingularMultiMap)cached.getFirst();
            if (mostlySingularMultiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "getDataFromFile"));
            }
            return mostlySingularMultiMap;
        }
        DataParsingSaxHandler handler2 = new DataParsingSaxHandler(file);
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(new InputSource(new CharSequenceReader(BaseExternalAnnotationsManager.escapeAttributes(file.getViewProvider().getContents()))), (DefaultHandler)handler2);
        }
        catch (IOException e) {
            LOG.error(e);
        }
        catch (ParserConfigurationException e) {
            LOG.error(e);
        }
        catch (SAXException e) {
            LOG.error(e);
        }
        MostlySingularMultiMap<String, AnnotationData> result2 = handler2.getResult();
        this.myAnnotationFileToDataAndModStamp.put(file, Pair.pair(result2, fileModificationStamp));
        MostlySingularMultiMap<String, AnnotationData> mostlySingularMultiMap = result2;
        if (mostlySingularMultiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "getDataFromFile"));
        }
        return mostlySingularMultiMap;
    }

    protected void duplicateError(@NotNull PsiFile file, @NotNull String externalName, @NotNull String text) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "duplicateError"));
        }
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalName", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "duplicateError"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "duplicateError"));
        }
        LOG.error(text + "; for signature: '" + externalName + "' in the " + file.getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private String intern(@NotNull String annotationFQN) {
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "intern"));
        }
        CharTableImpl charTableImpl = this.charTable;
        // MONITORENTER : charTableImpl
        String string = this.charTable.doIntern(annotationFQN).toString();
        // MONITOREXIT : charTableImpl
        if (string != null) return string;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "intern"));
    }

    @NotNull
    private List<AnnotationData> doCollect(@NotNull PsiModifierListOwner listOwner, boolean onlyWritable) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "doCollect"));
        }
        String externalName = BaseExternalAnnotationsManager.getExternalName(listOwner, false);
        if (externalName == null) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "doCollect"));
            }
            return list;
        }
        List<PsiFile> files = this.findExternalAnnotationsFiles(listOwner);
        if (files == null) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "doCollect"));
            }
            return list;
        }
        SmartList<AnnotationData> result2 = new SmartList<AnnotationData>();
        for (PsiFile file : files) {
            if (!file.isValid() || onlyWritable && !file.isWritable()) continue;
            MostlySingularMultiMap<String, AnnotationData> fileData = this.getDataFromFile(file);
            ContainerUtil.addAll(result2, fileData.get(externalName));
        }
        if (result2.isEmpty()) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "doCollect"));
            }
            return list;
        }
        result2.trimToSize();
        SmartList<AnnotationData> smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "doCollect"));
        }
        return smartList;
    }

    @Override
    @Nullable
    public List<PsiFile> findExternalAnnotationsFiles(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findExternalAnnotationsFiles"));
        }
        PsiFile containingFile = BaseExternalAnnotationsManager.preferCompiledElement(listOwner).getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            return null;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        List files = (List)this.myExternalAnnotations.get(virtualFile);
        if (files == NULL_LIST) {
            return null;
        }
        if (files != null) {
            boolean allValid = true;
            for (Object file : files) {
                if (file.isValid()) continue;
                allValid = false;
                break;
            }
            if (allValid) {
                return files;
            }
        }
        THashSet<PsiFile> possibleAnnotations = new THashSet<PsiFile>();
        String relativePath = ((PsiJavaFile)containingFile).getPackageName().replace('.', '/') + '/' + "annotations.xml";
        for (VirtualFile root : this.getExternalAnnotationsRoots(virtualFile)) {
            PsiFile psiFile;
            VirtualFile ext = root.findFileByRelativePath(relativePath);
            if (ext == null || !ext.isValid() || (psiFile = this.myPsiManager.findFile(ext)) == null) continue;
            possibleAnnotations.add(psiFile);
        }
        if (possibleAnnotations.isEmpty()) {
            this.myExternalAnnotations.put(virtualFile, NULL_LIST);
            return null;
        }
        SmartList<PsiFile> result2 = new SmartList<PsiFile>((Collection<PsiFile>)possibleAnnotations);
        Collections.sort(result2, new Comparator<PsiFile>(){

            @Override
            public int compare(PsiFile f1, PsiFile f2) {
                boolean w2;
                boolean w1 = f1.isWritable();
                return w1 == (w2 = f2.isWritable()) ? 0 : (w1 ? -1 : 1);
            }
        });
        this.myExternalAnnotations.put(virtualFile, result2);
        return result2;
    }

    @NotNull
    protected abstract List<VirtualFile> getExternalAnnotationsRoots(@NotNull VirtualFile var1);

    protected void dropCache() {
        this.myExternalAnnotations.clear();
        this.myAnnotationFileToDataAndModStamp.clear();
        this.cache.clear();
    }

    @NotNull
    private static CharSequence escapeAttributes(@NotNull CharSequence invalidXml) {
        if (invalidXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalidXml", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "escapeAttributes"));
        }
        StringBuilder buf = new StringBuilder(invalidXml.length());
        boolean inAttribute = false;
        for (int i = 0; i < invalidXml.length(); ++i) {
            char c = invalidXml.charAt(i);
            if (inAttribute && c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (inAttribute && c == '>') {
                buf.append("&gt;");
                continue;
            }
            if (c == '\"' || c == '\'') {
                buf.append('\"');
                inAttribute = !inAttribute;
                continue;
            }
            buf.append(c);
        }
        StringBuilder stringBuilder = buf;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "escapeAttributes"));
        }
        return stringBuilder;
    }

    @Override
    public void annotateExternally(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, @NotNull PsiFile fromFile, @Nullable PsiNameValuePair[] value) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "annotateExternally"));
        }
        if (annotationFQName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQName", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "annotateExternally"));
        }
        if (fromFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromFile", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "annotateExternally"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean deannotate(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "deannotate"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "deannotate"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean editExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @Nullable PsiNameValuePair[] value) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "editExternalAnnotation"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "editExternalAnnotation"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "chooseAnnotationsPlace"));
        }
        throw new UnsupportedOperationException();
    }

    protected void cacheExternalAnnotations(@NotNull String packageName, @NotNull PsiFile fromFile, @NotNull List<PsiFile> annotationFiles) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "cacheExternalAnnotations"));
        }
        if (fromFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromFile", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "cacheExternalAnnotations"));
        }
        if (annotationFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFiles", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "cacheExternalAnnotations"));
        }
        VirtualFile virtualFile = fromFile.getVirtualFile();
        if (virtualFile != null) {
            this.myExternalAnnotations.put(virtualFile, annotationFiles);
        }
    }

    private static PsiAnnotation markAsExternalAnnotation(@NotNull PsiAnnotation annotation2) {
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "markAsExternalAnnotation"));
        }
        annotation2.putUserData(EXTERNAL_ANNO_MARKER, Boolean.TRUE);
        ((LightVirtualFile)annotation2.getContainingFile().getViewProvider().getVirtualFile()).markReadOnly();
        return annotation2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private PsiAnnotation createAnnotationFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "createAnnotationFromText"));
        }
        CharTableImpl charTableImpl = this.charTable;
        // MONITORENTER : charTableImpl
        DummyHolder holder = DummyHolderFactory.createHolder(this.myPsiManager, new JavaDummyElement(text, ANNOTATION, LanguageLevel.HIGHEST), null, this.charTable);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotation)) {
            throw new IncorrectOperationException("Incorrect annotation \"" + text + "\".");
        }
        PsiAnnotation psiAnnotation = BaseExternalAnnotationsManager.markAsExternalAnnotation((PsiAnnotation)element);
        // MONITOREXIT : charTableImpl
        if (psiAnnotation != null) return psiAnnotation;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "createAnnotationFromText"));
    }

    private class DataParsingSaxHandler
    extends DefaultHandler {
        private final MostlySingularMultiMap<String, AnnotationData> myData = new MostlySingularMultiMap();
        private final PsiFile myFile;
        private String myExternalName = null;
        private String myAnnotationFqn = null;
        private StringBuilder myArguments = null;

        private DataParsingSaxHandler(PsiFile file) {
            this.myFile = file;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("item".equals(qName)) {
                this.myExternalName = attributes.getValue("name");
            } else if ("annotation".equals(qName)) {
                this.myAnnotationFqn = attributes.getValue("name");
                this.myArguments = new StringBuilder();
            } else if ("val".equals(qName)) {
                String name;
                if (this.myArguments.length() != 0) {
                    this.myArguments.append(",");
                }
                if ((name = attributes.getValue("name")) != null) {
                    this.myArguments.append(name);
                    this.myArguments.append("=");
                }
                this.myArguments.append(attributes.getValue("val"));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("item".equals(qName)) {
                this.myExternalName = null;
            } else if ("annotation".equals(qName) && this.myExternalName != null && this.myAnnotationFqn != null) {
                String argumentsString = this.myArguments.length() == 0 ? "" : BaseExternalAnnotationsManager.this.intern(this.myArguments.toString());
                for (AnnotationData existingData : this.myData.get(this.myExternalName)) {
                    if (!existingData.myFqName.equals(this.myAnnotationFqn)) continue;
                    BaseExternalAnnotationsManager.this.duplicateError(this.myFile, this.myExternalName, "Duplicate annotation '" + this.myAnnotationFqn + "'");
                }
                AnnotationData data2 = new AnnotationData(this.myAnnotationFqn, argumentsString);
                this.myData.add(this.myExternalName, BaseExternalAnnotationsManager.this.internAnnotationData(data2));
                this.myAnnotationFqn = null;
                this.myArguments = null;
            }
        }

        public MostlySingularMultiMap<String, AnnotationData> getResult() {
            if (this.myData.isEmpty()) {
                return MostlySingularMultiMap.emptyMap();
            }
            this.myData.compact();
            return this.myData;
        }
    }

    private static class AnnotationData {
        private final String myFqName;
        private final String myParameters;
        private volatile PsiAnnotation myAnnotation;

        private AnnotationData(@NotNull String fqn, @NotNull String parameters2) {
            if (fqn == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData", "<init>"));
            }
            if (parameters2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData", "<init>"));
            }
            this.myFqName = fqn;
            this.myParameters = parameters2;
        }

        @NotNull
        private PsiAnnotation getAnnotation(@NotNull BaseExternalAnnotationsManager context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData", "getAnnotation"));
            }
            PsiAnnotation a = this.myAnnotation;
            if (a == null) {
                String text = "@" + this.myFqName + (this.myParameters.isEmpty() ? "" : "(" + this.myParameters + ")");
                this.myAnnotation = a = BaseExternalAnnotationsManager.markAsExternalAnnotation(context.createAnnotationFromText(text));
            }
            PsiAnnotation psiAnnotation = a;
            if (psiAnnotation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData", "getAnnotation"));
            }
            return psiAnnotation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationData data2 = (AnnotationData)o;
            return this.myFqName.equals(data2.myFqName) && this.myParameters.equals(data2.myParameters);
        }

        public int hashCode() {
            int result2 = this.myFqName.hashCode();
            result2 = 31 * result2 + this.myParameters.hashCode();
            return result2;
        }

        public String toString() {
            return this.myFqName + "(" + this.myParameters + ")";
        }
    }
}

