/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.relocated.gnu.trove.THashSet;
import org.jetbrains.kotlin.relocated.gnu.trove.TObjectHashingStrategy;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.types.BoundsSubstitutor;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.Specificity;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class OverloadingConflictResolver {
    private final KotlinBuiltIns builtIns;

    public OverloadingConflictResolver(@NotNull KotlinBuiltIns builtIns) {
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/resolve/calls/results/OverloadingConflictResolver", "<init>"));
        }
        this.builtIns = builtIns;
    }

    @Nullable
    public <D extends CallableDescriptor> MutableResolvedCall<D> findMaximallySpecific(@NotNull Set<MutableResolvedCall<D>> candidates, boolean discriminateGenericDescriptors) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/results/OverloadingConflictResolver", "findMaximallySpecific"));
        }
        THashSet<MutableResolvedCall<D>> maximallySpecific = new THashSet<MutableResolvedCall<D>>(new TObjectHashingStrategy<MutableResolvedCall<D>>(){

            @Override
            public boolean equals(MutableResolvedCall<D> o1, MutableResolvedCall<D> o2) {
                return o1 == null ? o2 == null : o1.getResultingDescriptor().equals(o2.getResultingDescriptor());
            }

            @Override
            public int computeHashCode(MutableResolvedCall<D> object) {
                return object == null ? 0 : object.getResultingDescriptor().hashCode();
            }
        });
        for (MutableResolvedCall<D> candidateCall : candidates) {
            if (!this.isMaximallySpecific(candidateCall, candidates, discriminateGenericDescriptors)) continue;
            maximallySpecific.add(candidateCall);
        }
        return maximallySpecific.size() == 1 ? (MutableResolvedCall)maximallySpecific.iterator().next() : null;
    }

    private <D extends CallableDescriptor> boolean isMaximallySpecific(@NotNull MutableResolvedCall<D> candidateCall, @NotNull Set<MutableResolvedCall<D>> candidates, boolean discriminateGenericDescriptors) {
        if (candidateCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateCall", "org/jetbrains/kotlin/resolve/calls/results/OverloadingConflictResolver", "isMaximallySpecific"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/results/OverloadingConflictResolver", "isMaximallySpecific"));
        }
        Object me = candidateCall.getResultingDescriptor();
        boolean isInvoke = candidateCall instanceof VariableAsFunctionResolvedCall;
        VariableDescriptor variable = isInvoke ? ((VariableAsFunctionResolvedCall)((Object)candidateCall)).getVariableCall().getResultingDescriptor() : null;
        for (MutableResolvedCall<D> otherCall : candidates) {
            Object other = otherCall.getResultingDescriptor();
            if (other == me || !this.definitelyNotMaximallySpecific(me, other, discriminateGenericDescriptors)) continue;
            if (!isInvoke) {
                return false;
            }
            assert (otherCall instanceof VariableAsFunctionResolvedCall) : "'invoke' candidate goes with usual one: " + candidateCall + otherCall;
            ResolvedCall<VariableDescriptor> otherVariableCall = ((VariableAsFunctionResolvedCall)((Object)otherCall)).getVariableCall();
            if (!this.definitelyNotMaximallySpecific(variable, otherVariableCall.getResultingDescriptor(), discriminateGenericDescriptors)) continue;
            return false;
        }
        return true;
    }

    private <D extends CallableDescriptor> boolean definitelyNotMaximallySpecific(D me, D other, boolean discriminateGenericDescriptors) {
        return !this.moreSpecific(me, other, discriminateGenericDescriptors) || this.moreSpecific(other, me, discriminateGenericDescriptors);
    }

    private <Descriptor extends CallableDescriptor> boolean moreSpecific(Descriptor f, Descriptor g, boolean discriminateGenericDescriptors) {
        block21: {
            if (f.getContainingDeclaration() instanceof ScriptDescriptor && g.getContainingDeclaration() instanceof ScriptDescriptor) {
                ScriptDescriptor fs = (ScriptDescriptor)f.getContainingDeclaration();
                ScriptDescriptor gs = (ScriptDescriptor)g.getContainingDeclaration();
                if (fs.getPriority() != gs.getPriority()) {
                    return fs.getPriority() > gs.getPriority();
                }
            }
            boolean isGenericF = this.isGeneric(f);
            boolean isGenericG = this.isGeneric(g);
            if (discriminateGenericDescriptors) {
                if (!isGenericF && isGenericG) {
                    return true;
                }
                if (isGenericF && !isGenericG) {
                    return false;
                }
                if (isGenericF && isGenericG) {
                    return this.moreSpecific(BoundsSubstitutor.substituteBounds(f), BoundsSubstitutor.substituteBounds(g), false);
                }
            }
            if (OverrideResolver.overrides(f, g)) {
                return true;
            }
            if (OverrideResolver.overrides(g, f)) {
                return false;
            }
            ReceiverParameterDescriptor receiverOfF = f.getExtensionReceiverParameter();
            ReceiverParameterDescriptor receiverOfG = g.getExtensionReceiverParameter();
            if (receiverOfF != null && receiverOfG != null && !this.typeMoreSpecific(receiverOfF.getType(), receiverOfG.getType())) {
                return false;
            }
            List<ValueParameterDescriptor> fParams = f.getValueParameters();
            List<ValueParameterDescriptor> gParams = g.getValueParameters();
            int fSize = fParams.size();
            int gSize = gParams.size();
            boolean fIsVararg = this.isVariableArity(fParams);
            boolean gIsVararg = this.isVariableArity(gParams);
            if (!fIsVararg && gIsVararg) {
                return true;
            }
            if (fIsVararg && !gIsVararg) {
                return false;
            }
            if (!fIsVararg && !gIsVararg) {
                if (fSize > gSize) {
                    return false;
                }
                for (int i = 0; i < fSize; ++i) {
                    JetType gParamType;
                    ValueParameterDescriptor fParam = fParams.get(i);
                    ValueParameterDescriptor gParam = gParams.get(i);
                    JetType fParamType = fParam.getType();
                    if (this.typeMoreSpecific(fParamType, gParamType = gParam.getType())) continue;
                    return false;
                }
            }
            if (!fIsVararg || !gIsVararg) break block21;
            int minSize = Math.min(fSize, gSize);
            for (int i = 0; i < minSize - 1; ++i) {
                JetType gParamType;
                ValueParameterDescriptor fParam = fParams.get(i);
                ValueParameterDescriptor gParam = gParams.get(i);
                JetType fParamType = fParam.getType();
                if (this.typeMoreSpecific(fParamType, gParamType = gParam.getType())) continue;
                return false;
            }
            if (fSize < gSize) {
                ValueParameterDescriptor fParam = fParams.get(fSize - 1);
                JetType fParamType = fParam.getVarargElementType();
                assert (fParamType != null) : "fIsVararg guarantees this";
                for (int i = fSize - 1; i < gSize; ++i) {
                    ValueParameterDescriptor gParam = gParams.get(i);
                    if (this.typeMoreSpecific(fParamType, OverloadingConflictResolver.getVarargElementTypeOrType(gParam))) continue;
                    return false;
                }
            } else {
                ValueParameterDescriptor gParam = gParams.get(gSize - 1);
                JetType gParamType = gParam.getVarargElementType();
                assert (gParamType != null) : "gIsVararg guarantees this";
                for (int i = gSize - 1; i < fSize; ++i) {
                    ValueParameterDescriptor fParam = fParams.get(i);
                    if (this.typeMoreSpecific(OverloadingConflictResolver.getVarargElementTypeOrType(fParam), gParamType)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    private static JetType getVarargElementTypeOrType(@NotNull ValueParameterDescriptor parameterDescriptor) {
        if (parameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterDescriptor", "org/jetbrains/kotlin/resolve/calls/results/OverloadingConflictResolver", "getVarargElementTypeOrType"));
        }
        JetType varargElementType = parameterDescriptor.getVarargElementType();
        if (varargElementType != null) {
            JetType jetType = varargElementType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/OverloadingConflictResolver", "getVarargElementTypeOrType"));
            }
            return jetType;
        }
        JetType jetType = parameterDescriptor.getType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/OverloadingConflictResolver", "getVarargElementTypeOrType"));
        }
        return jetType;
    }

    private boolean isVariableArity(List<ValueParameterDescriptor> fParams) {
        int fSize = fParams.size();
        return fSize > 0 && fParams.get(fSize - 1).getVarargElementType() != null;
    }

    private boolean isGeneric(CallableDescriptor f) {
        return !f.getOriginal().getTypeParameters().isEmpty();
    }

    private boolean typeMoreSpecific(@NotNull JetType specific, @NotNull JetType general) {
        boolean isSubtype;
        if (specific == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specific", "org/jetbrains/kotlin/resolve/calls/results/OverloadingConflictResolver", "typeMoreSpecific"));
        }
        if (general == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "general", "org/jetbrains/kotlin/resolve/calls/results/OverloadingConflictResolver", "typeMoreSpecific"));
        }
        boolean bl = isSubtype = JetTypeChecker.DEFAULT.isSubtypeOf(specific, general) || this.numericTypeMoreSpecific(specific, general);
        if (!isSubtype) {
            return false;
        }
        Specificity.Relation sThanG = TypesPackage.getSpecificityRelationTo(specific, general);
        Specificity.Relation gThanS = TypesPackage.getSpecificityRelationTo(general, specific);
        return sThanG != Specificity.Relation.LESS_SPECIFIC || gThanS == Specificity.Relation.LESS_SPECIFIC;
    }

    private boolean numericTypeMoreSpecific(@NotNull JetType specific, @NotNull JetType general) {
        if (specific == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specific", "org/jetbrains/kotlin/resolve/calls/results/OverloadingConflictResolver", "numericTypeMoreSpecific"));
        }
        if (general == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "general", "org/jetbrains/kotlin/resolve/calls/results/OverloadingConflictResolver", "numericTypeMoreSpecific"));
        }
        JetType _double = this.builtIns.getDoubleType();
        JetType _float = this.builtIns.getFloatType();
        JetType _long = this.builtIns.getLongType();
        JetType _int = this.builtIns.getIntType();
        JetType _byte = this.builtIns.getByteType();
        JetType _short = this.builtIns.getShortType();
        if (TypeUtils.equalTypes(specific, _double) && TypeUtils.equalTypes(general, _float)) {
            return true;
        }
        if (TypeUtils.equalTypes(specific, _int)) {
            if (TypeUtils.equalTypes(general, _long)) {
                return true;
            }
            if (TypeUtils.equalTypes(general, _byte)) {
                return true;
            }
            if (TypeUtils.equalTypes(general, _short)) {
                return true;
            }
        }
        return TypeUtils.equalTypes(specific, _short) && TypeUtils.equalTypes(general, _byte);
    }
}

