/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.IntRange;
import kotlin.KotlinPackage;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedType;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBoundsImpl;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBoundsKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.CompoundConstraintPosition;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.types.typesApproximation.ApproximationBounds;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"v\u0004)!2i\u001c8tiJ\f\u0017N\u001c;TsN$X-\\%na2T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\be\u0016\u001cx\u000e\u001c<f\u0015\u0015\u0019\u0017\r\u001c7t\u0015%IgNZ3sK:\u001cWMC\fbI\u0012\u001cuN\\:ue\u0006Lg\u000e\u001e$s_6\u0014u.\u001e8eg*\u0019q\u000e\u001c3\u000b\u000b\t{WO\u001c3\u000b\u0015QK\b/\u001a\"pk:$7OC\u0002oK^TA!\u00168ji*\u0001B+\u001f9f\u0005>,h\u000eZ:%\u0005>,h\u000e\u001a\u0006\u001a\u0007>t7\u000f\u001e:bS:$\u0018J\\2peB|'/\u0019;j_:\\EO\u0003\thK:,'/\u0019;f\u001d\u0016<(i\\;oI*)!m\\;oI*a1/\u001e2ti&$X\u000f^5p]*\u0001\u0012N\\2peB|'/\u0019;f\u0005>,h\u000e\u001a\u0006\t]\u0016<(i\\;oIJS!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015QA\u0001\u0003\u0003\u0011\r)1\u0001\"\u0002\t\u00011\u0001Qa\u0001C\u0003\u0011\u0015a\u0001!B\u0002\u0005\b!%A\u0002A\u0003\u0002\u0011\u0007)1\u0001\"\u0003\t\r1\u0001QA\u0001C\u0003\u0011\u0001)!\u0001\"\u0002\t\u000e\u00159C!A\u000b\u0004\u000b\u0005A1\u0001G\u0002\u0019\bu=A\u0001\u0001\u0005\u0005\u001b\r)\u0011\u0001\u0003\u0003\u0019\tA\u001b\t!h\u0004\u0005\u0001!-QbA\u0003\u0002\u0011\u0011AB\u0001U\u0002\u0002C\r)\u0011\u0001C\u0003\u0019\u000bE\u001b\u0011\u0002b\u0002\n\u0003\u0011\u0001Q\"\u0001E\u0006\u001b\u0005Aa!D\u0001\t\ra\u001bq!B\u0014\u0005\u0003U\u0019Q!\u0001\u0005\u00041\rAz!h\u0004\u0005\u0001!AQbA\u0003\u0002\u0011\u0011AB\u0001UB\u0001;\u001f!\u0001\u0001#\u0005\u000e\u0007\u0015\t\u0001\u0002\u0002\r\u0005!\u000e\t\u0011eA\u0003\u0002\u0011\u0015AR!U\u0002\n\t\u001fI\u0011\u0001\u0002\u0001\u000e\u0003!-Q\"\u0001\u0005\u0007\u001b\u0005Aa\u0001W\u0002\b\u000bs!1!F\u0002\u0006\u0003!\u0019\u0001d\u0001\r\n;\u001f!\u0001\u0001c\u0005\u000e\u0007\u0015\t\u0001\u0002\u0002\r\u0005!\u000e\u0005\u0011eA\u0003\u0002\u0011\u0015AR!U\u0002\b\t%I\u0011\u0001\u0002\u0001\u000e\u0003!-Q\"\u0001\u0005\u00071\u000e9\u0001"})
public final class ConstraintIncorporationKt {
    /*
     * WARNING - void declaration
     */
    public static final void incorporateBound(ConstraintSystemImpl $receiver, @NotNull TypeBounds.Bound newBound) {
        void $receiver2;
        JetType constrainingType;
        int n;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(newBound, "newBound");
        TypeParameterDescriptor typeVariable = newBound.getTypeVariable();
        TypeBoundsImpl typeBounds = $receiver.getTypeBounds(typeVariable);
        IntRange intRange = KotlinPackage.getIndices(typeBounds.getBounds());
        int n2 = ((Number)intRange.getStart()).intValue();
        int n3 = ((Number)intRange.getEnd()).intValue();
        if (n2 <= n3) {
            while (true) {
                void oldBoundIndex;
                TypeBounds.Bound bound = (TypeBounds.Bound)((ArrayList)typeBounds.getBounds()).get((int)oldBoundIndex);
                Intrinsics.checkExpressionValueIsNotNull(bound, "typeBounds.bounds[oldBoundIndex]");
                ConstraintIncorporationKt.addConstraintFromBounds($receiver, bound, newBound);
                if (oldBoundIndex == n3) break;
                ++oldBoundIndex;
            }
        }
        List<TypeBounds.Bound> boundsUsedIn = $receiver.getBoundsUsedIn(typeVariable);
        IntRange intRange2 = KotlinPackage.getIndices((Collection)boundsUsedIn);
        n3 = ((Number)intRange2.getStart()).intValue();
        if (n3 <= (n = ((Number)intRange2.getEnd()).intValue())) {
            while (true) {
                void index2;
                TypeBounds.Bound boundUsedIn = boundsUsedIn.get((int)index2);
                ConstraintIncorporationKt.generateNewBound($receiver, boundUsedIn, newBound);
                if (index2 == n) break;
                ++index2;
            }
        }
        if ($receiver.isMyTypeVariable(constrainingType = newBound.getConstrainingType())) {
            ConstraintContext context = new ConstraintContext(newBound.getPosition(), newBound.getDerivedFrom(), false, 4, null);
            TypeParameterDescriptor typeParameterDescriptor = $receiver.getMyTypeVariable(constrainingType);
            if (typeParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            $receiver.addBound(typeParameterDescriptor, $receiver.getCorrespondingType(typeVariable), TypeBoundsKt.reverse(newBound.getKind()), context);
            return;
        }
        Iterable context = ConstraintSystemImpl.getNestedTypeVariables$default($receiver, constrainingType, false, 1);
        for (Object element : $receiver2) {
            int n4;
            TypeParameterDescriptor it2 = (TypeParameterDescriptor)element;
            Collection boundsForNestedVariable = $receiver.getTypeBounds(it2).getBounds();
            IntRange intRange3 = KotlinPackage.getIndices(boundsForNestedVariable);
            int n5 = ((Number)intRange3.getStart()).intValue();
            if (n5 > (n4 = ((Number)intRange3.getEnd()).intValue())) continue;
            while (true) {
                void index3;
                TypeBounds.Bound bound = (TypeBounds.Bound)((ArrayList)boundsForNestedVariable).get((int)index3);
                Intrinsics.checkExpressionValueIsNotNull(bound, "boundsForNestedVariable[index]");
                ConstraintIncorporationKt.generateNewBound($receiver, newBound, bound);
                if (index3 == n4) break;
                ++index3;
            }
        }
    }

    public static final void addConstraintFromBounds(ConstraintSystemImpl $receiver, @NotNull TypeBounds.Bound old, @NotNull TypeBounds.Bound bound) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(old, "old");
        Intrinsics.checkParameterIsNotNull(bound, "new");
        if (Intrinsics.areEqual(old, bound)) {
            return;
        }
        JetType oldType = old.getConstrainingType();
        JetType newType = bound.getConstrainingType();
        ConstraintContext context = new ConstraintContext(new CompoundConstraintPosition(old.getPosition(), bound.getPosition()), KotlinPackage.plus(old.getDerivedFrom(), (Iterable)bound.getDerivedFrom()), false, 4, null);
        if (old.getKind().ordinal() < bound.getKind().ordinal()) {
            $receiver.addConstraint(ConstraintSystemImpl.ConstraintKind.SUB_TYPE, oldType, newType, context);
        } else if (old.getKind().ordinal() > bound.getKind().ordinal()) {
            $receiver.addConstraint(ConstraintSystemImpl.ConstraintKind.SUB_TYPE, newType, oldType, context);
        } else if (Intrinsics.areEqual((Object)old.getKind(), (Object)bound.getKind()) && Intrinsics.areEqual((Object)old.getKind(), (Object)TypeBounds.BoundKind.EXACT_BOUND)) {
            $receiver.addConstraint(ConstraintSystemImpl.ConstraintKind.EQUAL, oldType, newType, context);
        }
    }

    public static final void generateNewBound(ConstraintSystemImpl $receiver, @NotNull TypeBounds.Bound bound, @NotNull TypeBounds.Bound substitution) {
        JetType jetType;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(bound, "bound");
        Intrinsics.checkParameterIsNotNull(substitution, "substitution");
        TypeBounds.BoundKind boundKind = substitution.getKind();
        if (Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.EXACT_BOUND)) {
            jetType = substitution.getConstrainingType();
        } else if (Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.UPPER_BOUND)) {
            jetType = new CapturedType(new TypeProjectionImpl(Variance.OUT_VARIANCE, substitution.getConstrainingType()));
        } else if (Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.LOWER_BOUND)) {
            jetType = new CapturedType(new TypeProjectionImpl(Variance.IN_VARIANCE, substitution.getConstrainingType()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        JetType substitutedType = jetType;
        TypeProjectionImpl newTypeProjection = new TypeProjectionImpl(substitutedType);
        TypeSubstitutor substitutor2 = TypeSubstitutor.create(KotlinPackage.mapOf(KotlinPackage.to(substitution.getTypeVariable().getTypeConstructor(), newTypeProjection)));
        JetType jetType2 = substitutor2.substitute(bound.getConstrainingType(), Variance.INVARIANT);
        if (jetType2 == null) {
            return;
        }
        JetType type2 = jetType2;
        CompoundConstraintPosition position = new CompoundConstraintPosition(bound.getPosition(), substitution.getPosition());
        Function2<JetType, TypeBounds.BoundKind, Unit> addNewBound$ = new Function2<JetType, TypeBounds.BoundKind, Unit>($receiver, bound, substitution, position){
            final /* synthetic */ ConstraintSystemImpl receiver$0;
            final /* synthetic */ TypeBounds.Bound $bound;
            final /* synthetic */ TypeBounds.Bound $substitution;
            final /* synthetic */ CompoundConstraintPosition $position;

            public final void invoke(@NotNull JetType newConstrainingType, @NotNull TypeBounds.BoundKind newBoundKind) {
                Intrinsics.checkParameterIsNotNull(newConstrainingType, "newConstrainingType");
                Intrinsics.checkParameterIsNotNull((Object)((Object)newBoundKind), "newBoundKind");
                List<TypeParameterDescriptor> nestedTypeVariables = this.receiver$0.getNestedTypeVariables(newConstrainingType, false);
                if (nestedTypeVariables.contains(this.$bound.getTypeVariable())) {
                    return;
                }
                HashSet<TypeParameterDescriptor> derivedFrom = new HashSet<TypeParameterDescriptor>((Collection)KotlinPackage.plus(this.$bound.getDerivedFrom(), (Iterable)this.$substitution.getDerivedFrom()));
                if (derivedFrom.contains(this.$substitution.getTypeVariable())) {
                    return;
                }
                derivedFrom.add(this.$substitution.getTypeVariable());
                this.receiver$0.addBound(this.$bound.getTypeVariable(), newConstrainingType, newBoundKind, new ConstraintContext(this.$position, derivedFrom, false, 4, null));
            }
            {
                this.receiver$0 = constraintSystemImpl;
                this.$bound = bound;
                this.$substitution = bound2;
                this.$position = compoundConstraintPosition;
                super(2);
            }
        };
        if (Intrinsics.areEqual((Object)substitution.getKind(), (Object)TypeBounds.BoundKind.EXACT_BOUND)) {
            JetType jetType3 = type2;
            Intrinsics.checkExpressionValueIsNotNull(jetType3, "type");
            addNewBound$.invoke(jetType3, bound.getKind());
            return;
        }
        JetType jetType4 = type2;
        Intrinsics.checkExpressionValueIsNotNull(jetType4, "type");
        ApproximationBounds<JetType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(jetType4);
        Function1<JetType, Boolean> containsConstrainingTypeWithoutProjection$ = new Function1<JetType, Boolean>(substitution){
            final /* synthetic */ TypeBounds.Bound $substitution;

            public final boolean invoke(JetType $receiver) {
                boolean bl;
                block1: {
                    Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                    Iterable $receiver2 = TypeUtilsKt.getNestedArguments($receiver);
                    for (T element : $receiver2) {
                        TypeProjection it2 = (TypeProjection)element;
                        if (!(Intrinsics.areEqual(it2.getType().getConstructor(), this.$substitution.getConstrainingType().getConstructor()) && Intrinsics.areEqual((Object)((Object)it2.getProjectionKind()), (Object)((Object)Variance.INVARIANT)))) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
            {
                this.$substitution = bound;
                super(1);
            }
        };
        if (containsConstrainingTypeWithoutProjection$.invoke(approximationBounds.getUpper()) && Intrinsics.areEqual((Object)bound.getKind(), (Object)TypeBounds.BoundKind.LOWER_BOUND) ^ true) {
            addNewBound$.invoke(approximationBounds.getUpper(), TypeBounds.BoundKind.UPPER_BOUND);
        }
        if (containsConstrainingTypeWithoutProjection$.invoke(approximationBounds.getLower()) && Intrinsics.areEqual((Object)bound.getKind(), (Object)TypeBounds.BoundKind.UPPER_BOUND) ^ true) {
            addNewBound$.invoke(approximationBounds.getLower(), TypeBounds.BoundKind.LOWER_BOUND);
        }
    }
}

