/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.expressions.CaptureKind;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"=\b)I2)\u00199ukJLgnZ%o\u00072|7/\u001e:f\u0007\",7m[3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u0002:fg>dg/\u001a\u0006\u0006G\u0006dGn\u001d\u0006\tG\",7m[3sg*Y1)\u00197m\u0007\",7m[3s\u0015\u0019a\u0014N\\5u})\taI\u0003\nDC2d\u0017M\u00197f\t\u0016\u001c8M]5qi>\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNTQa\u00195fG.TAB]3t_24X\rZ\"bY2TABU3t_24X\rZ\"bY2TQ!\\8eK2TqaY8oi\u0016DHO\u0003\u000eCCNL7mQ1mYJ+7o\u001c7vi&|gnQ8oi\u0016DHO\u0003\u0003V]&$(bF2iK\u000e\\7)\u00199ukJLgnZ%o\u00072|7/\u001e:f\u0015!1\u0018M]5bE2,'B\u0005,be&\f'\r\\3EKN\u001c'/\u001b9u_JTQ\u0001\u001e:bG\u0016TABQ5oI&tw\r\u0016:bG\u0016TQa]2pa\u0016TA\u0002T3yS\u000e\fGnU2pa\u0016Taa]2pa\u0016\u001c(BE5t\u0007\u0006\u0004H/\u001e:fI&s\u0017J\u001c7j]\u0016TaBQ5oI&twmQ8oi\u0016DHO\u0003\btG>\u0004XmQ8oi\u0006Lg.\u001a:\u000b+\u0011+7\r\\1sCRLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;pe*qa/\u0019:jC\ndW\rU1sK:$(b\u0002\"p_2,\u0017M\u001c\u0006\u0013SN\u001c\u0015\r\u001d;ve\u0016$g+\u0019:jC\ndW\rs\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\t!!\u0001C\u0002\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\r!)\u0001c\u0002\r\u0001\u0015\u0011A!\u0001E\u0006\u000b\r!A\u0001C\u0003\r\u0001\u0015\u0011AA\u0001E\b\u000b\r!Q\u0001C\u0004\r\u0001\u0015\u0011AA\u0001\u0005\t\u000b\r!a\u0001#\u0005\r\u0001\u0015\t\u00012A\u0003\u0004\t\u001dA\u0011\u0002\u0004\u0001\u0006\u0005\u0011)\u0001bB\u0003\u0003\t\u0019A\t\"B\u0002\u0005\t!UA\u0002A\u0003\u0004\t\u0007A9\u0002\u0004\u0001\u0006\u0005\u0011\r\u0001\"D\u0003\u0004\t)AI\u0002\u0004\u0001\u0006\u0005\u0011!\u0001RC\u0003\u0003\t\u0007A9\"\u0002\u0002\u0005\u0015!eQa\u0001C\u0002\u00119a\u0001!B\u0002\u0005\t!yA\u0002A\u0003\u0004\t\u001dA\u0001\u0003\u0004\u0001\u0006\u0005\u0011\r\u0001BD\u0003\u0003\t\u0011Aq\u0002B\u0002\r\u0007e\u0019Q!\u0001E\u00041\u000fiK\u0006B\u0006\u0012\r\u0011\u0001\u0001\u0012B\u000b\u0004\u000b\u0005AI\u0001'\u0003\u0019\rumA\u0001\u0001E\u0007\u001b%)\u0011\u0001c\u0003\n\u000b%!QA\u0001C\u0001\u0011\u0001a\u0002\u0001g\u0003Q\u0007\u0001iz\u0001\u0002\u0001\t\u00115\u0019Q!\u0001E\u00071\u001b\u00016\u0011A\u0011\u0004\u000b\u0005Ay\u0001g\u0004R\u0007\u001d!a!C\u0001\u0005\u00015\t\u0001\u0002C\u0007\u0002\u0011#i#\u0006B\u0001\u0019\u0014u=A\u0001\u0001\u0005\u000b\u001b\r)\u0011\u0001C\u0005\u0019\u0013A\u001b\u0001!h\u0004\u0005\u0001!YQbA\u0003\u0002\u0011'A\u001a\u0002UB\u0001;\u001f!\u0001\u0001\u0003\u0007\u000e\u0007\u0015\t\u0001R\u0003M\u000b!\u000e\t\u0011eA\u0003\u0002\u0011\u001fAz!U\u0002\n\t'I\u0011\u0001\u0002\u0001\u000e\u0003!YQ\"\u0001E\f\u001b\u0005AA\"\f\u0016\u0005\u0003amQt\u0002\u0003\u0001\u0011!i1!B\u0001\t\u001aae\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001RD\u0007\u0004\u000b\u0005AQ\u0002G\u0007Q\u0007\u0003iz\u0001\u0002\u0001\t 5\u0019Q!\u0001\u0005\u000e15\u00016!A\u0011\u0004\u000b\u0005AY\u0002g\u0007R\u0007%!Y\"C\u0001\u0005\u00025\t\u0001BD\u0007\u0002\u0011;i\u0011\u0001#\b.@\u0011\t\u0001\u0014EO\b\t\u0001Ay\"D\u0002\u0006\u0003!i\u0001$\u0004)\u0004\u0001u=A\u0001\u0001E\u000f\u001b\r)\u0011\u0001C\u0007\u0019\u001bA\u001b\t!I\u0002\u0006\u0003!m\u00014D)\u0004\u000f\u0011\u0005\u0012\"\u0001C\u0001\u001b\u0005Ai\"D\u0001\t\u001eUbQa\u0003\u0003d\u0002a!\u0011eA\u0003\u0002\u0011\rA2!U\u0002\u0004\t\u0011I\u0011\u0001\u0002\u0001"})
public final class CapturingInClosureChecker
implements CallChecker {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(CapturingInClosureChecker.class);
    }

    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        VariableDescriptor variableDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ResolvedCall<F> variableResolvedCall = resolvedCall instanceof VariableAsFunctionResolvedCall ? ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getVariableCall() : resolvedCall;
        F f = variableResolvedCall.getResultingDescriptor();
        if (!(f instanceof VariableDescriptor)) {
            f = null;
        }
        if ((variableDescriptor = (VariableDescriptor)f) != null) {
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
            this.checkCapturingInClosure(variableDescriptor, bindingTrace, lexicalScope);
        }
    }

    private final void checkCapturingInClosure(VariableDescriptor variable, BindingTrace trace, LexicalScope scope2) {
        DeclarationDescriptor variableParent = variable.getContainingDeclaration();
        DeclarationDescriptor scopeContainer = scope2.getOwnerDescriptor();
        DeclarationDescriptor declarationDescriptor = variableParent;
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "variableParent");
        if (this.isCapturedVariable(declarationDescriptor, scopeContainer) && Intrinsics.areEqual((Object)((CaptureKind)((Object)trace.get(BindingContext.CAPTURED_IN_CLOSURE, variable))), (Object)CaptureKind.NOT_INLINE) ^ true) {
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
            DeclarationDescriptor declarationDescriptor2 = variableParent;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "variableParent");
            boolean inline2 = this.isCapturedInInline(bindingContext, scopeContainer, declarationDescriptor2);
            trace.record(BindingContext.CAPTURED_IN_CLOSURE, variable, inline2 ? CaptureKind.INLINE_ONLY : CaptureKind.NOT_INLINE);
        }
    }

    private final boolean isCapturedVariable(DeclarationDescriptor variableParent, DeclarationDescriptor scopeContainer) {
        if (!(variableParent instanceof FunctionDescriptor) || Intrinsics.areEqual(scopeContainer, variableParent)) {
            return false;
        }
        if (variableParent instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)variableParent).getContainingDeclaration();
            if (Intrinsics.areEqual(scopeContainer, classDescriptor)) {
                return false;
            }
            if (scopeContainer instanceof PropertyDescriptor && Intrinsics.areEqual(((PropertyDescriptor)scopeContainer).getContainingDeclaration(), classDescriptor)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCapturedInInline(BindingContext context, DeclarationDescriptor scopeContainer, DeclarationDescriptor variableParent) {
        PsiElement scopeDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(scopeContainer);
        if (!InlineUtil.canBeInlineArgument(scopeDeclaration)) {
            return false;
        }
        PsiElement psiElement = scopeDeclaration;
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetFunction");
        }
        if (InlineUtil.isInlinedArgument((JetFunction)psiElement, context, false)) {
            void value;
            DeclarationDescriptor scopeContainerParent = scopeContainer.getContainingDeclaration();
            boolean bl = scopeContainerParent != null;
            if (KotlinPackage.getASSERTIONS_ENABLED() && value == false) {
                String message = "parent is null for " + scopeContainer;
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            DeclarationDescriptor declarationDescriptor = scopeContainerParent;
            if (declarationDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "scopeContainerParent!!");
            return !this.isCapturedVariable(variableParent, declarationDescriptor) || this.isCapturedInInline(context, scopeContainerParent, variableParent);
        }
        return false;
    }
}

