/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.bindingContextUtil;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"a\b)q!)\u001b8eS:<7i\u001c8uKb$(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\u000fI,7o\u001c7wK*yq-\u001a;ECR\fg\t\\8x\u0013:4wN\u0003\u0006fqB\u0014Xm]:j_:TQBS3u\u000bb\u0004(/Z:tS>t'b\u00019tS*aA)\u0019;b\r2|w/\u00138g_*)1-\u00197mg*Q1/\\1si\u000e\f7\u000f^:\u000b+\tKg\u000eZ5oO\u000e{g\u000e^3yiV#\u0018\u000e\\:Li*\u0019r-\u001a;SK\u001a,'/\u001a8dKR\u000b'oZ3ug*91m\u001c8uKb$(BC\"pY2,7\r^5p]*)B)Z2mCJ\fG/[8o\t\u0016\u001c8M]5qi>\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNTAA[1wC*!Q\u000f^5m\u0015MQU\r\u001e*fiV\u0014h.\u0012=qe\u0016\u001c8/[8o\u0015E9W\r\u001e+be\u001e,GOR;oGRLwN\u001c\u0006\u0017\u0015\u0016$8)\u00197mC\ndW\rR3dY\u0006\u0014\u0018\r^5p]*Yr-\u001a;UCJ<W\r\u001e$v]\u000e$\u0018n\u001c8EKN\u001c'/\u001b9u_JT!CR;oGRLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;pe*\t\u0012n]+oe\u0016\f7\r[1cY\u0016\u001cu\u000eZ3\u000b\u000f\t{w\u000e\\3b]*\u0011\u0012n]+tK\u0012\f5/\u0012=qe\u0016\u001c8/[8o\u0015EI7/V:fI\u0006\u001b8\u000b^1uK6,g\u000e\u001e\u0006\u0002\u0007*\t\"+Z:pYV$\u0018n\u001c8D_:$X\r\u001f;\u000b5I,7m\u001c:e'\u000e|\u0007/Z!oI\u0012\u000bG/\u0019$m_^LeNZ8\u000b\tUs\u0017\u000e\u001ef\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)1\u0001b\u0001\t\u00011\u0001QA\u0001\u0003\u0002\u0011\u0011)1\u0001\"\u0002\t\b1\u0001QA\u0001C\u0002\u0011\u0015)!\u0001b\u0002\t\f\u0015\u0019A\u0001\u0002E\u0005\u0019\u0001)!\u0001\u0002\u0003\t\n\u0015\u0011A1\u0001\u0005\u0001\u000b\t!)\u0001c\u0002\u0006\u0003!\rQa\u0001C\u0007\u0011\u001fa\u0001!\u0002\u0002\u0005\u0003!EQa\u0001C\b\u0011!a\u0001!B\u0001\t\u0013\u0015\u0011A\u0011\u0003E\n\u000b\t!\u0011\u0002c\u0004\u0006\u0007\u0011\u0015\u0001B\u0003\u0007\u0001\u000b\r!)\u0001C\u0006\r\u0001\u0015\u0011AQ\u0001\u0005\f\u000b\t!)\u0001\u0003\u0006\u0006\u0007\u0011=\u0001\u0002\u0004\u0007\u0001\u000b\t!y\u0001\u0003\u0007\u0006\u0007\u00115\u0001\"\u0004\u0007\u0001\u000b\t!9\u0001C\u0004\u0006\u0007\u0011m\u0001b\u0004\u0007\u0001\u000b\r!i\u0001\u0003\t\r\u0001\u0015\u0011A1\u0004\u0005\u0010\u000bw!1!F\u0002\u0006\u0003!\u0011\u0001D\u0001M\u0003;#!\u0001\u0001C\u0002\u000e\t\u0015\t\u0001b\u0001G\u00011\r\u00016\u0011A\u0011\u0004\u000b\u0005AI\u0001'\u0003R\u0007\u001d!)!C\u0001\t\u000b5\t\u00012B\u0007\u0002\u0011\u0019A6ABC\"\t\r)2!B\u0001\t\u0007a\u0019\u0001TBO\b\t\u0001Aq!D\u0002\u0006\u0003!\u0011\u0001D\u0001)\u0004\u0002\u0005BQ!\u0001\u0005\b\u0013\u0011I1!B\u0001\t\u0011aA\u0001dB)\u0004\u000f\u00115\u0011\"\u0001E\n\u001b\u0005Aa!D\u0001\t\fa\u001ba!b\u000f\u0005\u0007U\u0019Q!\u0001\u0005\u000b1)A*\"h\u0004\u0005\u0001!9QbA\u0003\u0002\u0011\tA\"\u0001UB\u0001C\u0011)\u0011\u0001#\u0006\r\u0002aU\u0011kA\u0004\u0005\u0016%\t\u0001bC\u0007\u0002\u0011/i\u0011\u0001c\u0003Y\u0007\u0019)Y\u0004B\u0002\u0016\u0007\u0015\t\u0001B\u0003\r\u000b1/iz\u0001\u0002\u0001\t\u000f5\u0019Q!\u0001\u0005\u00031\t\u00016\u0011A\u0011\u0005\u000b\u0005AA\u0002$\u0001\u0019\u0019E\u001bq\u0001b\u0006\n\u0003!eQ\"\u0001E\f\u001b\u0005AY\u0001W\u0002\u0007\u000bs!1!F\u0002\u0006\u0003!\u0019\u0001d\u0001M\r;\u001f!\u0001\u0001C\u0004\u000e\u0007\u0015\t\u0001B\u0001\r\u0003!\u000e\u0005\u0011eA\u0003\u0002\u00115AR\"U\u0002\b\t3I\u0011\u0001\"\u0001\u000e\u0003!1Q\"\u0001E\u00061\u000e1Q\u0011\b\u0003\u0004+\r)\u0011\u0001C\u0002\u0019\u0007amQt\u0002\u0003\u0001\u0011\u001di1!B\u0001\t\u0005a\u0011\u0001k!\u0001\"\u0007\u0015\t\u0001\"\u0004\r\u000e#\u000e9A1D\u0005\u0002\t\u0003i\u0011\u0001\u0003\u0004\u000e\u0003!-\u0001l\u0001\u0004\u0006:\u0011\u0019QcA\u0003\u0002\u0011\rA2\u0001\u0007\b\u001e\u0010\u0011\u0001\u0001bB\u0007\u0004\u000b\u0005A!\u0001\u0007\u0002Q\u0007\u0003\t3!B\u0001\t\u001bai\u0011kA\u0004\u0005\u001d%\tA\u0011A\u0007\u0002\u0011\u0019i\u0011\u0001c\u0003Y\u0007\u0019)\t\u0007B\u0002\u0012\u0019\u0011\u0001\u0001RD\u000b\n\u000b\u0005Aa\"C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001Ab\"F\u0005\u0006\u0003!q\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001aq\u0001tDO\t\t\u0001A1!\u0004\u0003\u0006\u0003!\u0019A\u0012\u0001\r\u0004!\u000e\u0005\u0011eA\u0003\u0002\u0011;Aj\"U\u0002\b\t?I\u0011\u0001\u0002\u0001\u000e\u0003!yQ\"\u0001\u0005\u00071\u000e1\u0001"})
public final class BindingContextUtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FunctionDescriptor getTargetFunctionDescriptor(JetReturnExpression $receiver, @NotNull BindingContext context) {
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JetSimpleNameExpression targetLabel = $receiver.getTargetLabel();
        if (targetLabel != null) {
            SimpleFunctionDescriptor simpleFunctionDescriptor;
            PsiElement psiElement = (PsiElement)context.get(BindingContext.LABEL_TARGET, targetLabel);
            if (psiElement != null) {
                PsiElement $receiver3 = psiElement;
                PsiElement it2 = $receiver3;
                simpleFunctionDescriptor = (SimpleFunctionDescriptor)context.get(BindingContext.FUNCTION, it2);
            } else {
                simpleFunctionDescriptor = null;
            }
            return simpleFunctionDescriptor;
        }
        PsiElement it2 = $receiver;
        ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
        BindingContext bindingContext = context;
        JetDeclarationWithBody jetDeclarationWithBody = PsiTreeUtil.getParentOfType((PsiElement)$receiver2, JetDeclarationWithBody.class, false);
        DeclarationDescriptor declarationDescriptor = bindingContext.get(readOnlySlice, jetDeclarationWithBody);
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(declarationDescriptor, FunctionDescriptor.class, false);
        if (containingFunctionDescriptor == null) {
            return null;
        }
        return KotlinPackage.firstOrNull(KotlinPackage.dropWhile(KotlinPackage.sequence(containingFunctionDescriptor, (Function1)getTargetFunctionDescriptor.2.INSTANCE$), (Function1)getTargetFunctionDescriptor.3.INSTANCE$));
    }

    @Nullable
    public static final JetCallableDeclaration getTargetFunction(JetReturnExpression $receiver, @NotNull BindingContext context) {
        JetCallableDeclaration jetCallableDeclaration;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        FunctionDescriptor functionDescriptor = BindingContextUtilsKt.getTargetFunctionDescriptor($receiver, context);
        if (functionDescriptor != null) {
            FunctionDescriptor $receiver2 = functionDescriptor;
            FunctionDescriptor it2 = $receiver2;
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(it2);
            if (!(psiElement instanceof JetCallableDeclaration)) {
                psiElement = null;
            }
            jetCallableDeclaration = (JetCallableDeclaration)psiElement;
        } else {
            jetCallableDeclaration = null;
        }
        return jetCallableDeclaration;
    }

    public static final boolean isUsedAsExpression(JetExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object v = context.get(BindingContext.USED_AS_EXPRESSION, $receiver);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    public static final boolean isUsedAsStatement(JetExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return !BindingContextUtilsKt.isUsedAsExpression($receiver, context);
    }

    public static final <C extends ResolutionContext<C>> void recordScopeAndDataFlowInfo(ResolutionContext<C> $receiver, @Nullable JetExpression expression) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (expression == null) {
            return;
        }
        LexicalScope scopeToRecord = ScopeUtilsKt.takeSnapshot($receiver.scope);
        $receiver.trace.record(BindingContext.RESOLUTION_SCOPE, expression, ScopeUtilsKt.asJetScope(scopeToRecord));
        $receiver.trace.record(BindingContext.LEXICAL_SCOPE, expression, scopeToRecord);
        JetTypeInfo typeInfo = (JetTypeInfo)$receiver.trace.get(BindingContext.EXPRESSION_TYPE_INFO, expression);
        if (typeInfo != null) {
            BindingTrace bindingTrace = $receiver.trace;
            DataFlowInfo dataFlowInfo = $receiver.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression, typeInfo.replaceDataFlowInfo(dataFlowInfo));
        } else if (Intrinsics.areEqual($receiver.dataFlowInfo, DataFlowInfo.EMPTY) ^ true) {
            BindingTrace bindingTrace = $receiver.trace;
            DataFlowInfo dataFlowInfo = $receiver.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression, TypeInfoFactoryKt.noTypeInfo(dataFlowInfo));
        }
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfo(BindingContext $receiver, @Nullable JetExpression expression) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                object = expression;
                if (object == null) break block2;
                JetExpression $receiver2 = object;
                JetExpression it2 = $receiver2;
                JetTypeInfo jetTypeInfo = (JetTypeInfo)$receiver.get(BindingContext.EXPRESSION_TYPE_INFO, it2);
                object = jetTypeInfo != null ? jetTypeInfo.getDataFlowInfo() : null;
                if (object != null) break block3;
            }
            object = DataFlowInfo.EMPTY;
        }
        Intrinsics.checkExpressionValueIsNotNull(object, "expression?.let { this[B\u2026o } ?: DataFlowInfo.EMPTY");
        return object;
    }

    public static final boolean isUnreachableCode(JetExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object v = context.get(BindingContext.UNREACHABLE_CODE, $receiver);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Collection<DeclarationDescriptor> getReferenceTargets(JetExpression $receiver, @NotNull BindingContext context) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        DeclarationDescriptor targetDescriptor = $receiver instanceof JetReferenceExpression ? (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, $receiver) : (DeclarationDescriptor)null;
        List<DeclarationDescriptor> list = targetDescriptor;
        if (list != null) {
            DeclarationDescriptor $receiver2 = list;
            DeclarationDescriptor it2 = $receiver2;
            list = KotlinPackage.listOf(it2);
            if (list != null) {
                collection = list;
                return collection;
            }
        }
        collection = KotlinPackage.orEmpty((Collection)context.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, $receiver));
        return collection;
    }
}

