/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetInstanceExpressionWithLabel;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"H\u0006)a2i\u001c8tiJ,8\r^8s\u0011\u0016\fG-\u001a:DC2d7\t[3dW\u0016\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\u000fI,7o\u001c7wK*Y1)\u00197m\u0007\",7m[3s\u0015\u0015\u0019\u0017\r\u001c7t\u0015!\u0019\u0007.Z2lKJ\u001c(B\u0002\u001fj]&$hHC\u0006d_:\u001cHO];di>\u0014(\"F\"p]N$(/^2u_J$Um]2sSB$xN\u001d\u0006\fI\u0016\u001c8M]5qi>\u00148OC\bd_:$\u0018-\u001b8j]\u001e\u001cE.Y:t\u0015=\u0019E.Y:t\t\u0016\u001c8M]5qi>\u0014(b\u0002(pi:+H\u000e\u001c\u0006\fC:tw\u000e^1uS>t7OC\u0001G\u0015I\u0019\u0015\r\u001c7bE2,G)Z:de&\u0004Ho\u001c:\u000b\u000b\rDWmY6\u000b\u0019I,7o\u001c7wK\u0012\u001c\u0015\r\u001c7\u000b\u0019I+7o\u001c7wK\u0012\u001c\u0015\r\u001c7\u000b\u000b5|G-\u001a7\u000b\u000f\r|g\u000e^3yi*Q\")Y:jG\u000e\u000bG\u000e\u001c*fg>dW\u000f^5p]\u000e{g\u000e^3yi*!QK\\5u\u0015-\u0011X\r]8si\u0016\u0013(o\u001c:\u001f\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011Qa\u0001C\u0002\u0011\u0001a\u0001!\u0002\u0002\u0005\u0004!\u0019QA\u0001C\u0003\u0011\u000f)1\u0001B\u0002\t\u00061\u0001QA\u0001\u0003\u0002\u0011\u0017)1\u0001\u0002\u0003\t\u000b1\u0001QA\u0001\u0003\u0005\u0011\u0015)1\u0001\u0002\u0003\t\u000e1\u0001QA\u0001C\u0001\u0011\u001f)1\u0001\u0002\u0004\t\u000f1\u0001QA\u0001\u0003\u0005\u0011\u001b)1\u0001\u0002\u0003\t\u00121\u0001QA\u0001C\u0003\u0011+)1\u0001\u0002\u0005\t\u00151\u0001QA\u0001C\u0003\u0011-)1\u0001B\u0005\t\u00181\u0001Q!\u0001E\u0002\u000b\r!!\u0002\u0003\u0007\r\u0001\u0015\u0011A\u0001\u0003\u0005\u000b\u000b\t!\u0011\u0002c\u0006\u0005\u00071\u0011\u0011dA\u0003\u0002\u0011\u000fA:!,\b\u0005C\u0012Ab!i\u0003\u0006\u0003!-\u00014B)\u0004\u0003\u00115Qk\u0001\u0003\u0006\u0007\u00111\u0011\"\u0001\u0005\b[3\"1\"\u0005\u0004\u0005\u0001!AQcA\u0003\u0002\u0011\u001fAz\u0001G\u0005\u001e\u001c\u0011\u0001\u00012C\u0007\n\u000b\u0005A\t\"C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001A\n\u0002U\u0002\u0001;\u001f!\u0001\u0001C\u0006\u000e\u0007\u0015\t\u00012\u0003M\n!\u000e\u0005\u0011eA\u0003\u0002\u0011+A*\"U\u0002\b\t%I\u0011\u0001\u0002\u0001\u000e\u0003!YQ\"\u0001E\f[\u0007\"\u0011\u0001'\u0007\u001e\u0010\u0011\u0001\u0001bC\u0007\u0004\u000b\u0005A\u0019\u0002g\u0005Q\u0007\u0001i\u001a\u0002\u0002\u0001\t\u00145)Q!\u0001E\t\u0013\u0005!\u0019\u0001'\u0005Q\u0007\u0003\t3!B\u0001\t\u0016aU\u0011kA\u0004\u0005\u001a%\tA\u0001A\u0007\u0002\u0011/i\u0011\u0001C\u00066.\u0015-Ba9\u0001\u0019\tu=A\u0001\u0001E\u0005\u001b\r)\u0011\u0001#\u0003\u0019\nA\u001b\u0001!I\u0002\u0006\u0003!\u0011\u0001DA)\u0004\u000b\u0011!\u0011\"\u0001\u0003\u0001\u001b\u0005AQ\u0001"})
public final class ConstructorHeaderCallChecker
implements CallChecker {
    public static final /* synthetic */ KClass $kotlinClass;
    private final ClassDescriptor containingClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(ConstructorHeaderCallChecker.class);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        JetElement callElement;
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (resolvedCall.getStatus().isSuccess()) {
            BindingContext bindingContext = context.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.getBindingContext()");
            if (ResolvedCallUtilKt.hasImplicitThisOrSuperDispatchReceiver(resolvedCall, bindingContext) && Intrinsics.areEqual(this.containingClass, DescriptorUtilsKt.getOwnerForEffectiveDispatchReceiverParameter(resolvedCall.getResultingDescriptor()))) {
                this.reportError(context, resolvedCall);
                return;
            }
        }
        if (!((callElement = resolvedCall.getCall().getCallElement()) instanceof JetInstanceExpressionWithLabel)) return;
        DeclarationDescriptor descriptor2 = (DeclarationDescriptor)context.trace.get(BindingContext.REFERENCE_TARGET, ((JetInstanceExpressionWithLabel)callElement).getInstanceReference());
        if (!Intrinsics.areEqual(this.containingClass, descriptor2)) return;
        this.reportError(context, resolvedCall);
    }

    private final void reportError(BasicCallResolutionContext context, ResolvedCall<?> resolvedCall) {
        context.trace.report(Errors.INSTANCE_ACCESS_BEFORE_SUPER_CALL.on(context.call.getCalleeExpression(), (DeclarationDescriptor)resolvedCall.getResultingDescriptor()));
    }

    public ConstructorHeaderCallChecker(@NotNull ConstructorDescriptor constructor) {
        Intrinsics.checkParameterIsNotNull(constructor, "constructor");
        this.containingClass = constructor.getContainingDeclaration();
    }
}

