/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.org.jdom;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.kotlin.relocated.org.jdom.Content;
import org.jetbrains.kotlin.relocated.org.jdom.IllegalDataException;
import org.jetbrains.kotlin.relocated.org.jdom.IllegalTargetException;
import org.jetbrains.kotlin.relocated.org.jdom.Verifier;
import org.jetbrains.kotlin.relocated.org.jdom.output.XMLOutputter;

public class ProcessingInstruction
extends Content {
    protected String target;
    protected String rawData;
    protected Map mapData;

    protected ProcessingInstruction() {
    }

    public ProcessingInstruction(String target, String data2) {
        this.setTarget(target);
        this.setData(data2);
    }

    public ProcessingInstruction setTarget(String newTarget) {
        String reason = Verifier.checkProcessingInstructionTarget(newTarget);
        if (reason != null) {
            throw new IllegalTargetException(newTarget, reason);
        }
        this.target = newTarget;
        return this;
    }

    @Override
    public String getValue() {
        return this.rawData;
    }

    public String getTarget() {
        return this.target;
    }

    public String getData() {
        return this.rawData;
    }

    public ProcessingInstruction setData(String data2) {
        String reason = Verifier.checkProcessingInstructionData(data2);
        if (reason != null) {
            throw new IllegalDataException(data2, reason);
        }
        this.rawData = data2;
        this.mapData = this.parseData(data2);
        return this;
    }

    private Map parseData(String rawData) {
        HashMap<String, String> data2 = new HashMap<String, String>();
        String inputData = rawData.trim();
        while (!inputData.trim().equals("")) {
            int pos;
            String name = "";
            String value = "";
            int startName = 0;
            char previousChar = inputData.charAt(startName);
            for (pos = 1; pos < inputData.length(); ++pos) {
                char currentChar = inputData.charAt(pos);
                if (currentChar == '=') {
                    name = inputData.substring(startName, pos).trim();
                    int[] bounds = ProcessingInstruction.extractQuotedString(inputData.substring(pos + 1));
                    if (bounds == null) {
                        return new HashMap();
                    }
                    value = inputData.substring(bounds[0] + pos + 1, bounds[1] + pos + 1);
                    pos += bounds[1] + 1;
                    break;
                }
                if (Character.isWhitespace(previousChar) && !Character.isWhitespace(currentChar)) {
                    startName = pos;
                }
                previousChar = currentChar;
            }
            inputData = inputData.substring(pos);
            if (name.length() <= 0 || value == null) continue;
            data2.put(name, value);
        }
        return data2;
    }

    private static int[] extractQuotedString(String rawData) {
        boolean inQuotes = false;
        char quoteChar = '\"';
        int start = 0;
        for (int pos = 0; pos < rawData.length(); ++pos) {
            char currentChar = rawData.charAt(pos);
            if (currentChar != '\"' && currentChar != '\'') continue;
            if (!inQuotes) {
                quoteChar = currentChar;
                inQuotes = true;
                start = pos + 1;
                continue;
            }
            if (quoteChar != currentChar) continue;
            inQuotes = false;
            return new int[]{start, pos};
        }
        return null;
    }

    public String toString() {
        return new StringBuffer().append("[ProcessingInstruction: ").append(new XMLOutputter().outputString(this)).append("]").toString();
    }

    @Override
    public Content clone() {
        ProcessingInstruction pi = (ProcessingInstruction)super.clone();
        if (this.mapData != null) {
            pi.mapData = this.parseData(this.rawData);
        }
        return pi;
    }
}

