/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetAnnotation;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetExpressionImpl;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierPackage;
import org.jetbrains.kotlin.psi.findDocComment.FindDocCommentPackage;

abstract class JetDeclarationImpl
extends JetExpressionImpl
implements JetDeclaration {
    public JetDeclarationImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetDeclarationImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @Nullable
    public JetModifierList getModifierList() {
        return (JetModifierList)this.findChildByType(JetNodeTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifier(@NotNull JetModifierKeywordToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/kotlin/psi/JetDeclarationImpl", "hasModifier"));
        }
        JetModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifier(modifier);
    }

    @Override
    public void addModifier(@NotNull JetModifierKeywordToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/kotlin/psi/JetDeclarationImpl", "addModifier"));
        }
        AddRemoveModifierPackage.addModifier(this, modifier, JetTokens.DEFAULT_VISIBILITY_KEYWORD);
    }

    @Override
    public void removeModifier(@NotNull JetModifierKeywordToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/kotlin/psi/JetDeclarationImpl", "removeModifier"));
        }
        AddRemoveModifierPackage.removeModifier(this, modifier);
    }

    @Override
    @NotNull
    public JetAnnotationEntry addAnnotationEntry(@NotNull JetAnnotationEntry annotationEntry) {
        if (annotationEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationEntry", "org/jetbrains/kotlin/psi/JetDeclarationImpl", "addAnnotationEntry"));
        }
        JetAnnotationEntry jetAnnotationEntry = AddRemoveModifierPackage.addAnnotationEntry(this, annotationEntry);
        if (jetAnnotationEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetDeclarationImpl", "addAnnotationEntry"));
        }
        return jetAnnotationEntry;
    }

    @Override
    @NotNull
    public List<JetAnnotationEntry> getAnnotationEntries() {
        JetModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            List<JetAnnotationEntry> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetDeclarationImpl", "getAnnotationEntries"));
            }
            return list;
        }
        List<JetAnnotationEntry> list = modifierList.getAnnotationEntries();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetDeclarationImpl", "getAnnotationEntries"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<JetAnnotation> getAnnotations() {
        JetModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            List<JetAnnotation> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetDeclarationImpl", "getAnnotations"));
            }
            return list;
        }
        List<JetAnnotation> list = modifierList.getAnnotations();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetDeclarationImpl", "getAnnotations"));
        }
        return list;
    }

    @Override
    @Nullable
    public KDoc getDocComment() {
        return FindDocCommentPackage.findDocComment(this);
    }
}

