/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.ArrayAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.CachedAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.QualifiedExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;

public final class AccessTranslationUtils {
    private AccessTranslationUtils() {
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull JetExpression referenceExpression, @NotNull TranslationContext context) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        AccessTranslator accessTranslator = AccessTranslationUtils.getAccessTranslator(referenceExpression, context, false);
        if (accessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        return accessTranslator;
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull JetExpression referenceExpression, @NotNull TranslationContext context, boolean forceOrderOfEvaluation) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        assert (referenceExpression instanceof JetReferenceExpression || referenceExpression instanceof JetQualifiedExpression);
        if (referenceExpression instanceof JetQualifiedExpression) {
            AccessTranslator accessTranslator = QualifiedExpressionTranslator.getAccessTranslator((JetQualifiedExpression)referenceExpression, context, forceOrderOfEvaluation);
            if (accessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
            }
            return accessTranslator;
        }
        if (referenceExpression instanceof JetSimpleNameExpression) {
            AccessTranslator accessTranslator = ReferenceTranslator.getAccessTranslator((JetSimpleNameExpression)referenceExpression, context);
            if (accessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
            }
            return accessTranslator;
        }
        assert (referenceExpression instanceof JetArrayAccessExpression);
        AccessTranslator accessTranslator = AccessTranslationUtils.getArrayAccessTranslator((JetArrayAccessExpression)referenceExpression, context, forceOrderOfEvaluation);
        if (accessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        return accessTranslator;
    }

    @NotNull
    private static AccessTranslator getArrayAccessTranslator(@NotNull JetArrayAccessExpression expression, @NotNull TranslationContext context, boolean forceOrderOfEvaluation) {
        TranslationContext accessArrayContext;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getArrayAccessTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getArrayAccessTranslator"));
        }
        if (forceOrderOfEvaluation) {
            LinkedHashMap<JetExpression, JsExpression> indexesMap = new LinkedHashMap<JetExpression, JsExpression>();
            for (JetExpression indexExpression : expression.getIndexExpressions()) {
                JsExpression jsIndexExpression = Translation.translateAsExpression(indexExpression, context);
                if (TranslationUtils.isCacheNeeded(jsIndexExpression)) {
                    TemporaryVariable temporaryVariable = context.declareTemporary(null);
                    context.addStatementToCurrentBlock(JsAstUtils.assignment(temporaryVariable.reference(), jsIndexExpression).makeStmt());
                    jsIndexExpression = temporaryVariable.reference();
                }
                indexesMap.put(indexExpression, jsIndexExpression);
            }
            accessArrayContext = context.innerContextWithAliasesForExpressions(indexesMap);
        } else {
            accessArrayContext = context;
        }
        ArrayAccessTranslator arrayAccessTranslator = ArrayAccessTranslator.newInstance(expression, accessArrayContext);
        if (arrayAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getArrayAccessTranslator"));
        }
        return arrayAccessTranslator;
    }

    @NotNull
    public static CachedAccessTranslator getCachedAccessTranslator(@NotNull JetExpression referenceExpression, @NotNull TranslationContext context) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getCachedAccessTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getCachedAccessTranslator"));
        }
        CachedAccessTranslator cachedAccessTranslator = AccessTranslationUtils.getAccessTranslator(referenceExpression, context).getCached();
        if (cachedAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "getCachedAccessTranslator"));
        }
        return cachedAccessTranslator;
    }

    @NotNull
    public static JsExpression translateAsGet(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "translateAsGet"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "translateAsGet"));
        }
        JsExpression jsExpression = AccessTranslationUtils.getAccessTranslator(expression, context).translateAsGet();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils", "translateAsGet"));
        }
        return jsExpression;
    }
}

