/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.Collection;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.HasName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"B\u0006)\u0011r-\u001a;DC2dWM])vC2Lg-[3s\u0015)IgN^8dCRLwN\u001c\u0006\r\u0015NLeN^8dCRLwN\u001c\u0006\u0004G>l'BB4p_\u001edWM\u0003\u0003eCJ$(\u0002C2p[BLG.\u001a:\u000b\u000f\t\f7m[3oI*\u0011!n\u001d\u0006\u0004CN$(\u0002\u0004&t\u000bb\u0004(/Z:tS>t'\"E%om>\u001c\u0017\r^5p]V#\u0018\u000e\\:Li*1r-\u001a;DC2dWM])vC2Lg-[3s\u00136\u0004HN\u0003\bhKR\u001c\u0016.\u001c9mK&#WM\u001c;\u000b\t\r\fG\u000e\u001c\u0006\u0007'R\u0014\u0018N\\4\u000b\r-|G\u000f\\5o\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u000eO\u0016$8+[7qY\u0016t\u0015-\\3\u000b\r)\u001bh*Y7f\u001519W\r^*uCRL7MU3g\u0015\u0019Q5OT8eK*\u0011\u0002.Y:DC2dWM])vC2Lg-[3s\u0015\u001d\u0011un\u001c7fC:T\u0001#[:DC2d\u0017J\u001c<pG\u0006$\u0018n\u001c8\u000b7%\u001ch)\u001e8di&|gn\u0011:fCR|'/\u00138w_\u000e\fG/[8o\t\u0007Q!\u0001E\u0002\u000b\t!\u0001\u0001\u0003\u0002\u0006\u0005\u0011\u0005\u0001RA\u0003\u0003\t\u0005A1!\u0002\u0002\u0005\u0004!\u001dQA\u0001\u0003\u0003\u0011\u0011)!\u0001\"\u0002\t\n\u0015\u0019Aa\u0001\u0005\u0002\u0019\u0001)1\u0001B\u0002\t\u000b1\u0001QA\u0001\u0003\u0004\u0011\u0015)!\u0001B\u0002\t\u0003\u0015\t\u0001\u0002C\u0003\u0004\t\u0017Ay\u0001\u0004\u0001\u0006\u0003!EQA\u0001C\u0007\u0011%)!\u0001B\u0004\t\u0010\u0015\u0019Aa\u0001\u0005\u000b\u0019\u0001)!\u0001B\u0002\t\u0015\u0015\u0019Aa\u0001\u0005\f\u0019\u0001)!\u0001B\u0002\t\u0017\u0015\u0019A1\u0002\u0005\r\u0019\u0001)i\u0003B\u0002\u0019\u0001u=A\u0001\u0001E\u0001\u001b\r)\u0011\u0001c\u0002\u0019\bA\u001b\u0001!I\u0002\u0006\u0003!!\u0001\u0004B)\u0004\u000b\u0011\u0001\u0011\"\u0001E\u0005\u001b\u0005AQ\u0001WB\u0006\u000b_!\u0011\u0001\u0007\u0004\u001e\u0010\u0011\u0001\u0001\u0012A\u0007\u0004\u000b\u0005A9\u0001g\u0002Q\u0007\u0001\tC!B\u0001\t\t1\u0005\u0001\u0004B)\u0004\u000b\u00111\u0011\"\u0001E\u0005\u001b\u0005AQ\u0001WB\u0006\u000b_!1\u0001'\u0004\u001e\u0010\u0011\u0001\u0001bB\u0007\u0004\u000b\u0005A9\u0001g\u0002Q\u0007\u0001\tC!B\u0001\t\r1\u0005\u0001DB)\u0004\u000b\u00115\u0011\"\u0001E\b\u001b\u0005AQ\u0001WB\u0006\u000b_!1\u0001g\u0005\u001e\u0010\u0011\u0001\u0001bB\u0007\u0004\u000b\u0005A9\u0001g\u0002Q\u0007\u0001\tC!B\u0001\t\u00111\u0005\u0001\u0004C)\u0004\u000b\u0011M\u0011\"\u0001E\t\u001b\u0005AQ\u0001WB\u0006\u000b_!\u0011\u0001'\u0006\u001e\u0010\u0011\u0001\u0001\u0012A\u0007\u0004\u000b\u0005A9\u0001g\u0002Q\u0007\u0001\tC!B\u0001\t\u00131\u0005\u0001$C)\u0004\u000b\u0011U\u0011\"\u0001E\n\u001b\u0005AQ\u0001WB\u0006\u000b[!1\u0001g\u0006\u001e\u0010\u0011\u0001\u0001\u0012A\u0007\u0004\u000b\u0005A9\u0001g\u0002Q\u0007\u0001\t3!B\u0001\t\u0015aQ\u0011kA\u0003\u0005\u0018%\tA\u0011A\u0007\u0002\u0011\u0015A61BC\u0017\t\rAJ\"h\u0004\u0005\u0001!\u0005QbA\u0003\u0002\u0011\u000fA:\u0001U\u0002\u0001C\r)\u0011\u0001\u0003\u0006\u0019\u0015E\u001bQ\u0001\"\u0007\n\u0003\u0011\u0005Q\"\u0001\u0005\u00061\u000e-QQ\u0006\u0003\u000415iz\u0001\u0002\u0001\t\u00025\u0019Q!\u0001E\u00041\u000f\u00016\u0001A\u0011\u0004\u000b\u0005A!\u0002\u0007\u0006R\u0007\u0015!Q\"C\u0001\u0005\u00025\t\u0001\"\u0002-\u0004\f\u0001"})
public final class InvocationUtilsKt {
    @Nullable
    public static final JsName getSimpleName(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        JsExpression qualifier = call.getQualifier();
        JsExpression jsExpression = qualifier;
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        return jsNameRef != null ? jsNameRef.getName() : null;
    }

    @Nullable
    public static final String getSimpleIdent(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        JsExpression qualifier = call.getQualifier();
        while (qualifier != null) {
            JsExpression jsExpression = qualifier;
            if (jsExpression instanceof JsInvocation) {
                JsExpression callableQualifier = qualifier;
                qualifier = ((JsInvocation)callableQualifier).getQualifier();
                if (!InvocationUtilsKt.isCallInvocation((JsInvocation)callableQualifier)) continue;
                JsExpression jsExpression2 = qualifier;
                if (!(jsExpression2 instanceof JsNameRef)) {
                    jsExpression2 = null;
                }
                JsNameRef jsNameRef = (JsNameRef)jsExpression2;
                qualifier = jsNameRef != null ? jsNameRef.getQualifier() : null;
                continue;
            }
            if (!(jsExpression instanceof HasName)) break;
            JsName jsName = ((HasName)((Object)qualifier)).getName();
            return jsName != null ? jsName.getIdent() : null;
        }
        return null;
    }

    public static final boolean isFunctionCreatorInvocation(@NotNull JsInvocation invocation) {
        JsNode staticRef;
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        JsNode jsNode = staticRef = InvocationUtilsKt.getStaticRef(invocation);
        return jsNode instanceof JsFunction ? FunctionUtilsKt.isFunctionCreator((JsFunction)staticRef) : false;
    }

    public static final boolean isCallInvocation(@NotNull JsInvocation invocation) {
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        JsExpression jsExpression = invocation.getQualifier();
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef qualifier = (JsNameRef)jsExpression;
        List<JsExpression> arguments2 = invocation.getArguments();
        JsNameRef jsNameRef = qualifier;
        return Intrinsics.areEqual(jsNameRef != null ? jsNameRef.getIdent() : null, Namer.CALL_FUNCTION) && KotlinPackage.isNotEmpty((Collection)arguments2);
    }

    public static final boolean hasCallerQualifier(@NotNull JsInvocation invocation) {
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        return InvocationUtilsKt.getCallerQualifierImpl(invocation) != null;
    }

    @NotNull
    public static final JsExpression getCallerQualifier(@NotNull JsInvocation invocation) {
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        JsExpression jsExpression = InvocationUtilsKt.getCallerQualifierImpl(invocation);
        if (jsExpression == null) {
            throw (Throwable)((Object)new AssertionError((Object)"must check hasQualifier() before calling getQualifier"));
        }
        return jsExpression;
    }

    @Nullable
    public static final JsExpression getCallerQualifierImpl(@NotNull JsInvocation invocation) {
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        JsExpression jsExpression = invocation.getQualifier();
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        return jsNameRef != null ? jsNameRef.getQualifier() : null;
    }

    @Nullable
    public static final JsNode getStaticRef(@NotNull JsInvocation invocation) {
        JsName qualifierName;
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        JsExpression qualifier = invocation.getQualifier();
        JsExpression jsExpression = qualifier;
        if (!(jsExpression instanceof HasName)) {
            jsExpression = null;
        }
        HasName hasName = (HasName)((Object)jsExpression);
        JsName jsName = qualifierName = hasName != null ? hasName.getName() : null;
        return jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
    }
}

