/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithSource;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.JetScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.SubstitutingScope;
import kotlin.reflect.jvm.internal.impl.types.DescriptorSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.JetTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazySubstitutingClassDescriptor
implements ClassDescriptor {
    private final ClassDescriptor original;
    private final TypeSubstitutor originalSubstitutor;
    private TypeSubstitutor newSubstitutor;
    private List<TypeParameterDescriptor> typeParameters;
    private TypeConstructor typeConstructor;

    public LazySubstitutingClassDescriptor(ClassDescriptor descriptor2, TypeSubstitutor substitutor2) {
        this.original = descriptor2;
        this.originalSubstitutor = substitutor2;
    }

    private TypeSubstitutor getSubstitutor() {
        if (this.newSubstitutor == null) {
            if (this.originalSubstitutor.isEmpty()) {
                this.newSubstitutor = this.originalSubstitutor;
            } else {
                List<TypeParameterDescriptor> originalTypeParameters = this.original.getTypeConstructor().getParameters();
                this.typeParameters = new ArrayList<TypeParameterDescriptor>(originalTypeParameters.size());
                this.newSubstitutor = DescriptorSubstitutor.substituteTypeParameters(originalTypeParameters, this.originalSubstitutor.getSubstitution(), this, this.typeParameters);
            }
        }
        return this.newSubstitutor;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        TypeConstructor originalTypeConstructor = this.original.getTypeConstructor();
        if (this.originalSubstitutor.isEmpty()) {
            TypeConstructor typeConstructor2 = originalTypeConstructor;
            if (typeConstructor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getTypeConstructor"));
            }
            return typeConstructor2;
        }
        if (this.typeConstructor == null) {
            TypeSubstitutor substitutor2 = this.getSubstitutor();
            Collection<JetType> originalSupertypes = originalTypeConstructor.getSupertypes();
            ArrayList<JetType> supertypes2 = new ArrayList<JetType>(originalSupertypes.size());
            for (JetType supertype : originalSupertypes) {
                supertypes2.add(substitutor2.substitute(supertype, Variance.INVARIANT));
            }
            this.typeConstructor = TypeConstructorImpl.createForClass(this, originalTypeConstructor.getAnnotations(), originalTypeConstructor.isFinal(), originalTypeConstructor.toString(), this.typeParameters, supertypes2);
        }
        TypeConstructor typeConstructor3 = this.typeConstructor;
        if (typeConstructor3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getTypeConstructor"));
        }
        return typeConstructor3;
    }

    @Override
    @NotNull
    public JetScope getMemberScope(@NotNull List<? extends TypeProjection> typeArguments) {
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getMemberScope"));
        }
        JetScope memberScope2 = this.original.getMemberScope(typeArguments);
        if (this.originalSubstitutor.isEmpty()) {
            JetScope jetScope = memberScope2;
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getMemberScope"));
            }
            return jetScope;
        }
        SubstitutingScope substitutingScope = new SubstitutingScope(memberScope2, this.getSubstitutor());
        if (substitutingScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getMemberScope"));
        }
        return substitutingScope;
    }

    @Override
    @NotNull
    public JetScope getMemberScope(@NotNull TypeSubstitution typeSubstitution) {
        if (typeSubstitution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSubstitution", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getMemberScope"));
        }
        JetScope memberScope2 = this.original.getMemberScope(typeSubstitution);
        if (this.originalSubstitutor.isEmpty()) {
            JetScope jetScope = memberScope2;
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getMemberScope"));
            }
            return jetScope;
        }
        SubstitutingScope substitutingScope = new SubstitutingScope(memberScope2, this.getSubstitutor());
        if (substitutingScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getMemberScope"));
        }
        return substitutingScope;
    }

    @Override
    @NotNull
    public JetScope getUnsubstitutedMemberScope() {
        JetScope memberScope2 = this.original.getUnsubstitutedMemberScope();
        if (this.originalSubstitutor.isEmpty()) {
            JetScope jetScope = memberScope2;
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getUnsubstitutedMemberScope"));
            }
            return jetScope;
        }
        SubstitutingScope substitutingScope = new SubstitutingScope(memberScope2, this.getSubstitutor());
        if (substitutingScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getUnsubstitutedMemberScope"));
        }
        return substitutingScope;
    }

    @Override
    @NotNull
    public JetScope getStaticScope() {
        JetScope jetScope = this.original.getStaticScope();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getStaticScope"));
        }
        return jetScope;
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        List<TypeProjection> typeProjections = TypeUtils.getDefaultTypeProjections(this.getTypeConstructor().getParameters());
        JetTypeImpl jetTypeImpl = JetTypeImpl.create(this.getAnnotations(), this, false, typeProjections);
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getDefaultType"));
        }
        return jetTypeImpl;
    }

    @Override
    @NotNull
    public ReceiverParameterDescriptor getThisAsReceiverParameter() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        Collection<ConstructorDescriptor> originalConstructors = this.original.getConstructors();
        ArrayList<ConstructorDescriptor> result2 = new ArrayList<ConstructorDescriptor>(originalConstructors.size());
        for (ConstructorDescriptor constructor : originalConstructors) {
            result2.add((ConstructorDescriptor)constructor.substitute(this.getSubstitutor()));
        }
        ArrayList<ConstructorDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getConstructors"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations2 = this.original.getAnnotations();
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getAnnotations"));
        }
        return annotations2;
    }

    @Override
    @NotNull
    public Name getName() {
        Name name = this.original.getName();
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getName"));
        }
        return name;
    }

    @Override
    @NotNull
    public DeclarationDescriptorWithSource getOriginal() {
        DeclarationDescriptorWithSource declarationDescriptorWithSource = this.original.getOriginal();
        if (declarationDescriptorWithSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getOriginal"));
        }
        return declarationDescriptorWithSource;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = this.original.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @Override
    @NotNull
    public ClassDescriptor substitute(@NotNull TypeSubstitutor substitutor2) {
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "substitute"));
        }
        if (substitutor2.isEmpty()) {
            LazySubstitutingClassDescriptor lazySubstitutingClassDescriptor = this;
            if (lazySubstitutingClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "substitute"));
            }
            return lazySubstitutingClassDescriptor;
        }
        LazySubstitutingClassDescriptor lazySubstitutingClassDescriptor = new LazySubstitutingClassDescriptor(this, TypeSubstitutor.createChainedSubstitutor(substitutor2.getSubstitution(), this.getSubstitutor().getSubstitution()));
        if (lazySubstitutingClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "substitute"));
        }
        return lazySubstitutingClassDescriptor;
    }

    @Override
    public ClassDescriptor getCompanionObjectDescriptor() {
        return this.original.getCompanionObjectDescriptor();
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = this.original.getKind();
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getKind"));
        }
        return classKind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.original.getModality();
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.original.getVisibility();
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isInner() {
        return this.original.isInner();
    }

    @Override
    public boolean isCompanionObject() {
        return this.original.isCompanionObject();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
        return visitor2.visitClassDescriptor(this, data2);
    }

    @Override
    public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public JetScope getUnsubstitutedInnerClassesScope() {
        JetScope jetScope = this.original.getUnsubstitutedInnerClassesScope();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getUnsubstitutedInnerClassesScope"));
        }
        return jetScope;
    }

    @Override
    @Nullable
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.original.getUnsubstitutedPrimaryConstructor();
    }

    @Override
    @NotNull
    public SourceElement getSource() {
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        if (sourceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/LazySubstitutingClassDescriptor", "getSource"));
        }
        return sourceElement;
    }
}

