/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.ThreadLocalCachedByteArray;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.iq80.snappy.Snappy;
import org.jetbrains.annotations.NotNull;

public class CompressionUtil {
    private static final ThreadLocalCachedByteArray spareBufferLocal = new ThreadLocalCachedByteArray();
    private static final AtomicInteger myCompressionRequests = new AtomicInteger();
    private static final AtomicLong myCompressionTime = new AtomicLong();
    private static final AtomicInteger myDecompressionRequests = new AtomicInteger();
    private static final AtomicLong myDecompressionTime = new AtomicLong();
    private static final AtomicLong myDecompressedSize = new AtomicLong();
    private static final AtomicLong mySizeBeforeCompression = new AtomicLong();
    private static final AtomicLong mySizeAfterCompression = new AtomicLong();
    public static final boolean DUMP_COMPRESSION_STATS = SystemProperties.getBooleanProperty("idea.dump.compression.stats", false);

    public static int writeCompressedWithoutOriginalBufferLength(@NotNull DataOutput out, @NotNull byte[] bytes, int length) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/CompressionUtil", "writeCompressedWithoutOriginalBufferLength"));
        }
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/util/CompressionUtil", "writeCompressedWithoutOriginalBufferLength"));
        }
        long started = System.nanoTime();
        byte[] compressedOutputBuffer = spareBufferLocal.getBuffer(Snappy.maxCompressedLength(length));
        int compressedSize = Snappy.compress(bytes, 0, length, compressedOutputBuffer, 0);
        long time = System.nanoTime() - started;
        mySizeAfterCompression.addAndGet(compressedSize);
        mySizeBeforeCompression.addAndGet(length);
        int requests = myCompressionRequests.incrementAndGet();
        long l = myCompressionTime.addAndGet(time);
        if (DUMP_COMPRESSION_STATS && requests % 1000 == 0) {
            System.out.println("Compressed " + requests + " times, size:" + mySizeBeforeCompression + "->" + mySizeAfterCompression + " for " + l / 1000000L + "ms");
        }
        DataInputOutputUtil.writeINT(out, compressedSize);
        out.write(compressedOutputBuffer, 0, compressedSize);
        return compressedSize;
    }
}

