/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.tree.IElementType;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetAnnotatedExpression;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDoWhileExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetLabeledExpression;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetTypedef;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.JetWhileExpression;
import org.jetbrains.kotlin.relocated.com.google.common.base.Function;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.utils.UtilsPackage;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingVisitor;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitor;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.PatternMatchingTypingVisitor;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage;

public class ExpressionTypingVisitorForStatements
extends ExpressionTypingVisitor {
    private final LexicalWritableScope scope;
    private final BasicExpressionTypingVisitor basic;
    private final ControlStructureTypingVisitor controlStructures;
    private final PatternMatchingTypingVisitor patterns;
    private final FunctionsTypingVisitor functions;

    public ExpressionTypingVisitorForStatements(@NotNull ExpressionTypingInternals facade, @NotNull LexicalWritableScope scope2, @NotNull BasicExpressionTypingVisitor basic, @NotNull ControlStructureTypingVisitor controlStructures, @NotNull PatternMatchingTypingVisitor patterns, @NotNull FunctionsTypingVisitor functions2) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "<init>"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "<init>"));
        }
        if (basic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basic", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "<init>"));
        }
        if (controlStructures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controlStructures", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "<init>"));
        }
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "<init>"));
        }
        if (functions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "<init>"));
        }
        super(facade);
        this.scope = scope2;
        this.basic = basic;
        this.controlStructures = controlStructures;
        this.patterns = patterns;
        this.functions = functions2;
    }

    @Nullable
    private JetType checkAssignmentType(@Nullable JetType assignmentType, @NotNull JetBinaryExpression expression, @NotNull ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "checkAssignmentType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "checkAssignmentType"));
        }
        if (assignmentType != null && !KotlinBuiltIns.isUnit(assignmentType) && !TypeUtils.noExpectedType(context.expectedType) && !context.expectedType.isError() && TypeUtils.equalTypes(context.expectedType, assignmentType)) {
            context.trace.report(Errors.ASSIGNMENT_TYPE_MISMATCH.on(expression, context.expectedType));
            return null;
        }
        return this.components.dataFlowAnalyzer.checkStatementType(expression, context);
    }

    @Override
    public JetTypeInfo visitObjectDeclaration(@NotNull JetObjectDeclaration declaration, ExpressionTypingContext context) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitObjectDeclaration"));
        }
        this.components.localClassifierAnalyzer.processClassOrObject(this.scope, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(this.scope)).replaceContextDependency(ContextDependency.INDEPENDENT), this.scope.getOwnerDescriptor(), declaration);
        return TypeInfoFactoryPackage.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(declaration, context), context);
    }

    @Override
    public JetTypeInfo visitProperty(@NotNull JetProperty property, ExpressionTypingContext typingContext) {
        JetTypeInfo typeInfo;
        JetExpression delegateExpression;
        JetPropertyAccessor setter2;
        JetPropertyAccessor getter2;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitProperty"));
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)typingContext.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceScope(this.scope);
        JetTypeReference receiverTypeRef = property.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            context.trace.report(Errors.LOCAL_EXTENSION_PROPERTY.on(receiverTypeRef));
        }
        if ((getter2 = property.getGetter()) != null) {
            context.trace.report(Errors.LOCAL_VARIABLE_WITH_GETTER.on(getter2));
        }
        if ((setter2 = property.getSetter()) != null) {
            context.trace.report(Errors.LOCAL_VARIABLE_WITH_SETTER.on(setter2));
        }
        if ((delegateExpression = property.getDelegateExpression()) != null) {
            this.components.expressionTypingServices.getTypeInfo(delegateExpression, context);
            context.trace.report(Errors.LOCAL_VARIABLE_WITH_DELEGATE.on(property.getDelegate()));
        }
        for (JetTypeParameter typeParameter : property.getTypeParameters()) {
            AnnotationResolver.reportUnsupportedAnnotationForTypeParameter(typeParameter, context.trace);
        }
        VariableDescriptor propertyDescriptor = this.components.descriptorResolver.resolveLocalVariableDescriptor(this.scope, property, context.dataFlowInfo, context.trace);
        JetExpression initializer = property.getInitializer();
        if (initializer != null) {
            JetType outType = propertyDescriptor.getType();
            typeInfo = this.facade.getTypeInfo(initializer, (ExpressionTypingContext)context.replaceExpectedType(outType));
            DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
            JetType type2 = typeInfo.getType();
            if (property.getTypeReference() == null && type2 != null) {
                DataFlowValue variableDataFlowValue = DataFlowValueFactory.createDataFlowValue(propertyDescriptor, context.trace.getBindingContext(), DescriptorUtils.getContainingModuleOrNull(this.scope.getOwnerDescriptor()));
                DataFlowValue initializerDataFlowValue = DataFlowValueFactory.createDataFlowValue(initializer, type2, context);
                typeInfo = typeInfo.replaceDataFlowInfo(dataFlowInfo.assign(variableDataFlowValue, initializerDataFlowValue));
            }
        } else {
            typeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
        }
        VariableDescriptor olderVariable = UtilsPackage.getLocalVariable(this.scope, propertyDescriptor.getName());
        ExpressionTypingUtils.checkVariableShadowing(context, propertyDescriptor, olderVariable);
        this.scope.addVariableDescriptor(propertyDescriptor);
        this.components.modifiersChecker.withTrace(context.trace).checkModifiersForLocalDeclaration(property, propertyDescriptor);
        return typeInfo.replaceType(this.components.dataFlowAnalyzer.checkStatementType(property, context));
    }

    @Override
    public JetTypeInfo visitMultiDeclaration(@NotNull JetMultiDeclaration multiDeclaration, ExpressionTypingContext context) {
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitMultiDeclaration"));
        }
        this.components.annotationResolver.resolveAnnotationsWithArguments((LexicalScope)this.scope, multiDeclaration.getModifierList(), context.trace);
        JetExpression initializer = multiDeclaration.getInitializer();
        if (initializer == null) {
            context.trace.report(Errors.INITIALIZER_REQUIRED_FOR_MULTIDECLARATION.on(multiDeclaration));
            return TypeInfoFactoryPackage.noTypeInfo(context);
        }
        ExpressionReceiver expressionReceiver = ExpressionTypingUtils.getExpressionReceiver(this.facade, initializer, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        JetTypeInfo typeInfo = this.facade.getTypeInfo(initializer, context);
        if (expressionReceiver == null) {
            return TypeInfoFactoryPackage.noTypeInfo(context);
        }
        this.components.multiDeclarationResolver.defineLocalVariablesFromMultiDeclaration(this.scope, multiDeclaration, expressionReceiver, initializer, context);
        return typeInfo.replaceType(this.components.dataFlowAnalyzer.checkStatementType(multiDeclaration, context));
    }

    @Override
    public JetTypeInfo visitNamedFunction(@NotNull JetNamedFunction function, ExpressionTypingContext context) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitNamedFunction"));
        }
        return this.functions.visitNamedFunction(function, context, true, this.scope);
    }

    @Override
    public JetTypeInfo visitClass(@NotNull JetClass klass, ExpressionTypingContext context) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitClass"));
        }
        this.components.localClassifierAnalyzer.processClassOrObject(this.scope, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(this.scope)).replaceContextDependency(ContextDependency.INDEPENDENT), this.scope.getOwnerDescriptor(), klass);
        return TypeInfoFactoryPackage.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(klass, context), context);
    }

    @Override
    public JetTypeInfo visitTypedef(@NotNull JetTypedef typedef, ExpressionTypingContext context) {
        if (typedef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typedef", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitTypedef"));
        }
        context.trace.report(Errors.UNSUPPORTED.on(typedef, "Typedefs are not supported"));
        return (JetTypeInfo)super.visitTypedef(typedef, context);
    }

    @Override
    public JetTypeInfo visitDeclaration(@NotNull JetDeclaration dcl, ExpressionTypingContext context) {
        if (dcl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dcl", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitDeclaration"));
        }
        return TypeInfoFactoryPackage.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(dcl, context), context);
    }

    @Override
    public JetTypeInfo visitBinaryExpression(@NotNull JetBinaryExpression expression, ExpressionTypingContext context) {
        JetTypeInfo result2;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitBinaryExpression"));
        }
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == JetTokens.EQ) {
            result2 = this.visitAssignment(expression, context);
        } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType)) {
            result2 = this.visitAssignmentOperation(expression, context);
        } else {
            return this.facade.getTypeInfo(expression, context);
        }
        return this.components.dataFlowAnalyzer.checkType(result2, (JetExpression)expression, (ResolutionContext)context);
    }

    @NotNull
    protected JetTypeInfo visitAssignmentOperation(JetBinaryExpression expression, ExpressionTypingContext contextWithExpectedType) {
        JetType binaryOperationType;
        OverloadResolutionResults<Object> binaryOperationDescriptors;
        JetExpression left;
        TemporaryTraceAndCache temporary = TemporaryTraceAndCache.create(contextWithExpectedType, "trace to resolve array set method for binary expression", expression);
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceTraceAndCache(temporary)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        JetExpression leftOperand = expression.getLeft();
        JetTypeInfo leftInfo = ExpressionTypingUtils.getTypeInfoOrNullType(leftOperand, context, this.facade);
        JetType leftType = leftInfo.getType();
        JetExpression right = expression.getRight();
        JetExpression jetExpression = left = leftOperand == null ? null : JetPsiUtil.deparenthesize(leftOperand);
        if (right == null || left == null) {
            temporary.commit();
            JetTypeInfo jetTypeInfo = leftInfo.clearType();
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignmentOperation"));
            }
            return jetTypeInfo;
        }
        if (leftType == null) {
            JetTypeInfo rightInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)context.replaceDataFlowInfo(leftInfo.getDataFlowInfo()));
            context.trace.report(Errors.UNRESOLVED_REFERENCE.on(operationSign, operationSign));
            temporary.commit();
            JetTypeInfo jetTypeInfo = rightInfo.clearType();
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignmentOperation"));
            }
            return jetTypeInfo;
        }
        ExpressionReceiver receiver = new ExpressionReceiver(left, leftType);
        Name name = (Name)OperatorConventions.ASSIGNMENT_OPERATIONS.get(operationType);
        TemporaryTraceAndCache temporaryForAssignmentOperation = TemporaryTraceAndCache.create(context, "trace to check assignment operation like '+=' for", expression);
        OverloadResolutionResults<FunctionDescriptor> assignmentOperationDescriptors = this.components.callResolver.resolveBinaryCall((ExpressionTypingContext)((ExpressionTypingContext)context.replaceTraceAndCache(temporaryForAssignmentOperation)).replaceScope(this.scope), receiver, expression, name);
        JetType assignmentOperationType = OverloadResolutionResultsUtil.getResultingType(assignmentOperationDescriptors, context.contextDependency);
        TemporaryTraceAndCache temporaryForBinaryOperation = TemporaryTraceAndCache.create(context, "trace to check binary operation like '+' for", expression);
        TemporaryBindingTrace ignoreReportsTrace = TemporaryBindingTrace.create(context.trace, "Trace for checking assignability");
        boolean lhsAssignable = this.basic.checkLValue(ignoreReportsTrace, context, left, right);
        if (assignmentOperationType == null || lhsAssignable) {
            Name counterpartName = (Name)OperatorConventions.BINARY_OPERATION_NAMES.get(OperatorConventions.ASSIGNMENT_OPERATION_COUNTERPARTS.get(operationType));
            binaryOperationDescriptors = this.components.callResolver.resolveBinaryCall((ExpressionTypingContext)((ExpressionTypingContext)context.replaceTraceAndCache(temporaryForBinaryOperation)).replaceScope(this.scope), receiver, expression, counterpartName);
            binaryOperationType = OverloadResolutionResultsUtil.getResultingType(binaryOperationDescriptors, context.contextDependency);
        } else {
            binaryOperationDescriptors = OverloadResolutionResultsImpl.nameNotFound();
            binaryOperationType = null;
        }
        JetType type2 = assignmentOperationType != null ? assignmentOperationType : binaryOperationType;
        JetTypeInfo rightInfo = leftInfo;
        if (assignmentOperationDescriptors.isSuccess() && binaryOperationDescriptors.isSuccess()) {
            OverloadResolutionResults<FunctionDescriptor> ambiguityResolutionResults = OverloadResolutionResultsUtil.ambiguity(assignmentOperationDescriptors, binaryOperationDescriptors);
            context.trace.report(Errors.ASSIGN_OPERATOR_AMBIGUITY.on(operationSign, ambiguityResolutionResults.getResultingCalls()));
            HashSet<FunctionDescriptor> descriptors = Sets.newHashSet();
            for (ResolvedCall<FunctionDescriptor> resolvedCall : ambiguityResolutionResults.getResultingCalls()) {
                descriptors.add(resolvedCall.getResultingDescriptor());
            }
            rightInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)context.replaceDataFlowInfo(leftInfo.getDataFlowInfo()));
            context.trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, operationSign, descriptors);
        } else if (assignmentOperationType != null && (assignmentOperationDescriptors.isSuccess() || !binaryOperationDescriptors.isSuccess())) {
            temporaryForAssignmentOperation.commit();
            if (!JetTypeChecker.DEFAULT.equalTypes(this.components.builtIns.getUnitType(), assignmentOperationType)) {
                context.trace.report(Errors.ASSIGNMENT_OPERATOR_SHOULD_RETURN_UNIT.on(operationSign, assignmentOperationDescriptors.getResultingDescriptor(), operationSign));
            }
        } else {
            temporaryForBinaryOperation.commit();
            context.trace.record(BindingContext.VARIABLE_REASSIGNMENT, expression);
            if (left instanceof JetArrayAccessExpression) {
                ExpressionTypingContext contextForResolve = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(this.scope)).replaceBindingTrace(TemporaryBindingTrace.create(context.trace, "trace to resolve array set method for assignment", expression));
                this.basic.resolveArrayAccessSetMethod((JetArrayAccessExpression)left, right, contextForResolve, context.trace);
            }
            rightInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)context.replaceDataFlowInfo(leftInfo.getDataFlowInfo()));
            this.components.dataFlowAnalyzer.checkType(binaryOperationType, (JetExpression)expression, (ResolutionContext)((ExpressionTypingContext)context.replaceExpectedType(leftType)).replaceDataFlowInfo(rightInfo.getDataFlowInfo()));
            this.basic.checkLValue(context.trace, context, leftOperand, right);
        }
        temporary.commit();
        JetTypeInfo jetTypeInfo = rightInfo.replaceType(this.checkAssignmentType(type2, expression, contextWithExpectedType));
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignmentOperation"));
        }
        return jetTypeInfo;
    }

    @NotNull
    protected JetTypeInfo visitAssignment(JetBinaryExpression expression, ExpressionTypingContext contextWithExpectedType) {
        JetTypeInfo resultInfo;
        final ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceScope(this.scope)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetExpression leftOperand = expression.getLeft();
        JetExpression left = JetPsiUtil.deparenthesizeWithResolutionStrategy(leftOperand, new Function<JetTypeReference, Void>(){

            @Override
            public Void apply(JetTypeReference reference) {
                ExpressionTypingVisitorForStatements.this.components.typeResolver.resolveType(context.scope, reference, context.trace, true);
                return null;
            }
        });
        JetExpression right = expression.getRight();
        if (left instanceof JetArrayAccessExpression) {
            JetArrayAccessExpression arrayAccessExpression = (JetArrayAccessExpression)left;
            if (right == null) {
                JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
                if (jetTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignment"));
                }
                return jetTypeInfo;
            }
            JetTypeInfo typeInfo = this.basic.resolveArrayAccessSetMethod(arrayAccessExpression, right, context, context.trace);
            this.basic.checkLValue(context.trace, context, arrayAccessExpression, right);
            JetTypeInfo jetTypeInfo = typeInfo.replaceType(this.checkAssignmentType(typeInfo.getType(), expression, contextWithExpectedType));
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignment"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo leftInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
        JetType leftType = leftInfo.getType();
        DataFlowInfo dataFlowInfo = leftInfo.getDataFlowInfo();
        if (right != null) {
            resultInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo)).replaceExpectedType(leftType));
            dataFlowInfo = resultInfo.getDataFlowInfo();
            JetType rightType = resultInfo.getType();
            if (left != null && leftType != null && rightType != null) {
                DataFlowValue leftValue = DataFlowValueFactory.createDataFlowValue(left, leftType, context);
                DataFlowValue rightValue = DataFlowValueFactory.createDataFlowValue(right, rightType, context);
                resultInfo = resultInfo.replaceDataFlowInfo(dataFlowInfo.assign(leftValue, rightValue));
            }
        } else {
            resultInfo = leftInfo;
        }
        if (leftType != null && leftOperand != null) {
            this.basic.checkLValue(context.trace, context, leftOperand, right);
        }
        JetTypeInfo jetTypeInfo = resultInfo.replaceType(this.components.dataFlowAnalyzer.checkStatementType(expression, contextWithExpectedType));
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitAssignment"));
        }
        return jetTypeInfo;
    }

    @Override
    public JetTypeInfo visitExpression(@NotNull JetExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitExpression"));
        }
        return this.facade.getTypeInfo(expression, context);
    }

    @Override
    public JetTypeInfo visitJetElement(@NotNull JetElement element, ExpressionTypingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitJetElement"));
        }
        context.trace.report(Errors.UNSUPPORTED.on(element, "in a block"));
        return TypeInfoFactoryPackage.noTypeInfo(context);
    }

    @Override
    public JetTypeInfo visitWhileExpression(@NotNull JetWhileExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitWhileExpression"));
        }
        return this.controlStructures.visitWhileExpression(expression, context, true);
    }

    @Override
    public JetTypeInfo visitDoWhileExpression(@NotNull JetDoWhileExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitDoWhileExpression"));
        }
        return this.controlStructures.visitDoWhileExpression(expression, context, true);
    }

    @Override
    public JetTypeInfo visitForExpression(@NotNull JetForExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitForExpression"));
        }
        return this.controlStructures.visitForExpression(expression, context, true);
    }

    @Override
    public JetTypeInfo visitAnnotatedExpression(@NotNull JetAnnotatedExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitAnnotatedExpression"));
        }
        return this.basic.visitAnnotatedExpression(expression, data2, true);
    }

    @Override
    public JetTypeInfo visitIfExpression(@NotNull JetIfExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitIfExpression"));
        }
        return this.controlStructures.visitIfExpression(expression, context, true);
    }

    @Override
    public JetTypeInfo visitWhenExpression(@NotNull JetWhenExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitWhenExpression"));
        }
        return this.patterns.visitWhenExpression(expression, context, true);
    }

    @Override
    public JetTypeInfo visitBlockExpression(@NotNull JetBlockExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitBlockExpression"));
        }
        return this.components.expressionTypingServices.getBlockReturnedType(expression, context, true);
    }

    @Override
    public JetTypeInfo visitLabeledExpression(@NotNull JetLabeledExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorForStatements", "visitLabeledExpression"));
        }
        return this.basic.visitLabeledExpression(expression, context, true);
    }
}

