/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.WritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage;

public class ExpressionTypingUtils {
    @NotNull
    public static ReceiverValue normalizeReceiverValueForVisibility(@NotNull ReceiverValue receiverValue, @NotNull BindingContext trace) {
        if (receiverValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValue", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "normalizeReceiverValueForVisibility"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "normalizeReceiverValueForVisibility"));
        }
        if (receiverValue instanceof ExpressionReceiver) {
            DeclarationDescriptor descriptor2;
            JetExpression expression = ((ExpressionReceiver)receiverValue).getExpression();
            JetReferenceExpression referenceExpression = null;
            if (expression instanceof JetThisExpression) {
                referenceExpression = ((JetThisExpression)expression).getInstanceReference();
            } else if (expression instanceof JetConstructorDelegationReferenceExpression) {
                referenceExpression = (JetReferenceExpression)expression;
            }
            if (referenceExpression != null && (descriptor2 = trace.get(BindingContext.REFERENCE_TARGET, referenceExpression)) instanceof ClassDescriptor) {
                ClassReceiver classReceiver = new ClassReceiver((ClassDescriptor)descriptor2.getOriginal());
                if (classReceiver == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "normalizeReceiverValueForVisibility"));
                }
                return classReceiver;
            }
        }
        ReceiverValue receiverValue2 = receiverValue;
        if (receiverValue2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "normalizeReceiverValueForVisibility"));
        }
        return receiverValue2;
    }

    @Nullable
    public static ExpressionReceiver getExpressionReceiver(@NotNull JetExpression expression, @Nullable JetType type2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getExpressionReceiver"));
        }
        if (type2 == null) {
            return null;
        }
        return new ExpressionReceiver(expression, type2);
    }

    @Nullable
    public static ExpressionReceiver getExpressionReceiver(@NotNull ExpressionTypingFacade facade, @NotNull JetExpression expression, ExpressionTypingContext context) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getExpressionReceiver"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getExpressionReceiver"));
        }
        return ExpressionTypingUtils.getExpressionReceiver(expression, facade.getTypeInfo(expression, context).getType());
    }

    @NotNull
    public static ExpressionReceiver safeGetExpressionReceiver(@NotNull ExpressionTypingFacade facade, @NotNull JetExpression expression, ExpressionTypingContext context) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "safeGetExpressionReceiver"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "safeGetExpressionReceiver"));
        }
        JetType type2 = ExpressionTypingUtils.safeGetType(facade.safeGetTypeInfo(expression, context));
        ExpressionReceiver expressionReceiver = new ExpressionReceiver(expression, type2);
        if (expressionReceiver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "safeGetExpressionReceiver"));
        }
        return expressionReceiver;
    }

    @NotNull
    public static JetType safeGetType(@NotNull JetTypeInfo typeInfo) {
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "safeGetType"));
        }
        JetType type2 = typeInfo.getType();
        assert (type2 != null) : "safeGetType should be invoked on safe JetTypeInfo; safeGetTypeInfo should return @NotNull type";
        JetType jetType = type2;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "safeGetType"));
        }
        return jetType;
    }

    @NotNull
    public static LexicalWritableScope newWritableScopeImpl(ExpressionTypingContext context, @NotNull String scopeDebugName) {
        if (scopeDebugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeDebugName", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "newWritableScopeImpl"));
        }
        LexicalWritableScope scope2 = new LexicalWritableScope(context.scope, context.scope.getOwnerDescriptor(), false, null, new TraceBasedRedeclarationHandler(context.trace), scopeDebugName);
        scope2.changeLockLevel(WritableScope.LockLevel.BOTH);
        LexicalWritableScope lexicalWritableScope = scope2;
        if (lexicalWritableScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "newWritableScopeImpl"));
        }
        return lexicalWritableScope;
    }

    public static JetExpression createFakeExpressionOfType(@NotNull Project project, @NotNull BindingTrace trace, @NotNull String argumentName, @NotNull JetType argumentType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        if (argumentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentName", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        if (argumentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentType", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        JetExpression fakeExpression = PsiPackage.JetPsiFactory(project).createExpression(argumentName);
        trace.recordType(fakeExpression, argumentType);
        trace.record(BindingContext.PROCESSED, fakeExpression);
        return fakeExpression;
    }

    public static void checkVariableShadowing(@NotNull ExpressionTypingContext context, @NotNull VariableDescriptor variableDescriptor, @Nullable VariableDescriptor oldDescriptor) {
        PsiElement declaration;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "checkVariableShadowing"));
        }
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "checkVariableShadowing"));
        }
        if (oldDescriptor != null && ExpressionTypingUtils.isLocal(variableDescriptor.getContainingDeclaration(), oldDescriptor) && (declaration = DescriptorToSourceUtils.descriptorToDeclaration(variableDescriptor)) != null) {
            context.trace.report(Errors.NAME_SHADOWING.on(declaration, variableDescriptor.getName().asString()));
        }
    }

    public static ObservableBindingTrace makeTraceInterceptingTypeMismatch(@NotNull BindingTrace trace, final @NotNull JetElement expressionToWatch, final @NotNull boolean[] mismatchFound) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "makeTraceInterceptingTypeMismatch"));
        }
        if (expressionToWatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToWatch", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "makeTraceInterceptingTypeMismatch"));
        }
        if (mismatchFound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mismatchFound", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "makeTraceInterceptingTypeMismatch"));
        }
        return new ObservableBindingTrace(trace){

            @Override
            public void report(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils$1", "report"));
                }
                DiagnosticFactory<?> factory = diagnostic.getFactory();
                if ((factory == Errors.TYPE_MISMATCH || factory == Errors.CONSTANT_EXPECTED_TYPE_MISMATCH || factory == Errors.NULL_FOR_NONNULL_TYPE) && diagnostic.getPsiElement() == expressionToWatch) {
                    mismatchFound[0] = true;
                }
                if (Errors.TYPE_INFERENCE_ERRORS.contains(factory) && PsiTreeUtil.isAncestor(expressionToWatch, diagnostic.getPsiElement(), false)) {
                    mismatchFound[0] = true;
                }
                super.report(diagnostic);
            }
        };
    }

    @NotNull
    public static JetTypeInfo getTypeInfoOrNullType(@Nullable JetExpression expression, @NotNull ExpressionTypingContext context, @NotNull ExpressionTypingInternals facade) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getTypeInfoOrNullType"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getTypeInfoOrNullType"));
        }
        JetTypeInfo jetTypeInfo = expression != null ? facade.getTypeInfo(expression, context) : TypeInfoFactoryPackage.noTypeInfo(context);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getTypeInfoOrNullType"));
        }
        return jetTypeInfo;
    }

    public static boolean isBinaryExpressionDependentOnExpectedType(@NotNull JetBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "isBinaryExpressionDependentOnExpectedType"));
        }
        IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
        return operationType == JetTokens.IDENTIFIER || OperatorConventions.BINARY_OPERATION_NAMES.containsKey(operationType) || operationType == JetTokens.ELVIS;
    }

    public static boolean isUnaryExpressionDependentOnExpectedType(@NotNull JetUnaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "isUnaryExpressionDependentOnExpectedType"));
        }
        return expression.getOperationReference().getReferencedNameElementType() == JetTokens.EXCLEXCL;
    }

    public static boolean isExclExclExpression(@Nullable JetExpression expression) {
        return expression instanceof JetUnaryExpression && ((JetUnaryExpression)expression).getOperationReference().getReferencedNameElementType() == JetTokens.EXCLEXCL;
    }

    @NotNull
    public static List<JetType> getValueParametersTypes(@NotNull List<ValueParameterDescriptor> valueParameters) {
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getValueParametersTypes"));
        }
        ArrayList<JetType> parameterTypes = new ArrayList<JetType>(valueParameters.size());
        for (ValueParameterDescriptor parameter : valueParameters) {
            parameterTypes.add(parameter.getType());
        }
        ArrayList<JetType> arrayList = parameterTypes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getValueParametersTypes"));
        }
        return arrayList;
    }

    public static boolean isLocal(DeclarationDescriptor containerOfTheCurrentLocality, DeclarationDescriptor candidate) {
        if (candidate instanceof ValueParameterDescriptor) {
            return true;
        }
        DeclarationDescriptor parent = candidate.getContainingDeclaration();
        if (!(parent instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)parent;
        for (DeclarationDescriptor current = containerOfTheCurrentLocality; current != null; current = current.getContainingDeclaration()) {
            if (current != functionDescriptor) continue;
            return true;
        }
        return false;
    }

    public static boolean dependsOnExpectedType(@Nullable JetExpression expression) {
        JetExpression expr = JetPsiUtil.deparenthesize(expression, false);
        if (expr == null) {
            return false;
        }
        if (expr instanceof JetBinaryExpressionWithTypeRHS) {
            return false;
        }
        if (expr instanceof JetBinaryExpression) {
            return ExpressionTypingUtils.isBinaryExpressionDependentOnExpectedType((JetBinaryExpression)expr);
        }
        if (expr instanceof JetUnaryExpression) {
            return ExpressionTypingUtils.isUnaryExpressionDependentOnExpectedType((JetUnaryExpression)expr);
        }
        return true;
    }

    private ExpressionTypingUtils() {
    }
}

