/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.calls.checkers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;

public class NeedSyntheticChecker
implements CallChecker {
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/jvm/calls/checkers/NeedSyntheticChecker", "check"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/jvm/calls/checkers/NeedSyntheticChecker", "check"));
        }
        F targetDescriptor = resolvedCall.getResultingDescriptor();
        if (this.needSyntheticAccessor(context.scope, (CallableDescriptor)targetDescriptor)) {
            context.trace.record(BindingContext.NEED_SYNTHETIC_ACCESSOR, (CallableMemberDescriptor)targetDescriptor.getOriginal(), Boolean.TRUE);
        }
    }

    private boolean needSyntheticAccessor(LexicalScope invokationScope, CallableDescriptor targetDescriptor) {
        return targetDescriptor instanceof CallableMemberDescriptor && Visibilities.isPrivate(targetDescriptor.getVisibility()) && targetDescriptor.getContainingDeclaration() != invokationScope.getOwnerDescriptor().getContainingDeclaration();
    }
}

