/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetAnnotation;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetElementImplStub;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierPackage;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public class JetModifierListOwnerStub<T extends StubElement<?>>
extends JetElementImplStub<T>
implements JetModifierListOwner {
    public JetModifierListOwnerStub(ASTNode node) {
        super(node);
    }

    public JetModifierListOwnerStub(T stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    @Nullable
    public JetModifierList getModifierList() {
        return (JetModifierList)this.getStubOrPsiChild(JetStubElementTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifier(@NotNull JetModifierKeywordToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/kotlin/psi/JetModifierListOwnerStub", "hasModifier"));
        }
        JetModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifier(modifier);
    }

    @Override
    public void addModifier(@NotNull JetModifierKeywordToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/kotlin/psi/JetModifierListOwnerStub", "addModifier"));
        }
        AddRemoveModifierPackage.addModifier(this, modifier, JetTokens.DEFAULT_VISIBILITY_KEYWORD);
    }

    @Override
    public void removeModifier(@NotNull JetModifierKeywordToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/kotlin/psi/JetModifierListOwnerStub", "removeModifier"));
        }
        AddRemoveModifierPackage.removeModifier(this, modifier);
    }

    @Override
    @NotNull
    public JetAnnotationEntry addAnnotationEntry(@NotNull JetAnnotationEntry annotationEntry) {
        if (annotationEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationEntry", "org/jetbrains/kotlin/psi/JetModifierListOwnerStub", "addAnnotationEntry"));
        }
        JetAnnotationEntry jetAnnotationEntry = AddRemoveModifierPackage.addAnnotationEntry(this, annotationEntry);
        if (jetAnnotationEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetModifierListOwnerStub", "addAnnotationEntry"));
        }
        return jetAnnotationEntry;
    }

    @Override
    @NotNull
    public List<JetAnnotationEntry> getAnnotationEntries() {
        JetModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            List<JetAnnotationEntry> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetModifierListOwnerStub", "getAnnotationEntries"));
            }
            return list;
        }
        List<JetAnnotationEntry> list = modifierList.getAnnotationEntries();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetModifierListOwnerStub", "getAnnotationEntries"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<JetAnnotation> getAnnotations() {
        JetModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            List<JetAnnotation> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetModifierListOwnerStub", "getAnnotations"));
            }
            return list;
        }
        List<JetAnnotation> list = modifierList.getAnnotations();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetModifierListOwnerStub", "getAnnotations"));
        }
        return list;
    }
}

