/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.JetDotQualifiedExpression;
import org.jetbrains.kotlin.psi.JetElementImplStub;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinImportDirectiveStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.kotlin.resolve.ImportPath;

public class JetImportDirective
extends JetElementImplStub<KotlinImportDirectiveStub> {
    public JetImportDirective(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetImportDirective", "<init>"));
        }
        super(node);
    }

    public JetImportDirective(@NotNull KotlinImportDirectiveStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetImportDirective", "<init>"));
        }
        super(stub, JetStubElementTypes.IMPORT_DIRECTIVE);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetImportDirective", "accept"));
        }
        return visitor2.visitImportDirective(this, data2);
    }

    public boolean isAbsoluteInRootPackage() {
        KotlinImportDirectiveStub stub = (KotlinImportDirectiveStub)this.getStub();
        if (stub != null) {
            return stub.isAbsoluteInRootPackage();
        }
        return this.findChildByType(JetTokens.PACKAGE_KEYWORD) != null;
    }

    @IfNotParsed
    @Nullable
    public JetExpression getImportedReference() {
        JetExpression[] references = (JetExpression[])this.getStubOrPsiChildren(JetStubElementTypes.INSIDE_DIRECTIVE_EXPRESSIONS, JetExpression.ARRAY_FACTORY);
        if (references.length > 0) {
            return references[0];
        }
        return null;
    }

    @Nullable
    public ASTNode getAliasNameNode() {
        boolean asPassed = false;
        for (ASTNode childNode = this.getNode().getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            IElementType tt = childNode.getElementType();
            if (tt == JetTokens.AS_KEYWORD) {
                asPassed = true;
            }
            if (!asPassed || tt != JetTokens.IDENTIFIER) continue;
            return childNode;
        }
        return null;
    }

    @Nullable
    public String getAliasName() {
        KotlinImportDirectiveStub stub = (KotlinImportDirectiveStub)this.getStub();
        if (stub != null) {
            return stub.getAliasName();
        }
        ASTNode aliasNameNode = this.getAliasNameNode();
        if (aliasNameNode == null) {
            return null;
        }
        return aliasNameNode.getText();
    }

    public boolean isAllUnder() {
        KotlinImportDirectiveStub stub = (KotlinImportDirectiveStub)this.getStub();
        if (stub != null) {
            return stub.isAllUnder();
        }
        return this.getNode().findChildByType(JetTokens.MUL) != null;
    }

    @IfNotParsed
    @Nullable
    public FqName getImportedFqName() {
        KotlinImportDirectiveStub stub = (KotlinImportDirectiveStub)this.getStub();
        if (stub != null) {
            return stub.getImportedFqName();
        }
        return JetImportDirective.fqNameFromExpression(this.getImportedReference());
    }

    @IfNotParsed
    @Nullable
    public ImportPath getImportPath() {
        FqName importFqn = this.getImportedFqName();
        if (importFqn == null) {
            return null;
        }
        Name alias = null;
        String aliasName = this.getAliasName();
        if (aliasName != null) {
            alias = Name.identifier(aliasName);
        }
        return new ImportPath(importFqn, this.isAllUnder(), alias);
    }

    public boolean isValidImport() {
        KotlinImportDirectiveStub stub = (KotlinImportDirectiveStub)this.getStub();
        if (stub != null) {
            return stub.isValid();
        }
        return !PsiTreeUtil.hasErrorElements(this);
    }

    @Nullable
    private static FqName fqNameFromExpression(@Nullable JetExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof JetDotQualifiedExpression) {
            JetDotQualifiedExpression dotQualifiedExpression = (JetDotQualifiedExpression)expression;
            FqName parentFqn = JetImportDirective.fqNameFromExpression(dotQualifiedExpression.getReceiverExpression());
            Name child = JetImportDirective.nameFromExpression(dotQualifiedExpression.getSelectorExpression());
            if (child == null) {
                return parentFqn;
            }
            if (parentFqn != null) {
                return parentFqn.child(child);
            }
            return null;
        }
        if (expression instanceof JetSimpleNameExpression) {
            JetSimpleNameExpression simpleNameExpression = (JetSimpleNameExpression)expression;
            return FqName.topLevel(simpleNameExpression.getReferencedNameAsName());
        }
        throw new IllegalArgumentException("Can't construct fqn for: " + expression.getClass().toString());
    }

    @Nullable
    private static Name nameFromExpression(@Nullable JetExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof JetSimpleNameExpression) {
            return ((JetSimpleNameExpression)expression).getReferencedNameAsName();
        }
        throw new IllegalArgumentException("Can't construct name for: " + expression.getClass().toString());
    }
}

