/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.commons.Remapper;

public class TypeRemapper
extends Remapper {
    private final Map<String, String> typeMapping;
    private Map<String, String> additionalMappings;

    public TypeRemapper(@NotNull Map<String, String> typeMapping) {
        if (typeMapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapping", "org/jetbrains/kotlin/codegen/inline/TypeRemapper", "<init>"));
        }
        this.typeMapping = typeMapping;
    }

    @Override
    public String map(String type2) {
        String newType = this.typeMapping.get(type2);
        if (newType != null) {
            return newType;
        }
        if (this.additionalMappings != null && (newType = this.additionalMappings.get(type2)) != null) {
            return newType;
        }
        return type2;
    }

    public void addAdditionalMappings(String oldName, String newName) {
        if (this.additionalMappings == null) {
            this.additionalMappings = new HashMap<String, String>();
        }
        this.additionalMappings.put(oldName, newName);
    }
}

