/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.PropertyCodegen;
import org.jetbrains.kotlin.codegen.SourceInfo;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.TraitImplBodyCodegen;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.DelegatingFacadeContext;
import org.jetbrains.kotlin.codegen.context.DelegatingToPartContext;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.inline.DefaultSourceMapper;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParametersUsages;
import org.jetbrains.kotlin.codegen.inline.SourceMapper;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.fileClasses.FileClassesPackage;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationContainer;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.DiagnosticsPackage;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.source.SourcePackage;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public abstract class MemberCodegen<T extends JetElement> {
    protected final GenerationState state;
    protected final T element;
    protected final FieldOwnerContext context;
    protected final ClassBuilder v;
    protected final FunctionCodegen functionCodegen;
    protected final PropertyCodegen propertyCodegen;
    protected final JetTypeMapper typeMapper;
    protected final BindingContext bindingContext;
    protected final JvmFileClassesProvider fileClassesProvider;
    private final MemberCodegen<?> parentCodegen;
    private final ReifiedTypeParametersUsages reifiedTypeParametersUsages;
    protected final Collection<ClassDescriptor> innerClasses;
    protected ExpressionCodegen clInit;
    private NameGenerator inlineNameGenerator;
    private SourceMapper sourceMapper;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;

    public MemberCodegen(@NotNull GenerationState state, @Nullable MemberCodegen<?> parentCodegen, @NotNull FieldOwnerContext context, T element, @NotNull ClassBuilder builder) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/MemberCodegen", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/MemberCodegen", "<init>"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/codegen/MemberCodegen", "<init>"));
        }
        this.reifiedTypeParametersUsages = new ReifiedTypeParametersUsages();
        this.innerClasses = new LinkedHashSet<ClassDescriptor>();
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.bindingContext = state.getBindingContext();
        this.fileClassesProvider = state.getFileClassesProvider();
        this.element = element;
        this.context = context;
        this.v = builder;
        this.functionCodegen = new FunctionCodegen(context, this.v, state, this);
        this.propertyCodegen = new PropertyCodegen(context, this.v, this.functionCodegen, this);
        this.parentCodegen = parentCodegen;
        this.constantExpressionEvaluator = new ConstantExpressionEvaluator(state.getModule().getBuiltIns());
    }

    protected MemberCodegen(@NotNull MemberCodegen<T> wrapped, T declaration, FieldOwnerContext codegenContext) {
        if (wrapped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapped", "org/jetbrains/kotlin/codegen/MemberCodegen", "<init>"));
        }
        this(wrapped.state, wrapped.getParentCodegen(), codegenContext, declaration, wrapped.v);
    }

    public void generate() {
        this.generateDeclaration();
        this.generateBody();
        this.generateSyntheticParts();
        this.generateKotlinAnnotation();
        this.done();
    }

    protected abstract void generateDeclaration();

    protected abstract void generateBody();

    protected void generateSyntheticParts() {
    }

    protected abstract void generateKotlinAnnotation();

    @Nullable
    protected ClassDescriptor classForInnerClassRecord() {
        return null;
    }

    protected void done() {
        if (this.clInit != null) {
            this.clInit.v.visitInsn(177);
            FunctionCodegen.endVisit(this.clInit.v, "static initializer", this.element);
        }
        this.writeInnerClasses();
        if (this.sourceMapper != null) {
            SourceMapper.Companion.flushToClassBuilder(this.sourceMapper, this.v);
        }
        this.v.done();
    }

    public void genFunctionOrProperty(@NotNull JetDeclaration functionOrProperty) {
        if (functionOrProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionOrProperty", "org/jetbrains/kotlin/codegen/MemberCodegen", "genFunctionOrProperty"));
        }
        if (functionOrProperty instanceof JetNamedFunction) {
            try {
                this.functionCodegen.gen((JetNamedFunction)functionOrProperty);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate function " + functionOrProperty.getName(), e, functionOrProperty);
            }
        } else if (functionOrProperty instanceof JetProperty) {
            try {
                this.propertyCodegen.gen((JetProperty)functionOrProperty);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate property " + functionOrProperty.getName(), e, functionOrProperty);
            }
        } else {
            throw new IllegalArgumentException("Unknown parameter: " + functionOrProperty);
        }
    }

    public static void genClassOrObject(@NotNull CodegenContext parentContext, @NotNull JetClassOrObject aClass, @NotNull GenerationState state, @Nullable MemberCodegen<?> parentCodegen) {
        if (parentContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentContext", "org/jetbrains/kotlin/codegen/MemberCodegen", "genClassOrObject"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/codegen/MemberCodegen", "genClassOrObject"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/MemberCodegen", "genClassOrObject"));
        }
        ClassDescriptor descriptor2 = state.getBindingContext().get(BindingContext.CLASS, aClass);
        if (descriptor2 == null || ErrorUtils.isError(descriptor2)) {
            MemberCodegen.badDescriptor(descriptor2, state.getClassBuilderMode());
            return;
        }
        if (descriptor2.getName().equals(SpecialNames.NO_NAME_PROVIDED)) {
            MemberCodegen.badDescriptor(descriptor2, state.getClassBuilderMode());
        }
        Type classType = state.getTypeMapper().mapClass(descriptor2);
        ClassBuilder classBuilder2 = state.getFactory().newVisitor(DiagnosticsPackage.OtherOrigin(aClass, descriptor2), classType, aClass.getContainingFile());
        ClassContext classContext = parentContext.intoClass(descriptor2, OwnerKind.IMPLEMENTATION, state);
        new ImplementationBodyCodegen(aClass, classContext, classBuilder2, state, parentCodegen).generate();
        if (aClass instanceof JetClass && ((JetClass)aClass).isInterface()) {
            Type traitImplType = state.getTypeMapper().mapTraitImpl(descriptor2);
            ClassBuilder traitImplBuilder = state.getFactory().newVisitor(DiagnosticsPackage.TraitImpl(aClass, descriptor2), traitImplType, aClass.getContainingFile());
            ClassContext traitImplContext = parentContext.intoClass(descriptor2, OwnerKind.TRAIT_IMPL, state);
            new TraitImplBodyCodegen(aClass, traitImplContext, traitImplBuilder, state, parentCodegen).generate();
        }
    }

    private static void badDescriptor(ClassDescriptor descriptor2, ClassBuilderMode mode) {
        if (mode != ClassBuilderMode.LIGHT_CLASSES) {
            throw new IllegalStateException("Generating bad descriptor in ClassBuilderMode = " + (Object)((Object)mode) + ": " + descriptor2);
        }
    }

    public void genClassOrObject(JetClassOrObject aClass) {
        MemberCodegen.genClassOrObject(this.context, aClass, this.state, this);
    }

    private void writeInnerClasses() {
        ClassDescriptor classDescriptor = this.classForInnerClassRecord();
        if (classDescriptor != null) {
            if (this.parentCodegen != null) {
                this.parentCodegen.innerClasses.add(classDescriptor);
            }
            for (MemberCodegen<?> codegen = this; codegen != null; codegen = codegen.getParentCodegen()) {
                ClassDescriptor outerClass = codegen.classForInnerClassRecord();
                if (outerClass == null) continue;
                this.innerClasses.add(outerClass);
            }
        }
        for (ClassDescriptor innerClass : this.innerClasses) {
            this.writeInnerClass(innerClass);
        }
    }

    private void writeInnerClass(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClass", "org/jetbrains/kotlin/codegen/MemberCodegen", "writeInnerClass"));
        }
        DeclarationDescriptor containing = innerClass.getContainingDeclaration();
        String outerClassInternalName = null;
        if (containing instanceof ClassDescriptor) {
            outerClassInternalName = this.typeMapper.mapClass((ClassDescriptor)containing).getInternalName();
        }
        String innerName = innerClass.getName().isSpecial() ? null : innerClass.getName().asString();
        String innerClassInternalName = this.typeMapper.mapClass(innerClass).getInternalName();
        this.v.visitInnerClass(innerClassInternalName, outerClassInternalName, innerName, AsmUtil.calculateInnerClassAccessFlags(innerClass));
    }

    protected void writeOuterClassAndEnclosingMethod() {
        CodegenContext context = this.context.getParentContext();
        while (context instanceof MethodContext && ((MethodContext)context).isInliningLambda()) {
            context = context.getParentContext().getParentContext();
        }
        assert (context != null) : "Outermost context can't be null: " + this.context;
        Type enclosingAsmType = this.computeOuterClass(context);
        if (enclosingAsmType != null) {
            Method method = this.computeEnclosingMethod(context);
            this.v.visitOuterClass(enclosingAsmType.getInternalName(), method == null ? null : method.getName(), method == null ? null : method.getDescriptor());
        }
    }

    @Nullable
    private Type computeOuterClass(@NotNull CodegenContext<?> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/MemberCodegen", "computeOuterClass"));
        }
        CodegenContext<ClassOrPackageFragmentDescriptor> outermost = context.getClassOrPackageParentContext();
        if (outermost instanceof ClassContext) {
            return this.typeMapper.mapType((ClassifierDescriptor)((ClassContext)outermost).getContextDescriptor());
        }
        if (outermost instanceof DelegatingFacadeContext || outermost instanceof DelegatingToPartContext) {
            Type implementationOwnerType = CodegenContextUtil.getImplementationOwnerClassType(outermost);
            if (implementationOwnerType != null) {
                return implementationOwnerType;
            }
            return FileClassesPackage.getFileClassType(this.fileClassesProvider, this.element.getContainingJetFile());
        }
        return null;
    }

    @Nullable
    private Method computeEnclosingMethod(@NotNull CodegenContext context) {
        Method method;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/MemberCodegen", "computeEnclosingMethod"));
        }
        if (context instanceof MethodContext && !(method = this.typeMapper.mapSignature(((MethodContext)context).getFunctionDescriptor()).getAsmMethod()).getName().equals("<clinit>")) {
            return method;
        }
        return null;
    }

    @NotNull
    public NameGenerator getInlineNameGenerator() {
        if (this.inlineNameGenerator == null) {
            String prefix = InlineCodegenUtil.getInlineName(this.context, this.typeMapper, this.fileClassesProvider);
            this.inlineNameGenerator = new NameGenerator(prefix);
        }
        NameGenerator nameGenerator = this.inlineNameGenerator;
        if (nameGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getInlineNameGenerator"));
        }
        return nameGenerator;
    }

    @NotNull
    protected ExpressionCodegen createOrGetClInitCodegen() {
        Object descriptor2 = this.context.getContextDescriptor();
        if (this.clInit == null) {
            MethodVisitor mv = this.v.newMethod(DiagnosticsPackage.OtherOrigin(descriptor2), 8, "<clinit>", "()V", null, null);
            SimpleFunctionDescriptorImpl clInit = SimpleFunctionDescriptorImpl.create(descriptor2, Annotations.EMPTY, Name.special("<clinit>"), CallableMemberDescriptor.Kind.SYNTHESIZED, SourcePackage.toSourceElement(this.element));
            clInit.initialize((JetType)null, (ReceiverParameterDescriptor)null, Collections.emptyList(), Collections.emptyList(), DescriptorUtilPackage.getModule(descriptor2).getBuiltIns().getUnitType(), (Modality)null, Visibilities.PRIVATE);
            this.clInit = new ExpressionCodegen(mv, new FrameMap(), Type.VOID_TYPE, this.context.intoFunction(clInit), this.state, this);
        }
        ExpressionCodegen expressionCodegen = this.clInit;
        if (expressionCodegen == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "createOrGetClInitCodegen"));
        }
        return expressionCodegen;
    }

    protected void generateInitializers(@NotNull Function0<ExpressionCodegen> createCodegen) {
        if (createCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createCodegen", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateInitializers"));
        }
        NotNullLazyValue<ExpressionCodegen> codegen = LockBasedStorageManager.NO_LOCKS.createLazyValue(createCodegen);
        for (JetDeclaration declaration : ((JetDeclarationContainer)this.element).getDeclarations()) {
            JetExpression body;
            if (declaration instanceof JetProperty) {
                if (!this.shouldInitializeProperty((JetProperty)declaration)) continue;
                this.initializeProperty((ExpressionCodegen)codegen.invoke(), (JetProperty)declaration);
                continue;
            }
            if (!(declaration instanceof JetClassInitializer) || (body = ((JetClassInitializer)declaration).getBody()) == null) continue;
            ((ExpressionCodegen)codegen.invoke()).gen(body, Type.VOID_TYPE);
        }
    }

    private void initializeProperty(@NotNull ExpressionCodegen codegen, @NotNull JetProperty property) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/MemberCodegen", "initializeProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/MemberCodegen", "initializeProperty"));
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.bindingContext.get(BindingContext.VARIABLE, property);
        assert (propertyDescriptor != null);
        JetExpression initializer = property.getDelegateExpressionOrInitializer();
        assert (initializer != null) : "shouldInitializeProperty must return false if initializer is null";
        StackValue.Property propValue = codegen.intermediateValueForProperty(propertyDescriptor, true, null, true, StackValue.LOCAL_0);
        propValue.store(codegen.gen(initializer), codegen.v);
        ResolvedCall<FunctionDescriptor> pdResolvedCall = this.bindingContext.get(BindingContext.DELEGATED_PROPERTY_PD_RESOLVED_CALL, propertyDescriptor);
        if (pdResolvedCall != null) {
            int index2 = PropertyCodegen.indexOfDelegatedProperty(property);
            StackValue lastValue = PropertyCodegen.invokeDelegatedPropertyConventionMethod(propertyDescriptor, codegen, this.typeMapper, pdResolvedCall, index2, 0);
            lastValue.put(Type.VOID_TYPE, codegen.v);
        }
    }

    private boolean shouldInitializeProperty(@NotNull JetProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/MemberCodegen", "shouldInitializeProperty"));
        }
        if (!property.hasDelegateExpressionOrInitializer()) {
            return false;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.bindingContext.get(BindingContext.VARIABLE, property);
        assert (propertyDescriptor != null);
        JetExpression initializer = property.getInitializer();
        ConstantValue<?> initializerValue = this.computeInitializerValue(property, propertyDescriptor, initializer);
        if (initializerValue == null) {
            return this.state.getClassBuilderMode() != ClassBuilderMode.LIGHT_CLASSES;
        }
        JetType jetType = this.getPropertyOrDelegateType(property, propertyDescriptor);
        Type type2 = this.typeMapper.mapType(jetType);
        return !MemberCodegen.skipDefaultValue(propertyDescriptor, initializerValue.getValue(), type2);
    }

    @Nullable
    private ConstantValue<?> computeInitializerValue(@NotNull JetProperty property, @NotNull PropertyDescriptor propertyDescriptor, @Nullable JetExpression initializer) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/MemberCodegen", "computeInitializerValue"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "computeInitializerValue"));
        }
        if (property.isVar() && initializer != null) {
            TemporaryBindingTrace tempTrace = TemporaryBindingTrace.create(this.state.getBindingTrace(), "property initializer");
            return this.constantExpressionEvaluator.evaluateToConstantValue(initializer, tempTrace, propertyDescriptor.getType());
        }
        return propertyDescriptor.getCompileTimeInitializer();
    }

    @NotNull
    private JetType getPropertyOrDelegateType(@NotNull JetProperty property, @NotNull PropertyDescriptor descriptor2) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/MemberCodegen", "getPropertyOrDelegateType"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "getPropertyOrDelegateType"));
        }
        JetExpression delegateExpression = property.getDelegateExpression();
        if (delegateExpression != null) {
            JetType delegateType = this.bindingContext.getType(delegateExpression);
            assert (delegateType != null) : "Type of delegate expression should be recorded";
            JetType jetType = delegateType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getPropertyOrDelegateType"));
            }
            return jetType;
        }
        JetType jetType = descriptor2.getType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getPropertyOrDelegateType"));
        }
        return jetType;
    }

    private static boolean skipDefaultValue(@NotNull PropertyDescriptor propertyDescriptor, Object value, @NotNull Type type2) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/MemberCodegen", "skipDefaultValue"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/MemberCodegen", "skipDefaultValue"));
        }
        if (AsmUtil.isPrimitive(type2)) {
            if (!propertyDescriptor.getType().isMarkedNullable() && value instanceof Number) {
                if (type2 == Type.INT_TYPE && ((Number)value).intValue() == 0) {
                    return true;
                }
                if (type2 == Type.BYTE_TYPE && ((Number)value).byteValue() == 0) {
                    return true;
                }
                if (type2 == Type.LONG_TYPE && ((Number)value).longValue() == 0L) {
                    return true;
                }
                if (type2 == Type.SHORT_TYPE && ((Number)value).shortValue() == 0) {
                    return true;
                }
                if (type2 == Type.DOUBLE_TYPE && ((Number)value).doubleValue() == 0.0) {
                    return true;
                }
                if (type2 == Type.FLOAT_TYPE && ((Number)value).floatValue() == 0.0f) {
                    return true;
                }
            }
            if (type2 == Type.BOOLEAN_TYPE && value instanceof Boolean && !((Boolean)value).booleanValue()) {
                return true;
            }
            if (type2 == Type.CHAR_TYPE && value instanceof Character && ((Character)value).charValue() == '\u0000') {
                return true;
            }
        } else if (value == null) {
            return true;
        }
        return false;
    }

    public static void generateReflectionObjectField(@NotNull GenerationState state, @NotNull Type thisAsmType, @NotNull ClassBuilder classBuilder2, @NotNull Method factory, @NotNull String fieldName, @NotNull InstructionAdapter v) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateReflectionObjectField"));
        }
        if (thisAsmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisAsmType", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateReflectionObjectField"));
        }
        if (classBuilder2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classBuilder", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateReflectionObjectField"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateReflectionObjectField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateReflectionObjectField"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateReflectionObjectField"));
        }
        String type2 = factory.getReturnType().getDescriptor();
        classBuilder2.newField(JvmDeclarationOrigin.NO_ORIGIN, 4121, fieldName, type2, null, null);
        if (state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) {
            return;
        }
        v.aconst(thisAsmType);
        if (factory.getArgumentTypes().length == 2) {
            v.aconst(state.getModuleName());
        }
        v.invokestatic("kotlin/jvm/internal/Reflection", factory.getName(), factory.getDescriptor(), false);
        v.putstatic(thisAsmType.getInternalName(), fieldName, type2);
    }

    public static void generateModuleNameField(@NotNull GenerationState state, @NotNull ClassBuilder classBuilder2) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateModuleNameField"));
        }
        if (classBuilder2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classBuilder", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateModuleNameField"));
        }
        classBuilder2.newField(JvmDeclarationOrigin.NO_ORIGIN, 4121, "$moduleName", AsmTypes.JAVA_STRING_TYPE.getDescriptor(), null, state.getModuleName());
    }

    protected void generatePropertyMetadataArrayFieldIfNeeded(@NotNull Type thisAsmType) {
        if (thisAsmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisAsmType", "org/jetbrains/kotlin/codegen/MemberCodegen", "generatePropertyMetadataArrayFieldIfNeeded"));
        }
        ArrayList<JetProperty> delegatedProperties = new ArrayList<JetProperty>();
        for (JetDeclaration declaration : ((JetDeclarationContainer)this.element).getDeclarations()) {
            JetProperty property;
            if (!(declaration instanceof JetProperty) || !(property = (JetProperty)declaration).hasDelegate()) continue;
            delegatedProperties.add(property);
        }
        if (delegatedProperties.isEmpty()) {
            return;
        }
        this.v.newField(JvmDeclarationOrigin.NO_ORIGIN, 4122, "$propertyMetadata", "[" + AsmTypes.PROPERTY_METADATA_TYPE, null, null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) {
            return;
        }
        InstructionAdapter iv = this.createOrGetClInitCodegen().v;
        iv.iconst(delegatedProperties.size());
        iv.newarray(AsmTypes.PROPERTY_METADATA_TYPE);
        int size = delegatedProperties.size();
        for (int i = 0; i < size; ++i) {
            VariableDescriptor property = BindingContextUtils.getNotNull(this.bindingContext, BindingContext.VARIABLE, delegatedProperties.get(i));
            iv.dup();
            iv.iconst(i);
            iv.anew(AsmTypes.PROPERTY_METADATA_IMPL_TYPE);
            iv.dup();
            iv.visitLdcInsn(property.getName().asString());
            iv.invokespecial(AsmTypes.PROPERTY_METADATA_IMPL_TYPE.getInternalName(), "<init>", "(Ljava/lang/String;)V", false);
            iv.astore(AsmTypes.PROPERTY_METADATA_IMPL_TYPE);
        }
        iv.putstatic(thisAsmType.getInternalName(), "$propertyMetadata", "[" + AsmTypes.PROPERTY_METADATA_TYPE);
    }

    public String getClassName() {
        return this.v.getThisName();
    }

    @NotNull
    public FieldOwnerContext<?> getContext() {
        FieldOwnerContext fieldOwnerContext = this.context;
        if (fieldOwnerContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getContext"));
        }
        return fieldOwnerContext;
    }

    @NotNull
    public ReifiedTypeParametersUsages getReifiedTypeParametersUsages() {
        ReifiedTypeParametersUsages reifiedTypeParametersUsages = this.reifiedTypeParametersUsages;
        if (reifiedTypeParametersUsages == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getReifiedTypeParametersUsages"));
        }
        return reifiedTypeParametersUsages;
    }

    public MemberCodegen<?> getParentCodegen() {
        return this.parentCodegen;
    }

    public String toString() {
        return this.context.toString();
    }

    @NotNull
    public SourceMapper getOrCreateSourceMapper() {
        if (this.sourceMapper == null) {
            this.sourceMapper = new DefaultSourceMapper(SourceInfo.Companion.createInfo((JetElement)this.element, this.getClassName()), null);
        }
        SourceMapper sourceMapper = this.sourceMapper;
        if (sourceMapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/MemberCodegen", "getOrCreateSourceMapper"));
        }
        return sourceMapper;
    }

    protected void generateConstInstance(@NotNull Type thisAsmType, @NotNull Type fieldAsmType, @NotNull Function1<InstructionAdapter, Unit> initialization) {
        if (thisAsmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisAsmType", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateConstInstance"));
        }
        if (fieldAsmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldAsmType", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateConstInstance"));
        }
        if (initialization == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialization", "org/jetbrains/kotlin/codegen/MemberCodegen", "generateConstInstance"));
        }
        this.v.newField(DiagnosticsPackage.OtherOrigin(this.element), 25, "INSTANCE$", fieldAsmType.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            InstructionAdapter iv = this.createOrGetClInitCodegen().v;
            iv.anew(thisAsmType);
            iv.dup();
            iv.invokespecial(thisAsmType.getInternalName(), "<init>", "()V", false);
            initialization.invoke(iv);
            iv.putstatic(thisAsmType.getInternalName(), "INSTANCE$", fieldAsmType.getDescriptor());
        }
    }
}

