/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.typesApproximation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.InferencePackage;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilPackage;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.JetScope;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.JetTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.ApproximationBounds;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.TypeArgument;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.TypesApproximationPackage;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.TypesApproximationPackage$WhenMappings;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.TypesApproximationPackage__CapturedTypeApproximationKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TypesApproximationPackage__CapturedTypeApproximationKt {
    @NotNull
    static final JetType NULLABLE_ANY = KotlinBuiltIns.getInstance().getNullableAnyType();
    @NotNull
    static final JetType NOTHING = KotlinBuiltIns.getInstance().getNothingType();

    @NotNull
    public static final JetType getNULLABLE_ANY() {
        return NULLABLE_ANY;
    }

    @NotNull
    public static final JetType getNOTHING() {
        return NOTHING;
    }

    @NotNull
    public static final TypeProjection toTypeProjection(TypeArgument $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        boolean value = $receiver.getIsConsistent();
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
            String message = "Only consistent enhanced type propection can be converted to type projection";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        Function1<Variance, Variance> removeProjectionIfRedundant$ = new Function1<Variance, Variance>($receiver){
            final /* synthetic */ TypeArgument receiver$0;

            @NotNull
            public final Variance invoke(@NotNull Variance variance) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)variance), "variance");
                return Intrinsics.areEqual((Object)((Object)variance), (Object)((Object)this.receiver$0.getTypeParameter().getVariance())) ? Variance.INVARIANT : variance;
            }
            {
                this.receiver$0 = typeArgument;
                super(1);
            }
        };
        return Intrinsics.areEqual($receiver.getInProjection(), $receiver.getOutProjection()) ? new TypeProjectionImpl($receiver.getInProjection()) : (KotlinBuiltIns.isNothing($receiver.getInProjection()) && Intrinsics.areEqual((Object)$receiver.getTypeParameter().getVariance(), (Object)Variance.IN_VARIANCE) ^ true ? new TypeProjectionImpl(removeProjectionIfRedundant$.invoke(Variance.OUT_VARIANCE), $receiver.getOutProjection()) : (KotlinBuiltIns.isNullableAny($receiver.getOutProjection()) ? new TypeProjectionImpl(removeProjectionIfRedundant$.invoke(Variance.IN_VARIANCE), $receiver.getInProjection()) : new TypeProjectionImpl(removeProjectionIfRedundant$.invoke(Variance.OUT_VARIANCE), $receiver.getOutProjection())));
    }

    @NotNull
    public static final TypeArgument toTypeArgument(TypeProjection $receiver, @NotNull TypeParameterDescriptor typeParameter) {
        TypeArgument typeArgument;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(typeParameter, "typeParameter");
        Variance variance = TypeSubstitutor.combine(typeParameter.getVariance(), $receiver.getProjectionKind());
        Intrinsics.checkExpressionValueIsNotNull((Object)variance, "TypeSubstitutor.combine(\u2026e(), getProjectionKind())");
        switch (TypesApproximationPackage$WhenMappings.$EnumSwitchMapping$0[variance.ordinal()]) {
            case 1: {
                JetType jetType = $receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull(jetType, "getType()");
                JetType jetType2 = $receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull(jetType2, "getType()");
                typeArgument = new TypeArgument(typeParameter, jetType, jetType2);
                break;
            }
            case 2: {
                JetType jetType = $receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull(jetType, "getType()");
                JetType jetType3 = DescriptorUtilPackage.getBuiltIns(typeParameter).getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull(jetType3, "typeParameter.builtIns.getNullableAnyType()");
                typeArgument = new TypeArgument(typeParameter, jetType, jetType3);
                break;
            }
            case 3: {
                JetType jetType = DescriptorUtilPackage.getBuiltIns(typeParameter).getNothingType();
                Intrinsics.checkExpressionValueIsNotNull(jetType, "typeParameter.builtIns.getNothingType()");
                JetType jetType4 = $receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull(jetType4, "getType()");
                typeArgument = new TypeArgument(typeParameter, jetType, jetType4);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return typeArgument;
    }

    @Nullable
    public static final TypeProjection approximateCapturedTypesIfNecessary(@Nullable TypeProjection typeProjection) {
        if (typeProjection == null) {
            return null;
        }
        if (typeProjection.isStarProjection()) {
            return typeProjection;
        }
        JetType type2 = typeProjection.getType();
        if (!TypeUtils.containsSpecialType(type2, approximateCapturedTypesIfNecessary.1.INSTANCE$)) {
            return typeProjection;
        }
        Variance howThisTypeIsUsed = typeProjection.getProjectionKind();
        if (Intrinsics.areEqual((Object)howThisTypeIsUsed, (Object)Variance.OUT_VARIANCE)) {
            JetType jetType = type2;
            Intrinsics.checkExpressionValueIsNotNull(jetType, "type");
            ApproximationBounds<JetType> approximation = TypesApproximationPackage.approximateCapturedTypes(jetType);
            return new TypeProjectionImpl(howThisTypeIsUsed, approximation.getUpper());
        }
        return TypesApproximationPackage__CapturedTypeApproximationKt.substituteCapturedTypes(typeProjection);
    }

    @Nullable
    public static final TypeProjection substituteCapturedTypes(@NotNull TypeProjection typeProjection) {
        Intrinsics.checkParameterIsNotNull(typeProjection, "typeProjection");
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new TypeConstructorSubstitution(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(substituteCapturedTypes.typeSubstitutor.1.class);
            }

            @Nullable
            public TypeProjection get(@NotNull TypeConstructor key) {
                Intrinsics.checkParameterIsNotNull(key, "key");
                TypeConstructor typeConstructor2 = key;
                if (!(typeConstructor2 instanceof CapturedTypeConstructor)) {
                    typeConstructor2 = null;
                }
                CapturedTypeConstructor capturedTypeConstructor = (CapturedTypeConstructor)typeConstructor2;
                return capturedTypeConstructor != null ? capturedTypeConstructor.getTypeProjection() : null;
            }
        });
        return typeSubstitutor2.substituteWithoutApproximation(typeProjection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ApproximationBounds<JetType> approximateCapturedTypes(@NotNull JetType type2) {
        boolean bl;
        ArrayList<void> upperBoundArguments;
        ArrayList<void> lowerBoundArguments;
        block9: {
            void $receiver;
            Intrinsics.checkParameterIsNotNull(type2, "type");
            TypeConstructor typeConstructor2 = type2.getConstructor();
            if (InferencePackage.isCaptured(type2)) {
                ApproximationBounds<JetType> approximationBounds;
                TypeConstructor typeConstructor3 = typeConstructor2;
                if (typeConstructor3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor");
                }
                TypeProjection typeProjection = ((CapturedTypeConstructor)typeConstructor3).getTypeProjection();
                Function1<JetType, JetType> makeNullableIfNeeded$ = new Function1<JetType, JetType>(type2){
                    final /* synthetic */ JetType $type;

                    @NotNull
                    public final JetType invoke(JetType $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        return TypeUtils.makeNullableIfNeeded($receiver, this.$type.isMarkedNullable());
                    }
                    {
                        this.$type = jetType;
                        super(1);
                    }
                };
                JetType bound = makeNullableIfNeeded$.invoke(typeProjection.getType());
                switch (TypesApproximationPackage$WhenMappings.$EnumSwitchMapping$1[typeProjection.getProjectionKind().ordinal()]) {
                    case 1: {
                        JetType jetType = bound;
                        Intrinsics.checkExpressionValueIsNotNull(jetType, "bound");
                        JetType jetType2 = TypesApproximationPackage__CapturedTypeApproximationKt.getNULLABLE_ANY();
                        Intrinsics.checkExpressionValueIsNotNull(jetType2, "NULLABLE_ANY");
                        approximationBounds = new ApproximationBounds<JetType>(jetType, jetType2);
                        break;
                    }
                    case 2: {
                        JetType jetType = makeNullableIfNeeded$.invoke(TypesApproximationPackage__CapturedTypeApproximationKt.getNOTHING());
                        Intrinsics.checkExpressionValueIsNotNull(jetType, "NOTHING.makeNullableIfNeeded()");
                        JetType jetType3 = bound;
                        Intrinsics.checkExpressionValueIsNotNull(jetType3, "bound");
                        approximationBounds = new ApproximationBounds<JetType>(jetType, jetType3);
                        break;
                    }
                    default: {
                        throw (Throwable)((Object)new AssertionError((Object)("Only nontrivial projections should have been captured, not: " + typeProjection)));
                    }
                }
                return approximationBounds;
            }
            if (type2.getArguments().isEmpty()) {
                return new ApproximationBounds<JetType>(type2, type2);
            }
            lowerBoundArguments = new ArrayList<void>();
            upperBoundArguments = new ArrayList<void>();
            Iterable iterable = type2.getArguments();
            Iterable iterable2 = typeConstructor2.getParameters();
            Intrinsics.checkExpressionValueIsNotNull(iterable2, "typeConstructor.getParameters()");
            for (Pair bound : KotlinPackage.zip(iterable, iterable2)) {
                void upper;
                void lower;
                TypeParameterDescriptor typeParameter;
                TypeProjection typeProjection = (TypeProjection)bound.component1();
                TypeParameterDescriptor typeParameterDescriptor = typeParameter = (TypeParameterDescriptor)bound.component2();
                Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
                ApproximationBounds<TypeArgument> approximationBounds = TypesApproximationPackage__CapturedTypeApproximationKt.approximateProjection(TypesApproximationPackage__CapturedTypeApproximationKt.toTypeArgument(typeProjection, typeParameterDescriptor));
                TypeArgument typeArgument = approximationBounds.component1();
                TypeArgument typeArgument2 = approximationBounds.component2();
                approximationBounds = null;
                lowerBoundArguments.add(lower);
                upperBoundArguments.add(upper);
            }
            Iterable iterable3 = lowerBoundArguments;
            for (Object element : $receiver) {
                TypeArgument it2 = (TypeArgument)element;
                if (!(!it2.getIsConsistent())) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        boolean lowerBoundIsTrivial = bl;
        JetType jetType = lowerBoundIsTrivial ? TypesApproximationPackage__CapturedTypeApproximationKt.getNOTHING() : TypesApproximationPackage__CapturedTypeApproximationKt.replaceTypeArguments(type2, (List<? extends TypeArgument>)lowerBoundArguments);
        Intrinsics.checkExpressionValueIsNotNull(jetType, "if (lowerBoundIsTrivial)\u2026ents(lowerBoundArguments)");
        return new ApproximationBounds<JetType>(jetType, TypesApproximationPackage__CapturedTypeApproximationKt.replaceTypeArguments(type2, (List<? extends TypeArgument>)upperBoundArguments));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JetType replaceTypeArguments(JetType $receiver, @NotNull List<? extends TypeArgument> newTypeArguments) {
        List list;
        void destination;
        void $receiver2;
        void $receiver3;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(newTypeArguments, "newTypeArguments");
        boolean value22 = $receiver.getArguments().size() == newTypeArguments.size();
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value22) {
            String message = "Incorrect type arguments " + newTypeArguments;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        Annotations annotations2 = $receiver.getAnnotations();
        Intrinsics.checkExpressionValueIsNotNull(annotations2, "getAnnotations()");
        TypeConstructor typeConstructor2 = $receiver.getConstructor();
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "getConstructor()");
        Iterable value22 = newTypeArguments;
        boolean bl = $receiver.isMarkedNullable();
        TypeConstructor typeConstructor3 = typeConstructor2;
        Annotations annotations3 = annotations2;
        JetTypeImpl.Companion companion = JetTypeImpl.Companion;
        void message = $receiver3;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault($receiver3, 10));
        for (Object item : $receiver2) {
            void it2;
            TypeArgument typeArgument = (TypeArgument)item;
            list = destination;
            TypeProjection typeProjection = TypesApproximationPackage__CapturedTypeApproximationKt.toTypeProjection((TypeArgument)it2);
            list.add(typeProjection);
        }
        list = (List)destination;
        JetScope jetScope = $receiver.getMemberScope();
        Intrinsics.checkExpressionValueIsNotNull(jetScope, "getMemberScope()");
        return companion.create(annotations3, typeConstructor3, bl, list, jetScope);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ApproximationBounds<TypeArgument> approximateProjection(@NotNull TypeArgument typeArgument) {
        void outUpper;
        void inLower;
        void outLower;
        void inUpper;
        Intrinsics.checkParameterIsNotNull(typeArgument, "typeArgument");
        Object object = TypesApproximationPackage.approximateCapturedTypes(typeArgument.getInProjection());
        JetType jetType = ((ApproximationBounds)object).component1();
        JetType jetType2 = ((ApproximationBounds)object).component2();
        object = null;
        ApproximationBounds<JetType> approximationBounds = TypesApproximationPackage.approximateCapturedTypes(typeArgument.getOutProjection());
        object = approximationBounds.component1();
        JetType jetType3 = approximationBounds.component2();
        approximationBounds = null;
        return new ApproximationBounds<TypeArgument>(new TypeArgument(typeArgument.getTypeParameter(), (JetType)inUpper, (JetType)outLower), new TypeArgument(typeArgument.getTypeParameter(), (JetType)inLower, (JetType)outUpper));
    }
}

