/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.Queue;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import org.jetbrains.annotations.NotNull;

public class VisibilityUtil {
    @NotNull
    public static CallableMemberDescriptor findMemberWithMaxVisibility(@NotNull Queue<CallableMemberDescriptor> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "kotlin/reflect/jvm/internal/impl/resolve/VisibilityUtil", "findMemberWithMaxVisibility"));
        }
        CallableMemberDescriptor descriptor2 = descriptors.element();
        for (CallableMemberDescriptor candidate : descriptors) {
            Integer result2 = Visibilities.compare(descriptor2.getVisibility(), candidate.getVisibility());
            if (result2 == null || result2 >= 0) continue;
            descriptor2 = candidate;
        }
        CallableMemberDescriptor callableMemberDescriptor = descriptor2;
        if (callableMemberDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/resolve/VisibilityUtil", "findMemberWithMaxVisibility"));
        }
        return callableMemberDescriptor;
    }
}

