/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationUseSiteTarget;
import kotlin.reflect.jvm.internal.impl.name.FqNameBase;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer$Companion$WhenMappings;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptionsImpl;
import kotlin.reflect.jvm.internal.impl.renderer.Renderer;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DescriptorRenderer
extends Renderer<DeclarationDescriptor> {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final Companion Companion;
    @NotNull
    public static final DescriptorRenderer COMPACT_WITH_MODIFIERS;
    @NotNull
    public static final DescriptorRenderer COMPACT;
    @NotNull
    public static final DescriptorRenderer COMPACT_WITH_SHORT_TYPES;
    @NotNull
    public static final DescriptorRenderer ONLY_NAMES_WITH_SHORT_TYPES;
    @NotNull
    public static final DescriptorRenderer FQ_NAMES_IN_TYPES;
    @NotNull
    public static final DescriptorRenderer SHORT_NAMES_IN_TYPES;
    @NotNull
    public static final DescriptorRenderer DEBUG_TEXT;
    @NotNull
    public static final DescriptorRenderer FLEXIBLE_TYPES_FOR_CODE;
    @NotNull
    public static final DescriptorRenderer HTML;

    static {
        Companion companion;
        $kotlinClass = Reflection.createKotlinClass(DescriptorRenderer.class);
        Companion companion2 = companion = (Companion = new Companion(null));
        COMPACT_WITH_MODIFIERS = companion.getCOMPACT_WITH_MODIFIERS();
        COMPACT = companion.getCOMPACT();
        COMPACT_WITH_SHORT_TYPES = companion.getCOMPACT_WITH_SHORT_TYPES();
        ONLY_NAMES_WITH_SHORT_TYPES = companion.getONLY_NAMES_WITH_SHORT_TYPES();
        FQ_NAMES_IN_TYPES = companion.getFQ_NAMES_IN_TYPES();
        SHORT_NAMES_IN_TYPES = companion.getSHORT_NAMES_IN_TYPES();
        DEBUG_TEXT = companion.getDEBUG_TEXT();
        FLEXIBLE_TYPES_FOR_CODE = companion.getFLEXIBLE_TYPES_FOR_CODE();
        HTML = companion.getHTML();
    }

    @NotNull
    public DescriptorRenderer withOptions(@NotNull Function1<? super DescriptorRendererOptions, ? extends Unit> var1);

    @NotNull
    public String renderType(@NotNull JetType var1);

    @NotNull
    public String renderTypeArguments(@NotNull List<? extends TypeProjection> var1);

    @NotNull
    public String renderTypeProjection(@NotNull TypeProjection var1);

    @NotNull
    public String renderTypeConstructor(@NotNull TypeConstructor var1);

    @NotNull
    public String renderClassifierName(@NotNull ClassifierDescriptor var1);

    @NotNull
    public String renderAnnotation(@NotNull AnnotationDescriptor var1, @Nullable AnnotationUseSiteTarget var2);

    @Override
    @NotNull
    public String render(@NotNull DeclarationDescriptor var1);

    @NotNull
    public String renderValueParameters(@NotNull Collection<? extends ValueParameterDescriptor> var1, boolean var2);

    @NotNull
    public String renderFunctionParameters(@NotNull FunctionDescriptor var1);

    @NotNull
    public String renderName(@NotNull Name var1);

    @NotNull
    public String renderFqName(@NotNull FqNameBase var1);

    public static interface ValueParametersHandler {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(ValueParametersHandler.class);
        }

        public void appendBeforeValueParameters(int var1, @NotNull StringBuilder var2);

        public void appendAfterValueParameters(int var1, @NotNull StringBuilder var2);

        public void appendBeforeValueParameter(@NotNull ValueParameterDescriptor var1, int var2, int var3, @NotNull StringBuilder var4);

        public void appendAfterValueParameter(@NotNull ValueParameterDescriptor var1, int var2, int var3, @NotNull StringBuilder var4);

        public static final class DEFAULT
        implements ValueParametersHandler {
            public static final /* synthetic */ KClass $kotlinClass;
            public static final DEFAULT INSTANCE$;

            static {
                $kotlinClass = Reflection.createKotlinClass(DEFAULT.class);
                new DEFAULT();
            }

            @Override
            public void appendBeforeValueParameters(int parameterCount, @NotNull StringBuilder builder) {
                Intrinsics.checkParameterIsNotNull(builder, "builder");
                builder.append("(");
            }

            @Override
            public void appendAfterValueParameters(int parameterCount, @NotNull StringBuilder builder) {
                Intrinsics.checkParameterIsNotNull(builder, "builder");
                builder.append(")");
            }

            @Override
            public void appendBeforeValueParameter(@NotNull ValueParameterDescriptor parameter, int parameterIndex, int parameterCount, @NotNull StringBuilder builder) {
                Intrinsics.checkParameterIsNotNull(parameter, "parameter");
                Intrinsics.checkParameterIsNotNull(builder, "builder");
            }

            @Override
            public void appendAfterValueParameter(@NotNull ValueParameterDescriptor parameter, int parameterIndex, int parameterCount, @NotNull StringBuilder builder) {
                Intrinsics.checkParameterIsNotNull(parameter, "parameter");
                Intrinsics.checkParameterIsNotNull(builder, "builder");
                if (parameterIndex != parameterCount - 1) {
                    builder.append(", ");
                }
            }

            DEFAULT() {
                INSTANCE$ = this;
            }
        }
    }

    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final DescriptorRenderer COMPACT_WITH_MODIFIERS = this.withOptions(COMPACT_WITH_MODIFIERS.1.INSTANCE$);
        @NotNull
        private final DescriptorRenderer COMPACT = this.withOptions(COMPACT.1.INSTANCE$);
        @NotNull
        private final DescriptorRenderer COMPACT_WITH_SHORT_TYPES = this.withOptions(COMPACT_WITH_SHORT_TYPES.1.INSTANCE$);
        @NotNull
        private final DescriptorRenderer ONLY_NAMES_WITH_SHORT_TYPES = this.withOptions(ONLY_NAMES_WITH_SHORT_TYPES.1.INSTANCE$);
        @NotNull
        private final DescriptorRenderer FQ_NAMES_IN_TYPES = this.withOptions(FQ_NAMES_IN_TYPES.1.INSTANCE$);
        @NotNull
        private final DescriptorRenderer SHORT_NAMES_IN_TYPES = this.withOptions(SHORT_NAMES_IN_TYPES.1.INSTANCE$);
        @NotNull
        private final DescriptorRenderer DEBUG_TEXT = this.withOptions(DEBUG_TEXT.1.INSTANCE$);
        @NotNull
        private final DescriptorRenderer FLEXIBLE_TYPES_FOR_CODE = this.withOptions(FLEXIBLE_TYPES_FOR_CODE.1.INSTANCE$);
        @NotNull
        private final DescriptorRenderer HTML = this.withOptions(HTML.1.INSTANCE$);

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final DescriptorRenderer withOptions(@NotNull Function1<? super DescriptorRendererOptions, ? extends Unit> changeOptions) {
            Intrinsics.checkParameterIsNotNull(changeOptions, "changeOptions");
            DescriptorRendererOptionsImpl options = new DescriptorRendererOptionsImpl();
            changeOptions.invoke(options);
            options.lock();
            return new DescriptorRendererImpl(options);
        }

        @NotNull
        public final DescriptorRenderer getCOMPACT_WITH_MODIFIERS() {
            return this.COMPACT_WITH_MODIFIERS;
        }

        @NotNull
        public final DescriptorRenderer getCOMPACT() {
            return this.COMPACT;
        }

        @NotNull
        public final DescriptorRenderer getCOMPACT_WITH_SHORT_TYPES() {
            return this.COMPACT_WITH_SHORT_TYPES;
        }

        @NotNull
        public final DescriptorRenderer getONLY_NAMES_WITH_SHORT_TYPES() {
            return this.ONLY_NAMES_WITH_SHORT_TYPES;
        }

        @NotNull
        public final DescriptorRenderer getFQ_NAMES_IN_TYPES() {
            return this.FQ_NAMES_IN_TYPES;
        }

        @NotNull
        public final DescriptorRenderer getSHORT_NAMES_IN_TYPES() {
            return this.SHORT_NAMES_IN_TYPES;
        }

        @NotNull
        public final DescriptorRenderer getDEBUG_TEXT() {
            return this.DEBUG_TEXT;
        }

        @NotNull
        public final DescriptorRenderer getFLEXIBLE_TYPES_FOR_CODE() {
            return this.FLEXIBLE_TYPES_FOR_CODE;
        }

        @NotNull
        public final DescriptorRenderer getHTML() {
            return this.HTML;
        }

        @NotNull
        public final String getClassKindPrefix(@NotNull ClassDescriptor klass) {
            String string;
            Intrinsics.checkParameterIsNotNull(klass, "klass");
            if (klass.isCompanionObject()) {
                return "companion object";
            }
            switch (DescriptorRenderer$Companion$WhenMappings.$EnumSwitchMapping$0[klass.getKind().ordinal()]) {
                case 1: {
                    string = "class";
                    break;
                }
                case 2: {
                    string = "interface";
                    break;
                }
                case 3: {
                    string = "enum class";
                    break;
                }
                case 4: {
                    string = "object";
                    break;
                }
                case 5: {
                    string = "class";
                    break;
                }
                case 6: {
                    string = "enum entry";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

