/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function0;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.javax.inject.Inject;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializationComponentsForJava;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ChainedScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.JetScope;
import kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.PackageData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataProvider;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ErrorReporter;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBufUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeserializedDescriptorResolver {
    private final ErrorReporter errorReporter;
    private DeserializationComponents components;
    public static final Set<KotlinClassHeader.Kind> KOTLIN_CLASS = KotlinPackage.setOf(KotlinClassHeader.Kind.CLASS);
    public static final Set<KotlinClassHeader.Kind> KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART = KotlinPackage.setOf(KotlinClassHeader.Kind.FILE_FACADE, KotlinClassHeader.Kind.MULTIFILE_CLASS_PART);
    public static final Set<KotlinClassHeader.Kind> KOTLIN_PACKAGE_FACADE = KotlinPackage.setOf(KotlinClassHeader.Kind.PACKAGE_FACADE);

    public DeserializedDescriptorResolver(@NotNull ErrorReporter errorReporter) {
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "<init>"));
        }
        this.errorReporter = errorReporter;
    }

    @Inject
    public void setComponents(@NotNull DeserializationComponentsForJava context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "setComponents"));
        }
        this.components = context.getComponents();
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull KotlinJvmBinaryClass kotlinClass) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "resolveClass"));
        }
        String[] data2 = this.readData(kotlinClass, KOTLIN_CLASS);
        if (data2 != null) {
            ClassData classData = JvmProtoBufUtil.readClassDataFrom(data2);
            KotlinJvmBinarySourceElement sourceElement = new KotlinJvmBinarySourceElement(kotlinClass);
            ClassDataProvider classDataProvider = new ClassDataProvider(classData, sourceElement);
            return this.components.getClassDeserializer().deserializeClass(kotlinClass.getClassId(), classDataProvider);
        }
        return null;
    }

    @Nullable
    public JetScope createKotlinPackagePartScope(@NotNull PackageFragmentDescriptor descriptor2, @NotNull KotlinJvmBinaryClass kotlinClass) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackagePartScope"));
        }
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackagePartScope"));
        }
        String[] data2 = this.readData(kotlinClass, KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART);
        if (data2 != null) {
            PackageData packageData = JvmProtoBufUtil.readPackageDataFrom(data2);
            return new DeserializedPackageMemberScope(descriptor2, packageData.getPackageProto(), packageData.getNameResolver(), this.components, (Function0<? extends Collection<? extends Name>>)new Function0<Collection<Name>>(){

                @Override
                public Collection<Name> invoke() {
                    return Collections.emptyList();
                }
            });
        }
        return null;
    }

    @NotNull
    public JetScope createKotlinPackageScope(@NotNull PackageFragmentDescriptor descriptor2, @NotNull List<KotlinJvmBinaryClass> packageParts) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        if (packageParts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageParts", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        ArrayList<JetScope> list = new ArrayList<JetScope>();
        for (KotlinJvmBinaryClass callable : packageParts) {
            JetScope scope2 = this.createKotlinPackagePartScope(descriptor2, callable);
            if (scope2 == null) continue;
            list.add(scope2);
        }
        if (list.isEmpty()) {
            JetScope.Empty empty = JetScope.Empty.INSTANCE$;
            if (empty == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
            }
            return empty;
        }
        ChainedScope chainedScope = new ChainedScope(descriptor2, "Member scope for union of package parts data", list.toArray(new JetScope[list.size()]));
        if (chainedScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        return chainedScope;
    }

    @Nullable
    public String[] readData(@NotNull KotlinJvmBinaryClass kotlinClass, @NotNull Set<KotlinClassHeader.Kind> expectedKinds) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "readData"));
        }
        if (expectedKinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedKinds", "kotlin/reflect/jvm/internal/impl/load/kotlin/DeserializedDescriptorResolver", "readData"));
        }
        KotlinClassHeader header = kotlinClass.getClassHeader();
        if (!header.getIsCompatibleAbiVersion()) {
            this.errorReporter.reportIncompatibleAbiVersion(kotlinClass.getClassId(), kotlinClass.getLocation(), header.getVersion());
        } else if (expectedKinds.contains((Object)header.getKind())) {
            return header.getAnnotationData();
        }
        return null;
    }
}

