/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class ConcurrentMostlySingularMultiMap<K, V>
extends MostlySingularMultiMap<K, V> {
    @Override
    @NotNull
    protected Map<K, Object> createMap() {
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentMostlySingularMultiMap", "createMap"));
        }
        return concurrentMap;
    }

    @Override
    public void add(@NotNull K key, @NotNull V value) {
        Object[] newArr;
        Object[] newArr2;
        Object[] curArr;
        Object current;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentMostlySingularMultiMap", "add"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentMostlySingularMultiMap", "add"));
        }
        ConcurrentMap map2 = (ConcurrentMap)this.myMap;
        while (!((current = map2.get(key)) == null ? ConcurrencyUtil.cacheOrGet(map2, key, value) == value : (current instanceof Object[] ? map2.replace(key, curArr = (Object[])current, newArr2 = ArrayUtil.append(curArr, value, ArrayUtil.OBJECT_ARRAY_FACTORY)) : map2.replace(key, current, newArr = new Object[]{current, value})))) {
        }
    }

    @Override
    public void compact() {
    }

    public boolean replace(@NotNull K key, @NotNull Collection<V> expectedValue, @NotNull Collection<V> newValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentMostlySingularMultiMap", "replace"));
        }
        if (expectedValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedValue", "com/intellij/util/containers/ConcurrentMostlySingularMultiMap", "replace"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/util/containers/ConcurrentMostlySingularMultiMap", "replace"));
        }
        ConcurrentMap map2 = (ConcurrentMap)this.myMap;
        Object[] newArray = ArrayUtil.toObjectArray(newValue);
        Object[] newValueToPut = newArray.length == 0 ? null : (newArray.length == 1 ? newArray[0] : newArray);
        Object oldValue = map2.get(key);
        List oldCollection = this.rawValueToCollection(oldValue);
        if (!oldCollection.equals(expectedValue)) {
            return false;
        }
        if (oldValue == null) {
            return newValueToPut == null || map2.putIfAbsent(key, newValueToPut) == null;
        }
        if (newValueToPut == null) {
            return map2.remove(key, oldValue);
        }
        return map2.replace(key, oldValue, newValueToPut);
    }
}

