/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.text;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.ASTDiffBuilder;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DiffLog
implements DiffTreeChangeBuilder<ASTNode, ASTNode> {
    private final List<LogEntry> myEntries = new ArrayList<LogEntry>();

    @NotNull
    public TreeChangeEventImpl performActualPsiChange(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/text/DiffLog", "performActualPsiChange"));
        }
        ASTDiffBuilder astDiffBuilder = new ASTDiffBuilder((PsiFileImpl)file);
        for (LogEntry entry : this.myEntries) {
            entry.doActualPsiChange(file, astDiffBuilder);
        }
        file.subtreeChanged();
        TreeChangeEventImpl treeChangeEventImpl = astDiffBuilder.getEvent();
        if (treeChangeEventImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/DiffLog", "performActualPsiChange"));
        }
        return treeChangeEventImpl;
    }

    @Override
    public void nodeReplaced(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
        if (oldNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "com/intellij/psi/impl/source/text/DiffLog", "nodeReplaced"));
        }
        if (newNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "com/intellij/psi/impl/source/text/DiffLog", "nodeReplaced"));
        }
        if (oldNode instanceof FileElement && newNode instanceof FileElement) {
            this.appendReplaceFileElement((FileElement)oldNode, (FileElement)newNode);
        } else {
            this.myEntries.add(new ReplaceEntry(oldNode, newNode));
        }
    }

    void appendReplaceElementWithEvents(@NotNull CompositeElement oldRoot, @NotNull CompositeElement newRoot) {
        if (oldRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoot", "com/intellij/psi/impl/source/text/DiffLog", "appendReplaceElementWithEvents"));
        }
        if (newRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRoot", "com/intellij/psi/impl/source/text/DiffLog", "appendReplaceElementWithEvents"));
        }
        this.myEntries.add(new ReplaceElementWithEvents(oldRoot, newRoot));
    }

    void appendReplaceFileElement(@NotNull FileElement oldNode, @NotNull FileElement newNode) {
        if (oldNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "com/intellij/psi/impl/source/text/DiffLog", "appendReplaceFileElement"));
        }
        if (newNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "com/intellij/psi/impl/source/text/DiffLog", "appendReplaceFileElement"));
        }
        this.myEntries.add(new ReplaceFileElement(oldNode, newNode));
    }

    @Override
    public void nodeDeleted(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
        if (oldParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "com/intellij/psi/impl/source/text/DiffLog", "nodeDeleted"));
        }
        if (oldNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "com/intellij/psi/impl/source/text/DiffLog", "nodeDeleted"));
        }
        this.myEntries.add(new DeleteEntry(oldParent, oldNode));
    }

    @Override
    public void nodeInserted(@NotNull ASTNode oldParent, @NotNull ASTNode newNode, int pos) {
        if (oldParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "com/intellij/psi/impl/source/text/DiffLog", "nodeInserted"));
        }
        if (newNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "com/intellij/psi/impl/source/text/DiffLog", "nodeInserted"));
        }
        this.myEntries.add(new InsertEntry(oldParent, newNode, pos));
    }

    private static PsiElement getPsi(ASTNode node, PsiFile file) {
        node.putUserData(TreeUtil.CONTAINING_FILE_KEY_AFTER_REPARSE, ((PsiFileImpl)file).getTreeElement());
        PsiElement psiChild = file.isPhysical() ? node.getPsi() : null;
        node.putUserData(TreeUtil.CONTAINING_FILE_KEY_AFTER_REPARSE, null);
        return psiChild;
    }

    private static class ReplaceElementWithEvents
    extends LogEntry {
        @NotNull
        private final CompositeElement myOldRoot;
        @NotNull
        private final CompositeElement myNewRoot;

        private ReplaceElementWithEvents(@NotNull CompositeElement oldRoot, @NotNull CompositeElement newRoot) {
            if (oldRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoot", "com/intellij/psi/impl/source/text/DiffLog$ReplaceElementWithEvents", "<init>"));
            }
            if (newRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRoot", "com/intellij/psi/impl/source/text/DiffLog$ReplaceElementWithEvents", "<init>"));
            }
            this.myOldRoot = oldRoot;
            this.myNewRoot = newRoot;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file, @NotNull ASTDiffBuilder astDiffBuilder) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/text/DiffLog$ReplaceElementWithEvents", "doActualPsiChange"));
            }
            if (astDiffBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astDiffBuilder", "com/intellij/psi/impl/source/text/DiffLog$ReplaceElementWithEvents", "doActualPsiChange"));
            }
            this.myOldRoot.replaceAllChildrenToChildrenOf(this.myNewRoot);
        }
    }

    private static class ReplaceFileElement
    extends LogEntry {
        @NotNull
        private final FileElement myOldNode;
        @NotNull
        private final FileElement myNewNode;

        private ReplaceFileElement(@NotNull FileElement oldNode, @NotNull FileElement newNode) {
            if (oldNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "com/intellij/psi/impl/source/text/DiffLog$ReplaceFileElement", "<init>"));
            }
            if (newNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "com/intellij/psi/impl/source/text/DiffLog$ReplaceFileElement", "<init>"));
            }
            this.myOldNode = oldNode;
            this.myNewNode = newNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file, @NotNull ASTDiffBuilder astDiffBuilder) {
            TreeElement firstChildNode;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/text/DiffLog$ReplaceFileElement", "doActualPsiChange"));
            }
            if (astDiffBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astDiffBuilder", "com/intellij/psi/impl/source/text/DiffLog$ReplaceFileElement", "doActualPsiChange"));
            }
            PsiFileImpl fileImpl = (PsiFileImpl)file;
            int oldLength = this.myOldNode.getTextLength();
            PsiManagerImpl manager = (PsiManagerImpl)fileImpl.getManager();
            BlockSupportImpl.sendBeforeChildrenChangeEvent(manager, fileImpl, false);
            if (this.myOldNode.getFirstChildNode() != null) {
                this.myOldNode.rawRemoveAllChildren();
            }
            if ((firstChildNode = this.myNewNode.getFirstChildNode()) != null) {
                this.myOldNode.rawAddChildren(firstChildNode);
            }
            fileImpl.getTreeElement().setCharTable(this.myNewNode.getCharTable());
            this.myOldNode.subtreeChanged();
            BlockSupportImpl.sendAfterChildrenChangedEvent(manager, fileImpl, oldLength, false);
        }
    }

    private static class InsertEntry
    extends LogEntry {
        @NotNull
        private final ASTNode myOldParent;
        @NotNull
        private final ASTNode myNewNode;
        private final int myPos;

        private InsertEntry(@NotNull ASTNode oldParent, @NotNull ASTNode newNode, int pos) {
            if (oldParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "com/intellij/psi/impl/source/text/DiffLog$InsertEntry", "<init>"));
            }
            if (newNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "com/intellij/psi/impl/source/text/DiffLog$InsertEntry", "<init>"));
            }
            assert (oldParent instanceof CompositeElement) : oldParent;
            assert (pos >= 0) : pos;
            this.myOldParent = oldParent;
            this.myNewNode = newNode;
            this.myPos = pos;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file, @NotNull ASTDiffBuilder astDiffBuilder) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/text/DiffLog$InsertEntry", "doActualPsiChange"));
            }
            if (astDiffBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astDiffBuilder", "com/intellij/psi/impl/source/text/DiffLog$InsertEntry", "doActualPsiChange"));
            }
            ASTNode anchor2 = null;
            ASTNode firstChildNode = this.myOldParent.getFirstChildNode();
            for (int i = 0; i < this.myPos; ++i) {
                anchor2 = anchor2 == null ? firstChildNode : anchor2.getTreeNext();
            }
            PsiElement psiParent = this.myOldParent.getPsi();
            PsiElement psiChild = DiffLog.getPsi(this.myNewNode, file);
            if (psiParent != null && psiChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file.getManager());
                event.setParent(psiParent);
                event.setChild(psiChild);
                event.setFile(file);
                ((PsiManagerEx)file.getManager()).beforeChildAddition(event);
            }
            ((TreeElement)this.myNewNode).rawRemove();
            if (anchor2 != null) {
                ((TreeElement)anchor2).rawInsertAfterMe((TreeElement)this.myNewNode);
            } else if (firstChildNode != null) {
                ((TreeElement)firstChildNode).rawInsertBeforeMe((TreeElement)this.myNewNode);
            } else {
                ((CompositeElement)this.myOldParent).rawAddChildren((TreeElement)this.myNewNode);
            }
            astDiffBuilder.nodeInserted(this.myOldParent, this.myNewNode, this.myPos);
            ((TreeElement)this.myNewNode).clearCaches();
            ((CompositeElement)this.myOldParent).subtreeChanged();
            DebugUtil.checkTreeStructure(this.myOldParent);
        }
    }

    private static class DeleteEntry
    extends LogEntry {
        @NotNull
        private final ASTNode myOldParent;
        @NotNull
        private final ASTNode myOldNode;

        private DeleteEntry(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
            if (oldParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "com/intellij/psi/impl/source/text/DiffLog$DeleteEntry", "<init>"));
            }
            if (oldNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "com/intellij/psi/impl/source/text/DiffLog$DeleteEntry", "<init>"));
            }
            this.myOldParent = oldParent;
            this.myOldNode = oldNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file, @NotNull ASTDiffBuilder astDiffBuilder) {
            PsiElement psiChild;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/text/DiffLog$DeleteEntry", "doActualPsiChange"));
            }
            if (astDiffBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astDiffBuilder", "com/intellij/psi/impl/source/text/DiffLog$DeleteEntry", "doActualPsiChange"));
            }
            ASTNode child = this.myOldNode;
            ASTNode parent = this.myOldParent;
            PsiElement psiParent = parent.getPsi();
            PsiElement psiElement = psiChild = file.isPhysical() ? child.getPsi() : null;
            if (psiParent != null && psiChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file.getManager());
                event.setParent(psiParent);
                event.setChild(psiChild);
                event.setFile(file);
                ((PsiManagerEx)file.getManager()).beforeChildRemoval(event);
            }
            astDiffBuilder.nodeDeleted(parent, child);
            ((TreeElement)child).rawRemove();
            ((CompositeElement)parent).subtreeChanged();
            DebugUtil.checkTreeStructure(parent);
        }
    }

    private static class ReplaceEntry
    extends LogEntry {
        private final ASTNode myOldChild;
        private final ASTNode myNewChild;

        private ReplaceEntry(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
            if (oldNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "com/intellij/psi/impl/source/text/DiffLog$ReplaceEntry", "<init>"));
            }
            if (newNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "com/intellij/psi/impl/source/text/DiffLog$ReplaceEntry", "<init>"));
            }
            this.myOldChild = oldNode;
            this.myNewChild = newNode;
            ASTNode parent = oldNode.getTreeParent();
            assert (parent != null) : "old:" + oldNode + " new:" + newNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file, @NotNull ASTDiffBuilder astDiffBuilder) {
            PsiElement psiOldChild;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/text/DiffLog$ReplaceEntry", "doActualPsiChange"));
            }
            if (astDiffBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astDiffBuilder", "com/intellij/psi/impl/source/text/DiffLog$ReplaceEntry", "doActualPsiChange"));
            }
            ASTNode oldNode = this.myOldChild;
            ASTNode newNode = this.myNewChild;
            ASTNode parent = oldNode.getTreeParent();
            assert (parent != null) : "old:" + oldNode + " new:" + newNode;
            PsiElement psiParent = parent.getPsi();
            PsiElement psiElement = psiOldChild = file.isPhysical() ? oldNode.getPsi() : null;
            if (psiParent != null && psiOldChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file.getManager());
                event.setParent(psiParent);
                event.setFile(file);
                event.setOldChild(psiOldChild);
                PsiElement psiNewChild = DiffLog.getPsi(newNode, file);
                event.setNewChild(psiNewChild);
                ((PsiManagerEx)file.getManager()).beforeChildReplacement(event);
            }
            ((TreeElement)newNode).rawRemove();
            ((TreeElement)oldNode).rawReplaceWithList((TreeElement)newNode);
            astDiffBuilder.nodeReplaced(oldNode, newNode);
            ((TreeElement)newNode).clearCaches();
            if (!(newNode instanceof FileElement)) {
                ((CompositeElement)newNode.getTreeParent()).subtreeChanged();
            }
            DebugUtil.checkTreeStructure(parent);
        }
    }

    private static abstract class LogEntry {
        protected LogEntry() {
            ProgressIndicatorProvider.checkCanceled();
        }

        abstract void doActualPsiChange(@NotNull PsiFile var1, @NotNull ASTDiffBuilder var2);
    }
}

