/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.rmi.service;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.TimerTask;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import kotlin.KotlinPackage;
import kotlin.Lazy;
import kotlin.Pair;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.Unit;
import kotlin.concurrent.ConcurrentPackage;
import kotlin.io.IoPackage;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.rmi.CompilerId;
import org.jetbrains.kotlin.rmi.DaemonOptions;
import org.jetbrains.kotlin.rmi.DaemonParamsKt;
import org.jetbrains.kotlin.rmi.LoopbackNetworkInterface;
import org.jetbrains.kotlin.rmi.OptionsGroup;
import org.jetbrains.kotlin.rmi.service.CompileDaemon;
import org.jetbrains.kotlin.rmi.service.CompileDaemonKt;
import org.jetbrains.kotlin.rmi.service.CompileServiceImpl;
import org.jetbrains.kotlin.rmi.service.CompileServiceImplKt;
import org.jetbrains.kotlin.rmi.service.LogStream;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"&\u0006)i1i\\7qS2,G)Y3n_:T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0004e6L'bB:feZL7-\u001a\u0006\u0004\u0003:L(b\u00017pO*1Aj\\4hKJTAA[1wC*!Q\u000f^5m\u0015\u001dawnZ4j]\u001eTqc[8uY&tgF\u001b<n]Ac\u0017\r\u001e4pe6$\u0016\u0010]3\u000b\u00191|w\r\n3fY\u0016<\u0017\r^3\u000b\t1\u000b'0\u001f\u0006\u0007O\u0016$Hj\\4\u000b\rI\fg\u000eZ8n\u0015\u0019\u0011\u0016M\u001c3p[*Iq-\u001a;SC:$w.\u001c\u0006\u000fGJ,\u0017\r^3SK\u001eL7\u000f\u001e:z\u0015!\tG\u000f^3naR\u001c(bA%oi*!\u0001+Y5s\u0015!\u0011VmZ5tiJL(\u0002\u0003:fO&\u001cHO]=\u000b/1|\u0017\r\u001a,feNLwN\u001c$s_6\u0014Vm]8ve\u000e,'BB*ue&twM\u0003\u0003mC:<'\u0002B7bS:TA!\u0019:hg*)\u0011I\u001d:bs*!QK\\5ua\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019Aa\u0001\u0005\u0004\u0019\u0001)\u0011\u0001#\u0003\u0006\u0005\u0011!\u0001\"B\u0003\u0003\t\u0013AY!B\u0002\u0005\u000b!!A\u0002A\u0003\u0003\t\rAq!\u0002\u0002\u0005\u000b!!Qa\u0001C\u0005\u0011#a\u0001!\u0002\u0002\u0005\n!EQa\u0001\u0003\u0004\u0011+a\u0001!B\u0002\u0005\u0007!YA\u0002A\u0003\u0003\t\u0011A!!\u0002\u0002\u0005\u0013!aQa\u0001C\n\u0011/a\u0001!\u0002\u0002\u0005\u0007!YQa\u0001\u0003\u0004\u00115a\u0001!\u0002\u0002\u0005\t!mQA\u0001C\f\u00115)1\u0001B\u0002\t\u001f1\u0001Qa\u0001\u0003\u0004\u0011?a\u0001\u0001B2\u0002\u0019\u000bI2!B\u0001\t\ba\u001dQf\u0006\u0003d\ta\u001d\u0011%C\u0003\u0002\u0011\u0017\u0001b!\u0006\u0003\u0006\u0003!-A\u0012\u0001M\u00061\u0017!3%V\u0002\t\u000b\r!i!C\u0001\t\r5\u0019AqB\u0005\u0002\u0011\u001bi\u0003\u0003B2\u00051!\t3!B\u0001\t\u000fa9Qk\u0001\u0005\u0006\u0007\u0011A\u0011\"\u0001E\b\u001b\r!\u0011\"C\u0001\t\u00105zB!\u0001M\n;\u001f!\u0001\u0001\u0003\u0006\u000e\u0007\u0015\t\u0001\u0002\u0003\r\t!\u000e\u0001\u0011%D\u0003\u0002\u0011#IA!C\u0002\u0006\u0003!Q\u0001DC\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0005\u0019\u0011aE\u0011kA\u0003\u0005\u0014%\t\u0001RC\u0007\u0002\t\u000bi;\u0002B\u0001\u0019\u001a\u0005\"Q!\u0001\u0005\f\u0019\u0003A2\"U\u0002\u0004\t3I\u0011\u0001\u0003\u0007.7\u0011\u001d\u0001DDO\r\t\u0001Ai\"\u0004\u0005\u0006\u0003!e\u0011\u0002B\u0005\u0004\u000b\u0005A1\u0002G\u0006\u0019\u001aA\u001b\u0001!I\u0002\u0006\u0003!i\u0001$D)\u0004\r\u0011q\u0011\"\u0001\u0003\u0001\u001b\tAA\u0002$\u00016\u0001\u0001"})
public final class CompileDaemon {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final Lazy<? extends Logger> log$delegate;
    @NotNull
    public static final Random random;
    private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;
    public static final CompileDaemon INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(CompileDaemon.class);
        $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("log")};
        new CompileDaemon();
    }

    public final Logger getLog() {
        return KotlinPackage.get(log$delegate, this, $propertyMetadata[0]);
    }

    private final String loadVersionFromResource() {
        Unit unit;
        Object object;
        ClassLoader classLoader = CompileDaemon.class.getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            classLoader = null;
        }
        if ((object = (URLClassLoader)classLoader) != null && (object = ((URLClassLoader)object).findResource("META-INF/MANIFEST.MF")) != null) {
            Object $receiver = object;
            URL it2 = (URL)$receiver;
            try {
                String string = new Manifest(it2.openStream()).getMainAttributes().getValue("Implementation-Version");
                if (string == null) {
                    string = null;
                }
                return string;
            }
            catch (IOException iOException) {
                unit = Unit.INSTANCE$;
            }
        } else {
            unit = null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        Logger logger = INSTANCE$.getLog();
        StringBuilder stringBuilder = new StringBuilder().append("Kotlin compiler daemon version ");
        String string = INSTANCE$.loadVersionFromResource();
        if (string == null) {
            string = "<unknown>";
        }
        logger.info(stringBuilder.append(string).toString());
        INSTANCE$.getLog().info("daemon JVM args: " + KotlinPackage.joinToString$default(ManagementFactory.getRuntimeMXBean().getInputArguments(), " ", null, null, 0, null, null, 62));
        INSTANCE$.getLog().info("daemon args: " + KotlinPackage.joinToString$default(args, " ", null, null, 0, null, null, 62));
        CompilerId compilerId = new CompilerId(null, null, null, 7, null);
        DaemonOptions daemonOptions = new DaemonOptions(null, 0L, 0, null, 15, null);
        try {
            Unit unit;
            void registry;
            void port;
            List list;
            String destination;
            void $receiver;
            void $receiver2;
            File file;
            Iterable<String> filteredArgs = DaemonParamsKt.filterExtractProps(KotlinPackage.asIterable((Object[])args), new OptionsGroup[]{compilerId, daemonOptions}, DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX());
            if (KotlinPackage.any(filteredArgs)) {
                String helpLine = "usage: <daemon> <compilerId options> <daemon options>";
                INSTANCE$.getLog().info(helpLine);
                IoPackage.println(helpLine);
                throw (Throwable)new IllegalArgumentException("Unknown arguments: " + KotlinPackage.joinToString$default(filteredArgs, " ", null, null, 0, null, null, 62));
            }
            INSTANCE$.getLog().info("starting daemon");
            Pair<Registry, Integer> pair = INSTANCE$.createRegistry(DaemonParamsKt.getCOMPILE_DAEMON_FIND_PORT_ATTEMPTS());
            Registry helpLine = pair.component1();
            int n = ((Number)pair.component2()).intValue();
            pair = null;
            File runFileDir = new File(KotlinPackage.isBlank(daemonOptions.getRunFilesPath()) ? DaemonParamsKt.getCOMPILE_DAEMON_DEFAULT_RUN_DIR_PATH() : daemonOptions.getRunFilesPath());
            runFileDir.mkdirs();
            Iterable iterable = compilerId.getCompilerClasspath();
            String string2 = KotlinPackage.format("%tFT%<tH-%<tM-%<tS.%<tLZ", Calendar.getInstance(TimeZone.getTimeZone("Z")));
            File file2 = runFileDir;
            File file3 = file;
            File file4 = file;
            void var12_15 = $receiver2;
            Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault($receiver2, 10));
            for (Object item : $receiver) {
                void it2;
                String string3 = (String)item;
                list = destination;
                String string4 = new File((String)it2).getAbsolutePath();
                list.add(string4);
            }
            list = (List)((Object)destination);
            file3(file2, DaemonParamsKt.makeRunFilenameString$default(string2, DaemonParamsKt.distinctStringsDigest(list), String.valueOf((int)port), null, 8));
            File runFile = file4;
            try {
                if (!runFile.createNewFile()) {
                    throw (Throwable)new Exception("createNewFile returned false");
                }
            }
            catch (Exception e) {
                throw (Throwable)new IllegalStateException("Unable to create run file '" + runFile.getAbsolutePath() + "'", e);
            }
            runFile.deleteOnExit();
            K2JVMCompiler compiler = new K2JVMCompiler();
            CompileServiceImpl<CLICompiler> compilerService = new CompileServiceImpl<CLICompiler>((Registry)registry, compiler, compilerId, (int)port);
            if (KotlinPackage.isNotEmpty(daemonOptions.getRunFilesPath())) {
                IoPackage.println(daemonOptions.getRunFilesPath());
            }
            String string5 = daemonOptions.getClientAliveFlagPath();
            if (string5 != null) {
                void $receiver3;
                destination = string5;
                String it3 = (String)$receiver3;
                if (!new File(it3).exists()) {
                    INSTANCE$.getLog().info("Client alive flag " + it3 + " do not exist, disable watching it");
                    daemonOptions.setClientAliveFlagPath(null);
                }
                unit = Unit.INSTANCE$;
            } else {
                unit = null;
            }
            System.out.close();
            System.err.close();
            System.setErr(new PrintStream(new LogStream("stderr")));
            System.setOut(new PrintStream(new LogStream("stdout")));
            main.2 shutdownCondition$ = main.2.INSTANCE$;
            ConcurrentPackage.timer$default(null, false, CompileDaemonKt.getDAEMON_PERIODIC_CHECK_INTERVAL_MS(), CompileDaemonKt.getDAEMON_PERIODIC_CHECK_INTERVAL_MS(), (Function1)new Function1<TimerTask, Unit>(compilerService, runFile, daemonOptions){
                final /* synthetic */ CompileServiceImpl $compilerService;
                final /* synthetic */ File $runFile;
                final /* synthetic */ DaemonOptions $daemonOptions;

                public final void invoke(TimerTask $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                    try {
                        long idleSeconds = CompileServiceImplKt.nowSeconds() - this.$compilerService.getLastUsedSeconds();
                        if (main.2.INSTANCE$.invoke((Function0<? extends Boolean>)new Function0<Boolean>(this){
                            final /* synthetic */ main.3 this$0;

                            public final boolean invoke() {
                                return !this.this$0.$runFile.exists();
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }, "Run file removed, shutting down") || main.2.INSTANCE$.invoke((Function0<? extends Boolean>)new Function0<Boolean>(this, idleSeconds){
                            final /* synthetic */ main.3 this$0;
                            final /* synthetic */ long $idleSeconds;

                            public final boolean invoke() {
                                return this.this$0.$daemonOptions.getAutoshutdownIdleSeconds() != DaemonParamsKt.getCOMPILE_DAEMON_TIMEOUT_INFINITE_S() && this.$idleSeconds > (long)this.this$0.$daemonOptions.getAutoshutdownIdleSeconds();
                            }
                            {
                                this.this$0 = var1_1;
                                this.$idleSeconds = l;
                                super(0);
                            }
                        }, "Idle timeout exceeded " + this.$daemonOptions.getAutoshutdownIdleSeconds() + "s, shutting down") || main.2.INSTANCE$.invoke((Function0<? extends Boolean>)new Function0<Boolean>(this){
                            final /* synthetic */ main.3 this$0;

                            public final boolean invoke() {
                                boolean bl;
                                String string = this.this$0.$daemonOptions.getClientAliveFlagPath();
                                if (string != null) {
                                    String $receiver = string;
                                    String it2 = $receiver;
                                    bl = !new File(it2).exists();
                                } else {
                                    bl = false;
                                }
                                return bl;
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }, "Client alive flag " + this.$daemonOptions.getClientAliveFlagPath() + " removed, shutting down")) {
                            $receiver.cancel();
                            this.$compilerService.shutdown();
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Exception in timer thread: " + e.getMessage());
                        Throwable throwable = e;
                        PrintStream printStream = System.err;
                        Intrinsics.checkExpressionValueIsNotNull(printStream, "System.err");
                        KotlinPackage.printStackTrace(throwable, printStream);
                    }
                }
                {
                    this.$compilerService = compileServiceImpl;
                    this.$runFile = file;
                    this.$daemonOptions = daemonOptions;
                    super(1);
                }
            }, 3);
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            Throwable throwable = e;
            PrintStream printStream = System.err;
            Intrinsics.checkExpressionValueIsNotNull(printStream, "System.err");
            KotlinPackage.printStackTrace(throwable, printStream);
            INSTANCE$.getLog().log(Level.INFO, "Exception: ", e);
            throw (Throwable)e;
        }
    }

    @NotNull
    public final Random getRandom() {
        return random;
    }

    private final Pair<Registry, Integer> createRegistry(int attempts) {
        int i = 0;
        RemoteException lastException = null;
        while (i++ < attempts) {
            int port = random.nextInt(DaemonParamsKt.getCOMPILE_DAEMON_PORTS_RANGE_END() - DaemonParamsKt.getCOMPILE_DAEMON_PORTS_RANGE_START()) + DaemonParamsKt.getCOMPILE_DAEMON_PORTS_RANGE_START();
            try {
                return new Pair<Registry, Integer>(LocateRegistry.createRegistry(port, LoopbackNetworkInterface.INSTANCE$.getClientLoopbackSocketFactory(), LoopbackNetworkInterface.INSTANCE$.getServerLoopbackSocketFactory()), port);
            }
            catch (RemoteException e) {
                lastException = e;
            }
        }
        throw (Throwable)new IllegalStateException("Cannot find free port in " + attempts + " attempts", lastException);
    }

    CompileDaemon() {
        INSTANCE$ = this;
        String string = System.getProperty("kotlin.daemon.log.path");
        if (string == null || (string = KotlinPackage.trimEnd(string, '/', '\\')) == null) {
            string = "%t";
        }
        String logPath = string;
        String string2 = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss-SSS").format(new Date());
        Intrinsics.checkExpressionValueIsNotNull(string2, "SimpleDateFormat(\"yyyy-M\u2026m-ss-SSS\").format(Date())");
        String logTime = string2;
        String cfg = "handlers = java.util.logging.FileHandler\n" + "java.util.logging.FileHandler.level     = ALL\n" + "java.util.logging.FileHandler.formatter = java.util.logging.SimpleFormatter\n" + "java.util.logging.FileHandler.encoding  = UTF-8\n" + "java.util.logging.FileHandler.limit     = 1073741824\n" + "java.util.logging.FileHandler.count     = 3\n" + "java.util.logging.FileHandler.append    = false\n" + ("java.util.logging.FileHandler.pattern   = " + logPath + "/" + DaemonParamsKt.getCOMPILE_DAEMON_DEFAULT_FILES_PREFIX() + "." + logTime + ".%u%g.log" + "\n") + "java.util.logging.SimpleFormatter.format = %1$tF %1$tT.%1$tL [%3$s] %4$s: %5$s\\n\n";
        LogManager.getLogManager().readConfiguration(IoPackage.byteInputStream$default(cfg, null, 1));
        log$delegate = KotlinPackage.lazy(log.1.INSTANCE$);
        random = new Random();
    }
}

