/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.inline.InlineAnalyzerExtension;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

public class FunctionAnalyzerExtension {
    @NotNull
    private final BindingTrace trace;

    public FunctionAnalyzerExtension(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/FunctionAnalyzerExtension", "<init>"));
        }
        this.trace = trace;
    }

    public void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        if (bodiesResolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodiesResolveContext", "org/jetbrains/kotlin/resolve/FunctionAnalyzerExtension", "process"));
        }
        for (Map.Entry<JetNamedFunction, SimpleFunctionDescriptor> entry : bodiesResolveContext.getFunctions().entrySet()) {
            JetNamedFunction function = entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = entry.getValue();
            for (AnalyzerExtension extension : FunctionAnalyzerExtension.getExtensions(functionDescriptor)) {
                extension.process(functionDescriptor, function, this.trace);
            }
        }
    }

    @NotNull
    private static List<AnalyzerExtension> getExtensions(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/FunctionAnalyzerExtension", "getExtensions"));
        }
        if (InlineUtil.isInline(functionDescriptor)) {
            List<AnalyzerExtension> list = Collections.singletonList(InlineAnalyzerExtension.INSTANCE);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/FunctionAnalyzerExtension", "getExtensions"));
            }
            return list;
        }
        List<AnalyzerExtension> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/FunctionAnalyzerExtension", "getExtensions"));
        }
        return list;
    }

    public static interface AnalyzerExtension {
        public void process(@NotNull FunctionDescriptor var1, @NotNull JetNamedFunction var2, @NotNull BindingTrace var3);
    }
}

