/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.org.apache.log4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jetbrains.kotlin.relocated.org.apache.log4j.Appender;
import org.jetbrains.kotlin.relocated.org.apache.log4j.DefaultCategoryFactory;
import org.jetbrains.kotlin.relocated.org.apache.log4j.Layout;
import org.jetbrains.kotlin.relocated.org.apache.log4j.Level;
import org.jetbrains.kotlin.relocated.org.apache.log4j.Logger;
import org.jetbrains.kotlin.relocated.org.apache.log4j.NameValue;
import org.jetbrains.kotlin.relocated.org.apache.log4j.SortedKeyEnumeration;
import org.jetbrains.kotlin.relocated.org.apache.log4j.config.PropertySetter;
import org.jetbrains.kotlin.relocated.org.apache.log4j.helpers.LogLog;
import org.jetbrains.kotlin.relocated.org.apache.log4j.helpers.OptionConverter;
import org.jetbrains.kotlin.relocated.org.apache.log4j.or.RendererMap;
import org.jetbrains.kotlin.relocated.org.apache.log4j.spi.Configurator;
import org.jetbrains.kotlin.relocated.org.apache.log4j.spi.ErrorHandler;
import org.jetbrains.kotlin.relocated.org.apache.log4j.spi.Filter;
import org.jetbrains.kotlin.relocated.org.apache.log4j.spi.LoggerFactory;
import org.jetbrains.kotlin.relocated.org.apache.log4j.spi.LoggerRepository;
import org.jetbrains.kotlin.relocated.org.apache.log4j.spi.OptionHandler;
import org.jetbrains.kotlin.relocated.org.apache.log4j.spi.RendererSupport;
import org.jetbrains.kotlin.relocated.org.apache.log4j.spi.ThrowableRenderer;
import org.jetbrains.kotlin.relocated.org.apache.log4j.spi.ThrowableRendererSupport;

public class PropertyConfigurator
implements Configurator {
    protected Hashtable registry = new Hashtable(11);
    private LoggerRepository repository;
    protected LoggerFactory loggerFactory = new DefaultCategoryFactory();
    static /* synthetic */ Class class$org$apache$log4j$spi$LoggerFactory;
    static /* synthetic */ Class class$org$apache$log4j$spi$ThrowableRenderer;
    static /* synthetic */ Class class$org$apache$log4j$Appender;
    static /* synthetic */ Class class$org$apache$log4j$Layout;
    static /* synthetic */ Class class$org$apache$log4j$spi$ErrorHandler;
    static /* synthetic */ Class class$org$apache$log4j$spi$Filter;

    public void doConfigure(Properties properties2, LoggerRepository hierarchy) {
        String thresholdStr;
        String reset;
        this.repository = hierarchy;
        String value = properties2.getProperty("log4j.debug");
        if (value == null && (value = properties2.getProperty("log4j.configDebug")) != null) {
            LogLog.warn("[log4j.configDebug] is deprecated. Use [log4j.debug] instead.");
        }
        if (value != null) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean(value, true));
        }
        if ((reset = properties2.getProperty("log4j.reset")) != null && OptionConverter.toBoolean(reset, false)) {
            hierarchy.resetConfiguration();
        }
        if ((thresholdStr = OptionConverter.findAndSubst("log4j.threshold", properties2)) != null) {
            hierarchy.setThreshold(OptionConverter.toLevel(thresholdStr, Level.ALL));
            LogLog.debug(new StringBuffer().append("Hierarchy threshold set to [").append(hierarchy.getThreshold()).append("].").toString());
        }
        this.configureRootCategory(properties2, hierarchy);
        this.configureLoggerFactory(properties2);
        this.parseCatsAndRenderers(properties2, hierarchy);
        LogLog.debug("Finished configuring.");
        this.registry.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doConfigure(URL configURL, LoggerRepository hierarchy) {
        Properties props = new Properties();
        LogLog.debug(new StringBuffer().append("Reading configuration from URL ").append(configURL).toString());
        InputStream istream = null;
        URLConnection uConn = null;
        try {
            uConn = configURL.openConnection();
            uConn.setUseCaches(false);
            istream = uConn.getInputStream();
            props.load(istream);
        }
        catch (Exception e) {
            if (e instanceof InterruptedIOException || e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LogLog.error(new StringBuffer().append("Could not read configuration file from URL [").append(configURL).append("].").toString(), e);
            LogLog.error(new StringBuffer().append("Ignoring configuration file [").append(configURL).append("].").toString());
            return;
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (InterruptedIOException ignore) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException iOException) {
                }
                catch (RuntimeException runtimeException) {}
            }
        }
        this.doConfigure(props, hierarchy);
    }

    protected void configureLoggerFactory(Properties props) {
        String factoryClassName = OptionConverter.findAndSubst("log4j.loggerFactory", props);
        if (factoryClassName != null) {
            LogLog.debug(new StringBuffer().append("Setting category factory to [").append(factoryClassName).append("].").toString());
            this.loggerFactory = (LoggerFactory)OptionConverter.instantiateByClassName(factoryClassName, class$org$apache$log4j$spi$LoggerFactory == null ? (class$org$apache$log4j$spi$LoggerFactory = PropertyConfigurator.class$("org.jetbrains.kotlin.relocated.org.apache.log4j.spi.LoggerFactory")) : class$org$apache$log4j$spi$LoggerFactory, this.loggerFactory);
            PropertySetter.setProperties(this.loggerFactory, props, "log4j.factory.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void configureRootCategory(Properties props, LoggerRepository hierarchy) {
        String effectiveFrefix = "log4j.rootLogger";
        String value = OptionConverter.findAndSubst("log4j.rootLogger", props);
        if (value == null) {
            value = OptionConverter.findAndSubst("log4j.rootCategory", props);
            effectiveFrefix = "log4j.rootCategory";
        }
        if (value == null) {
            LogLog.debug("Could not find root logger information. Is this OK?");
        } else {
            Logger root;
            Logger logger = root = hierarchy.getRootLogger();
            synchronized (logger) {
                this.parseCategory(props, root, effectiveFrefix, "root", value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseCatsAndRenderers(Properties props, LoggerRepository hierarchy) {
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (key.startsWith("log4j.category.") || key.startsWith("log4j.logger.")) {
                Logger logger;
                String loggerName = null;
                if (key.startsWith("log4j.category.")) {
                    loggerName = key.substring("log4j.category.".length());
                } else if (key.startsWith("log4j.logger.")) {
                    loggerName = key.substring("log4j.logger.".length());
                }
                String value = OptionConverter.findAndSubst(key, props);
                Logger logger2 = logger = hierarchy.getLogger(loggerName, this.loggerFactory);
                synchronized (logger2) {
                    this.parseCategory(props, logger, key, loggerName, value);
                    this.parseAdditivityForLogger(props, logger, loggerName);
                    continue;
                }
            }
            if (key.startsWith("log4j.renderer.")) {
                String renderedClass = key.substring("log4j.renderer.".length());
                String renderingClass = OptionConverter.findAndSubst(key, props);
                if (!(hierarchy instanceof RendererSupport)) continue;
                RendererMap.addRenderer((RendererSupport)((Object)hierarchy), renderedClass, renderingClass);
                continue;
            }
            if (!key.equals("log4j.throwableRenderer") || !(hierarchy instanceof ThrowableRendererSupport)) continue;
            ThrowableRenderer tr = (ThrowableRenderer)OptionConverter.instantiateByKey(props, "log4j.throwableRenderer", class$org$apache$log4j$spi$ThrowableRenderer == null ? PropertyConfigurator.class$("org.jetbrains.kotlin.relocated.org.apache.log4j.spi.ThrowableRenderer") : class$org$apache$log4j$spi$ThrowableRenderer, null);
            if (tr == null) {
                LogLog.error("Could not instantiate throwableRenderer.");
                continue;
            }
            PropertySetter setter2 = new PropertySetter(tr);
            setter2.setProperties(props, "log4j.throwableRenderer.");
            ((ThrowableRendererSupport)((Object)hierarchy)).setThrowableRenderer(tr);
        }
    }

    void parseAdditivityForLogger(Properties props, Logger cat, String loggerName) {
        String value = OptionConverter.findAndSubst(new StringBuffer().append("log4j.additivity.").append(loggerName).toString(), props);
        LogLog.debug(new StringBuffer().append("Handling log4j.additivity.").append(loggerName).append("=[").append(value).append("]").toString());
        if (value != null && !value.equals("")) {
            boolean additivity = OptionConverter.toBoolean(value, true);
            LogLog.debug(new StringBuffer().append("Setting additivity for \"").append(loggerName).append("\" to ").append(additivity).toString());
            cat.setAdditivity(additivity);
        }
    }

    void parseCategory(Properties props, Logger logger, String optionKey, String loggerName, String value) {
        LogLog.debug(new StringBuffer().append("Parsing for [").append(loggerName).append("] with value=[").append(value).append("].").toString());
        StringTokenizer st = new StringTokenizer(value, ",");
        if (!value.startsWith(",") && !value.equals("")) {
            if (!st.hasMoreTokens()) {
                return;
            }
            String levelStr = st.nextToken();
            LogLog.debug(new StringBuffer().append("Level token is [").append(levelStr).append("].").toString());
            if ("inherited".equalsIgnoreCase(levelStr) || "null".equalsIgnoreCase(levelStr)) {
                if (loggerName.equals("root")) {
                    LogLog.warn("The root logger cannot be set to null.");
                } else {
                    logger.setLevel(null);
                }
            } else {
                logger.setLevel(OptionConverter.toLevel(levelStr, Level.DEBUG));
            }
            LogLog.debug(new StringBuffer().append("Category ").append(loggerName).append(" set to ").append(logger.getLevel()).toString());
        }
        logger.removeAllAppenders();
        while (st.hasMoreTokens()) {
            String appenderName = st.nextToken().trim();
            if (appenderName == null || appenderName.equals(",")) continue;
            LogLog.debug(new StringBuffer().append("Parsing appender named \"").append(appenderName).append("\".").toString());
            Appender appender = this.parseAppender(props, appenderName);
            if (appender == null) continue;
            logger.addAppender(appender);
        }
    }

    Appender parseAppender(Properties props, String appenderName) {
        Appender appender = this.registryGet(appenderName);
        if (appender != null) {
            LogLog.debug(new StringBuffer().append("Appender \"").append(appenderName).append("\" was already parsed.").toString());
            return appender;
        }
        String prefix = new StringBuffer().append("log4j.appender.").append(appenderName).toString();
        String layoutPrefix = new StringBuffer().append(prefix).append(".layout").toString();
        appender = (Appender)OptionConverter.instantiateByKey(props, prefix, class$org$apache$log4j$Appender == null ? (class$org$apache$log4j$Appender = PropertyConfigurator.class$("org.jetbrains.kotlin.relocated.org.apache.log4j.Appender")) : class$org$apache$log4j$Appender, null);
        if (appender == null) {
            LogLog.error(new StringBuffer().append("Could not instantiate appender named \"").append(appenderName).append("\".").toString());
            return null;
        }
        appender.setName(appenderName);
        if (appender instanceof OptionHandler) {
            ErrorHandler eh;
            String errorHandlerPrefix;
            String errorHandlerClass;
            Layout layout;
            if (appender.requiresLayout() && (layout = (Layout)OptionConverter.instantiateByKey(props, layoutPrefix, class$org$apache$log4j$Layout == null ? (class$org$apache$log4j$Layout = PropertyConfigurator.class$("org.jetbrains.kotlin.relocated.org.apache.log4j.Layout")) : class$org$apache$log4j$Layout, null)) != null) {
                appender.setLayout(layout);
                LogLog.debug(new StringBuffer().append("Parsing layout options for \"").append(appenderName).append("\".").toString());
                PropertySetter.setProperties(layout, props, new StringBuffer().append(layoutPrefix).append(".").toString());
                LogLog.debug(new StringBuffer().append("End of parsing for \"").append(appenderName).append("\".").toString());
            }
            if ((errorHandlerClass = OptionConverter.findAndSubst(errorHandlerPrefix = new StringBuffer().append(prefix).append(".errorhandler").toString(), props)) != null && (eh = (ErrorHandler)OptionConverter.instantiateByKey(props, errorHandlerPrefix, class$org$apache$log4j$spi$ErrorHandler == null ? (class$org$apache$log4j$spi$ErrorHandler = PropertyConfigurator.class$("org.jetbrains.kotlin.relocated.org.apache.log4j.spi.ErrorHandler")) : class$org$apache$log4j$spi$ErrorHandler, null)) != null) {
                appender.setErrorHandler(eh);
                LogLog.debug(new StringBuffer().append("Parsing errorhandler options for \"").append(appenderName).append("\".").toString());
                this.parseErrorHandler(eh, errorHandlerPrefix, props, this.repository);
                Properties edited = new Properties();
                String[] keys = new String[]{new StringBuffer().append(errorHandlerPrefix).append(".").append("root-ref").toString(), new StringBuffer().append(errorHandlerPrefix).append(".").append("logger-ref").toString(), new StringBuffer().append(errorHandlerPrefix).append(".").append("appender-ref").toString()};
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    int i;
                    for (i = 0; i < keys.length && !keys[i].equals(entry.getKey()); ++i) {
                    }
                    if (i != keys.length) continue;
                    edited.put(entry.getKey(), entry.getValue());
                }
                PropertySetter.setProperties(eh, edited, new StringBuffer().append(errorHandlerPrefix).append(".").toString());
                LogLog.debug(new StringBuffer().append("End of errorhandler parsing for \"").append(appenderName).append("\".").toString());
            }
            PropertySetter.setProperties(appender, props, new StringBuffer().append(prefix).append(".").toString());
            LogLog.debug(new StringBuffer().append("Parsed \"").append(appenderName).append("\" options.").toString());
        }
        this.parseAppenderFilters(props, appenderName, appender);
        this.registryPut(appender);
        return appender;
    }

    private void parseErrorHandler(ErrorHandler eh, String errorHandlerPrefix, Properties props, LoggerRepository hierarchy) {
        Appender backup;
        String appenderName;
        String loggerName;
        boolean rootRef = OptionConverter.toBoolean(OptionConverter.findAndSubst(new StringBuffer().append(errorHandlerPrefix).append("root-ref").toString(), props), false);
        if (rootRef) {
            eh.setLogger(hierarchy.getRootLogger());
        }
        if ((loggerName = OptionConverter.findAndSubst(new StringBuffer().append(errorHandlerPrefix).append("logger-ref").toString(), props)) != null) {
            Logger logger = this.loggerFactory == null ? hierarchy.getLogger(loggerName) : hierarchy.getLogger(loggerName, this.loggerFactory);
            eh.setLogger(logger);
        }
        if ((appenderName = OptionConverter.findAndSubst(new StringBuffer().append(errorHandlerPrefix).append("appender-ref").toString(), props)) != null && (backup = this.parseAppender(props, appenderName)) != null) {
            eh.setBackupAppender(backup);
        }
    }

    void parseAppenderFilters(Properties props, String appenderName, Appender appender) {
        String filterPrefix = new StringBuffer().append("log4j.appender.").append(appenderName).append(".filter.").toString();
        int fIdx = filterPrefix.length();
        Hashtable filters = new Hashtable();
        Enumeration<Object> e = props.keys();
        String name = "";
        while (e.hasMoreElements()) {
            Vector<NameValue> filterOpts;
            String key = (String)e.nextElement();
            if (!key.startsWith(filterPrefix)) continue;
            int dotIdx = key.indexOf(46, fIdx);
            String filterKey = key;
            if (dotIdx != -1) {
                filterKey = key.substring(0, dotIdx);
                name = key.substring(dotIdx + 1);
            }
            if ((filterOpts = (Vector<NameValue>)filters.get(filterKey)) == null) {
                filterOpts = new Vector<NameValue>();
                filters.put(filterKey, filterOpts);
            }
            if (dotIdx == -1) continue;
            String value = OptionConverter.findAndSubst(key, props);
            filterOpts.add(new NameValue(name, value));
        }
        SortedKeyEnumeration g = new SortedKeyEnumeration(filters);
        while (g.hasMoreElements()) {
            String key = (String)g.nextElement();
            String clazz = props.getProperty(key);
            if (clazz != null) {
                LogLog.debug(new StringBuffer().append("Filter key: [").append(key).append("] class: [").append(props.getProperty(key)).append("] props: ").append(filters.get(key)).toString());
                Filter filter = (Filter)OptionConverter.instantiateByClassName(clazz, class$org$apache$log4j$spi$Filter == null ? PropertyConfigurator.class$("org.jetbrains.kotlin.relocated.org.apache.log4j.spi.Filter") : class$org$apache$log4j$spi$Filter, null);
                if (filter == null) continue;
                PropertySetter propSetter = new PropertySetter(filter);
                Vector v = (Vector)filters.get(key);
                Enumeration filterProps = v.elements();
                while (filterProps.hasMoreElements()) {
                    NameValue kv = (NameValue)filterProps.nextElement();
                    propSetter.setProperty(kv.key, kv.value);
                }
                propSetter.activate();
                LogLog.debug(new StringBuffer().append("Adding filter of type [").append(filter.getClass()).append("] to appender named [").append(appender.getName()).append("].").toString());
                appender.addFilter(filter);
                continue;
            }
            LogLog.warn(new StringBuffer().append("Missing class definition for filter: [").append(key).append("]").toString());
        }
    }

    void registryPut(Appender appender) {
        this.registry.put(appender.getName(), appender);
    }

    Appender registryGet(String name) {
        return (Appender)this.registry.get(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

