/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.inline.util.collectors.InstanceCollector;
import org.jetbrains.kotlin.js.inline.util.collectors.NameCollector;
import org.jetbrains.kotlin.js.inline.util.collectors.PropertyCollector;
import org.jetbrains.kotlin.js.inline.util.collectors.ReferenceNameCollector;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"H\u0006)y2m\u001c7mK\u000e$h)\u001e8di&|gNU3gKJ,gnY3t\u0013:\u001c\u0018\u000eZ3\u000b\u000bM\u001cw\u000e]3\u000b\r)\u001bhj\u001c3f\u0015\r\u0019w.\u001c\u0006\u0007O>|w\r\\3\u000b\t\u0011\f'\u000f\u001e\u0006\tG>l\u0007/\u001b7fe*9!-Y2lK:$'B\u00016t\u0015\r\t7\u000f\u001e\u0006\u0005\u0019&\u001cHO\u0003\u0004l_Rd\u0017N\u001c\u0006\u0007\u0015Nt\u0015-\\3\u000b\t)\fg/\u0019\u0006\u0005kRLGN\u0003\bD_2dWm\u0019;Vi&d7o\u0013;\u000b\u0003QS\u0001cY8mY\u0016\u001cG/\u00138ti\u0006t7-Z:\u000b\u000b-d\u0017m]:\u000b\u000b\rc\u0017m]:\u000b\t1\fgn\u001a\u0006\u0014G>dG.Z2u\u0015N\u0004&o\u001c9feRLWm\u001d\u0006\u0010\u0013\u0012,g\u000e^5us\"\u000b7\u000f['ba*a!j]#yaJ,7o]5p]*\t2m\u001c7mK\u000e$Hj\\2bY:\u000bW.Z:\u000b\u0011\u0019,hn\u0019;j_:T!BS:Gk:\u001cG/[8o\u0015U\u0019w\u000e\u001c7fGRt\u0015-\\3e\rVt7\r^5p]NTqcY8mY\u0016\u001cGOU3gKJ,gnY3t\u0013:\u001c\u0018\u000eZ3\u0013\u0004)\u0011\u0001c\u0001\u0006\u0005\u0011\u0001\u0001BA\u0003\u0003\t\u0003A)!\u0002\u0002\u0005\u0003!\u0019QA\u0001C\u0002\u0011\u000f)!\u0001\u0002\u0002\t\t\u0015\u0011AQ\u0001E\u0005\u000b\r!1\u0001C\u0001\r\u0001\u0015\t\u00012B\u0003\u0004\t\u0011AQ\u0001\u0004\u0001\u0006\u0007\u0011\u0019\u0001B\u0002\u0007\u0001\u000b\u0005Ai!\u0002\u0002\u0005\f!9QA\u0001\u0003\u0007\u0011\u0015)!\u0001B\u0002\t\u0003\u0015\u0011A1\u0002\u0005\u000b\u000b\r!y\u0001c\u0005\r\u0001\u0015\u0011Aq\u0002E\n\u000b\r!a\u0001C\u0006\r\u0001\u0015\u0019Aa\u0001E\f\u0019\u0001)!\u0001\u0002\u0004\t\u0017\u0015\u0019Aa\u0001\u0005\u000e\u0019\u0001)!\u0001B\u0002\t\u001b\u0015]Ba\u0001\r\u0001;\u001f!\u0001\u0001#\u0001\u000e\u0007\u0015\t\u0001r\u0001M\u0004!\u000e\u0001\u0011\u0005C\u0003\u0002\u0011\u0013IA!C\u0002\u0006\u0003!)\u0001$\u0002M\u0005#\u000e)A\u0001A\u0005\u0002\u0011\u001bi\u0011\u0001C\u0004Y\u0007\u001f)A\u0007B\u0002\u0012\r\u0011\u0001\u0001\u0002C\u000b\u0004\u000b\u0005A9\u0001g\u0002\u0019\u0012umA\u0001\u0001\u0005\n\u001b%)\u0011\u0001\u0003\u0005\n\u000b%!QA\u0001C\u0001\u0011\u0001a\u0002\u0001\u0007\u0005Q\u0007\u0001iz\u0001\u0002\u0001\t\u00025\u0019Q!\u0001E\u00041\u000f\u00016\u0011A\u0011\n\u000b\u0005AI!C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001AJ!U\u0002\b\t#I\u0011\u0001#\u0004\u000e\u0003!EQ\"\u0001\u0005\b1\u000e=Q\u0011\t\u0003\u00041+iz\u0001\u0002\u0001\t\u00025\u0019Q!\u0001E\u00041\u000f\u00016\u0001A\u0011\u000e\u000b\u0005A\u0011\"\u0003\u0003\n\u0007\u0015\t\u0001\"\u0002\r\u0006\u0013\u0011I1!B\u0001\t\u0014aM\u0001$C)\u0004\u000b\u0011U\u0011\"\u0001\u0005\u000b\u001b\u0005Aq\u0001WB\b\u000bo!1\u0001\u0007\u0007\u001e\u0010\u0011\u0001\u0001\u0012D\u0007\u0004\u000b\u0005A)\u0002'\u0006Q\u0007\u0001\t\u0003\"B\u0001\t\n%!\u0011bA\u0003\u0002\u0011\u0015AR\u0001'\u0003R\u0007\u0015!A\"C\u0001\t\u000e5\t\u0001b\u0003-\u0004\u0010\u0015\u0005Ca\u0001M\u000e;\u001f!\u0001\u0001#\u0001\u000e\u0007\u0015\t\u0001r\u0001M\u0004!\u000e\u0001\u0011%D\u0003\u0002\u0011%IA!C\u0002\u0006\u0003!)\u0001$B\u0005\u0005\u0013\r)\u0011\u0001#\u0006\u0019\u0016aI\u0011kA\u0003\u0005\u001c%\t\u0001BC\u0007\u0002\u0011\u001dA6qBC\u001c\t\rAb\"h\u0004\u0005\u0001!\u0005QbA\u0003\u0002\u0011\u000fA:\u0001U\u0002\u0001C!)\u0011\u0001#\u0003\n\t%\u0019Q!\u0001\u0005\u00061\u0015AJ!U\u0002\u0006\t9I\u0011\u0001#\u0004\u000e\u0003!9\u0001la\u0004"})
public final class CollectUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JsName> collectFunctionReferencesInside(@NotNull JsNode scope2) {
        void var3_3;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Iterable $receiver2 = CollectUtilsKt.collectReferencesInside(scope2);
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList();
        for (Object element : $receiver) {
            JsName it2 = (JsName)element;
            if (!(MetadataProperties.getStaticRef(it2) instanceof JsFunction)) continue;
            destination.add(element);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final List<JsName> collectReferencesInside(@NotNull JsNode scope2) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        ReferenceNameCollector receiver = new ReferenceNameCollector();
        ReferenceNameCollector $receiver = receiver;
        $receiver.accept(scope2);
        return $receiver.getReferences();
    }

    @NotNull
    public static final List<JsName> collectLocalNames(@NotNull JsFunction function) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        JsFunctionScope functionScope = function.getScope();
        JsScope jsScope = functionScope;
        Intrinsics.checkExpressionValueIsNotNull(jsScope, "functionScope");
        NameCollector receiver = new NameCollector(jsScope);
        NameCollector $receiver = receiver;
        $receiver.accept((JsNode)function.getBody());
        return KotlinPackage.toList((Iterable)$receiver.getNames().values());
    }

    @NotNull
    public static final IdentityHashMap<JsName, JsExpression> collectJsProperties(@NotNull JsNode scope2) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        PropertyCollector collector2 = new PropertyCollector();
        collector2.accept(scope2);
        return collector2.getProperties();
    }

    @NotNull
    public static final IdentityHashMap<JsName, JsFunction> collectNamedFunctions(@NotNull JsNode scope2) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        IdentityHashMap<JsName, JsFunction> namedFunctions = new IdentityHashMap<JsName, JsFunction>();
        Iterator iterator2 = KotlinPackage.iterator((Map)CollectUtilsKt.collectJsProperties(scope2));
        while (iterator2.hasNext()) {
            JsFunction function;
            JsFunction jsFunction;
            Map.Entry entry = iterator2.next();
            JsName name = (JsName)KotlinPackage.component1(entry);
            JsExpression value = (JsExpression)KotlinPackage.component2(entry);
            JsExpression jsExpression = value;
            if (jsExpression instanceof JsFunction) {
                jsFunction = (JsFunction)value;
            } else {
                InlineMetadata inlineMetadata = InlineMetadata.Companion.decompose(value);
                jsFunction = inlineMetadata != null ? inlineMetadata.getFunction() : null;
            }
            if ((function = jsFunction) == null) continue;
            KotlinPackage.set(namedFunctions, name, function);
        }
        return namedFunctions;
    }

    @NotNull
    public static final <T extends JsNode> List<T> collectInstances(@NotNull Class<T> klass, @NotNull JsNode scope2) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        InstanceCollector<JsNode> receiver = new InstanceCollector<JsNode>(klass, false);
        InstanceCollector<JsNode> $receiver = receiver;
        $receiver.accept(scope2);
        return $receiver.getCollected();
    }
}

