/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.LineSeparator;
import java.util.EnumSet;
import java.util.Set;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.relocated.org.fusesource.jansi.Ansi;
import org.jetbrains.kotlin.relocated.org.fusesource.jansi.internal.CLibrary;

public abstract class PlainTextMessageRenderer
implements MessageRenderer {
    private static final boolean COLOR_ENABLED = !SystemInfo.isWindows && CLibrary.isatty(CLibrary.STDERR_FILENO) != 0;
    private static final String LINE_SEPARATOR = LineSeparator.getSystemLineSeparator().getSeparatorString();
    private static final Set<CompilerMessageSeverity> IMPORTANT_MESSAGE_SEVERITIES = EnumSet.of(CompilerMessageSeverity.EXCEPTION, CompilerMessageSeverity.ERROR, CompilerMessageSeverity.WARNING);

    @Override
    public String renderPreamble() {
        return "";
    }

    @Override
    public String render(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer", "render"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer", "render"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer", "render"));
        }
        StringBuilder result2 = new StringBuilder();
        int line = location.getLine();
        int column = location.getColumn();
        String lineContent = location.getLineContent();
        String path = this.getPath(location);
        if (path != null) {
            result2.append(path);
            result2.append(":");
            if (line > 0) {
                result2.append(line).append(":");
                if (column > 0) {
                    result2.append(column).append(":");
                }
            }
            result2.append(" ");
        }
        if (COLOR_ENABLED) {
            String decapitalized;
            int firstNewline;
            Ansi ansi = Ansi.ansi().bold().fg(PlainTextMessageRenderer.severityColor(severity)).a(severity.name().toLowerCase()).a(": ").reset();
            if (IMPORTANT_MESSAGE_SEVERITIES.contains((Object)severity)) {
                ansi.bold();
            }
            if ((firstNewline = (decapitalized = PlainTextMessageRenderer.decapitalizeIfNeeded(message)).indexOf(LINE_SEPARATOR)) < 0) {
                result2.append(ansi.a(decapitalized).reset());
            } else {
                result2.append(ansi.a(decapitalized.substring(0, firstNewline)).reset().a(decapitalized.substring(firstNewline)));
            }
        } else {
            result2.append(severity.name().toLowerCase());
            result2.append(": ");
            result2.append(PlainTextMessageRenderer.decapitalizeIfNeeded(message));
        }
        if (lineContent != null && 1 <= column && column <= lineContent.length() + 1) {
            result2.append(LINE_SEPARATOR);
            result2.append(lineContent);
            result2.append(LINE_SEPARATOR);
            result2.append(KotlinPackage.repeat(" ", column - 1));
            result2.append("^");
        }
        return result2.toString();
    }

    @NotNull
    private static String decapitalizeIfNeeded(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer", "decapitalizeIfNeeded"));
        }
        if (message.startsWith("Java") || message.startsWith("Kotlin")) {
            String string = message;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer", "decapitalizeIfNeeded"));
            }
            return string;
        }
        if (message.length() >= 2 && Character.isUpperCase(message.charAt(0)) && Character.isUpperCase(message.charAt(1))) {
            String string = message;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer", "decapitalizeIfNeeded"));
            }
            return string;
        }
        String string = KotlinPackage.decapitalize(message);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer", "decapitalizeIfNeeded"));
        }
        return string;
    }

    @NotNull
    private static Ansi.Color severityColor(@NotNull CompilerMessageSeverity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer", "severityColor"));
        }
        switch (severity) {
            case EXCEPTION: {
                Ansi.Color color = Ansi.Color.RED;
                if (color == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer", "severityColor"));
                }
                return color;
            }
            case ERROR: {
                Ansi.Color color = Ansi.Color.RED;
                if (color == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer", "severityColor"));
                }
                return color;
            }
            case WARNING: {
                Ansi.Color color = Ansi.Color.YELLOW;
                if (color == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer", "severityColor"));
                }
                return color;
            }
            case INFO: {
                Ansi.Color color = Ansi.Color.BLUE;
                if (color == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer", "severityColor"));
                }
                return color;
            }
            case LOGGING: {
                Ansi.Color color = Ansi.Color.BLUE;
                if (color == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer", "severityColor"));
                }
                return color;
            }
            case OUTPUT: {
                Ansi.Color color = Ansi.Color.BLUE;
                if (color == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer", "severityColor"));
                }
                return color;
            }
        }
        throw new UnsupportedOperationException("Unknown severity: " + (Object)((Object)severity));
    }

    @Nullable
    protected abstract String getPath(@NotNull CompilerMessageLocation var1);

    @Override
    public String renderConclusion() {
        return "";
    }
}

