/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetAnnotatedExpression;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetCallableReferenceExpression;
import org.jetbrains.kotlin.psi.JetClassLiteralExpression;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetDelegatorToSuperCall;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.JetLabeledExpression;
import org.jetbrains.kotlin.psi.JetObjectLiteralExpression;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetPrefixExpression;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetRootPackageExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateEntry;
import org.jetbrains.kotlin.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateExpression;
import org.jetbrains.kotlin.psi.JetSuperExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.JetTypeArgumentList;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TraceEntryFilter;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.calls.CallExpressionResolver;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArgumentsImpl;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.WritableScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.resolve.source.SourcePackage;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.LabelResolver;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.SenselessComparisonChecker;
import org.jetbrains.kotlin.types.expressions.TypeReconstructionUtil;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;
import org.jetbrains.kotlin.utils.ThrowingList;

public class BasicExpressionTypingVisitor
extends ExpressionTypingVisitor {
    private static final TokenSet BARE_TYPES_ALLOWED = TokenSet.create(JetTokens.AS_KEYWORD, JetTokens.AS_SAFE);

    protected BasicExpressionTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "<init>"));
        }
        super(facade);
    }

    @Override
    public JetTypeInfo visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitSimpleNameExpression"));
        }
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        JetTypeInfo typeInfo = callExpressionResolver.getSimpleNameExpressionTypeInfo(expression, ReceiverValue.NO_RECEIVER, null, context2);
        return DataFlowUtils.checkType(typeInfo, (JetExpression)expression, (ResolutionContext)context2);
    }

    @Override
    public JetTypeInfo visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitParenthesizedExpression"));
        }
        JetExpression innerExpression = expression.getExpression();
        if (innerExpression == null) {
            return TypeInfoFactoryPackage.noTypeInfo(context2);
        }
        return this.facade.getTypeInfo(innerExpression, (ExpressionTypingContext)context2.replaceScope(context2.scope));
    }

    @Override
    public JetTypeInfo visitConstantExpression(@NotNull JetConstantExpression expression, ExpressionTypingContext context2) {
        CompileTimeConstantChecker compileTimeConstantChecker;
        boolean hasError;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitConstantExpression"));
        }
        CompileTimeConstant<?> value = ConstantExpressionEvaluator.evaluate(expression, context2.trace, context2.expectedType);
        if (!(value instanceof IntegerValueTypeConstant) && (hasError = (compileTimeConstantChecker = context2.getCompileTimeConstantChecker()).checkConstantExpressionType(value, expression, context2.expectedType))) {
            IElementType elementType = expression.getNode().getElementType();
            return TypeInfoFactoryPackage.createTypeInfo(this.getDefaultType(elementType), context2);
        }
        assert (value != null) : "CompileTimeConstant should be evaluated for constant expression or an error should be recorded " + expression.getText();
        return ExpressionTypingUtils.createCompileTimeConstantTypeInfo(value, expression, context2, this.components.builtIns);
    }

    @NotNull
    public JetType getDefaultType(IElementType constantType) {
        KotlinBuiltIns builtIns = this.components.builtIns;
        if (constantType == JetNodeTypes.INTEGER_CONSTANT) {
            JetType jetType = builtIns.getIntType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.FLOAT_CONSTANT) {
            JetType jetType = builtIns.getDoubleType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.BOOLEAN_CONSTANT) {
            JetType jetType = builtIns.getBooleanType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.CHARACTER_CONSTANT) {
            JetType jetType = builtIns.getCharType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.NULL) {
            JetType jetType = builtIns.getNullableNothingType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getDefaultType"));
            }
            return jetType;
        }
        throw new IllegalArgumentException("Unsupported constant type: " + constantType);
    }

    @Override
    public JetTypeInfo visitBinaryWithTypeRHSExpression(@NotNull JetBinaryExpressionWithTypeRHS expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitBinaryWithTypeRHSExpression"));
        }
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetExpression left = expression.getLeft();
        JetTypeReference right = expression.getRight();
        if (right == null) {
            return this.facade.getTypeInfo(left, contextWithNoExpectedType).clearType();
        }
        IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
        boolean allowBareTypes = BARE_TYPES_ALLOWED.contains(operationType);
        TypeResolutionContext typeResolutionContext = new TypeResolutionContext(context2.scope, context2.trace, true, allowBareTypes);
        PossiblyBareType possiblyBareTarget = this.components.typeResolver.resolvePossiblyBareType(typeResolutionContext, right);
        if (operationType == JetTokens.COLON) {
            assert (!possiblyBareTarget.isBare()) : "Bare types should not be allowed for static assertions, because argument inference makes no sense there";
            JetType targetType = possiblyBareTarget.getActualType();
            JetTypeInfo typeInfo = this.facade.getTypeInfo(left, (ExpressionTypingContext)contextWithNoExpectedType.replaceExpectedType(targetType));
            this.checkBinaryWithTypeRHS(expression, context2, targetType, typeInfo.getType());
            return DataFlowUtils.checkType(typeInfo.replaceType(targetType), (JetExpression)expression, (ResolutionContext)context2);
        }
        JetTypeInfo typeInfo = this.facade.getTypeInfo(left, contextWithNoExpectedType);
        JetType subjectType = typeInfo.getType();
        JetType targetType = TypeReconstructionUtil.reconstructBareType(right, possiblyBareTarget, subjectType, context2.trace, this.components.builtIns);
        if (subjectType != null) {
            this.checkBinaryWithTypeRHS(expression, contextWithNoExpectedType, targetType, subjectType);
            DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
            if (operationType == JetTokens.AS_KEYWORD) {
                DataFlowValue value = DataFlowValueFactory.createDataFlowValue(left, subjectType, context2);
                typeInfo = typeInfo.replaceDataFlowInfo(dataFlowInfo.establishSubtyping(value, targetType));
            }
        }
        JetType result2 = operationType == JetTokens.AS_SAFE ? TypeUtils.makeNullable(targetType) : targetType;
        return DataFlowUtils.checkType(typeInfo.replaceType(result2), (JetExpression)expression, (ResolutionContext)context2);
    }

    private void checkBinaryWithTypeRHS(@NotNull JetBinaryExpressionWithTypeRHS expression, @NotNull ExpressionTypingContext context2, @NotNull JetType targetType, @Nullable JetType actualType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkBinaryWithTypeRHS"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkBinaryWithTypeRHS"));
        }
        if (targetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetType", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkBinaryWithTypeRHS"));
        }
        if (actualType == null) {
            return;
        }
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == JetTokens.COLON) {
            context2.trace.report(Errors.DEPRECATED_STATIC_ASSERT.on(expression));
            return;
        }
        if (operationType != JetTokens.AS_KEYWORD && operationType != JetTokens.AS_SAFE) {
            context2.trace.report(Errors.UNSUPPORTED.on(operationSign, "binary operation with type RHS"));
            return;
        }
        this.checkForCastImpossibilityOrRedundancy(expression, actualType, targetType, context2);
    }

    private void checkForCastImpossibilityOrRedundancy(JetBinaryExpressionWithTypeRHS expression, JetType actualType, JetType targetType, ExpressionTypingContext context2) {
        if (actualType == null || TypeUtils.noExpectedType(targetType) || targetType.isError()) {
            return;
        }
        if (TypesPackage.isDynamic(targetType)) {
            JetTypeReference right = expression.getRight();
            assert (right != null) : "We know target is dynamic, but RHS is missing";
            context2.trace.report(Errors.DYNAMIC_NOT_ALLOWED.on(right));
            return;
        }
        if (!CastDiagnosticsUtil.isCastPossible(actualType, targetType, this.components.platformToKotlinClassMap)) {
            context2.trace.report(Errors.CAST_NEVER_SUCCEEDS.on(expression.getOperationReference()));
            return;
        }
        JetTypeChecker typeChecker = JetTypeChecker.DEFAULT;
        if (((Object)actualType).equals(targetType)) {
            context2.trace.report(Errors.USELESS_CAST.on(expression));
            return;
        }
        Collection<JetType> possibleTypes = DataFlowUtils.getAllPossibleTypes(expression.getLeft(), context2.dataFlowInfo, actualType, context2);
        boolean checkExactType = BasicExpressionTypingVisitor.checkExactTypeForUselessCast(expression);
        for (JetType possibleType : possibleTypes) {
            boolean castIsUseless = checkExactType ? ((Object)possibleType).equals(targetType) : typeChecker.isSubtypeOf(possibleType, targetType);
            if (!castIsUseless) continue;
            context2.trace.report(Errors.USELESS_CAST.on(expression));
            return;
        }
        if (CastDiagnosticsUtil.isCastErased(actualType, targetType, typeChecker)) {
            context2.trace.report(Errors.UNCHECKED_CAST.on(expression, actualType, targetType));
        }
    }

    private static boolean checkExactTypeForUselessCast(JetBinaryExpressionWithTypeRHS expression) {
        PsiElement parent = expression.getParent();
        while (parent instanceof JetParenthesizedExpression || parent instanceof JetLabeledExpression || parent instanceof JetAnnotatedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof JetValueArgument) {
            return true;
        }
        if (parent instanceof JetQualifiedExpression) {
            JetExpression receiver = ((JetQualifiedExpression)parent).getReceiverExpression();
            return PsiTreeUtil.isAncestor(receiver, expression, false);
        }
        return false;
    }

    @Override
    public JetTypeInfo visitThisExpression(@NotNull JetThisExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitThisExpression"));
        }
        JetType result2 = null;
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = BasicExpressionTypingVisitor.resolveToReceiver(expression, context2, false);
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                break;
            }
            case NO_THIS: {
                context2.trace.report(Errors.NO_THIS.on(expression));
                break;
            }
            case SUCCESS: {
                result2 = resolutionResult.getReceiverParameterDescriptor().getType();
                context2.trace.recordType(expression.getInstanceReference(), result2);
            }
        }
        return TypeInfoFactoryPackage.createCheckedTypeInfo(result2, context2, expression);
    }

    @Override
    public JetTypeInfo visitSuperExpression(@NotNull JetSuperExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitSuperExpression"));
        }
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = BasicExpressionTypingVisitor.resolveToReceiver(expression, context2, true);
        if (!JetPsiUtil.isLHSOfDot(expression)) {
            context2.trace.report(Errors.SUPER_IS_NOT_AN_EXPRESSION.on(expression, expression.getText()));
            return this.errorInSuper(expression, context2);
        }
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                return this.errorInSuper(expression, context2);
            }
            case NO_THIS: {
                context2.trace.report(Errors.SUPER_NOT_AVAILABLE.on(expression));
                return this.errorInSuper(expression, context2);
            }
            case SUCCESS: {
                JetType result2 = this.checkPossiblyQualifiedSuper(expression, context2, resolutionResult.getReceiverParameterDescriptor());
                if (result2 != null) {
                    context2.trace.recordType(expression.getInstanceReference(), result2);
                }
                return TypeInfoFactoryPackage.createCheckedTypeInfo(result2, context2, expression);
            }
        }
        throw new IllegalStateException("Unknown code: " + (Object)((Object)resolutionResult.getCode()));
    }

    private JetTypeInfo errorInSuper(JetSuperExpression expression, ExpressionTypingContext context2) {
        JetTypeReference superTypeQualifier = expression.getSuperTypeQualifier();
        if (superTypeQualifier != null) {
            this.components.typeResolver.resolveType(context2.scope, superTypeQualifier, context2.trace, true);
        }
        return TypeInfoFactoryPackage.noTypeInfo(context2);
    }

    private JetType checkPossiblyQualifiedSuper(JetSuperExpression expression, ExpressionTypingContext context2, ReceiverParameterDescriptor thisReceiver) {
        JetTypeReference superTypeQualifier;
        JetType thisType;
        JetType result2;
        block17: {
            TypeSubstitutor substitutor;
            Collection<JetType> supertypes2;
            block14: {
                boolean validType;
                JetTypeArgumentList redundantTypeArguments;
                JetType supertype;
                ClassifierDescriptor classifierCandidate;
                block16: {
                    block15: {
                        result2 = null;
                        thisType = thisReceiver.getType();
                        supertypes2 = thisType.getConstructor().getSupertypes();
                        substitutor = TypeSubstitutor.create(thisType);
                        superTypeQualifier = expression.getSuperTypeQualifier();
                        if (superTypeQualifier == null) break block14;
                        JetTypeElement typeElement = superTypeQualifier.getTypeElement();
                        classifierCandidate = null;
                        supertype = null;
                        redundantTypeArguments = null;
                        if (typeElement instanceof JetUserType) {
                            JetUserType userType = (JetUserType)typeElement;
                            if (userType.getTypeArguments().isEmpty()) {
                                classifierCandidate = this.components.typeResolver.resolveClass(context2.scope, userType, context2.trace);
                            } else {
                                supertype = this.components.typeResolver.resolveType(context2.scope, superTypeQualifier, context2.trace, true);
                                redundantTypeArguments = userType.getTypeArgumentList();
                            }
                        } else {
                            supertype = this.components.typeResolver.resolveType(context2.scope, superTypeQualifier, context2.trace, true);
                        }
                        if (supertype == null) break block15;
                        if (!supertypes2.contains(supertype)) break block16;
                        result2 = supertype;
                        break block16;
                    }
                    if (classifierCandidate instanceof ClassDescriptor) {
                        ClassDescriptor superclass = (ClassDescriptor)classifierCandidate;
                        for (JetType declaredSupertype : supertypes2) {
                            if (!declaredSupertype.getConstructor().equals(superclass.getTypeConstructor())) continue;
                            result2 = substitutor.safeSubstitute(declaredSupertype, Variance.INVARIANT);
                            break;
                        }
                    }
                }
                boolean validClassifier = classifierCandidate != null && !ErrorUtils.isError(classifierCandidate);
                boolean bl = validType = supertype != null && !supertype.isError();
                if (result2 == null && (validClassifier || validType)) {
                    context2.trace.report(Errors.NOT_A_SUPERTYPE.on(superTypeQualifier));
                } else if (redundantTypeArguments != null) {
                    context2.trace.report(Errors.TYPE_ARGUMENTS_REDUNDANT_IN_SUPER_QUALIFIER.on(redundantTypeArguments));
                }
                break block17;
            }
            if (supertypes2.size() > 1) {
                context2.trace.report(Errors.AMBIGUOUS_SUPER.on(expression));
            } else {
                JetType type2 = supertypes2.isEmpty() ? this.components.builtIns.getAnyType() : supertypes2.iterator().next();
                result2 = substitutor.substitute(type2, Variance.INVARIANT);
            }
        }
        if (result2 != null) {
            if (DescriptorUtils.isTrait(thisType.getConstructor().getDeclarationDescriptor()) && DescriptorUtils.isClass(result2.getConstructor().getDeclarationDescriptor())) {
                context2.trace.report(Errors.SUPERCLASS_NOT_ACCESSIBLE_FROM_TRAIT.on(expression));
            }
            context2.trace.recordType(expression.getInstanceReference(), result2);
            context2.trace.record(BindingContext.REFERENCE_TARGET, expression.getInstanceReference(), result2.getConstructor().getDeclarationDescriptor());
        }
        if (superTypeQualifier != null) {
            context2.trace.record(BindingContext.TYPE_RESOLUTION_SCOPE, superTypeQualifier, context2.scope);
        }
        return result2;
    }

    @NotNull
    private static LabelResolver.LabeledReceiverResolutionResult resolveToReceiver(JetInstanceExpressionWithLabel expression, ExpressionTypingContext context2, boolean onlyClassReceivers) {
        Name labelName = expression.getLabelNameAsName();
        if (labelName != null) {
            LabelResolver.LabeledReceiverResolutionResult resolutionResult = LabelResolver.INSTANCE.resolveThisOrSuperLabel(expression, context2, labelName);
            if (resolutionResult.success()) {
                ReceiverParameterDescriptor receiverParameterDescriptor = resolutionResult.getReceiverParameterDescriptor();
                BasicExpressionTypingVisitor.recordThisOrSuperCallInTraceAndCallExtension(context2, receiverParameterDescriptor, expression);
                if (onlyClassReceivers && !BasicExpressionTypingVisitor.isDeclaredInClass(receiverParameterDescriptor)) {
                    LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabelResolver.LabeledReceiverResolutionResult.labelResolutionSuccess(ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER);
                    if (labeledReceiverResolutionResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveToReceiver"));
                    }
                    return labeledReceiverResolutionResult;
                }
            }
            LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = resolutionResult;
            if (labeledReceiverResolutionResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveToReceiver"));
            }
            return labeledReceiverResolutionResult;
        }
        ReceiverParameterDescriptor result2 = ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER;
        List<ReceiverParameterDescriptor> receivers = context2.scope.getImplicitReceiversHierarchy();
        if (onlyClassReceivers) {
            for (ReceiverParameterDescriptor receiver : receivers) {
                if (!BasicExpressionTypingVisitor.isDeclaredInClass(receiver)) continue;
                result2 = receiver;
                break;
            }
        } else if (!receivers.isEmpty()) {
            result2 = receivers.get(0);
        }
        if (result2 != ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER) {
            context2.trace.record(BindingContext.REFERENCE_TARGET, expression.getInstanceReference(), result2.getContainingDeclaration());
            BasicExpressionTypingVisitor.recordThisOrSuperCallInTraceAndCallExtension(context2, result2, expression);
        }
        LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabelResolver.LabeledReceiverResolutionResult.labelResolutionSuccess(result2);
        if (labeledReceiverResolutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveToReceiver"));
        }
        return labeledReceiverResolutionResult;
    }

    private static void recordThisOrSuperCallInTraceAndCallExtension(ExpressionTypingContext context2, ReceiverParameterDescriptor descriptor2, JetExpression expression) {
        BindingTrace trace = context2.trace;
        Call call = CallMaker.makeCall(expression, ReceiverValue.NO_RECEIVER, null, expression, Collections.emptyList());
        ResolutionCandidate<ReceiverParameterDescriptor> resolutionCandidate = ResolutionCandidate.create(call, descriptor2, ReceiverValue.NO_RECEIVER, ReceiverValue.NO_RECEIVER, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null);
        ResolvedCallImpl<ReceiverParameterDescriptor> resolvedCall = ResolvedCallImpl.create(resolutionCandidate, TemporaryBindingTrace.create(trace, "Fake trace for fake 'this' or 'super' resolved call"), TracingStrategy.EMPTY, new DataFlowInfoForArgumentsImpl(call));
        resolvedCall.markCallAsCompleted();
        trace.record(BindingContext.RESOLVED_CALL, call, resolvedCall);
        trace.record(BindingContext.CALL, expression, call);
        BasicCallResolutionContext resolutionContext = BasicCallResolutionContext.create(context2, call, CheckValueArgumentsMode.DISABLED);
        context2.callChecker.check(resolvedCall, resolutionContext);
        context2.symbolUsageValidator.validateCall(descriptor2, trace, expression);
    }

    private static boolean isDeclaredInClass(ReceiverParameterDescriptor receiver) {
        return receiver.getContainingDeclaration() instanceof ClassDescriptor;
    }

    @Override
    public JetTypeInfo visitBlockExpression(@NotNull JetBlockExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitBlockExpression"));
        }
        return this.components.expressionTypingServices.getBlockReturnedType(expression, context2, false);
    }

    @Override
    public JetTypeInfo visitClassLiteralExpression(@NotNull JetClassLiteralExpression expression, ExpressionTypingContext c) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitClassLiteralExpression"));
        }
        JetType type2 = this.resolveClassLiteral(expression, c);
        if (type2 != null && !type2.isError()) {
            return TypeInfoFactoryPackage.createTypeInfo(this.components.reflectionTypes.getKClassType(Annotations.EMPTY, type2), c);
        }
        return TypeInfoFactoryPackage.createTypeInfo(ErrorUtils.createErrorType("Unresolved class"), c);
    }

    @Nullable
    private JetType resolveClassLiteral(@NotNull JetClassLiteralExpression expression, ExpressionTypingContext c) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveClassLiteral"));
        }
        JetTypeReference typeReference = expression.getTypeReference();
        if (typeReference == null) {
            c.trace.report(Errors.UNSUPPORTED.on(expression, "Class literals with empty left hand side are not yet supported"));
            return null;
        }
        TypeResolutionContext context2 = new TypeResolutionContext(c.scope, c.trace, false, true);
        PossiblyBareType possiblyBareType = this.components.typeResolver.resolvePossiblyBareType(context2, typeReference);
        JetType type2 = null;
        if (possiblyBareType.isBare()) {
            ClassifierDescriptor descriptor2;
            if (!possiblyBareType.isNullable() && (descriptor2 = possiblyBareType.getBareTypeConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) {
                ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
                if (KotlinBuiltIns.isNonPrimitiveArray(classDescriptor)) {
                    context2.trace.report(Errors.ARRAY_CLASS_LITERAL_REQUIRES_ARGUMENT.on(expression));
                    return null;
                }
                type2 = BasicExpressionTypingVisitor.substituteWithStarProjections(classDescriptor);
            }
        } else {
            JetType actualType = possiblyBareType.getActualType();
            if (BasicExpressionTypingVisitor.isAllowedInClassLiteral(actualType)) {
                type2 = actualType;
            }
        }
        if (type2 != null) {
            return type2;
        }
        context2.trace.report(Errors.CLASS_LITERAL_LHS_NOT_A_CLASS.on(expression));
        return null;
    }

    @NotNull
    private static JetType substituteWithStarProjections(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "substituteWithStarProjections"));
        }
        TypeConstructor typeConstructor2 = descriptor2.getTypeConstructor();
        List<TypeProjection> arguments2 = KotlinPackage.map(typeConstructor2.getParameters(), new Function1<TypeParameterDescriptor, TypeProjection>(){

            @Override
            public TypeProjection invoke(TypeParameterDescriptor descriptor2) {
                return TypeUtils.makeStarProjection(descriptor2);
            }
        });
        JetTypeImpl jetTypeImpl = new JetTypeImpl(Annotations.EMPTY, typeConstructor2, false, arguments2, descriptor2.getMemberScope(arguments2));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "substituteWithStarProjections"));
        }
        return jetTypeImpl;
    }

    private static boolean isAllowedInClassLiteral(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "isAllowedInClassLiteral"));
        }
        if (type2.isMarkedNullable()) {
            return false;
        }
        TypeConstructor typeConstructor2 = type2.getConstructor();
        if (!(typeConstructor2.getDeclarationDescriptor() instanceof ClassDescriptor)) {
            return false;
        }
        List<TypeParameterDescriptor> parameters2 = typeConstructor2.getParameters();
        if (parameters2.size() != type2.getArguments().size()) {
            return false;
        }
        for (TypeParameterDescriptor parameter : parameters2) {
            if (parameter.isReified()) continue;
            return false;
        }
        return true;
    }

    @Override
    public JetTypeInfo visitCallableReferenceExpression(@NotNull JetCallableReferenceExpression expression, ExpressionTypingContext c) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitCallableReferenceExpression"));
        }
        JetTypeReference typeReference = expression.getTypeReference();
        JetType receiverType = typeReference == null ? null : this.components.typeResolver.resolveType(c.scope, typeReference, c.trace, false);
        JetSimpleNameExpression callableReference = expression.getCallableReference();
        if (callableReference.getReferencedName().isEmpty()) {
            c.trace.report(Errors.UNRESOLVED_REFERENCE.on(callableReference, callableReference));
            JetType errorType = ErrorUtils.createErrorType("Empty callable reference");
            return TypeInfoFactoryPackage.createCheckedTypeInfo(errorType, c, expression);
        }
        JetType result2 = this.getCallableReferenceType(expression, receiverType, c);
        return TypeInfoFactoryPackage.createCheckedTypeInfo(result2, c, expression);
    }

    @Override
    public JetTypeInfo visitObjectLiteralExpression(final @NotNull JetObjectLiteralExpression expression, final ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitObjectLiteralExpression"));
        }
        final JetType[] result2 = new JetType[1];
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(context2.trace, "trace to resolve object literal expression", expression);
        ObservableBindingTrace.RecordHandler<PsiElement, ClassDescriptor> handler = new ObservableBindingTrace.RecordHandler<PsiElement, ClassDescriptor>(){

            @Override
            public void handleRecord(WritableSlice<PsiElement, ClassDescriptor> slice, PsiElement declaration, final ClassDescriptor descriptor2) {
                if (slice == BindingContext.CLASS && declaration == expression.getObjectDeclaration()) {
                    DeferredType defaultType = DeferredType.createRecursionIntolerant(BasicExpressionTypingVisitor.this.components.globalContext.getStorageManager(), context2.trace, new Function0<JetType>(){

                        @Override
                        public JetType invoke() {
                            return descriptor2.getDefaultType();
                        }
                    });
                    result2[0] = defaultType;
                }
            }
        };
        ObservableBindingTrace traceAdapter = new ObservableBindingTrace(temporaryTrace);
        traceAdapter.addHandler(BindingContext.CLASS, handler);
        this.components.localClassifierAnalyzer.processClassOrObject(this.components.globalContext, null, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceBindingTrace(traceAdapter)).replaceContextDependency(ContextDependency.INDEPENDENT), context2.scope.getContainingDeclaration(), expression.getObjectDeclaration(), this.components.additionalCheckerProvider, this.components.dynamicTypesSettings);
        temporaryTrace.commit();
        DataFlowInfo resultFlowInfo = context2.dataFlowInfo;
        for (JetDelegationSpecifier specifier : expression.getObjectDeclaration().getDelegationSpecifiers()) {
            JetDelegatorToSuperCall delegator;
            JetTypeInfo delegatorTypeInfo;
            if (!(specifier instanceof JetDelegatorToSuperCall) || (delegatorTypeInfo = context2.trace.get(BindingContext.EXPRESSION_TYPE_INFO, (delegator = (JetDelegatorToSuperCall)specifier).getCalleeExpression())) == null) continue;
            resultFlowInfo = resultFlowInfo.and(delegatorTypeInfo.getDataFlowInfo());
        }
        JetTypeInfo resultTypeInfo = DataFlowUtils.checkType(TypeInfoFactoryPackage.createTypeInfo(result2[0], resultFlowInfo), (JetExpression)expression, (ResolutionContext)context2);
        context2.trace.record(BindingContext.EXPRESSION_TYPE_INFO, expression, resultTypeInfo);
        context2.trace.record(BindingContext.PROCESSED, expression);
        return resultTypeInfo;
    }

    @Nullable
    private JetType getCallableReferenceType(@NotNull JetCallableReferenceExpression expression, @Nullable JetType lhsType, @NotNull ExpressionTypingContext context2) {
        boolean isExtension;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getCallableReferenceType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getCallableReferenceType"));
        }
        JetSimpleNameExpression reference = expression.getCallableReference();
        boolean[] result2 = new boolean[1];
        CallableDescriptor descriptor2 = this.resolveCallableReferenceTarget(lhsType, (ExpressionTypingContext)context2.replaceContextDependency(ContextDependency.INDEPENDENT), expression, result2);
        if (!result2[0]) {
            context2.trace.report(Errors.UNRESOLVED_REFERENCE.on(reference, reference));
        }
        if (descriptor2 == null) {
            return null;
        }
        ReceiverParameterDescriptor extensionReceiver2 = descriptor2.getExtensionReceiverParameter();
        ReceiverParameterDescriptor dispatchReceiver = descriptor2.getDispatchReceiverParameter();
        if (extensionReceiver2 != null && dispatchReceiver != null && descriptor2 instanceof CallableMemberDescriptor) {
            context2.trace.report(Errors.EXTENSION_IN_CLASS_REFERENCE_NOT_ALLOWED.on(reference, (CallableMemberDescriptor)descriptor2));
            return null;
        }
        JetType receiverType = null;
        if (extensionReceiver2 != null) {
            receiverType = extensionReceiver2.getType();
        } else if (dispatchReceiver != null) {
            receiverType = dispatchReceiver.getType();
        }
        boolean bl = isExtension = extensionReceiver2 != null;
        if (descriptor2 instanceof FunctionDescriptor) {
            return this.createFunctionReferenceType(expression, context2, (FunctionDescriptor)descriptor2, receiverType, isExtension);
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            return this.createPropertyReferenceType(expression, context2, (PropertyDescriptor)descriptor2, receiverType, isExtension);
        }
        if (descriptor2 instanceof VariableDescriptor) {
            context2.trace.report(Errors.UNSUPPORTED.on(reference, "References to variables aren't supported yet"));
            return null;
        }
        throw new UnsupportedOperationException("Callable reference resolved to an unsupported descriptor: " + descriptor2);
    }

    @Nullable
    private JetType createFunctionReferenceType(@NotNull JetCallableReferenceExpression expression, @NotNull ExpressionTypingContext context2, @NotNull FunctionDescriptor descriptor2, @Nullable JetType receiverType, boolean isExtension) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "createFunctionReferenceType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "createFunctionReferenceType"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "createFunctionReferenceType"));
        }
        JetType type2 = this.components.reflectionTypes.getKFunctionType(Annotations.EMPTY, receiverType, ExpressionTypingUtils.getValueParametersTypes(descriptor2.getValueParameters()), descriptor2.getReturnType(), isExtension);
        AnonymousFunctionDescriptor functionDescriptor = new AnonymousFunctionDescriptor(context2.scope.getContainingDeclaration(), Annotations.EMPTY, CallableMemberDescriptor.Kind.DECLARATION, SourcePackage.toSourceElement(expression));
        FunctionDescriptorUtil.initializeFromFunctionType(functionDescriptor, type2, null, Modality.FINAL, Visibilities.PUBLIC);
        context2.trace.record(BindingContext.FUNCTION, expression, functionDescriptor);
        return type2;
    }

    @Nullable
    private JetType createPropertyReferenceType(@NotNull JetCallableReferenceExpression expression, @NotNull ExpressionTypingContext context2, @NotNull PropertyDescriptor descriptor2, @Nullable JetType receiverType, boolean isExtension) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "createPropertyReferenceType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "createPropertyReferenceType"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "createPropertyReferenceType"));
        }
        JetType type2 = this.components.reflectionTypes.getKPropertyType(Annotations.EMPTY, receiverType, descriptor2.getType(), isExtension, descriptor2.isVar());
        LocalVariableDescriptor localVariable = new LocalVariableDescriptor(context2.scope.getContainingDeclaration(), Annotations.EMPTY, Name.special("<anonymous>"), type2, false, SourcePackage.toSourceElement(expression));
        context2.trace.record(BindingContext.VARIABLE, expression, localVariable);
        return type2;
    }

    @Nullable
    private CallableDescriptor resolveCallableReferenceTarget(@Nullable JetType lhsType, @NotNull ExpressionTypingContext context2, @NotNull JetCallableReferenceExpression expression, @NotNull boolean[] result2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveCallableReferenceTarget"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveCallableReferenceTarget"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveCallableReferenceTarget"));
        }
        JetSimpleNameExpression reference = expression.getCallableReference();
        if (lhsType == null) {
            return this.resolveCallableNotCheckingArguments(reference, ReceiverValue.NO_RECEIVER, context2, result2);
        }
        ClassifierDescriptor classifier2 = lhsType.getConstructor().getDeclarationDescriptor();
        if (!(classifier2 instanceof ClassDescriptor)) {
            context2.trace.report(Errors.CALLABLE_REFERENCE_LHS_NOT_A_CLASS.on(expression));
            return null;
        }
        JetScope staticScope = ((ClassDescriptor)classifier2).getStaticScope();
        TemporaryTraceAndCache temporaryForStatic = TemporaryTraceAndCache.create(context2, "trace to resolve callable reference in static scope", reference);
        CallableDescriptor possibleStatic = this.resolveCallableNotCheckingArguments(reference, ReceiverValue.NO_RECEIVER, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceTraceAndCache(temporaryForStatic)).replaceScope(staticScope), result2);
        if (result2[0]) {
            temporaryForStatic.commit();
            return possibleStatic;
        }
        JetScope staticNestedClasses = DescriptorUtils.getStaticNestedClassesScope((ClassDescriptor)classifier2);
        TemporaryTraceAndCache temporaryForNested = TemporaryTraceAndCache.create(context2, "trace to resolve callable reference in static nested classes scope", reference);
        CallableDescriptor possibleNestedClassConstructor = this.resolveCallableNotCheckingArguments(reference, ReceiverValue.NO_RECEIVER, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceTraceAndCache(temporaryForNested)).replaceScope(staticNestedClasses), result2);
        if (result2[0]) {
            temporaryForNested.commit();
            return possibleNestedClassConstructor;
        }
        TransientReceiver receiver = new TransientReceiver(lhsType);
        TemporaryTraceAndCache temporaryWithReceiver = TemporaryTraceAndCache.create(context2, "trace to resolve callable reference with receiver", reference);
        CallableDescriptor descriptor2 = this.resolveCallableNotCheckingArguments(reference, receiver, (ExpressionTypingContext)context2.replaceTraceAndCache(temporaryWithReceiver), result2);
        if (result2[0]) {
            temporaryWithReceiver.commit();
            return descriptor2;
        }
        return null;
    }

    @Nullable
    private CallableDescriptor resolveCallableNotCheckingArguments(@NotNull JetSimpleNameExpression reference, @NotNull ReceiverValue receiver, @NotNull ExpressionTypingContext context2, @NotNull boolean[] result2) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveCallableNotCheckingArguments"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveCallableNotCheckingArguments"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveCallableNotCheckingArguments"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveCallableNotCheckingArguments"));
        }
        Call call = CallMaker.makeCall(reference, receiver, null, reference, ThrowingList.instance());
        TemporaryTraceAndCache temporaryTrace = TemporaryTraceAndCache.create(context2, "trace to resolve callable reference as function", reference);
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(((ExpressionTypingContext)context2.replaceTraceAndCache(temporaryTrace)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE), call, CheckValueArgumentsMode.DISABLED);
        OverloadResolutionResults<CallableDescriptor> results = this.components.callResolver.resolveCallForMember(reference, callResolutionContext);
        if (!results.isNothing()) {
            temporaryTrace.commit();
            result2[0] = true;
            ResolvedCall<CallableDescriptor> callable = OverloadResolutionResultsUtil.getResultingCall(results, context2.contextDependency);
            if (callable != null) {
                return callable.getResultingDescriptor();
            }
        }
        return null;
    }

    @Override
    public JetTypeInfo visitQualifiedExpression(@NotNull JetQualifiedExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitQualifiedExpression"));
        }
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        return callExpressionResolver.getQualifiedExpressionTypeInfo(expression, context2);
    }

    @Override
    public JetTypeInfo visitCallExpression(@NotNull JetCallExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitCallExpression"));
        }
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        return callExpressionResolver.getCallExpressionTypeInfo(expression, ReceiverValue.NO_RECEIVER, null, context2);
    }

    @Override
    public JetTypeInfo visitUnaryExpression(@NotNull JetUnaryExpression expression, ExpressionTypingContext contextWithExpectedType) {
        JetType result2;
        OverloadResolutionResults<FunctionDescriptor> resolutionResults;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitUnaryExpression"));
        }
        ExpressionTypingContext context2 = ExpressionTypingUtils.isUnaryExpressionDependentOnExpectedType(expression) ? contextWithExpectedType : (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression baseExpression = expression.getBaseExpression();
        if (baseExpression == null) {
            return TypeInfoFactoryPackage.noTypeInfo(context2);
        }
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == JetTokens.EXCLEXCL) {
            return this.visitExclExclExpression(expression, context2);
        }
        JetTypeInfo typeInfo = this.facade.safeGetTypeInfo(baseExpression, context2);
        JetType type2 = ExpressionTypingUtils.safeGetType(typeInfo);
        ExpressionReceiver receiver = new ExpressionReceiver(baseExpression, type2);
        Call call = CallMaker.makeCall((ReceiverValue)receiver, expression);
        Name name = (Name)OperatorConventions.UNARY_OPERATION_NAMES.get(operationType);
        if (name == null) {
            context2.trace.report(Errors.UNSUPPORTED.on(operationSign, "visitUnaryExpression"));
            return typeInfo.clearType();
        }
        if ((operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS) && baseExpression instanceof JetArrayAccessExpression) {
            JetExpression stubExpression = ExpressionTypingUtils.createFakeExpressionOfType(baseExpression.getProject(), context2.trace, "$e", type2);
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context2.trace, "trace to resolve array access set method for unary expression", expression);
            ExpressionTypingContext newContext = (ExpressionTypingContext)context2.replaceBindingTrace(temporaryBindingTrace);
            this.resolveArrayAccessSetMethod((JetArrayAccessExpression)baseExpression, stubExpression, newContext, context2.trace);
        }
        if (!(resolutionResults = this.components.callResolver.resolveCallWithGivenName(context2, call, expression.getOperationReference(), name)).isSuccess()) {
            return typeInfo.clearType();
        }
        JetType returnType2 = resolutionResults.getResultingDescriptor().getReturnType();
        if (operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS) {
            assert (returnType2 != null) : "returnType is null for " + resolutionResults.getResultingDescriptor();
            if (KotlinBuiltIns.isUnit(returnType2)) {
                result2 = ErrorUtils.createErrorType(this.components.builtIns.getUnit().getName().asString());
                context2.trace.report(Errors.INC_DEC_SHOULD_NOT_RETURN_UNIT.on(operationSign));
            } else {
                JetType receiverType = receiver.getType();
                if (!JetTypeChecker.DEFAULT.isSubtypeOf(returnType2, receiverType)) {
                    context2.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, name.asString(), receiverType, returnType2));
                } else {
                    context2.trace.record(BindingContext.VARIABLE_REASSIGNMENT, expression);
                    JetExpression stubExpression = ExpressionTypingUtils.createFakeExpressionOfType(baseExpression.getProject(), context2.trace, "$e", type2);
                    this.checkLValue(context2.trace, context2, baseExpression, stubExpression);
                }
                DataFlowValue receiverValue = DataFlowValueFactory.createDataFlowValue(call.getExplicitReceiver(), contextWithExpectedType);
                if (expression instanceof JetPrefixExpression) {
                    result2 = returnType2;
                } else {
                    result2 = receiverType;
                    DataFlowValue returnValue = DataFlowValueFactory.createDataFlowValue(expression, receiverType, contextWithExpectedType);
                    typeInfo = typeInfo.replaceDataFlowInfo(typeInfo.getDataFlowInfo().assign(returnValue, receiverValue));
                }
            }
        } else {
            result2 = returnType2;
        }
        CompileTimeConstant<?> value = ConstantExpressionEvaluator.evaluate(expression, contextWithExpectedType.trace, contextWithExpectedType.expectedType);
        if (value != null) {
            return ExpressionTypingUtils.createCompileTimeConstantTypeInfo(value, expression, contextWithExpectedType, this.components.builtIns);
        }
        return DataFlowUtils.checkType(typeInfo.replaceType(result2), (JetExpression)expression, contextWithExpectedType.replaceDataFlowInfo(typeInfo.getDataFlowInfo()));
    }

    private JetTypeInfo visitExclExclExpression(@NotNull JetUnaryExpression expression, @NotNull ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitExclExclExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitExclExclExpression"));
        }
        JetExpression baseExpression = expression.getBaseExpression();
        assert (baseExpression != null);
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        assert (operationSign.getReferencedNameElementType() == JetTokens.EXCLEXCL);
        Call call = ControlStructureTypingUtils.createCallForSpecialConstruction(expression, expression.getOperationReference(), Collections.singletonList(baseExpression));
        this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(call, "ExclExcl", Collections.singletonList("baseExpr"), Collections.singletonList(true), context2, null);
        JetTypeInfo baseTypeInfo = BindingContextUtils.getRecordedTypeInfo(baseExpression, context2.trace.getBindingContext());
        assert (baseTypeInfo != null) : "Base expression was not processed: " + expression;
        JetType baseType = baseTypeInfo.getType();
        if (baseType == null) {
            return baseTypeInfo;
        }
        DataFlowInfo dataFlowInfo = baseTypeInfo.getDataFlowInfo();
        if (BasicExpressionTypingVisitor.isKnownToBeNotNull(baseExpression, context2) && !baseType.isError()) {
            context2.trace.report(Errors.UNNECESSARY_NOT_NULL_ASSERTION.on(operationSign, baseType));
        } else {
            DataFlowValue value = DataFlowValueFactory.createDataFlowValue(baseExpression, baseType, context2);
            baseTypeInfo = baseTypeInfo.replaceDataFlowInfo(dataFlowInfo.disequate(value, DataFlowValue.NULL));
        }
        JetType resultingType = TypeUtils.makeNotNullable(baseType);
        if (context2.contextDependency == ContextDependency.DEPENDENT) {
            return baseTypeInfo.replaceType(resultingType);
        }
        return DataFlowUtils.checkType(baseTypeInfo.replaceType(resultingType), (JetExpression)expression, context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
    }

    @Override
    public JetTypeInfo visitLabeledExpression(@NotNull JetLabeledExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
        }
        return this.visitLabeledExpression(expression, context2, false);
    }

    @NotNull
    public JetTypeInfo visitLabeledExpression(@NotNull JetLabeledExpression expression, @NotNull ExpressionTypingContext context2, boolean isStatement) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
        }
        JetExpression baseExpression = expression.getBaseExpression();
        if (baseExpression == null) {
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context2);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = this.facade.getTypeInfo(baseExpression, context2, isStatement);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
        }
        return jetTypeInfo;
    }

    private static boolean isKnownToBeNotNull(JetExpression expression, ExpressionTypingContext context2) {
        JetType type2 = context2.trace.getType(expression);
        assert (type2 != null) : "This method is only supposed to be called when the type is not null";
        return BasicExpressionTypingVisitor.isKnownToBeNotNull(expression, type2, context2);
    }

    private static boolean isKnownToBeNotNull(JetExpression expression, JetType jetType, ExpressionTypingContext context2) {
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, jetType, context2);
        return !context2.dataFlowInfo.getNullability(dataFlowValue).canBeNull();
    }

    public boolean checkLValue(@NotNull BindingTrace trace, @NotNull ExpressionTypingContext context2, @NotNull JetExpression expression, @Nullable JetExpression rightHandSide) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        return this.checkLValue(trace, context2, expression, rightHandSide, false);
    }

    private boolean checkLValue(@NotNull BindingTrace trace, @NotNull ExpressionTypingContext context2, @NotNull JetExpression expressionWithParenthesis, @Nullable JetExpression rightHandSide, boolean canBeThis) {
        JetExpression reportOn;
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        if (expressionWithParenthesis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionWithParenthesis", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        JetExpression expression = JetPsiUtil.deparenthesize(expressionWithParenthesis);
        if (expression instanceof JetArrayAccessExpression) {
            JetArrayAccessExpression arrayAccessExpression = (JetArrayAccessExpression)expression;
            JetExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            if (arrayExpression == null || rightHandSide == null) {
                return false;
            }
            TemporaryBindingTrace ignoreReportsTrace = TemporaryBindingTrace.create(trace, "Trace for checking set function");
            ExpressionTypingContext findSetterContext = (ExpressionTypingContext)context2.replaceBindingTrace(ignoreReportsTrace);
            JetTypeInfo info = this.resolveArrayAccessSetMethod(arrayAccessExpression, rightHandSide, findSetterContext, ignoreReportsTrace);
            return info.getType() != null;
        }
        if (canBeThis && expression instanceof JetThisExpression) {
            return true;
        }
        VariableDescriptor variable2 = BindingContextUtils.extractVariableDescriptorIfAny(trace.getBindingContext(), expression, true);
        boolean result2 = true;
        JetExpression jetExpression = reportOn = expression != null ? expression : expressionWithParenthesis;
        if (reportOn instanceof JetQualifiedExpression) {
            reportOn = ((JetQualifiedExpression)reportOn).getSelectorExpression();
        }
        if (variable2 instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variable2;
            PropertySetterDescriptor setter2 = propertyDescriptor.getSetter();
            if (propertyDescriptor.isSetterProjectedOut()) {
                trace.report(Errors.SETTER_PROJECTED_OUT.on(reportOn, propertyDescriptor));
                result2 = false;
            } else if (setter2 != null) {
                context2.symbolUsageValidator.validateCall(setter2, trace, reportOn);
            }
        }
        if (variable2 == null) {
            trace.report(Errors.VARIABLE_EXPECTED.on(reportOn));
            result2 = false;
        } else if (!variable2.isVar()) {
            result2 = false;
        }
        return result2;
    }

    @Override
    public JetTypeInfo visitBinaryExpression(@NotNull JetBinaryExpression expression, ExpressionTypingContext contextWithExpectedType) {
        JetTypeInfo result2;
        Name referencedName;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitBinaryExpression"));
        }
        ExpressionTypingContext context2 = ExpressionTypingUtils.isBinaryExpressionDependentOnExpectedType(expression) ? contextWithExpectedType : (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        JetExpression left = expression.getLeft();
        JetExpression right = expression.getRight();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == JetTokens.IDENTIFIER) {
            referencedName = operationSign.getReferencedNameAsName();
            result2 = this.getTypeInfoForBinaryCall(referencedName, context2, expression);
        } else if (OperatorConventions.BINARY_OPERATION_NAMES.containsKey(operationType)) {
            referencedName = (Name)OperatorConventions.BINARY_OPERATION_NAMES.get(operationType);
            result2 = this.getTypeInfoForBinaryCall(referencedName, context2, expression);
        } else {
            if (operationType == JetTokens.ELVIS) {
                return this.visitElvisExpression(expression, context2);
            }
            if (operationType == JetTokens.EQ) {
                result2 = this.visitAssignment(expression, context2);
            } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType)) {
                result2 = this.visitAssignmentOperation(expression, context2);
            } else if (OperatorConventions.COMPARISON_OPERATIONS.contains(operationType)) {
                result2 = this.visitComparison(expression, context2, operationSign);
            } else if (OperatorConventions.EQUALS_OPERATIONS.contains(operationType)) {
                result2 = this.visitEquality(expression, context2, operationSign, left, right);
            } else if (OperatorConventions.IDENTITY_EQUALS_OPERATIONS.contains(operationType)) {
                context2.trace.record(BindingContext.REFERENCE_TARGET, operationSign, this.components.builtIns.getIdentityEquals());
                this.ensureNonemptyIntersectionOfOperandTypes(expression, context2);
                result2 = TypeInfoFactoryPackage.createTypeInfo(this.components.builtIns.getBooleanType(), context2);
            } else if (OperatorConventions.IN_OPERATIONS.contains(operationType)) {
                ValueArgument leftArgument = CallMaker.makeValueArgument(left, left != null ? left : operationSign);
                result2 = this.checkInExpression(expression, operationSign, leftArgument, right, context2);
            } else if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey(operationType)) {
                result2 = this.visitBooleanOperationExpression(operationType, left, right, context2);
            } else {
                context2.trace.report(Errors.UNSUPPORTED.on(operationSign, "Unknown operation"));
                result2 = TypeInfoFactoryPackage.noTypeInfo(context2);
            }
        }
        CompileTimeConstant<?> value = ConstantExpressionEvaluator.evaluate(expression, contextWithExpectedType.trace, contextWithExpectedType.expectedType);
        if (value != null) {
            return ExpressionTypingUtils.createCompileTimeConstantTypeInfo(value, expression, contextWithExpectedType, this.components.builtIns);
        }
        return DataFlowUtils.checkType(result2, (JetExpression)expression, (ResolutionContext)contextWithExpectedType);
    }

    private JetTypeInfo visitEquality(JetBinaryExpression expression, ExpressionTypingContext context2, JetSimpleNameExpression operationSign, final JetExpression left, final JetExpression right) {
        if (right == null || left == null) {
            ExpressionTypingUtils.getTypeInfoOrNullType(right, context2, this.facade);
            ExpressionTypingUtils.getTypeInfoOrNullType(left, context2, this.facade);
            return TypeInfoFactoryPackage.createTypeInfo(this.components.builtIns.getBooleanType(), context2);
        }
        JetTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, context2, this.facade);
        DataFlowInfo dataFlowInfo = leftTypeInfo.getDataFlowInfo();
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo);
        JetTypeInfo rightTypeInfo = this.facade.getTypeInfo(right, contextWithDataFlow);
        TemporaryBindingTrace traceInterpretingRightAsNullableAny = TemporaryBindingTrace.create(context2.trace, "trace to resolve 'equals(Any?)' interpreting as of type Any? an expression:", right);
        traceInterpretingRightAsNullableAny.recordType(right, this.components.builtIns.getNullableAnyType());
        JetType leftType = leftTypeInfo.getType();
        if (leftType != null && KotlinBuiltIns.isNothingOrNullableNothing(leftType)) {
            traceInterpretingRightAsNullableAny.recordType(left, this.components.builtIns.getNullableAnyType());
        }
        ExpressionTypingContext newContext = (ExpressionTypingContext)context2.replaceBindingTrace(traceInterpretingRightAsNullableAny);
        ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, newContext);
        Call call = CallMaker.makeCallWithExpressions(expression, receiver, new JetPsiFactory(expression.getProject()).createSafeCallNode(), operationSign, Collections.singletonList(right));
        OverloadResolutionResults<FunctionDescriptor> resolutionResults = this.components.callResolver.resolveCallWithGivenName(newContext, call, operationSign, OperatorConventions.EQUALS);
        traceInterpretingRightAsNullableAny.commit(new TraceEntryFilter(){

            @Override
            public boolean accept(@Nullable WritableSlice<?, ?> slice, Object key) {
                if ((key == right || key == left) && slice == BindingContext.EXPRESSION_TYPE_INFO) {
                    return false;
                }
                return key != left || slice != BindingContext.SMARTCAST;
            }
        }, true);
        if (resolutionResults.isSuccess()) {
            FunctionDescriptor equals = resolutionResults.getResultingCall().getResultingDescriptor();
            if (this.ensureBooleanResult(operationSign, OperatorConventions.EQUALS, equals.getReturnType(), context2)) {
                this.ensureNonemptyIntersectionOfOperandTypes(expression, context2);
            }
        } else if (resolutionResults.isAmbiguity()) {
            context2.trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on(operationSign, resolutionResults.getResultingCalls()));
        } else {
            context2.trace.report(Errors.EQUALS_MISSING.on(operationSign));
        }
        return rightTypeInfo.replaceType(this.components.builtIns.getBooleanType());
    }

    @NotNull
    private JetTypeInfo visitComparison(@NotNull JetBinaryExpression expression, @NotNull ExpressionTypingContext context2, @NotNull JetSimpleNameExpression operationSign) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitComparison"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitComparison"));
        }
        if (operationSign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationSign", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitComparison"));
        }
        JetTypeInfo typeInfo = this.getTypeInfoForBinaryCall(OperatorConventions.COMPARE_TO, context2, expression);
        JetType compareToReturnType = typeInfo.getType();
        JetType type2 = null;
        if (compareToReturnType != null && !compareToReturnType.isError()) {
            if (JetTypeChecker.DEFAULT.equalTypes(this.components.builtIns.getIntType(), compareToReturnType)) {
                type2 = this.components.builtIns.getBooleanType();
            } else {
                context2.trace.report(Errors.COMPARE_TO_TYPE_MISMATCH.on(operationSign, compareToReturnType));
            }
        }
        JetTypeInfo jetTypeInfo = typeInfo.replaceType(type2);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitComparison"));
        }
        return jetTypeInfo;
    }

    @NotNull
    private JetTypeInfo visitBooleanOperationExpression(@Nullable IElementType operationType, @Nullable JetExpression left, @Nullable JetExpression right, @NotNull ExpressionTypingContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitBooleanOperationExpression"));
        }
        JetType booleanType = this.components.builtIns.getBooleanType();
        JetTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, (ExpressionTypingContext)context2.replaceExpectedType(booleanType), this.facade);
        DataFlowInfo dataFlowInfo = leftTypeInfo.getDataFlowInfo();
        WritableScopeImpl leftScope = ExpressionTypingUtils.newWritableScopeImpl(context2, "Left scope of && or ||");
        boolean isAnd = operationType == JetTokens.ANDAND;
        DataFlowInfo flowInfoLeft = DataFlowUtils.extractDataFlowInfoFromCondition(left, isAnd, context2).and(dataFlowInfo);
        WritableScopeImpl rightScope = isAnd ? leftScope : ExpressionTypingUtils.newWritableScopeImpl(context2, "Right scope of && or ||");
        ExpressionTypingContext contextForRightExpr = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceDataFlowInfo(flowInfoLeft)).replaceScope(rightScope)).replaceExpectedType(booleanType);
        if (right != null) {
            this.facade.getTypeInfo(right, contextForRightExpr);
        }
        JetTypeInfo jetTypeInfo = leftTypeInfo.replaceType(booleanType);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitBooleanOperationExpression"));
        }
        return jetTypeInfo;
    }

    @NotNull
    private JetTypeInfo visitElvisExpression(@NotNull JetBinaryExpression expression, @NotNull ExpressionTypingContext contextWithExpectedType) {
        JetType type2;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
        }
        if (contextWithExpectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextWithExpectedType", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
        }
        ExpressionTypingContext context2 = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression left = expression.getLeft();
        JetExpression right = expression.getRight();
        if (left == null || right == null) {
            ExpressionTypingUtils.getTypeInfoOrNullType(left, context2, this.facade);
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context2);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
            }
            return jetTypeInfo;
        }
        Call call = ControlStructureTypingUtils.createCallForSpecialConstruction(expression, expression.getOperationReference(), Lists.newArrayList(left, right));
        ResolvedCall<FunctionDescriptor> resolvedCall = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(call, "Elvis", Lists.newArrayList("left", "right"), Lists.newArrayList(true, false), contextWithExpectedType, null);
        JetTypeInfo leftTypeInfo = BindingContextUtils.getRecordedTypeInfo(left, context2.trace.getBindingContext());
        assert (leftTypeInfo != null) : "Left expression was not processed: " + expression;
        JetType leftType = leftTypeInfo.getType();
        if (leftType != null && BasicExpressionTypingVisitor.isKnownToBeNotNull(left, leftType, context2)) {
            context2.trace.report(Errors.USELESS_ELVIS.on(left, leftType));
        }
        JetTypeInfo rightTypeInfo = BindingContextUtils.getRecordedTypeInfo(right, context2.trace.getBindingContext());
        assert (rightTypeInfo != null) : "Right expression was not processed: " + expression;
        boolean loopBreakContinuePossible = leftTypeInfo.getJumpOutPossible() || rightTypeInfo.getJumpOutPossible();
        JetType rightType = rightTypeInfo.getType();
        DataFlowInfo dataFlowInfo = resolvedCall.getDataFlowInfoForArguments().getResultInfo();
        if (leftType != null && rightType != null && KotlinBuiltIns.isNothingOrNullableNothing(rightType) && !rightType.isMarkedNullable()) {
            DataFlowValue value = DataFlowValueFactory.createDataFlowValue(left, leftType, context2);
            dataFlowInfo = dataFlowInfo.disequate(value, DataFlowValue.NULL);
        }
        if ((type2 = resolvedCall.getResultingDescriptor().getReturnType()) == null || rightType == null) {
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
            }
            return jetTypeInfo;
        }
        if (!TypeUtils.isNullableType(rightType) && TypeUtils.isNullableType(type2)) {
            type2 = TypeUtils.makeNotNullable(type2);
        }
        if (context2.contextDependency == ContextDependency.DEPENDENT) {
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.createTypeInfo(type2, dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.createTypeInfo(DataFlowUtils.checkType(type2, (JetExpression)expression, (ResolutionContext)context2), dataFlowInfo, loopBreakContinuePossible, context2.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo checkInExpression(@NotNull JetElement callElement, @NotNull JetSimpleNameExpression operationSign, @NotNull ValueArgument leftArgument, @Nullable JetExpression right, @NotNull ExpressionTypingContext context2) {
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        if (operationSign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationSign", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        if (leftArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftArgument", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        JetExpression left = leftArgument.getArgumentExpression();
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        if (right == null) {
            if (left != null) {
                this.facade.getTypeInfo(left, contextWithNoExpectedType);
            }
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context2);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo rightTypeInfo = this.facade.getTypeInfo(right, contextWithNoExpectedType);
        DataFlowInfo dataFlowInfo = rightTypeInfo.getDataFlowInfo();
        ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, right, contextWithNoExpectedType);
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo);
        OverloadResolutionResults<FunctionDescriptor> resolutionResult = this.components.callResolver.resolveCallWithGivenName(contextWithDataFlow, CallMaker.makeCall(callElement, receiver, null, operationSign, Collections.singletonList(leftArgument)), operationSign, OperatorConventions.CONTAINS);
        JetType containsType = OverloadResolutionResultsUtil.getResultingType(resolutionResult, context2.contextDependency);
        this.ensureBooleanResult(operationSign, OperatorConventions.CONTAINS, containsType, context2);
        if (left != null) {
            dataFlowInfo = this.facade.getTypeInfo(left, contextWithDataFlow).getDataFlowInfo().and(dataFlowInfo);
            rightTypeInfo = rightTypeInfo.replaceDataFlowInfo(dataFlowInfo);
        }
        if (resolutionResult.isSuccess()) {
            JetTypeInfo jetTypeInfo = rightTypeInfo.replaceType(this.components.builtIns.getBooleanType());
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = rightTypeInfo.clearType();
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        return jetTypeInfo;
    }

    private boolean ensureBooleanResult(JetExpression operationSign, Name name, JetType resultType, ExpressionTypingContext context2) {
        return this.ensureBooleanResultWithCustomSubject(operationSign, resultType, "'" + name + "'", context2);
    }

    private boolean ensureBooleanResultWithCustomSubject(JetExpression operationSign, JetType resultType, String subjectName, ExpressionTypingContext context2) {
        if (resultType != null && !this.components.builtIns.isBooleanOrSubtype(resultType)) {
            context2.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, subjectName, this.components.builtIns.getBooleanType(), resultType));
            return false;
        }
        return true;
    }

    private void ensureNonemptyIntersectionOfOperandTypes(JetBinaryExpression expression, final ExpressionTypingContext context2) {
        JetType rightType;
        JetExpression left = expression.getLeft();
        if (left == null) {
            return;
        }
        JetExpression right = expression.getRight();
        JetType leftType = this.facade.getTypeInfo(left, context2).getType();
        if (leftType != null && right != null && (rightType = this.facade.getTypeInfo(right, context2).getType()) != null) {
            if (TypeUtils.isIntersectionEmpty(leftType, rightType)) {
                context2.trace.report(Errors.EQUALITY_NOT_APPLICABLE.on(expression, expression.getOperationReference(), leftType, rightType));
            }
            SenselessComparisonChecker.checkSenselessComparisonWithNull(expression, left, right, context2, (Function1<? super JetExpression, ? extends JetType>)new Function1<JetExpression, JetType>(){

                @Override
                public JetType invoke(JetExpression expression) {
                    return BasicExpressionTypingVisitor.this.facade.getTypeInfo(expression, context2).getType();
                }
            }, (Function1<? super DataFlowValue, ? extends Nullability>)new Function1<DataFlowValue, Nullability>(){

                @Override
                public Nullability invoke(DataFlowValue value) {
                    return context2.dataFlowInfo.getNullability(value);
                }
            });
        }
    }

    @NotNull
    private JetTypeInfo visitAssignmentOperation(JetBinaryExpression expression, ExpressionTypingContext context2) {
        JetTypeInfo jetTypeInfo = this.assignmentIsNotAnExpressionError(expression, context2);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitAssignmentOperation"));
        }
        return jetTypeInfo;
    }

    @NotNull
    private JetTypeInfo visitAssignment(JetBinaryExpression expression, ExpressionTypingContext context2) {
        JetTypeInfo jetTypeInfo = this.assignmentIsNotAnExpressionError(expression, context2);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitAssignment"));
        }
        return jetTypeInfo;
    }

    @NotNull
    private JetTypeInfo assignmentIsNotAnExpressionError(JetBinaryExpression expression, ExpressionTypingContext context2) {
        this.facade.checkStatementType(expression, context2);
        context2.trace.report(Errors.ASSIGNMENT_IN_EXPRESSION_CONTEXT.on(expression));
        JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context2);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "assignmentIsNotAnExpressionError"));
        }
        return jetTypeInfo;
    }

    @Override
    public JetTypeInfo visitArrayAccessExpression(@NotNull JetArrayAccessExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitArrayAccessExpression"));
        }
        return DataFlowUtils.checkType(this.resolveArrayAccessGetMethod(expression, context2), (JetExpression)expression, (ResolutionContext)context2);
    }

    @NotNull
    public JetTypeInfo getTypeInfoForBinaryCall(@NotNull Name name, @NotNull ExpressionTypingContext context2, @NotNull JetBinaryExpression binaryExpression) {
        OverloadResolutionResults<Object> resolutionResults;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getTypeInfoForBinaryCall"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getTypeInfoForBinaryCall"));
        }
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getTypeInfoForBinaryCall"));
        }
        JetExpression left = binaryExpression.getLeft();
        JetTypeInfo typeInfo = left != null ? this.facade.getTypeInfo(left, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)) : TypeInfoFactoryPackage.noTypeInfo(context2);
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context2.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        if (left != null) {
            ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, context2);
            resolutionResults = this.components.callResolver.resolveBinaryCall((ExpressionTypingContext)contextWithDataFlow.replaceScope(context2.scope), receiver, binaryExpression, name);
        } else {
            resolutionResults = OverloadResolutionResultsImpl.nameNotFound();
        }
        if (resolutionResults.isSingleResult()) {
            typeInfo = typeInfo.replaceDataFlowInfo(resolutionResults.getResultingCall().getDataFlowInfoForArguments().getResultInfo());
        }
        JetTypeInfo jetTypeInfo = typeInfo.replaceType(OverloadResolutionResultsUtil.getResultingType(resolutionResults, context2.contextDependency));
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "getTypeInfoForBinaryCall"));
        }
        return jetTypeInfo;
    }

    @Override
    public JetTypeInfo visitDeclaration(@NotNull JetDeclaration dcl, ExpressionTypingContext context2) {
        if (dcl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dcl", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitDeclaration"));
        }
        context2.trace.report(Errors.DECLARATION_IN_ILLEGAL_CONTEXT.on(dcl));
        return TypeInfoFactoryPackage.noTypeInfo(context2);
    }

    @Override
    public JetTypeInfo visitRootPackageExpression(@NotNull JetRootPackageExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitRootPackageExpression"));
        }
        if (!JetPsiUtil.isLHSOfDot(expression)) {
            context2.trace.report(Errors.PACKAGE_IS_NOT_AN_EXPRESSION.on(expression));
        }
        return TypeInfoFactoryPackage.noTypeInfo(context2);
    }

    @Override
    public JetTypeInfo visitStringTemplateExpression(@NotNull JetStringTemplateExpression expression, ExpressionTypingContext contextWithExpectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitStringTemplateExpression"));
        }
        final ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        class StringTemplateVisitor
        extends JetVisitorVoid {
            private JetTypeInfo typeInfo;

            StringTemplateVisitor() {
                this.typeInfo = TypeInfoFactoryPackage.noTypeInfo(context2);
            }

            @Override
            public void visitStringTemplateEntryWithExpression(@NotNull JetStringTemplateEntryWithExpression entry) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor$1StringTemplateVisitor", "visitStringTemplateEntryWithExpression"));
                }
                JetExpression entryExpression = entry.getExpression();
                if (entryExpression != null) {
                    this.typeInfo = BasicExpressionTypingVisitor.this.facade.getTypeInfo(entryExpression, (ExpressionTypingContext)context2.replaceDataFlowInfo(this.typeInfo.getDataFlowInfo()));
                }
            }

            @Override
            public void visitEscapeStringTemplateEntry(@NotNull JetEscapeStringTemplateEntry entry) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor$1StringTemplateVisitor", "visitEscapeStringTemplateEntry"));
                }
                CompileTimeConstantChecker.CharacterWithDiagnostic value = CompileTimeConstantChecker.escapedStringToCharacter(entry.getText(), entry);
                Diagnostic diagnostic = value.getDiagnostic();
                if (diagnostic != null) {
                    context2.trace.report(diagnostic);
                }
            }
        }
        StringTemplateVisitor visitor2 = new StringTemplateVisitor();
        for (JetStringTemplateEntry entry : expression.getEntries()) {
            entry.accept(visitor2);
        }
        ConstantExpressionEvaluator.evaluate(expression, context2.trace, contextWithExpectedType.expectedType);
        return DataFlowUtils.checkType(visitor2.typeInfo.replaceType(this.components.builtIns.getStringType()), (JetExpression)expression, (ResolutionContext)contextWithExpectedType);
    }

    @Override
    public JetTypeInfo visitAnnotatedExpression(@NotNull JetAnnotatedExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitAnnotatedExpression"));
        }
        return this.visitAnnotatedExpression(expression, context2, false);
    }

    public JetTypeInfo visitAnnotatedExpression(JetAnnotatedExpression expression, ExpressionTypingContext context2, boolean isStatement) {
        AnnotationResolver.reportDeprecatedAnnotationSyntax(expression.getAnnotations(), context2.trace);
        this.components.annotationResolver.resolveAnnotationsWithArguments(context2.scope, expression.getAnnotationEntries(), context2.trace);
        JetExpression baseExpression = expression.getBaseExpression();
        if (baseExpression == null) {
            return TypeInfoFactoryPackage.noTypeInfo(context2);
        }
        return this.facade.getTypeInfo(baseExpression, context2, isStatement);
    }

    @Override
    public JetTypeInfo visitJetElement(@NotNull JetElement element, ExpressionTypingContext context2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "visitJetElement"));
        }
        context2.trace.report(Errors.UNSUPPORTED.on(element, this.getClass().getCanonicalName()));
        return TypeInfoFactoryPackage.noTypeInfo(context2);
    }

    @NotNull
    JetTypeInfo resolveArrayAccessSetMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @NotNull JetExpression rightHandSide, @NotNull ExpressionTypingContext context2, @NotNull BindingTrace traceForResolveResult) {
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        if (rightHandSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightHandSide", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        if (traceForResolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceForResolveResult", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        JetTypeInfo jetTypeInfo = this.resolveArrayAccessSpecialMethod(arrayAccessExpression, rightHandSide, context2, traceForResolveResult, false);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        return jetTypeInfo;
    }

    @NotNull
    JetTypeInfo resolveArrayAccessGetMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @NotNull ExpressionTypingContext context2) {
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessGetMethod"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessGetMethod"));
        }
        JetTypeInfo jetTypeInfo = this.resolveArrayAccessSpecialMethod(arrayAccessExpression, null, context2, context2.trace, true);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessGetMethod"));
        }
        return jetTypeInfo;
    }

    @NotNull
    private JetTypeInfo resolveArrayAccessSpecialMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @Nullable JetExpression rightHandSide, @NotNull ExpressionTypingContext oldContext, @NotNull BindingTrace traceForResolveResult, boolean isGet) {
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
        }
        if (oldContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldContext", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
        }
        if (traceForResolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceForResolveResult", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
        }
        JetExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        if (arrayExpression == null) {
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(oldContext);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo arrayTypeInfo = this.facade.safeGetTypeInfo(arrayExpression, (ExpressionTypingContext)((ExpressionTypingContext)oldContext.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        JetType arrayType = ExpressionTypingUtils.safeGetType(arrayTypeInfo);
        ExpressionTypingContext context2 = (ExpressionTypingContext)oldContext.replaceDataFlowInfo(arrayTypeInfo.getDataFlowInfo());
        ExpressionReceiver receiver = new ExpressionReceiver(arrayExpression, arrayType);
        if (!isGet) assert (rightHandSide != null);
        Call call = isGet ? CallMaker.makeArrayGetCall(receiver, arrayAccessExpression, Call.CallType.ARRAY_GET_METHOD) : CallMaker.makeArraySetCall(receiver, arrayAccessExpression, rightHandSide, Call.CallType.ARRAY_SET_METHOD);
        OverloadResolutionResults<FunctionDescriptor> functionResults = this.components.callResolver.resolveCallWithGivenName(context2, call, arrayAccessExpression, Name.identifier(isGet ? "get" : "set"));
        List<JetExpression> indices = arrayAccessExpression.getIndexExpressions();
        JetTypeInfo resultTypeInfo = arrayTypeInfo;
        if (!indices.isEmpty()) {
            resultTypeInfo = this.facade.getTypeInfo(indices.get(indices.size() - 1), context2);
        }
        if (!isGet) {
            resultTypeInfo = this.facade.getTypeInfo(rightHandSide, context2);
        }
        if (!functionResults.isSingleResult()) {
            traceForResolveResult.report(isGet ? Errors.NO_GET_METHOD.on(arrayAccessExpression) : Errors.NO_SET_METHOD.on(arrayAccessExpression));
            JetTypeInfo jetTypeInfo = resultTypeInfo.clearType();
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
            }
            return jetTypeInfo;
        }
        traceForResolveResult.record(isGet ? BindingContext.INDEXED_LVALUE_GET : BindingContext.INDEXED_LVALUE_SET, arrayAccessExpression, functionResults.getResultingCall());
        JetTypeInfo jetTypeInfo = resultTypeInfo.replaceType(functionResults.getResultingDescriptor().getReturnType());
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
        }
        return jetTypeInfo;
    }
}

