/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.storage;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNullable;
import org.jetbrains.kotlin.storage.NoLock;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.utils.UtilsPackage;
import org.jetbrains.kotlin.utils.WrappedValues;

public class LockBasedStorageManager
implements StorageManager {
    public static final StorageManager NO_LOCKS = new LockBasedStorageManager("NO_LOCKS", ExceptionHandlingStrategy.THROW, NoLock.INSTANCE){

        @Override
        @NotNull
        protected <T> RecursionDetectedResult<T> recursionDetectedDefault() {
            RecursionDetectedResult recursionDetectedResult = RecursionDetectedResult.fallThrough();
            if (recursionDetectedResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager$1", "recursionDetectedDefault"));
            }
            return recursionDetectedResult;
        }
    };
    protected final Lock lock;
    private final ExceptionHandlingStrategy exceptionHandlingStrategy;
    private final String debugText;

    @NotNull
    public static LockBasedStorageManager createWithExceptionHandling(@NotNull ExceptionHandlingStrategy exceptionHandlingStrategy) {
        if (exceptionHandlingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionHandlingStrategy", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createWithExceptionHandling"));
        }
        LockBasedStorageManager lockBasedStorageManager = new LockBasedStorageManager(exceptionHandlingStrategy);
        if (lockBasedStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createWithExceptionHandling"));
        }
        return lockBasedStorageManager;
    }

    private LockBasedStorageManager(@NotNull String debugText, @NotNull ExceptionHandlingStrategy exceptionHandlingStrategy, @NotNull Lock lock) {
        if (debugText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugText", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "<init>"));
        }
        if (exceptionHandlingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionHandlingStrategy", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "<init>"));
        }
        if (lock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lock", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "<init>"));
        }
        this.lock = lock;
        this.exceptionHandlingStrategy = exceptionHandlingStrategy;
        this.debugText = debugText;
    }

    public LockBasedStorageManager() {
        this(LockBasedStorageManager.getPointOfConstruction(), ExceptionHandlingStrategy.THROW, new ReentrantLock());
    }

    protected LockBasedStorageManager(@NotNull ExceptionHandlingStrategy exceptionHandlingStrategy) {
        if (exceptionHandlingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionHandlingStrategy", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "<init>"));
        }
        this(LockBasedStorageManager.getPointOfConstruction(), exceptionHandlingStrategy, new ReentrantLock());
    }

    private static String getPointOfConstruction() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (trace.length <= 3) {
            return "<unknown creating class>";
        }
        return trace[3].toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " (" + this.debugText + ")";
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function1<? super K, ? extends V> compute) {
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createMemoizedFunction"));
        }
        MemoizedFunctionToNotNull<? super K, ? extends V> memoizedFunctionToNotNull = this.createMemoizedFunction(compute, LockBasedStorageManager.<K>createConcurrentHashMap());
        if (memoizedFunctionToNotNull == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createMemoizedFunction"));
        }
        return memoizedFunctionToNotNull;
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function1<? super K, ? extends V> compute, @NotNull ConcurrentMap<K, Object> map) {
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createMemoizedFunction"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createMemoizedFunction"));
        }
        MapBasedMemoizedFunctionToNotNull<? super K, ? extends V> mapBasedMemoizedFunctionToNotNull = new MapBasedMemoizedFunctionToNotNull<K, V>(map, compute);
        if (mapBasedMemoizedFunctionToNotNull == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createMemoizedFunction"));
        }
        return mapBasedMemoizedFunctionToNotNull;
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNullable<K, V> createMemoizedFunctionWithNullableValues(@NotNull Function1<? super K, ? extends V> compute) {
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createMemoizedFunctionWithNullableValues"));
        }
        MemoizedFunctionToNullable<? super K, ? extends V> memoizedFunctionToNullable = this.createMemoizedFunctionWithNullableValues(compute, LockBasedStorageManager.<K>createConcurrentHashMap());
        if (memoizedFunctionToNullable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createMemoizedFunctionWithNullableValues"));
        }
        return memoizedFunctionToNullable;
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNullable<K, V> createMemoizedFunctionWithNullableValues(@NotNull Function1<? super K, ? extends V> compute, @NotNull ConcurrentMap<K, Object> map) {
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createMemoizedFunctionWithNullableValues"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createMemoizedFunctionWithNullableValues"));
        }
        MapBasedMemoizedFunction<? super K, ? extends V> mapBasedMemoizedFunction = new MapBasedMemoizedFunction<K, V>(map, compute);
        if (mapBasedMemoizedFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createMemoizedFunctionWithNullableValues"));
        }
        return mapBasedMemoizedFunction;
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValue(@NotNull Function0<? extends T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createLazyValue"));
        }
        LockBasedNotNullLazyValue<? extends T> lockBasedNotNullLazyValue = new LockBasedNotNullLazyValue<T>(computable);
        if (lockBasedNotNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createLazyValue"));
        }
        return lockBasedNotNullLazyValue;
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createRecursionTolerantLazyValue(@NotNull Function0<? extends T> computable, final @NotNull T onRecursiveCall) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createRecursionTolerantLazyValue"));
        }
        if (onRecursiveCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onRecursiveCall", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createRecursionTolerantLazyValue"));
        }
        LockBasedNotNullLazyValue lockBasedNotNullLazyValue = new LockBasedNotNullLazyValue<T>(computable){

            @Override
            @NotNull
            protected RecursionDetectedResult<T> recursionDetected(boolean firstTime) {
                RecursionDetectedResult<Object> recursionDetectedResult = RecursionDetectedResult.value(onRecursiveCall);
                if (recursionDetectedResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager$2", "recursionDetected"));
                }
                return recursionDetectedResult;
            }
        };
        if (lockBasedNotNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createRecursionTolerantLazyValue"));
        }
        return lockBasedNotNullLazyValue;
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValueWithPostCompute(@NotNull Function0<? extends T> computable, final Function1<? super Boolean, ? extends T> onRecursiveCall, final @NotNull Function1<? super T, ? extends Unit> postCompute) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createLazyValueWithPostCompute"));
        }
        if (postCompute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postCompute", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createLazyValueWithPostCompute"));
        }
        LockBasedNotNullLazyValue lockBasedNotNullLazyValue = new LockBasedNotNullLazyValue<T>(computable){

            @Override
            @NotNull
            protected RecursionDetectedResult<T> recursionDetected(boolean firstTime) {
                if (onRecursiveCall == null) {
                    RecursionDetectedResult recursionDetectedResult = super.recursionDetected(firstTime);
                    if (recursionDetectedResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager$3", "recursionDetected"));
                    }
                    return recursionDetectedResult;
                }
                RecursionDetectedResult recursionDetectedResult = RecursionDetectedResult.value(onRecursiveCall.invoke(firstTime));
                if (recursionDetectedResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager$3", "recursionDetected"));
                }
                return recursionDetectedResult;
            }

            @Override
            protected void postCompute(@NotNull T value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/storage/LockBasedStorageManager$3", "postCompute"));
                }
                postCompute.invoke(value);
            }
        };
        if (lockBasedNotNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createLazyValueWithPostCompute"));
        }
        return lockBasedNotNullLazyValue;
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createNullableLazyValue(@NotNull Function0<? extends T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createNullableLazyValue"));
        }
        LockBasedLazyValue<? extends T> lockBasedLazyValue = new LockBasedLazyValue<T>(computable);
        if (lockBasedLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createNullableLazyValue"));
        }
        return lockBasedLazyValue;
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createRecursionTolerantNullableLazyValue(@NotNull Function0<? extends T> computable, final T onRecursiveCall) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createRecursionTolerantNullableLazyValue"));
        }
        LockBasedLazyValue lockBasedLazyValue = new LockBasedLazyValue<T>(computable){

            @Override
            @NotNull
            protected RecursionDetectedResult<T> recursionDetected(boolean firstTime) {
                RecursionDetectedResult<Object> recursionDetectedResult = RecursionDetectedResult.value(onRecursiveCall);
                if (recursionDetectedResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager$4", "recursionDetected"));
                }
                return recursionDetectedResult;
            }
        };
        if (lockBasedLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createRecursionTolerantNullableLazyValue"));
        }
        return lockBasedLazyValue;
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createNullableLazyValueWithPostCompute(@NotNull Function0<? extends T> computable, final @NotNull Function1<? super T, ? extends Unit> postCompute) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createNullableLazyValueWithPostCompute"));
        }
        if (postCompute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postCompute", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createNullableLazyValueWithPostCompute"));
        }
        LockBasedLazyValue lockBasedLazyValue = new LockBasedLazyValue<T>(computable){

            @Override
            protected void postCompute(@Nullable T value) {
                postCompute.invoke(value);
            }
        };
        if (lockBasedLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createNullableLazyValueWithPostCompute"));
        }
        return lockBasedLazyValue;
    }

    @Override
    public <T> T compute(@NotNull Function0<? extends T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "compute"));
        }
        this.lock.lock();
        try {
            T t = computable.invoke();
            return t;
        }
        catch (Throwable throwable) {
            throw this.exceptionHandlingStrategy.handleException(throwable);
        }
        finally {
            this.lock.unlock();
        }
    }

    @NotNull
    private static <K> ConcurrentMap<K, Object> createConcurrentHashMap() {
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(3, 1.0f, 2);
        if (concurrentHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createConcurrentHashMap"));
        }
        return concurrentHashMap;
    }

    @NotNull
    protected <T> RecursionDetectedResult<T> recursionDetectedDefault() {
        throw new IllegalStateException("Recursive call in a lazy value under " + this);
    }

    @NotNull
    public static LockBasedStorageManager createDelegatingWithSameLock(@NotNull LockBasedStorageManager base, @NotNull ExceptionHandlingStrategy newStrategy) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createDelegatingWithSameLock"));
        }
        if (newStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStrategy", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createDelegatingWithSameLock"));
        }
        LockBasedStorageManager lockBasedStorageManager = new LockBasedStorageManager(LockBasedStorageManager.getPointOfConstruction(), newStrategy, base.lock);
        if (lockBasedStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager", "createDelegatingWithSameLock"));
        }
        return lockBasedStorageManager;
    }

    private class MapBasedMemoizedFunctionToNotNull<K, V>
    extends MapBasedMemoizedFunction<K, V>
    implements MemoizedFunctionToNotNull<K, V> {
        public MapBasedMemoizedFunctionToNotNull(@NotNull ConcurrentMap<K, Object> map, @NotNull Function1<? super K, ? extends V> compute) {
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/storage/LockBasedStorageManager$MapBasedMemoizedFunctionToNotNull", "<init>"));
            }
            if (compute == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/kotlin/storage/LockBasedStorageManager$MapBasedMemoizedFunctionToNotNull", "<init>"));
            }
            super(map, compute);
        }

        @Override
        @NotNull
        public V invoke(K input) {
            Object result2 = super.invoke(input);
            assert (result2 != null) : "compute() returned null under " + LockBasedStorageManager.this;
            Object v = result2;
            if (v == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager$MapBasedMemoizedFunctionToNotNull", "invoke"));
            }
            return v;
        }
    }

    private class MapBasedMemoizedFunction<K, V>
    implements MemoizedFunctionToNullable<K, V> {
        private final ConcurrentMap<K, Object> cache;
        private final Function1<? super K, ? extends V> compute;

        public MapBasedMemoizedFunction(@NotNull ConcurrentMap<K, Object> map, @NotNull Function1<? super K, ? extends V> compute) {
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/storage/LockBasedStorageManager$MapBasedMemoizedFunction", "<init>"));
            }
            if (compute == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/kotlin/storage/LockBasedStorageManager$MapBasedMemoizedFunction", "<init>"));
            }
            this.cache = map;
            this.compute = compute;
        }

        @Override
        @Nullable
        public V invoke(K input) {
            Object value = this.cache.get(input);
            if (value != null && value != NotValue.COMPUTING) {
                return WrappedValues.unescapeExceptionOrNull(value);
            }
            LockBasedStorageManager.this.lock.lock();
            try {
                V v;
                value = this.cache.get(input);
                assert (value != NotValue.COMPUTING) : "Recursion detected on input: " + input + " under " + LockBasedStorageManager.this;
                if (value != null) {
                    Object v2 = WrappedValues.unescapeExceptionOrNull(value);
                    return v2;
                }
                AssertionError error = null;
                try {
                    this.cache.put(input, (Object)NotValue.COMPUTING);
                    V typedValue = this.compute.invoke(input);
                    Object oldValue = this.cache.put(input, WrappedValues.escapeNull(typedValue));
                    if (oldValue != NotValue.COMPUTING) {
                        error = new AssertionError((Object)("Race condition detected on input " + input + ". Old value is " + oldValue + " under " + LockBasedStorageManager.this));
                        throw error;
                    }
                    v = typedValue;
                }
                catch (Throwable throwable) {
                    if (throwable == error) {
                        throw LockBasedStorageManager.this.exceptionHandlingStrategy.handleException(throwable);
                    }
                    Object oldValue = this.cache.put(input, WrappedValues.escapeThrowable(throwable));
                    assert (oldValue == NotValue.COMPUTING) : "Race condition detected on input " + input + ". Old value is " + oldValue + " under " + LockBasedStorageManager.this;
                    throw LockBasedStorageManager.this.exceptionHandlingStrategy.handleException(throwable);
                }
                return v;
            }
            finally {
                LockBasedStorageManager.this.lock.unlock();
            }
        }

        @Override
        public boolean isComputed(K key) {
            Object value = this.cache.get(key);
            return value != null && value != NotValue.COMPUTING;
        }
    }

    private class LockBasedNotNullLazyValue<T>
    extends LockBasedLazyValue<T>
    implements NotNullLazyValue<T> {
        public LockBasedNotNullLazyValue(@NotNull Function0<? extends T> computable) {
            if (computable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/kotlin/storage/LockBasedStorageManager$LockBasedNotNullLazyValue", "<init>"));
            }
            super(computable);
        }

        @Override
        @NotNull
        public T invoke() {
            Object result2 = super.invoke();
            assert (result2 != null) : "compute() returned null";
            Object t = result2;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager$LockBasedNotNullLazyValue", "invoke"));
            }
            return t;
        }
    }

    private class LockBasedLazyValue<T>
    implements NullableLazyValue<T> {
        private final Function0<? extends T> computable;
        @Nullable
        private volatile Object value;

        public LockBasedLazyValue(@NotNull Function0<? extends T> computable) {
            if (computable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/kotlin/storage/LockBasedStorageManager$LockBasedLazyValue", "<init>"));
            }
            this.value = NotValue.NOT_COMPUTED;
            this.computable = computable;
        }

        @Override
        public boolean isComputed() {
            return this.value != NotValue.NOT_COMPUTED && this.value != NotValue.COMPUTING;
        }

        @Override
        public T invoke() {
            Object _value = this.value;
            if (!(_value instanceof NotValue)) {
                return (T)WrappedValues.unescapeThrowable(_value);
            }
            LockBasedStorageManager.this.lock.lock();
            try {
                T t;
                RecursionDetectedResult<T> result2;
                _value = this.value;
                if (!(_value instanceof NotValue)) {
                    Object v = WrappedValues.unescapeThrowable(_value);
                    return (T)v;
                }
                if (_value == NotValue.COMPUTING) {
                    this.value = NotValue.RECURSION_WAS_DETECTED;
                    result2 = this.recursionDetected(true);
                    if (!result2.isFallThrough()) {
                        T t2 = result2.getValue();
                        return t2;
                    }
                }
                if (_value == NotValue.RECURSION_WAS_DETECTED && !(result2 = this.recursionDetected(false)).isFallThrough()) {
                    T t3 = result2.getValue();
                    return t3;
                }
                this.value = NotValue.COMPUTING;
                try {
                    T typedValue = this.computable.invoke();
                    this.value = typedValue;
                    this.postCompute(typedValue);
                    t = typedValue;
                }
                catch (Throwable throwable) {
                    if (this.value == NotValue.COMPUTING) {
                        this.value = WrappedValues.escapeThrowable(throwable);
                    }
                    throw LockBasedStorageManager.this.exceptionHandlingStrategy.handleException(throwable);
                }
                return t;
            }
            finally {
                LockBasedStorageManager.this.lock.unlock();
            }
        }

        @NotNull
        protected RecursionDetectedResult<T> recursionDetected(boolean firstTime) {
            RecursionDetectedResult recursionDetectedResult = LockBasedStorageManager.this.recursionDetectedDefault();
            if (recursionDetectedResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager$LockBasedLazyValue", "recursionDetected"));
            }
            return recursionDetectedResult;
        }

        protected void postCompute(T value) {
        }
    }

    private static enum NotValue {
        NOT_COMPUTED,
        COMPUTING,
        RECURSION_WAS_DETECTED;

    }

    private static class RecursionDetectedResult<T> {
        private final T value;
        private final boolean fallThrough;

        @NotNull
        public static <T> RecursionDetectedResult<T> value(T value) {
            RecursionDetectedResult<T> recursionDetectedResult = new RecursionDetectedResult<T>(value, false);
            if (recursionDetectedResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager$RecursionDetectedResult", "value"));
            }
            return recursionDetectedResult;
        }

        @NotNull
        public static <T> RecursionDetectedResult<T> fallThrough() {
            RecursionDetectedResult<Object> recursionDetectedResult = new RecursionDetectedResult<Object>(null, true);
            if (recursionDetectedResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager$RecursionDetectedResult", "fallThrough"));
            }
            return recursionDetectedResult;
        }

        private RecursionDetectedResult(T value, boolean fallThrough) {
            this.value = value;
            this.fallThrough = fallThrough;
        }

        public T getValue() {
            assert (!this.fallThrough) : "A value requested from FALL_THROUGH in " + this;
            return this.value;
        }

        public boolean isFallThrough() {
            return this.fallThrough;
        }

        public String toString() {
            return this.isFallThrough() ? "FALL_THROUGH" : String.valueOf(this.value);
        }
    }

    public static interface ExceptionHandlingStrategy {
        public static final ExceptionHandlingStrategy THROW = new ExceptionHandlingStrategy(){

            @Override
            @NotNull
            public RuntimeException handleException(@NotNull Throwable throwable) {
                if (throwable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwable", "org/jetbrains/kotlin/storage/LockBasedStorageManager$ExceptionHandlingStrategy$1", "handleException"));
                }
                throw UtilsPackage.rethrow(throwable);
            }
        };

        @NotNull
        public RuntimeException handleException(@NotNull Throwable var1);
    }
}

