/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.parsing.JetScriptDefinition;
import org.jetbrains.kotlin.parsing.JetScriptDefinitionProvider;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.resolve.AnalyzerScriptParameter;

public final class ScriptParameterResolver {
    @NotNull
    public static List<ValueParameterDescriptor> resolveScriptParameters(@NotNull JetScript declaration, @NotNull ScriptDescriptor scriptDescriptor) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/ScriptParameterResolver", "resolveScriptParameters"));
        }
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDescriptor", "org/jetbrains/kotlin/resolve/ScriptParameterResolver", "resolveScriptParameters"));
        }
        ArrayList<ValueParameterDescriptor> valueParameters = Lists.newArrayList();
        JetFile file = declaration.getContainingJetFile();
        JetScriptDefinition scriptDefinition = JetScriptDefinitionProvider.getInstance(file.getProject()).findScriptDefinition(file);
        int index2 = 0;
        for (AnalyzerScriptParameter scriptParameter : scriptDefinition.getScriptParameters()) {
            ValueParameterDescriptor parameter = ScriptParameterResolver.resolveScriptParameter(scriptParameter, index2, scriptDescriptor);
            valueParameters.add(parameter);
            ++index2;
        }
        ArrayList<ValueParameterDescriptor> arrayList = valueParameters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ScriptParameterResolver", "resolveScriptParameters"));
        }
        return arrayList;
    }

    @NotNull
    private static ValueParameterDescriptor resolveScriptParameter(@NotNull AnalyzerScriptParameter scriptParameter, int index2, @NotNull ScriptDescriptor script) {
        if (scriptParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptParameter", "org/jetbrains/kotlin/resolve/ScriptParameterResolver", "resolveScriptParameter"));
        }
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/resolve/ScriptParameterResolver", "resolveScriptParameter"));
        }
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(script, null, index2, Annotations.EMPTY, scriptParameter.getName(), scriptParameter.getType(), false, null, SourceElement.NO_SOURCE);
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ScriptParameterResolver", "resolveScriptParameter"));
        }
        return valueParameterDescriptorImpl;
    }

    private ScriptParameterResolver() {
    }
}

