/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetKeywordToken;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNullableType;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProjectionKind;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStubbedPsiUtil;
import org.jetbrains.kotlin.psi.JetTypeConstraint;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwner;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.psi.JetVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Maps;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.relocated.javax.inject.Inject;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.constants.evaluate.EvaluatePackage;
import org.jetbrains.kotlin.resolve.dataClassUtils.DataClassUtilsPackage;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.JetScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.WritableScope;
import org.jetbrains.kotlin.resolve.scopes.WritableScopeImpl;
import org.jetbrains.kotlin.resolve.source.SourcePackage;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;

public class DescriptorResolver {
    public static final Name COPY_METHOD_NAME = Name.identifier("copy");
    private static final Set<JetModifierKeywordToken> MODIFIERS_ILLEGAL_ON_PARAMETERS = Sets.newHashSet();
    private TypeResolver typeResolver;
    private AnnotationResolver annotationResolver;
    private ExpressionTypingServices expressionTypingServices;
    private DelegatedPropertyResolver delegatedPropertyResolver;
    private StorageManager storageManager;
    private KotlinBuiltIns builtIns;

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        if (typeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolver", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setTypeResolver"));
        }
        this.typeResolver = typeResolver;
    }

    @Inject
    public void setAnnotationResolver(@NotNull AnnotationResolver annotationResolver) {
        if (annotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationResolver", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setAnnotationResolver"));
        }
        this.annotationResolver = annotationResolver;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setDelegatedPropertyResolver(@NotNull DelegatedPropertyResolver delegatedPropertyResolver) {
        if (delegatedPropertyResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatedPropertyResolver", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setDelegatedPropertyResolver"));
        }
        this.delegatedPropertyResolver = delegatedPropertyResolver;
    }

    @Inject
    public void setStorageManager(@NotNull StorageManager storageManager) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setStorageManager"));
        }
        this.storageManager = storageManager;
    }

    @Inject
    public void setBuiltIns(@NotNull KotlinBuiltIns builtIns) {
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setBuiltIns"));
        }
        this.builtIns = builtIns;
    }

    public List<JetType> resolveSupertypes(@NotNull JetScope scope2, @NotNull ClassDescriptor classDescriptor, @NotNull JetClassOrObject jetClass, BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveSupertypes"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveSupertypes"));
        }
        if (jetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetClass", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveSupertypes"));
        }
        ArrayList<JetType> supertypes2 = Lists.newArrayList();
        List<JetDelegationSpecifier> delegationSpecifiers = jetClass.getDelegationSpecifiers();
        Collection<JetType> declaredSupertypes = this.resolveDelegationSpecifiers(scope2, delegationSpecifiers, this.typeResolver, trace, false);
        for (JetType declaredSupertype : declaredSupertypes) {
            DescriptorResolver.addValidSupertype(supertypes2, declaredSupertype);
        }
        if (classDescriptor.getKind() == ClassKind.ENUM_CLASS && !this.containsClass(supertypes2)) {
            supertypes2.add(0, this.builtIns.getEnumType(classDescriptor.getDefaultType()));
        }
        if (supertypes2.isEmpty()) {
            JetType defaultSupertype = this.getDefaultSupertype(jetClass, trace);
            DescriptorResolver.addValidSupertype(supertypes2, defaultSupertype);
        }
        return supertypes2;
    }

    private static void addValidSupertype(List<JetType> supertypes2, JetType declaredSupertype) {
        if (!declaredSupertype.isError()) {
            supertypes2.add(declaredSupertype);
        }
    }

    private boolean containsClass(Collection<JetType> result2) {
        for (JetType type2 : result2) {
            ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (!(descriptor2 instanceof ClassDescriptor) || ((ClassDescriptor)descriptor2).getKind() == ClassKind.INTERFACE) continue;
            return true;
        }
        return false;
    }

    private JetType getDefaultSupertype(JetClassOrObject jetClass, BindingTrace trace) {
        if (jetClass instanceof JetEnumEntry) {
            JetClassOrObject parent = JetStubbedPsiUtil.getContainingDeclaration(jetClass, JetClassOrObject.class);
            ClassDescriptor parentDescriptor = trace.getBindingContext().get(BindingContext.CLASS, parent);
            if (parentDescriptor.getTypeConstructor().getParameters().isEmpty()) {
                return parentDescriptor.getDefaultType();
            }
            trace.report(Errors.NO_GENERICS_IN_SUPERTYPE_SPECIFIER.on(jetClass.getNameIdentifier()));
            return ErrorUtils.createErrorType("Supertype not specified");
        }
        if (jetClass instanceof JetClass && ((JetClass)jetClass).isAnnotation()) {
            return this.builtIns.getAnnotationType();
        }
        return this.builtIns.getAnyType();
    }

    public Collection<JetType> resolveDelegationSpecifiers(JetScope extensibleScope, List<JetDelegationSpecifier> delegationSpecifiers, @NotNull TypeResolver resolver2, BindingTrace trace, boolean checkBounds) {
        if (resolver2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegationSpecifiers"));
        }
        if (delegationSpecifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JetType> result2 = Lists.newArrayList();
        for (JetDelegationSpecifier delegationSpecifier : delegationSpecifiers) {
            JetTypeReference typeReference = delegationSpecifier.getTypeReference();
            if (typeReference != null) {
                JetType supertype = resolver2.resolveType(extensibleScope, typeReference, trace, checkBounds);
                if (TypesPackage.isDynamic(supertype)) {
                    trace.report(Errors.DYNAMIC_SUPERTYPE.on(typeReference));
                    continue;
                }
                result2.add(supertype);
                JetTypeElement bareSuperType = DescriptorResolver.checkNullableSupertypeAndStripQuestionMarks(trace, typeReference.getTypeElement());
                DescriptorResolver.checkProjectionsInImmediateArguments(trace, bareSuperType);
                continue;
            }
            result2.add(ErrorUtils.createErrorType("No type reference"));
        }
        return result2;
    }

    @Nullable
    private static JetTypeElement checkNullableSupertypeAndStripQuestionMarks(@NotNull BindingTrace trace, @Nullable JetTypeElement typeElement) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkNullableSupertypeAndStripQuestionMarks"));
        }
        while (typeElement instanceof JetNullableType) {
            JetNullableType nullableType = (JetNullableType)typeElement;
            if ((typeElement = nullableType.getInnerType()) instanceof JetNullableType || typeElement == null) continue;
            trace.report(Errors.NULLABLE_SUPERTYPE.on(nullableType));
        }
        return typeElement;
    }

    private static void checkProjectionsInImmediateArguments(@NotNull BindingTrace trace, @Nullable JetTypeElement typeElement) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkProjectionsInImmediateArguments"));
        }
        if (typeElement instanceof JetUserType) {
            JetUserType userType = (JetUserType)typeElement;
            List<JetTypeProjection> typeArguments = userType.getTypeArguments();
            for (JetTypeProjection typeArgument : typeArguments) {
                if (typeArgument.getProjectionKind() == JetProjectionKind.NONE) continue;
                trace.report(Errors.PROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE.on(typeArgument));
            }
        }
    }

    @NotNull
    public static SimpleFunctionDescriptor createComponentFunctionDescriptor(int parameterIndex, @NotNull PropertyDescriptor property2, @NotNull ValueParameterDescriptor parameter, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        Name functionName = DataClassUtilsPackage.createComponentName(parameterIndex);
        JetType returnType2 = property2.getType();
        SimpleFunctionDescriptorImpl functionDescriptor = SimpleFunctionDescriptorImpl.create(classDescriptor, Annotations.EMPTY, functionName, CallableMemberDescriptor.Kind.SYNTHESIZED, parameter.getSource());
        functionDescriptor.initialize((JetType)null, classDescriptor.getThisAsReceiverParameter(), Collections.emptyList(), Collections.emptyList(), returnType2, Modality.FINAL, property2.getVisibility());
        trace.record(BindingContext.DATA_CLASS_COMPONENT_FUNCTION, parameter, functionDescriptor);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        if (simpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        return simpleFunctionDescriptorImpl;
    }

    @NotNull
    public static SimpleFunctionDescriptor createCopyFunctionDescriptor(@NotNull Collection<ValueParameterDescriptor> constructorParameters, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        if (constructorParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorParameters", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createCopyFunctionDescriptor"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createCopyFunctionDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createCopyFunctionDescriptor"));
        }
        JetType returnType2 = classDescriptor.getDefaultType();
        SimpleFunctionDescriptorImpl functionDescriptor = SimpleFunctionDescriptorImpl.create(classDescriptor, Annotations.EMPTY, COPY_METHOD_NAME, CallableMemberDescriptor.Kind.SYNTHESIZED, classDescriptor.getSource());
        ArrayList<ValueParameterDescriptorImpl> parameterDescriptors = Lists.newArrayList();
        for (ValueParameterDescriptor parameter : constructorParameters) {
            PropertyDescriptor propertyDescriptor = trace.getBindingContext().get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameter);
            boolean declaresDefaultValue = propertyDescriptor != null;
            ValueParameterDescriptorImpl parameterDescriptor = new ValueParameterDescriptorImpl(functionDescriptor, null, parameter.getIndex(), parameter.getAnnotations(), parameter.getName(), parameter.getType(), declaresDefaultValue, parameter.getVarargElementType(), SourceElement.NO_SOURCE);
            parameterDescriptors.add(parameterDescriptor);
            if (!declaresDefaultValue) continue;
            trace.record(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameterDescriptor, propertyDescriptor);
        }
        functionDescriptor.initialize((JetType)null, classDescriptor.getThisAsReceiverParameter(), Collections.emptyList(), parameterDescriptors, returnType2, Modality.FINAL, Visibilities.PUBLIC);
        trace.record(BindingContext.DATA_CLASS_COPY_FUNCTION, classDescriptor, functionDescriptor);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        if (simpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createCopyFunctionDescriptor"));
        }
        return simpleFunctionDescriptorImpl;
    }

    public static Visibility getDefaultVisibility(JetModifierListOwner modifierListOwner, DeclarationDescriptor containingDescriptor) {
        JetModifierList modifierList;
        Visibility defaultVisibility = containingDescriptor instanceof ClassDescriptor ? ((modifierList = modifierListOwner.getModifierList()) != null && modifierList.hasModifier(JetTokens.OVERRIDE_KEYWORD) ? Visibilities.INHERITED : Visibilities.INTERNAL) : (containingDescriptor instanceof FunctionDescriptor || containingDescriptor instanceof PropertyDescriptor ? Visibilities.LOCAL : Visibilities.INTERNAL);
        return defaultVisibility;
    }

    public static Modality getDefaultModality(DeclarationDescriptor containingDescriptor, Visibility visibility, boolean isBodyPresent) {
        Modality defaultModality;
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean isTrait = ((ClassDescriptor)containingDescriptor).getKind() == ClassKind.INTERFACE;
            boolean isDefinitelyAbstract = isTrait && !isBodyPresent;
            Modality basicModality = isTrait && !Visibilities.isPrivate(visibility) ? Modality.OPEN : Modality.FINAL;
            defaultModality = isDefinitelyAbstract ? Modality.ABSTRACT : basicModality;
        } else {
            defaultModality = Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    public ValueParameterDescriptorImpl resolveValueParameterDescriptor(JetScope scope2, DeclarationDescriptor declarationDescriptor, JetParameter valueParameter, int index2, JetType type2, BindingTrace trace) {
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = this.resolveValueParameterDescriptor(declarationDescriptor, valueParameter, index2, type2, trace, this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, valueParameter.getModifierList(), trace));
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveValueParameterDescriptor"));
        }
        return valueParameterDescriptorImpl;
    }

    @NotNull
    private ValueParameterDescriptorImpl resolveValueParameterDescriptor(DeclarationDescriptor declarationDescriptor, JetParameter valueParameter, int index2, JetType type2, BindingTrace trace, Annotations annotations2) {
        JetType varargElementType = null;
        JetType variableType = type2;
        if (valueParameter.hasModifier(JetTokens.VARARG_KEYWORD)) {
            varargElementType = type2;
            variableType = this.getVarargParameterType(type2);
        }
        ValueParameterDescriptorImpl valueParameterDescriptor = new ValueParameterDescriptorImpl(declarationDescriptor, null, index2, annotations2, JetPsiUtil.safeName(valueParameter.getName()), variableType, valueParameter.hasDefaultValue(), varargElementType, SourcePackage.toSourceElement(valueParameter));
        trace.record(BindingContext.VALUE_PARAMETER, valueParameter, valueParameterDescriptor);
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = valueParameterDescriptor;
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveValueParameterDescriptor"));
        }
        return valueParameterDescriptorImpl;
    }

    @NotNull
    private JetType getVarargParameterType(@NotNull JetType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVarargParameterType"));
        }
        JetType primitiveArrayType = this.builtIns.getPrimitiveArrayJetTypeByPrimitiveJetType(elementType);
        if (primitiveArrayType != null) {
            JetType jetType = primitiveArrayType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVarargParameterType"));
            }
            return jetType;
        }
        JetType jetType = this.builtIns.getArrayType(Variance.OUT_VARIANCE, elementType);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVarargParameterType"));
        }
        return jetType;
    }

    public List<TypeParameterDescriptorImpl> resolveTypeParametersForCallableDescriptor(DeclarationDescriptor containingDescriptor, WritableScope extensibleScope, List<JetTypeParameter> typeParameters, BindingTrace trace) {
        ArrayList<TypeParameterDescriptorImpl> result2 = new ArrayList<TypeParameterDescriptorImpl>();
        int typeParametersSize = typeParameters.size();
        for (int i = 0; i < typeParametersSize; ++i) {
            JetTypeParameter typeParameter = typeParameters.get(i);
            result2.add(this.resolveTypeParameterForCallableDescriptor(containingDescriptor, extensibleScope, typeParameter, i, trace));
        }
        return result2;
    }

    private TypeParameterDescriptorImpl resolveTypeParameterForCallableDescriptor(DeclarationDescriptor containingDescriptor, WritableScope extensibleScope, JetTypeParameter typeParameter, int index2, BindingTrace trace) {
        if (typeParameter.getVariance() != Variance.INVARIANT) {
            assert (!(containingDescriptor instanceof ClassifierDescriptor)) : "This method is intended for functions/properties";
            trace.report(Errors.VARIANCE_ON_TYPE_PARAMETER_OF_FUNCTION_OR_PROPERTY.on(typeParameter));
        }
        AnnotationResolver.reportUnsupportedAnnotationForTypeParameter(typeParameter, trace);
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDescriptor, Annotations.EMPTY, typeParameter.hasModifier(JetTokens.REIFIED_KEYWORD), typeParameter.getVariance(), JetPsiUtil.safeName(typeParameter.getName()), index2, SourcePackage.toSourceElement(typeParameter));
        trace.record(BindingContext.TYPE_PARAMETER, typeParameter, typeParameterDescriptor);
        extensibleScope.addClassifierDescriptor(typeParameterDescriptor);
        return typeParameterDescriptor;
    }

    @NotNull
    public static ConstructorDescriptorImpl createAndRecordPrimaryConstructorForObject(@Nullable JetClassOrObject object, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createAndRecordPrimaryConstructorForObject"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createAndRecordPrimaryConstructorForObject"));
        }
        ConstructorDescriptorImpl constructorDescriptor = DescriptorFactory.createPrimaryConstructorForObject(classDescriptor, SourcePackage.toSourceElement(object));
        if (object != null) {
            trace.record(BindingContext.CONSTRUCTOR, object, constructorDescriptor);
        }
        ConstructorDescriptorImpl constructorDescriptorImpl = constructorDescriptor;
        if (constructorDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createAndRecordPrimaryConstructorForObject"));
        }
        return constructorDescriptorImpl;
    }

    public void resolveGenericBounds(@NotNull JetTypeParameterListOwner declaration, @NotNull DeclarationDescriptor descriptor2, JetScope scope2, List<TypeParameterDescriptorImpl> parameters2, BindingTrace trace) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveGenericBounds"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveGenericBounds"));
        }
        ArrayList<UpperBoundCheckerTask> deferredUpperBoundCheckerTasks = Lists.newArrayList();
        List<JetTypeParameter> typeParameters = declaration.getTypeParameters();
        HashMap<Name, TypeParameterDescriptorImpl> parameterByName = Maps.newHashMap();
        for (int i = 0; i < typeParameters.size(); ++i) {
            JetTypeParameter jetTypeParameter = typeParameters.get(i);
            TypeParameterDescriptorImpl typeParameterDescriptor = parameters2.get(i);
            parameterByName.put(typeParameterDescriptor.getName(), typeParameterDescriptor);
            JetTypeReference extendsBound = jetTypeParameter.getExtendsBound();
            if (extendsBound == null) continue;
            JetType type2 = this.typeResolver.resolveType(scope2, extendsBound, trace, false);
            typeParameterDescriptor.addUpperBound(type2);
            deferredUpperBoundCheckerTasks.add(new UpperBoundCheckerTask(extendsBound, type2));
        }
        for (JetTypeConstraint constraint : declaration.getTypeConstraints()) {
            JetSimpleNameExpression subjectTypeParameterName = constraint.getSubjectTypeParameterName();
            if (subjectTypeParameterName == null) continue;
            Name referencedName = subjectTypeParameterName.getReferencedNameAsName();
            TypeParameterDescriptorImpl typeParameterDescriptor = (TypeParameterDescriptorImpl)parameterByName.get(referencedName);
            JetTypeReference boundTypeReference = constraint.getBoundTypeReference();
            JetType bound = null;
            if (boundTypeReference != null) {
                bound = this.typeResolver.resolveType(scope2, boundTypeReference, trace, false);
                deferredUpperBoundCheckerTasks.add(new UpperBoundCheckerTask(boundTypeReference, bound));
            }
            if (typeParameterDescriptor == null) continue;
            trace.record(BindingContext.REFERENCE_TARGET, subjectTypeParameterName, typeParameterDescriptor);
            if (bound == null) continue;
            typeParameterDescriptor.addUpperBound(bound);
        }
        for (TypeParameterDescriptorImpl parameter : parameters2) {
            parameter.addDefaultUpperBound();
            parameter.setInitialized();
            DescriptorResolver.checkConflictingUpperBounds(trace, parameter, typeParameters.get(parameter.getIndex()));
        }
        if (!(declaration instanceof JetClass)) {
            for (UpperBoundCheckerTask checkerTask : deferredUpperBoundCheckerTasks) {
                DescriptorResolver.checkUpperBoundType(checkerTask.upperBound, checkerTask.upperBoundType, trace);
            }
            this.checkNamesInConstraints(declaration, descriptor2, scope2, trace);
        }
    }

    public static void checkConflictingUpperBounds(@NotNull BindingTrace trace, @NotNull TypeParameterDescriptor parameter, @NotNull JetTypeParameter typeParameter) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkConflictingUpperBounds"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkConflictingUpperBounds"));
        }
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkConflictingUpperBounds"));
        }
        if (KotlinBuiltIns.isNothing(parameter.getUpperBoundsAsType())) {
            trace.report(Errors.CONFLICTING_UPPER_BOUNDS.on(typeParameter, parameter));
        }
    }

    public void checkNamesInConstraints(@NotNull JetTypeParameterListOwner declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull JetScope scope2, @NotNull BindingTrace trace) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkNamesInConstraints"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkNamesInConstraints"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkNamesInConstraints"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkNamesInConstraints"));
        }
        for (JetTypeConstraint constraint : declaration.getTypeConstraints()) {
            JetTypeReference boundTypeReference;
            Name name;
            ClassifierDescriptor classifier2;
            JetSimpleNameExpression nameExpression = constraint.getSubjectTypeParameterName();
            if (nameExpression == null || (classifier2 = scope2.getClassifier(name = nameExpression.getReferencedNameAsName())) instanceof TypeParameterDescriptor && classifier2.getContainingDeclaration() == descriptor2) continue;
            if (classifier2 != null) {
                trace.report(Errors.NAME_IN_CONSTRAINT_IS_NOT_A_TYPE_PARAMETER.on(nameExpression, constraint, declaration));
                trace.record(BindingContext.REFERENCE_TARGET, nameExpression, classifier2);
            } else {
                trace.report(Errors.UNRESOLVED_REFERENCE.on(nameExpression, nameExpression));
            }
            if ((boundTypeReference = constraint.getBoundTypeReference()) == null) continue;
            this.typeResolver.resolveType(scope2, boundTypeReference, trace, true);
        }
    }

    public static void checkUpperBoundType(JetTypeReference upperBound, @NotNull JetType upperBoundType, BindingTrace trace) {
        if (upperBoundType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upperBoundType", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkUpperBoundType"));
        }
        if (!TypeUtils.canHaveSubtypes(JetTypeChecker.DEFAULT, upperBoundType)) {
            trace.report(Errors.FINAL_UPPER_BOUND.on(upperBound, upperBoundType));
        }
        if (TypesPackage.isDynamic(upperBoundType)) {
            trace.report(Errors.DYNAMIC_UPPER_BOUND.on(upperBound));
        }
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull JetScope scope2, @NotNull JetParameter parameter, BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        JetType type2 = this.resolveParameterType(scope2, parameter, trace);
        VariableDescriptor variableDescriptor = this.resolveLocalVariableDescriptor(parameter, type2, trace, scope2);
        if (variableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        return variableDescriptor;
    }

    private JetType resolveParameterType(JetScope scope2, JetParameter parameter, BindingTrace trace) {
        JetTypeReference typeReference = parameter.getTypeReference();
        JetType type2 = typeReference != null ? this.typeResolver.resolveType(scope2, typeReference, trace, true) : ErrorUtils.createErrorType("Annotation is absent");
        if (parameter.hasModifier(JetTokens.VARARG_KEYWORD)) {
            return this.getVarargParameterType(type2);
        }
        return type2;
    }

    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull JetParameter parameter, @NotNull JetType type2, BindingTrace trace, @NotNull JetScope scope2) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope2.getContainingDeclaration(), this.annotationResolver.resolveAnnotationsWithArguments(scope2, parameter.getModifierList(), trace), JetPsiUtil.safeName(parameter.getName()), type2, false, SourcePackage.toSourceElement(parameter));
        trace.record(BindingContext.VALUE_PARAMETER, parameter, variableDescriptor);
        return variableDescriptor;
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(JetScope scope2, JetVariableDeclaration variable2, DataFlowInfo dataFlowInfo, BindingTrace trace) {
        DeclarationDescriptor containingDeclaration = scope2.getContainingDeclaration();
        if (JetPsiUtil.isScriptDeclaration(variable2)) {
            PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(containingDeclaration, this.annotationResolver.resolveAnnotationsWithArguments(scope2, variable2.getModifierList(), trace), Modality.FINAL, Visibilities.INTERNAL, variable2.isVar(), JetPsiUtil.safeName(variable2.getName()), CallableMemberDescriptor.Kind.DECLARATION, SourcePackage.toSourceElement(variable2));
            JetType type2 = this.getVariableType(propertyDescriptor, scope2, variable2, dataFlowInfo, false, trace);
            ReceiverParameterDescriptor receiverParameter = ((ScriptDescriptor)containingDeclaration).getThisAsReceiverParameter();
            propertyDescriptor.setType(type2, Collections.emptyList(), receiverParameter, (JetType)null);
            DescriptorResolver.initializeWithDefaultGetterSetter(propertyDescriptor);
            trace.record(BindingContext.VARIABLE, variable2, propertyDescriptor);
            PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
            if (propertyDescriptorImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
            }
            return propertyDescriptorImpl;
        }
        VariableDescriptorImpl variableDescriptor = this.resolveLocalVariableDescriptorWithType(scope2, variable2, null, trace);
        JetType type3 = this.getVariableType(variableDescriptor, scope2, variable2, dataFlowInfo, false, trace);
        variableDescriptor.setOutType(type3);
        VariableDescriptorImpl variableDescriptorImpl = variableDescriptor;
        if (variableDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        return variableDescriptorImpl;
    }

    private static void initializeWithDefaultGetterSetter(PropertyDescriptorImpl propertyDescriptor) {
        PropertySetterDescriptor setter2;
        PropertyGetterDescriptorImpl getter2 = propertyDescriptor.getGetter();
        if (getter2 == null && !Visibilities.isPrivate(propertyDescriptor.getVisibility())) {
            getter2 = DescriptorFactory.createDefaultGetter(propertyDescriptor);
            getter2.initialize(propertyDescriptor.getType());
        }
        if ((setter2 = propertyDescriptor.getSetter()) == null && propertyDescriptor.isVar()) {
            setter2 = DescriptorFactory.createDefaultSetter(propertyDescriptor);
        }
        propertyDescriptor.initialize(getter2, setter2);
    }

    @NotNull
    public VariableDescriptorImpl resolveLocalVariableDescriptorWithType(@NotNull JetScope scope2, @NotNull JetVariableDeclaration variable2, @Nullable JetType type2, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptorWithType"));
        }
        if (variable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptorWithType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptorWithType"));
        }
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope2.getContainingDeclaration(), this.annotationResolver.resolveAnnotationsWithArguments(scope2, variable2.getModifierList(), trace), JetPsiUtil.safeName(variable2.getName()), type2, variable2.isVar(), SourcePackage.toSourceElement(variable2));
        trace.record(BindingContext.VARIABLE, variable2, variableDescriptor);
        LocalVariableDescriptor localVariableDescriptor = variableDescriptor;
        if (localVariableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptorWithType"));
        }
        return localVariableDescriptor;
    }

    @NotNull
    public PropertyDescriptor resolvePropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetScope scope2, @NotNull JetProperty property2, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        List<TypeParameterDescriptorImpl> typeParameterDescriptors2;
        JetScope scopeWithTypeParameters;
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        JetModifierList modifierList = property2.getModifierList();
        boolean isVar = property2.isVar();
        boolean hasBody = DescriptorResolver.hasBody(property2);
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(property2, DescriptorResolver.getDefaultVisibility(property2, containingDeclaration));
        Modality modality = containingDeclaration instanceof ClassDescriptor ? ModifiersChecker.resolveModalityFromModifiers(property2, DescriptorResolver.getDefaultModality(containingDeclaration, visibility, hasBody)) : Modality.FINAL;
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(containingDeclaration, this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, modifierList, trace), modality, visibility, isVar, JetPsiUtil.safeName(property2.getName()), CallableMemberDescriptor.Kind.DECLARATION, SourcePackage.toSourceElement(property2));
        JetType receiverType = null;
        List typeParameters = property2.getTypeParameters();
        if (typeParameters.isEmpty()) {
            scopeWithTypeParameters = scope2;
            typeParameterDescriptors2 = Collections.emptyList();
        } else {
            WritableScopeImpl writableScope = new WritableScopeImpl(scope2, containingDeclaration, new TraceBasedRedeclarationHandler(trace), "Scope with type parameters of a property");
            typeParameterDescriptors2 = this.resolveTypeParametersForCallableDescriptor(propertyDescriptor, writableScope, typeParameters, trace);
            writableScope.changeLockLevel(WritableScope.LockLevel.READING);
            this.resolveGenericBounds(property2, propertyDescriptor, writableScope, typeParameterDescriptors2, trace);
            scopeWithTypeParameters = writableScope;
        }
        JetTypeReference receiverTypeRef = property2.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            receiverType = this.typeResolver.resolveType(scopeWithTypeParameters, receiverTypeRef, trace, true);
        }
        ReceiverParameterDescriptor receiverDescriptor = DescriptorFactory.createExtensionReceiverParameterForCallable(propertyDescriptor, receiverType);
        ReceiverParameterDescriptor implicitInitializerReceiver = property2.hasDelegate() ? ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER : receiverDescriptor;
        JetScope propertyScope = JetScopeUtils.getPropertyDeclarationInnerScope(propertyDescriptor, scope2, typeParameterDescriptors2, implicitInitializerReceiver, trace);
        JetType type2 = this.getVariableType(propertyDescriptor, propertyScope, property2, dataFlowInfo, true, trace);
        propertyDescriptor.setType(type2, typeParameterDescriptors2, DescriptorUtils.getDispatchReceiverParameterIfNeeded(containingDeclaration), receiverDescriptor);
        PropertyGetterDescriptorImpl getter2 = this.resolvePropertyGetterDescriptor(scopeWithTypeParameters, property2, propertyDescriptor, trace);
        PropertySetterDescriptor setter2 = this.resolvePropertySetterDescriptor(scopeWithTypeParameters, property2, propertyDescriptor, trace);
        propertyDescriptor.initialize(getter2, setter2);
        trace.record(BindingContext.VARIABLE, property2, propertyDescriptor);
        PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        return propertyDescriptorImpl;
    }

    static boolean hasBody(JetProperty property2) {
        boolean hasBody = property2.hasDelegateExpressionOrInitializer();
        if (!hasBody) {
            JetPropertyAccessor getter2 = property2.getGetter();
            if (getter2 != null && getter2.hasBody()) {
                hasBody = true;
            }
            JetPropertyAccessor setter2 = property2.getSetter();
            if (!hasBody && setter2 != null && setter2.hasBody()) {
                hasBody = true;
            }
        }
        return hasBody;
    }

    @NotNull
    private JetType getVariableType(final @NotNull VariableDescriptorImpl variableDescriptor, final @NotNull JetScope scope2, final @NotNull JetVariableDeclaration variable2, final @NotNull DataFlowInfo dataFlowInfo, boolean notLocal, final @NotNull BindingTrace trace) {
        boolean hasDelegate;
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
        }
        if (variable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
        }
        JetTypeReference propertyTypeRef = variable2.getTypeReference();
        boolean bl = hasDelegate = variable2 instanceof JetProperty && ((JetProperty)variable2).hasDelegateExpression();
        if (propertyTypeRef == null) {
            if (!variable2.hasInitializer()) {
                JetProperty property2;
                if (hasDelegate && variableDescriptor instanceof PropertyDescriptor && (property2 = (JetProperty)variable2).hasDelegateExpression()) {
                    DeferredType deferredType = DeferredType.createRecursionIntolerant(this.storageManager, trace, new Function0<JetType>(){

                        @Override
                        public JetType invoke() {
                            return DescriptorResolver.this.resolveDelegatedPropertyType(property2, (PropertyDescriptor)((Object)variableDescriptor), scope2, property2.getDelegateExpression(), dataFlowInfo, trace);
                        }
                    });
                    if (deferredType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
                    }
                    return deferredType;
                }
                if (!notLocal) {
                    trace.report(Errors.VARIABLE_WITH_NO_TYPE_NO_INITIALIZER.on(variable2));
                }
                JetType jetType = ErrorUtils.createErrorType("No type, no body");
                if (jetType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
                }
                return jetType;
            }
            if (notLocal) {
                DeferredType deferredType = DeferredType.createRecursionIntolerant(this.storageManager, trace, new Function0<JetType>(){

                    @Override
                    public JetType invoke() {
                        JetType initializerType = DescriptorResolver.this.resolveInitializerType(scope2, variable2.getInitializer(), dataFlowInfo, trace);
                        DescriptorResolver.this.setConstantForVariableIfNeeded(variableDescriptor, scope2, variable2, dataFlowInfo, initializerType, trace);
                        return DescriptorResolver.transformAnonymousTypeIfNeeded(variableDescriptor, variable2, initializerType, trace);
                    }
                });
                if (deferredType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
                }
                return deferredType;
            }
            JetType initializerType = this.resolveInitializerType(scope2, variable2.getInitializer(), dataFlowInfo, trace);
            this.setConstantForVariableIfNeeded(variableDescriptor, scope2, variable2, dataFlowInfo, initializerType, trace);
            JetType jetType = initializerType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
            }
            return jetType;
        }
        JetType type2 = this.typeResolver.resolveType(scope2, propertyTypeRef, trace, true);
        this.setConstantForVariableIfNeeded(variableDescriptor, scope2, variable2, dataFlowInfo, type2, trace);
        JetType jetType = type2;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
        }
        return jetType;
    }

    private void setConstantForVariableIfNeeded(@NotNull VariableDescriptorImpl variableDescriptor, final @NotNull JetScope scope2, final @NotNull JetVariableDeclaration variable2, final @NotNull DataFlowInfo dataFlowInfo, final @NotNull JetType variableType, final @NotNull BindingTrace trace) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (variable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (variableType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableType", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (!DescriptorUtils.shouldRecordInitializerForProperty(variableDescriptor, variableType)) {
            return;
        }
        if (!variable2.hasInitializer()) {
            return;
        }
        variableDescriptor.setCompileTimeInitializer(this.storageManager.createRecursionTolerantNullableLazyValue(new Function0<CompileTimeConstant<?>>(){

            @Override
            @Nullable
            public CompileTimeConstant<?> invoke() {
                JetType initializerType;
                JetExpression initializer = variable2.getInitializer();
                CompileTimeConstant<?> constant = ConstantExpressionEvaluator.evaluate(initializer, trace, initializerType = DescriptorResolver.this.expressionTypingServices.safeGetType(scope2, initializer, variableType, dataFlowInfo, trace));
                if (constant instanceof IntegerValueTypeConstant) {
                    return EvaluatePackage.createCompileTimeConstantWithType((IntegerValueTypeConstant)constant, initializerType);
                }
                return constant;
            }
        }, null));
    }

    @NotNull
    private JetType resolveDelegatedPropertyType(@NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull JetScope scope2, @NotNull JetExpression delegateExpression, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        JetType getterReturnType;
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        JetScope accessorScope = JetScopeUtils.makeScopeForPropertyAccessor(propertyDescriptor, scope2, trace);
        JetType type2 = this.delegatedPropertyResolver.resolveDelegateExpression(delegateExpression, property2, propertyDescriptor, scope2, accessorScope, trace, dataFlowInfo);
        if (type2 != null && (getterReturnType = this.delegatedPropertyResolver.getDelegatedPropertyGetMethodReturnType(propertyDescriptor, delegateExpression, type2, trace, accessorScope)) != null) {
            JetType jetType = getterReturnType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
            }
            return jetType;
        }
        JetType jetType = ErrorUtils.createErrorType("Type from delegate");
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        return jetType;
    }

    @Nullable
    static JetType transformAnonymousTypeIfNeeded(@NotNull DeclarationDescriptorWithVisibility descriptor2, @NotNull JetNamedDeclaration declaration, @NotNull JetType type2, @NotNull BindingTrace trace) {
        boolean transformNeeded;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null || !DescriptorUtils.isAnonymousObject(classifierDescriptor)) {
            return type2;
        }
        boolean definedInClass = DescriptorUtils.getParentOfType(descriptor2, ClassDescriptor.class) != null;
        boolean isLocal = DescriptorUtils.isLocal(descriptor2);
        Visibility visibility = descriptor2.getVisibility();
        boolean bl = transformNeeded = !isLocal && !visibility.isPublicAPI() && (!definedInClass || !Visibilities.isPrivate(visibility));
        if (transformNeeded) {
            if (type2.getConstructor().getSupertypes().size() == 1) {
                assert (type2.getArguments().isEmpty()) : "Object expression couldn't have any type parameters!";
                return type2.getConstructor().getSupertypes().iterator().next();
            }
            trace.report(Errors.AMBIGUOUS_ANONYMOUS_TYPE_INFERRED.on(declaration, type2.getConstructor().getSupertypes()));
        }
        return type2;
    }

    @NotNull
    private JetType resolveInitializerType(@NotNull JetScope scope2, @NotNull JetExpression initializer, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        JetType jetType = this.expressionTypingServices.safeGetType(scope2, initializer, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, trace);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        return jetType;
    }

    @Nullable
    private PropertySetterDescriptor resolvePropertySetterDescriptor(@NotNull JetScope scope2, @NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor, BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        JetPropertyAccessor setter2 = property2.getSetter();
        PropertySetterDescriptorImpl setterDescriptor = null;
        if (setter2 != null) {
            Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, setter2.getModifierList(), trace);
            JetParameter parameter = setter2.getParameter();
            setterDescriptor = new PropertySetterDescriptorImpl(propertyDescriptor, annotations2, ModifiersChecker.resolveModalityFromModifiers(setter2, propertyDescriptor.getModality()), ModifiersChecker.resolveVisibilityFromModifiers(setter2, propertyDescriptor.getVisibility()), setter2.hasBody(), false, CallableMemberDescriptor.Kind.DECLARATION, null, SourcePackage.toSourceElement(setter2));
            if (parameter != null) {
                JetType type2;
                JetTypeReference typeReference;
                if (parameter.hasDefaultValue()) {
                    trace.report(Errors.SETTER_PARAMETER_WITH_DEFAULT_VALUE.on(parameter.getDefaultValue()));
                }
                if ((typeReference = parameter.getTypeReference()) == null) {
                    type2 = propertyDescriptor.getType();
                } else {
                    type2 = this.typeResolver.resolveType(scope2, typeReference, trace, true);
                    JetType inType = propertyDescriptor.getType();
                    if (inType != null && !TypeUtils.equalTypes(type2, inType)) {
                        trace.report(Errors.WRONG_SETTER_PARAMETER_TYPE.on(typeReference, inType, type2));
                    }
                }
                ValueParameterDescriptorImpl valueParameterDescriptor = this.resolveValueParameterDescriptor(scope2, setterDescriptor, parameter, 0, type2, trace);
                setterDescriptor.initialize(valueParameterDescriptor);
            } else {
                setterDescriptor.initializeDefault();
            }
            trace.record(BindingContext.PROPERTY_ACCESSOR, setter2, setterDescriptor);
        } else if (property2.isVar()) {
            setterDescriptor = DescriptorFactory.createSetter(propertyDescriptor, !property2.hasDelegate());
        }
        if (!property2.isVar() && setter2 != null) {
            trace.report(Errors.VAL_WITH_SETTER.on(setter2));
        }
        return setterDescriptor;
    }

    @Nullable
    private PropertyGetterDescriptorImpl resolvePropertyGetterDescriptor(@NotNull JetScope scope2, @NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor, BindingTrace trace) {
        PropertyGetterDescriptorImpl getterDescriptor;
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        JetPropertyAccessor getter2 = property2.getGetter();
        if (getter2 != null) {
            JetType outType;
            Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, getter2.getModifierList(), trace);
            JetType returnType2 = outType = propertyDescriptor.getType();
            JetTypeReference returnTypeReference = getter2.getReturnTypeReference();
            if (returnTypeReference != null) {
                returnType2 = this.typeResolver.resolveType(scope2, returnTypeReference, trace, true);
                if (outType != null && !TypeUtils.equalTypes(returnType2, outType)) {
                    trace.report(Errors.WRONG_GETTER_RETURN_TYPE.on(returnTypeReference, propertyDescriptor.getReturnType(), outType));
                }
            }
            getterDescriptor = new PropertyGetterDescriptorImpl(propertyDescriptor, annotations2, ModifiersChecker.resolveModalityFromModifiers(getter2, propertyDescriptor.getModality()), ModifiersChecker.resolveVisibilityFromModifiers(getter2, propertyDescriptor.getVisibility()), getter2.hasBody(), false, CallableMemberDescriptor.Kind.DECLARATION, null, SourcePackage.toSourceElement(getter2));
            getterDescriptor.initialize(returnType2);
            trace.record(BindingContext.PROPERTY_ACCESSOR, getter2, getterDescriptor);
        } else {
            getterDescriptor = DescriptorFactory.createGetter(propertyDescriptor, !property2.hasDelegate());
            getterDescriptor.initialize(propertyDescriptor.getType());
        }
        return getterDescriptor;
    }

    @NotNull
    public PropertyDescriptor resolvePrimaryConstructorParameterToAProperty(@NotNull ClassDescriptor classDescriptor, @NotNull ValueParameterDescriptor valueParameter, @NotNull JetScope scope2, @NotNull JetParameter parameter, BindingTrace trace) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        if (valueParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        JetType type2 = this.resolveParameterType(scope2, parameter, trace);
        Name name = parameter.getNameAsSafeName();
        boolean isMutable = parameter.isMutable();
        JetModifierList modifierList = parameter.getModifierList();
        if (modifierList != null && modifierList.hasModifier(JetTokens.ABSTRACT_KEYWORD)) {
            trace.report(Errors.ABSTRACT_PROPERTY_IN_PRIMARY_CONSTRUCTOR_PARAMETERS.on(parameter));
        }
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(classDescriptor, valueParameter.getAnnotations(), ModifiersChecker.resolveModalityFromModifiers(parameter, Modality.FINAL), ModifiersChecker.resolveVisibilityFromModifiers(parameter, DescriptorResolver.getDefaultVisibility(parameter, classDescriptor)), isMutable, name, CallableMemberDescriptor.Kind.DECLARATION, SourcePackage.toSourceElement(parameter));
        propertyDescriptor.setType(type2, Collections.emptyList(), DescriptorUtils.getDispatchReceiverParameterIfNeeded(classDescriptor), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER);
        PropertyGetterDescriptorImpl getter2 = DescriptorFactory.createDefaultGetter(propertyDescriptor);
        PropertySetterDescriptorImpl setter2 = propertyDescriptor.isVar() ? DescriptorFactory.createDefaultSetter(propertyDescriptor) : null;
        propertyDescriptor.initialize(getter2, setter2);
        getter2.initialize(propertyDescriptor.getType());
        trace.record(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter, propertyDescriptor);
        trace.record(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameter, propertyDescriptor);
        PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        return propertyDescriptorImpl;
    }

    public static void checkBounds(@NotNull JetTypeReference typeReference, @NotNull JetType type2, @NotNull BindingTrace trace) {
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeReference", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (type2.isError()) {
            return;
        }
        JetTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement == null) {
            return;
        }
        List<TypeParameterDescriptor> parameters2 = type2.getConstructor().getParameters();
        List<TypeProjection> arguments2 = type2.getArguments();
        assert (parameters2.size() == arguments2.size());
        List<JetTypeReference> jetTypeArguments = typeElement.getTypeArgumentsAsTypes();
        if (TypesPackage.isFlexible(type2) && !TypesPackage.isDynamic(type2)) {
            assert (jetTypeArguments.size() == 2) : "Flexible type cannot be denoted in Kotlin otherwise than as ft<T1, T2>, but was: " + PsiUtilPackage.getElementTextWithContext(typeReference);
            Flexibility flexibility = TypesPackage.flexibility(type2);
            DescriptorResolver.checkBounds(jetTypeArguments.get(0), flexibility.getLowerBound(), trace);
            DescriptorResolver.checkBounds(jetTypeArguments.get(1), flexibility.getUpperBound(), trace);
            return;
        }
        assert (jetTypeArguments.size() == arguments2.size()) : typeElement.getText() + ": " + jetTypeArguments + " - " + arguments2;
        TypeSubstitutor substitutor = TypeSubstitutor.create(type2);
        for (int i = 0; i < jetTypeArguments.size(); ++i) {
            JetTypeReference jetTypeArgument = jetTypeArguments.get(i);
            if (jetTypeArgument == null) continue;
            JetType typeArgument = arguments2.get(i).getType();
            DescriptorResolver.checkBounds(jetTypeArgument, typeArgument, trace);
            TypeParameterDescriptor typeParameterDescriptor = parameters2.get(i);
            DescriptorResolver.checkBounds(jetTypeArgument, typeArgument, typeParameterDescriptor, substitutor, trace);
        }
    }

    public static void checkBounds(@NotNull JetTypeReference jetTypeArgument, @NotNull JetType typeArgument, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor, @NotNull BindingTrace trace) {
        if (jetTypeArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetTypeArgument", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (typeArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArgument", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        for (JetType bound : typeParameterDescriptor.getUpperBounds()) {
            JetType substitutedBound = substitutor.safeSubstitute(bound, Variance.INVARIANT);
            if (JetTypeChecker.DEFAULT.isSubtypeOf(typeArgument, substitutedBound)) continue;
            trace.report(Errors.UPPER_BOUND_VIOLATED.on(jetTypeArgument, substitutedBound, typeArgument));
        }
    }

    public static boolean checkHasOuterClassInstance(@NotNull JetScope scope2, @NotNull BindingTrace trace, @NotNull PsiElement reportErrorsOn, @NotNull ClassDescriptor target) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (reportErrorsOn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportErrorsOn", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        ClassDescriptor classDescriptor = DescriptorResolver.getContainingClass(scope2);
        if (!DescriptorResolver.isInsideOuterClassOrItsSubclass(classDescriptor, target)) {
            return true;
        }
        while (classDescriptor != null) {
            if (DescriptorUtils.isSubclass(classDescriptor, target)) {
                return true;
            }
            if (DescriptorUtils.isStaticNestedClass(classDescriptor)) {
                trace.report(Errors.INACCESSIBLE_OUTER_CLASS_EXPRESSION.on(reportErrorsOn, classDescriptor));
                return false;
            }
            classDescriptor = DescriptorUtils.getParentOfType(classDescriptor, ClassDescriptor.class, true);
        }
        return true;
    }

    private static boolean isInsideOuterClassOrItsSubclass(@Nullable DeclarationDescriptor nested, @NotNull ClassDescriptor outer) {
        if (outer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outer", "org/jetbrains/kotlin/resolve/DescriptorResolver", "isInsideOuterClassOrItsSubclass"));
        }
        if (nested == null) {
            return false;
        }
        if (nested instanceof ClassDescriptor && DescriptorUtils.isSubclass((ClassDescriptor)nested, outer)) {
            return true;
        }
        return DescriptorResolver.isInsideOuterClassOrItsSubclass(nested.getContainingDeclaration(), outer);
    }

    @Nullable
    public static ClassDescriptor getContainingClass(@NotNull JetScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getContainingClass"));
        }
        return DescriptorUtils.getParentOfType(scope2.getContainingDeclaration(), ClassDescriptor.class, false);
    }

    public static void checkParameterHasNoValOrVar(@NotNull BindingTrace trace, @NotNull JetParameter parameter, @NotNull DiagnosticFactory1<PsiElement, JetKeywordToken> diagnosticFactory) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkParameterHasNoValOrVar"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkParameterHasNoValOrVar"));
        }
        if (diagnosticFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticFactory", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkParameterHasNoValOrVar"));
        }
        ASTNode valOrVarNode = parameter.getValOrVarNode();
        if (valOrVarNode != null) {
            trace.report(diagnosticFactory.on(valOrVarNode.getPsi(), (JetKeywordToken)valOrVarNode.getElementType()));
        }
    }

    public static void checkParameterHasNoModifier(@NotNull BindingTrace trace, @NotNull JetParameter parameter) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkParameterHasNoModifier"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkParameterHasNoModifier"));
        }
        ModifiersChecker.reportIllegalModifiers(parameter.getModifierList(), MODIFIERS_ILLEGAL_ON_PARAMETERS, trace);
    }

    public static void resolvePackageHeader(@NotNull JetPackageDirective packageDirective, @NotNull ModuleDescriptor module, @NotNull BindingTrace trace) {
        if (packageDirective == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDirective", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePackageHeader"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePackageHeader"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePackageHeader"));
        }
        for (JetSimpleNameExpression nameExpression : packageDirective.getPackageNames()) {
            FqName fqName2 = packageDirective.getFqName(nameExpression);
            PackageViewDescriptor packageView = module.getPackage(fqName2);
            assert (packageView != null) : "package not found: " + fqName2;
            trace.record(BindingContext.REFERENCE_TARGET, nameExpression, packageView);
            PackageViewDescriptor parentPackageView = packageView.getContainingDeclaration();
            assert (parentPackageView != null) : "package has no parent: " + packageView;
            trace.record(BindingContext.RESOLUTION_SCOPE, nameExpression, parentPackageView.getMemberScope());
        }
    }

    public static void registerFileInPackage(@NotNull BindingTrace trace, @NotNull JetFile file) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "registerFileInPackage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/resolve/DescriptorResolver", "registerFileInPackage"));
        }
        FqName fqName2 = file.getPackageFqName();
        Collection<JetFile> files = trace.get(BindingContext.PACKAGE_TO_FILES, fqName2);
        if (files == null) {
            files = Sets.newIdentityHashSet();
        }
        files.add(file);
        trace.record(BindingContext.PACKAGE_TO_FILES, fqName2, files);
    }

    static {
        MODIFIERS_ILLEGAL_ON_PARAMETERS.addAll(Arrays.asList(JetTokens.MODIFIER_KEYWORDS_ARRAY));
        MODIFIERS_ILLEGAL_ON_PARAMETERS.remove(JetTokens.VARARG_KEYWORD);
    }

    static final class UpperBoundCheckerTask {
        JetTypeReference upperBound;
        JetType upperBoundType;

        private UpperBoundCheckerTask(JetTypeReference upperBound, JetType upperBoundType) {
            this.upperBound = upperBound;
            this.upperBoundType = upperBoundType;
        }
    }
}

